/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.positron.plugin.chat.attachments;

import com.google.common.annotations.VisibleForTesting;
import com.oxygenxml.positron.plugin.chat.attachments.AttachmentChipUtil;
import com.oxygenxml.positron.plugin.chat.attachments.AttachmentRemoveButton;
import com.oxygenxml.positron.plugin.ui.ThemeColorProvider;
import java.awt.Color;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.FontMetrics;
import java.awt.Insets;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.net.URL;
import java.util.Collection;
import java.util.Optional;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JToolTip;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.plaf.BorderUIResource;
import ro.sync.basic.util.URLUtil;
import ro.sync.exml.workspace.api.PluginWorkspace;
import ro.sync.exml.workspace.api.PluginWorkspaceProvider;
import ro.sync.exml.workspace.api.standalone.ui.OxygenUIComponentsFactory;

public class AttachmentChip
extends JPanel {
    private static final long serialVersionUID = 1L;
    private final URL resource;
    private final AttachmentRemoveButton removeAttachmentButton;
    private JLabel fileNameLabel;
    private String originalFileName;
    private Collection<URL> attachments;

    public AttachmentChip(final URL resource, final Runnable onRemove, Collection<URL> attachments) {
        this.resource = resource;
        this.attachments = attachments;
        this.setLayout(new FlowLayout(0, 2, 0));
        this.setBorder(new BorderUIResource.MatteBorderUIResource(1, 1, 1, 1, ThemeColorProvider.getInstance().getViewTabsBorderColor()));
        this.originalFileName = AttachmentChipUtil.extractFileName(resource, attachments);
        this.fileNameLabel = new JLabel(this.originalFileName){

            @Override
            public JToolTip createToolTip() {
                return OxygenUIComponentsFactory.installMultilineTooltip((JComponent)AttachmentChip.this.fileNameLabel);
            }
        };
        this.fileNameLabel.setFont(this.fileNameLabel.getFont().deriveFont(0));
        this.fileNameLabel.setToolTipText(URLUtil.getDescription((URL)URLUtil.clearUserInfo((URL)resource)));
        this.fileNameLabel.setBorder(new EmptyBorder(0, 2, 0, 0));
        this.fileNameLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent e) {
                if (SwingUtilities.isMiddleMouseButton(e) && onRemove != null && AttachmentChip.this.removeAttachmentButton.isVisible()) {
                    onRemove.run();
                }
            }

            @Override
            public void mouseClicked(MouseEvent e) {
                if (SwingUtilities.isLeftMouseButton(e)) {
                    AttachmentChip.this.onClick(resource);
                }
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                AttachmentChip.this.onMouseEntered();
            }

            @Override
            public void mouseExited(MouseEvent e) {
                AttachmentChip.this.onMouseExited();
            }
        });
        this.add(this.fileNameLabel);
        this.removeAttachmentButton = new AttachmentRemoveButton();
        this.removeAttachmentButton.setBorder(new EmptyBorder(0, 5, 0, 0));
        this.removeAttachmentButton.setXSymbolColor(this.fileNameLabel.getForeground());
        this.removeAttachmentButton.setHoverBackgroundColor(this.calculateHoverBackgroundColor());
        this.removeAttachmentButton.addActionListener(e -> Optional.ofNullable(onRemove).ifPresent(Runnable::run));
        this.add(this.removeAttachmentButton);
    }

    protected void onClick(URL resource) {
        PluginWorkspaceProvider.getPluginWorkspace().open(resource);
    }

    protected void onMouseEntered() {
        this.fileNameLabel.setCursor(Cursor.getPredefinedCursor(12));
    }

    protected void onMouseExited() {
        this.fileNameLabel.setCursor(Cursor.getDefaultCursor());
    }

    public URL getUrl() {
        return this.resource;
    }

    public void setRemoveChipButtonVisible(boolean visible) {
        this.removeAttachmentButton.setVisible(visible);
    }

    @VisibleForTesting
    public AttachmentRemoveButton getRemoveAttachmentButtonForTC() {
        return this.removeAttachmentButton;
    }

    protected void setChipText(String customChipName) {
        this.originalFileName = customChipName != null ? customChipName : AttachmentChipUtil.extractFileName(this.resource, this.attachments);
    }

    @Override
    public void setToolTipText(String text) {
        this.fileNameLabel.setToolTipText(text);
    }

    public void updateLabelText(int fixedComponentWidth) {
        Container parent = this.getParent();
        if (parent != null && this.originalFileName != null) {
            FontMetrics fm = this.fileNameLabel.getFontMetrics(this.fileNameLabel.getFont());
            int totalSpacing = this.calculatesComponentsSpacing();
            int availableWidth = parent.getSize().width - fixedComponentWidth - totalSpacing;
            this.fileNameLabel.setText(AttachmentChip.getTruncatedText(this.originalFileName, fm, availableWidth));
        } else {
            this.fileNameLabel.setText(this.originalFileName);
        }
    }

    private int calculatesComponentsSpacing() {
        FlowLayout layout = (FlowLayout)this.getLayout();
        int layoutGaps = layout.getHgap() * 2;
        int containerInsets = this.getInsets().left + this.getInsets().right;
        int labelSpacing = AttachmentChip.getComponentSpacing(this.fileNameLabel);
        int removeButtonSpacing = AttachmentChip.getComponentSpacing(this.removeAttachmentButton);
        Dimension preferredSize = this.removeAttachmentButton.getPreferredSize();
        if (preferredSize != null) {
            removeButtonSpacing += preferredSize.width;
        }
        return containerInsets + labelSpacing + removeButtonSpacing + layoutGaps;
    }

    private static int getComponentSpacing(JComponent component) {
        Insets borderInsets;
        Border border;
        int spacing = 0;
        Insets insets = component.getInsets();
        if (insets != null) {
            spacing = insets.left + insets.right;
        }
        if ((border = component.getBorder()) != null && (borderInsets = border.getBorderInsets(component)) != null) {
            spacing += borderInsets.left;
            spacing += borderInsets.right;
        }
        return spacing;
    }

    private static String getTruncatedText(String originalFileName, FontMetrics fm, int availableWidth) {
        if (availableWidth <= 0 || fm.stringWidth(originalFileName) <= availableWidth) {
            return originalFileName;
        }
        String ellipsis = "...";
        int ellipsisWidth = fm.stringWidth(ellipsis);
        int textWidth = availableWidth - ellipsisWidth;
        int halfWidth = textWidth / 2;
        int beginChars = 0;
        int width = 0;
        for (char c : originalFileName.toCharArray()) {
            if ((width += fm.charWidth(c)) > halfWidth) break;
            ++beginChars;
        }
        int endChars = 0;
        width = 0;
        char[] chars = originalFileName.toCharArray();
        for (int i = chars.length - 1; i >= 0 && (width += fm.charWidth(chars[i])) <= halfWidth; --i) {
            ++endChars;
        }
        if (beginChars + endChars >= originalFileName.length() - 3) {
            return originalFileName;
        }
        String beginning = originalFileName.substring(0, beginChars);
        String end = originalFileName.substring(originalFileName.length() - endChars);
        return beginning + ellipsis + end;
    }

    private Color calculateHoverBackgroundColor() {
        PluginWorkspace pw = PluginWorkspaceProvider.getPluginWorkspace();
        if (pw != null && pw.getColorTheme() != null && pw.getColorTheme().isDarkTheme()) {
            return Color.GRAY;
        }
        return new Color(0, 0, 0, 20);
    }
}

