/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.positron.plugin.chat.actions.importexport;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.PrettyPrinter;
import com.fasterxml.jackson.core.util.DefaultIndenter;
import com.fasterxml.jackson.core.util.DefaultPrettyPrinter;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.oxygenxml.positron.plugin.chat.ChatModel;
import com.oxygenxml.positron.plugin.chat.actions.importexport.AIActionDetailsMixin;
import com.oxygenxml.positron.plugin.chat.history.UnknownActionToImportException;
import com.oxygenxml.positron.plugin.completion.CompletionActionsManager;
import com.oxygenxml.positron.utilities.AIRequestUtil;
import com.oxygenxml.positron.utilities.json.AIActionDetails;
import java.io.IOException;
import java.util.Map;
import java.util.stream.Collectors;

public class ImportExportChatUtil {
    private static final String EOL = "\n";
    private static final String INDENT = "  ";

    private ImportExportChatUtil() {
        throw new UnsupportedOperationException("Instantiation of this utility class is not allowed!");
    }

    public static String serializeChatModelAsJSON(ChatModel chatModel) throws JsonProcessingException {
        AIActionDetails actionDetails = chatModel.getActionDetails();
        ObjectMapper mapper = AIRequestUtil.defaultObjectMapper();
        mapper.enable(SerializationFeature.INDENT_OUTPUT);
        DefaultPrettyPrinter pp = new DefaultPrettyPrinter().withObjectIndenter((DefaultPrettyPrinter.Indenter)new DefaultIndenter(INDENT, EOL));
        mapper.setDefaultPrettyPrinter((PrettyPrinter)pp);
        if (actionDetails.isBuiltinAction()) {
            mapper.addMixIn(AIActionDetails.class, AIActionDetailsMixin.class);
        }
        return mapper.writeValueAsString((Object)chatModel);
    }

    public static ChatModel newChatModelFromJSON(String conversationJSON, CompletionActionsManager completionActionsManager) throws IOException {
        Map<String, Object> actionParameters;
        ChatModel modelToImport = (ChatModel)AIRequestUtil.defaultObjectMapper().readValue(conversationJSON, ChatModel.class);
        AIActionDetails actionDetails = modelToImport.getActionDetails();
        if (actionDetails == null) {
            throw new IOException("The imported chat does not contain a valid action.");
        }
        String actionID = actionDetails.getId();
        AIActionDetails aiAction = completionActionsManager.retrieveAIAction(actionID, actionParameters = modelToImport.getActionParameters().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> entry.getValue())));
        if (aiAction == null) {
            throw new UnknownActionToImportException(actionID);
        }
        if (actionDetails.isBuiltinAction()) {
            actionDetails.setPrompt(aiAction.getPrompt());
        }
        return modelToImport;
    }
}

