/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.positron.plugin.chat.actions;

import com.oxygenxml.positron.api.connector.dto.ModelDescriptor;
import com.oxygenxml.positron.core.actions.ActionInteractor;
import com.oxygenxml.positron.core.actions.types.BaseActionInteractor;
import com.oxygenxml.positron.core.actions.types.ReplaceCapableActionInteractor;
import com.oxygenxml.positron.core.engines.EnginesManagerProvider;
import com.oxygenxml.positron.core.plugin.Translator;
import com.oxygenxml.positron.core.tools.ToolsSessionManager;
import com.oxygenxml.positron.core.tools.internal.ToolsDocumentsChangesManager;
import com.oxygenxml.positron.core.util.TextUtils;
import com.oxygenxml.positron.functions.ToolsDocumentsChangesManagerBase;
import com.oxygenxml.positron.plugin.ModelsUIUtil;
import com.oxygenxml.positron.plugin.chat.ChatMessageResponseWithActionsPanel;
import com.oxygenxml.positron.plugin.chat.MessageUpdater;
import com.oxygenxml.positron.plugin.chat.utils.ChatUtil;
import com.oxygenxml.positron.plugin.util.IconsLoader;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Toolkit;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.text.BadLocationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.sync.exml.workspace.api.PluginWorkspaceProvider;
import ro.sync.exml.workspace.api.standalone.ui.OxygenUIComponentsFactory;
import ro.sync.exml.workspace.api.standalone.ui.SplitMenuButton;

public class ChatResponseActionsPanel
extends JPanel {
    private static final String CANNOT_EXECUTE_ACTION_REASON = "Cannot execute action. Reason: ";
    private static final Logger LOGGER = LoggerFactory.getLogger((String)ChatResponseActionsPanel.class.getName());
    private static final Translator TRANSLATOR = Translator.getInstance();
    private final String messageContent;
    private boolean allowsExecutionRetargeting = true;
    private ChatMessageResponseWithActionsPanel currentResponse;
    private MessageUpdater messageUpdater;
    private ActionInteractor actionInteractor;
    private JButton copyBtn;
    private boolean isCurrentResponse;
    private JLabel noChangesLabel;

    public ChatResponseActionsPanel(ActionInteractor actionInteractor, String message, ChatMessageResponseWithActionsPanel currentResponse, MessageUpdater messageUpdater) {
        super(new GridBagLayout());
        this.messageContent = message;
        this.currentResponse = currentResponse;
        this.messageUpdater = messageUpdater;
        this.actionInteractor = actionInteractor;
        this.setOpaque(false);
        this.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.isCurrentResponse = true;
        this.reconfigureInternal(actionInteractor);
        this.allowsExecutionRetargeting = actionInteractor == null || actionInteractor.allowsExecutionRetargeting();
    }

    public void reconfigureActionsOnDocumentChange(ActionInteractor actionInteractor) {
        if (this.actionInteractor instanceof BaseActionInteractor && actionInteractor instanceof BaseActionInteractor) {
            ((BaseActionInteractor)actionInteractor).transferContentInserterAndListenerTo((BaseActionInteractor)this.actionInteractor);
        }
        this.reconfigureInternal(actionInteractor);
    }

    public void reconfigure() {
        this.isCurrentResponse = false;
        this.reconfigureInternal(this.actionInteractor);
    }

    public void reconfigureInternal(ActionInteractor actionInteractor) {
        boolean canUseAIResponse;
        ToolsDocumentsChangesManager toolsChangesManager;
        if (!this.allowsExecutionRetargeting) {
            return;
        }
        this.removeAll();
        boolean isAIResponseIdenticalToInputToBeReplaced = false;
        if (actionInteractor instanceof ReplaceCapableActionInteractor) {
            isAIResponseIdenticalToInputToBeReplaced = ((ReplaceCapableActionInteractor)actionInteractor).isAIResponseIdenticalToInput();
        }
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        if (isAIResponseIdenticalToInputToBeReplaced) {
            this.noChangesLabel = new JLabel(TRANSLATOR.getTranslation("No_changes"), IconsLoader.loadIcon("/images/InlineHelp16.png"), 2);
            this.noChangesLabel.setToolTipText(TRANSLATOR.getTranslation("Identical_input_and_response"));
            this.add((Component)this.noChangesLabel, gbc);
            ++gbc.gridx;
        }
        JPanel filler = new JPanel();
        filler.setOpaque(false);
        gbc.fill = 2;
        gbc.weightx = 1.0;
        this.add((Component)filler, gbc);
        gbc.fill = 0;
        gbc.weightx = 0.0;
        ++gbc.gridx;
        if (ToolsSessionManager.getInstance().isToolsDocumentsChangesSupportAvailable() && this.isCurrentResponse && (toolsChangesManager = ToolsSessionManager.getInstance().getToolsDocumentsChangesManager()).hasChangesWhichCanBeApproved()) {
            this.add((Component)this.createPreviewFilesChangesButton(), gbc);
            ++gbc.gridx;
            gbc.insets.left = 10;
        }
        boolean bl = canUseAIResponse = actionInteractor != null && !isAIResponseIdenticalToInputToBeReplaced;
        if (canUseAIResponse) {
            if (actionInteractor.canModifyDocument()) {
                this.add((Component)this.createInsertOrReplaceOrCreateDocumentBtn(actionInteractor), gbc);
                ++gbc.gridx;
                gbc.insets.left = 10;
            }
            if (actionInteractor.canPreviewDocumentModifications()) {
                this.add((Component)this.createPreviewBtn(actionInteractor), gbc);
                ++gbc.gridx;
                gbc.insets.left = 10;
            }
        }
        if (!isAIResponseIdenticalToInputToBeReplaced) {
            this.copyBtn = this.createCopyBtn();
            this.add((Component)this.copyBtn, gbc);
            ++gbc.gridx;
            gbc.insets.left = 10;
        }
        this.add((Component)this.createRegenerateResponseWidget(), gbc);
        this.invalidate();
    }

    private JButton createPreviewFilesChangesButton() {
        JButton[] filesChangesButton;
        filesChangesButton = new JButton[]{ChatUtil.createResponseActionButtonWithIcon(TRANSLATOR.getTranslation("Diff_Document_Changes_Tooltip"), TRANSLATOR.getTranslation("Diff_Document_Changes_Tooltip"), IconsLoader.loadIcon("/images/ManageReviews16.png"), () -> {
            ToolsDocumentsChangesManager toolsChangesManager = ToolsSessionManager.getInstance().getToolsDocumentsChangesManager();
            toolsChangesManager.showChangesForApproval();
            filesChangesButton[0].setVisible(toolsChangesManager.hasChangesWhichCanBeApproved());
        })};
        ToolsDocumentsChangesManagerBase toolsChangesManager = (ToolsDocumentsChangesManagerBase)ToolsSessionManager.getInstance().getToolsDocumentsChangesManager();
        toolsChangesManager.executeOnClearChanges(() -> filesChangesButton[0].setVisible(toolsChangesManager.hasChangesWhichCanBeApproved()));
        return filesChangesButton[0];
    }

    private JButton createSimpleRegenerateResponseButton() {
        return ChatUtil.createResponseActionButtonWithIcon(TRANSLATOR.getTranslation("Regenerate"), TRANSLATOR.getTranslation("Regenerate_response"), IconsLoader.loadIcon("/images/RegenerateResponse16.png"), () -> this.messageUpdater.regenerateResponse(this.currentResponse, null));
    }

    private JButton createCopyBtn() {
        return ChatUtil.createResponseActionButtonWithIcon(TRANSLATOR.getTranslation("Edit_Copy"), TRANSLATOR.getTranslation("Copy_to_clipboard"), IconsLoader.loadIcon("/images/Copy16.png"), () -> Toolkit.getDefaultToolkit().getSystemClipboard().setContents(new StringSelection(this.getMessageContentForAction()), null));
    }

    private JButton createPreviewBtn(ActionInteractor actionInteractor) {
        return ChatUtil.createResponseActionButtonWithIcon(TRANSLATOR.getTranslation("Preview"), actionInteractor.getPreviewChangeDescription(), IconsLoader.loadIcon("/images/OnlinePreview16.png"), () -> {
            try {
                actionInteractor.previewDocumentModifications(this.getMessageContentForAction());
            }
            catch (BadLocationException ex) {
                LOGGER.error((Object)ex, (Throwable)ex);
                PluginWorkspaceProvider.getPluginWorkspace().showErrorMessage(CANNOT_EXECUTE_ACTION_REASON + ex.getMessage());
            }
        });
    }

    private JButton createInsertOrReplaceOrCreateDocumentBtn(ActionInteractor actionInteractor) {
        String iconPath = actionInteractor.getActionChangeIconPath();
        return ChatUtil.createResponseActionButtonWithIcon(actionInteractor.getActionChangeType(), actionInteractor.getActionChangeDescription(), IconsLoader.loadIcon(iconPath), () -> {
            try {
                actionInteractor.applyChangesToDocument(this.getMessageContentForAction());
            }
            catch (BadLocationException ex) {
                LOGGER.error((Object)ex, (Throwable)ex);
                PluginWorkspaceProvider.getPluginWorkspace().showErrorMessage(CANNOT_EXECUTE_ACTION_REASON + ex.getMessage());
            }
        });
    }

    private String getMessageContentForAction() {
        return TextUtils.extractInsertionContentFromResponseForCurrentEditor((String)this.messageContent);
    }

    private JComponent createRegenerateResponseWidget() {
        Map availableModels = EnginesManagerProvider.getInstance().getEnginesManager().getAvailableEngines();
        return EnginesManagerProvider.getInstance().getEnginesManager().isChoosingEngineAllowed() ? this.createRegenerateResponseSplitMenuButton(availableModels) : this.createSimpleRegenerateResponseButton();
    }

    private JComponent createRegenerateResponseSplitMenuButton(Map<String, List<ModelDescriptor>> availableEngines) {
        SplitMenuButton modelsButton = OxygenUIComponentsFactory.createSplitMenuButton(null, (Icon)IconsLoader.loadIcon("/images/RegenerateResponse16.png"), (boolean)false, (boolean)false, (boolean)false, (boolean)false);
        AbstractAction regenerateWithTheSameModel = new AbstractAction(TRANSLATOR.getTranslation("Regenerate_response")){

            @Override
            public void actionPerformed(ActionEvent e) {
                ChatResponseActionsPanel.this.messageUpdater.regenerateResponse(ChatResponseActionsPanel.this.currentResponse, null);
            }
        };
        regenerateWithTheSameModel.putValue("ShortDescription", TRANSLATOR.getTranslation("Regenerate_response_with_models_tooltip"));
        modelsButton.setAction((Action)regenerateWithTheSameModel);
        ModelsUIUtil.addModelsToPopup(modelsButton.getPopupMenu(), availableEngines, descriptor -> {
            String engineName = descriptor.getUiLabel();
            AbstractAction changeEngineAction = new AbstractAction(engineName, (ModelDescriptor)descriptor){
                final /* synthetic */ ModelDescriptor val$descriptor;
                {
                    this.val$descriptor = modelDescriptor;
                    super(arg0);
                }

                @Override
                public void actionPerformed(ActionEvent e) {
                    ChatResponseActionsPanel.this.messageUpdater.regenerateResponse(ChatResponseActionsPanel.this.currentResponse, this.val$descriptor.getId());
                }
            };
            changeEngineAction.putValue("ShortDescription", descriptor.getDescription());
            return changeEngineAction;
        });
        return modelsButton;
    }

    public void setResponseActionsEnabled(boolean enabled) {
        Component[] components;
        for (Component component : components = this.getComponents()) {
            if (component == this.copyBtn || component == this.noChangesLabel) continue;
            component.setEnabled(enabled);
        }
    }
}

