/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.positron.plugin.chat.actions;

import com.oxygenxml.positron.core.plugin.Translator;
import com.oxygenxml.positron.plugin.chat.URLInserter;
import java.awt.event.ActionEvent;
import java.io.File;
import java.net.MalformedURLException;
import java.util.Arrays;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.sync.basic.util.URLUtil;
import ro.sync.exml.workspace.api.PluginWorkspace;
import ro.sync.exml.workspace.api.PluginWorkspaceProvider;

public class AttachFileToChatMessageAction
extends AbstractAction {
    private static final Logger log = LoggerFactory.getLogger(AttachFileToChatMessageAction.class);
    private static final String[] ACCEPTED_FILES_EXTENSIONS = new String[]{"txt", "text", "md", "xml", "dita", "png", "jpg", "jpeg", "docx", "pdf", "pptx"};
    private static final Translator TRANSLATOR = Translator.getInstance();
    private URLInserter fileInserter;

    public AttachFileToChatMessageAction(URLInserter fileInserter, String name, Icon icon) {
        super(name, icon);
        this.fileInserter = fileInserter;
        this.putValue("ShortDescription", TRANSLATOR.getTranslation("Attach_tooltip") + ".");
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        File[] files;
        PluginWorkspace pluginWorkspace = PluginWorkspaceProvider.getPluginWorkspace();
        if (pluginWorkspace != null && (files = pluginWorkspace.chooseFiles(null, TRANSLATOR.getTranslation("Attach_tooltip"), ACCEPTED_FILES_EXTENSIONS, TRANSLATOR.getTranslation("Attach_file_filter_description"))) != null) {
            Arrays.stream(files).forEach(f -> {
                block2: {
                    try {
                        this.fileInserter.insertURL(URLUtil.correct((File)f));
                    }
                    catch (MalformedURLException e1) {
                        if (!log.isDebugEnabled()) break block2;
                        log.debug((Object)e1, (Throwable)e1);
                    }
                }
            });
        }
    }
}

