/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.positron.plugin.chat;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.oxygenxml.positron.core.plugin.Translator;
import com.oxygenxml.positron.plugin.chat.history.ValidationErrorMessageNode;
import com.oxygenxml.positron.plugin.ui.ThemeColorProvider;
import com.oxygenxml.positron.plugin.util.IconsLoader;
import com.oxygenxml.positron.utilities.debug.LoggerUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.sync.exml.workspace.api.standalone.ui.OxygenUIComponentsFactory;

public class ValidationErrorMessagePanel
extends JPanel {
    private static final Logger log = LoggerFactory.getLogger(ValidationErrorMessagePanel.class);
    private static final String DESCRIPTION_PARAM = "description";
    private static final String SEVERITY_PARAM = "severity";
    private ValidationErrorMessageNode validationErrorNode;
    private boolean isExpanded = false;
    private JPanel detailsPanel;
    private JLabel expandCollapseLabel;
    private JLabel titleLabel;
    private JLabel statusLabel;
    private ValidationErrorMessageNode.ValidationErrorStatus currentStatus = ValidationErrorMessageNode.ValidationErrorStatus.DETECTED;
    private JTextArea validationErrorsTextArea;

    public ValidationErrorMessagePanel(ValidationErrorMessageNode validationErrorNode) {
        this.validationErrorNode = validationErrorNode;
        this.currentStatus = validationErrorNode.getStatus();
        this.initPanel();
    }

    private void initPanel() {
        this.setOpaque(false);
        this.setLayout(new GridBagLayout());
        JPanel mainPanel = new JPanel(new GridBagLayout());
        mainPanel.setOpaque(true);
        ThemeColorProvider colorProvider = ThemeColorProvider.getInstance();
        Color backgroundColor = colorProvider.getMeCardBackgroundColor();
        Color borderColor = colorProvider.getViewTabsBorderColor();
        Border lineBorder = BorderFactory.createLineBorder(borderColor, 1);
        Border emptyBorder = BorderFactory.createEmptyBorder(5, 5, 5, 5);
        CompoundBorder compoundBorder = BorderFactory.createCompoundBorder(lineBorder, emptyBorder);
        mainPanel.setBorder(compoundBorder);
        mainPanel.setBackground(backgroundColor);
        JPanel headerPanel = this.createHeaderPanel();
        this.detailsPanel = this.createDetailsPanel();
        this.detailsPanel.setVisible(false);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.anchor = 17;
        gbc.fill = 2;
        gbc.weightx = 1.0;
        mainPanel.add((Component)headerPanel, gbc);
        ++gbc.gridy;
        gbc.fill = 1;
        gbc.weighty = 1.0;
        mainPanel.add((Component)this.detailsPanel, gbc);
        GridBagConstraints constr = new GridBagConstraints();
        constr.gridx = 0;
        constr.gridy = 0;
        constr.fill = 1;
        constr.weightx = 1.0;
        constr.weighty = 1.0;
        constr.anchor = 13;
        constr.insets = new Insets(5, 5, 5, 5);
        this.add((Component)mainPanel, constr);
        this.updateStatusBasedOnCurrentStatus();
    }

    private void updateStatusBasedOnCurrentStatus() {
        switch (this.currentStatus) {
            case FIXING_IN_PROGRESS: {
                this.statusLabel.setText(Translator.getInstance().getTranslation("Fixing_In_Progress"));
                this.statusLabel.setVisible(true);
                break;
            }
            case FIXES_APPLIED: {
                this.statusLabel.setText(Translator.getInstance().getTranslation("Fixes_Applied"));
                this.statusLabel.setVisible(true);
                break;
            }
            case FIXES_ABORTED: {
                this.statusLabel.setText(Translator.getInstance().getTranslation("Validation_fixes_aborted"));
                this.statusLabel.setVisible(true);
                break;
            }
            default: {
                this.statusLabel.setVisible(false);
            }
        }
    }

    private JPanel createHeaderPanel() {
        JPanel headerPanel = new JPanel(new GridBagLayout());
        headerPanel.setOpaque(false);
        JLabel warningIcon = new JLabel(IconsLoader.loadIcon("/images/Warning16.png"));
        this.expandCollapseLabel = new JLabel(IconsLoader.loadIcon("/images/Collapsed16.png"));
        this.expandCollapseLabel.setCursor(Cursor.getPredefinedCursor(12));
        this.expandCollapseLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                ValidationErrorMessagePanel.this.isExpanded = !ValidationErrorMessagePanel.this.isExpanded;
                ValidationErrorMessagePanel.this.expandCollapseLabel.setIcon(IconsLoader.loadIcon(ValidationErrorMessagePanel.this.isExpanded ? "/images/Expanded16.png" : "/images/Collapsed16.png"));
                ValidationErrorMessagePanel.this.detailsPanel.setVisible(ValidationErrorMessagePanel.this.isExpanded);
            }
        });
        this.titleLabel = new JLabel(Translator.getInstance().getTranslation("Validation_Problems"));
        this.titleLabel.setFont(this.titleLabel.getFont().deriveFont(1));
        this.statusLabel = new JLabel();
        this.statusLabel.setVisible(false);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.anchor = 17;
        gbc.insets = new Insets(0, 0, 0, 5);
        headerPanel.add((Component)warningIcon, gbc);
        ++gbc.gridx;
        gbc.weightx = 1.0;
        headerPanel.add((Component)this.titleLabel, gbc);
        ++gbc.gridx;
        gbc.weightx = 0.0;
        gbc.insets = new Insets(0, 0, 0, 0);
        headerPanel.add((Component)this.expandCollapseLabel, gbc);
        gbc.gridx = 1;
        ++gbc.gridy;
        gbc.weightx = 1.0;
        gbc.insets = new Insets(5, 0, 0, 0);
        headerPanel.add((Component)this.statusLabel, gbc);
        headerPanel.setCursor(Cursor.getPredefinedCursor(12));
        headerPanel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                ValidationErrorMessagePanel.this.expandCollapseLabel.dispatchEvent(new MouseEvent(ValidationErrorMessagePanel.this.expandCollapseLabel, 500, e.getWhen(), e.getModifiers(), 0, 0, e.getClickCount(), e.isPopupTrigger(), e.getButton()));
            }
        });
        return headerPanel;
    }

    private JPanel createDetailsPanel() {
        JPanel panel = new JPanel(new GridBagLayout());
        panel.setOpaque(false);
        this.validationErrorsTextArea = OxygenUIComponentsFactory.createTextArea(null);
        this.validationErrorsTextArea.setEditable(false);
        this.validationErrorsTextArea.setLineWrap(true);
        this.validationErrorsTextArea.setWrapStyleWord(true);
        if (this.validationErrorNode != null) {
            this.validationErrorsTextArea.setText(ValidationErrorMessagePanel.formatValidationErrors(this.validationErrorNode.getValidationErrors()));
        }
        Border innerEmpty = BorderFactory.createEmptyBorder(5, 5, 5, 5);
        Border outerLine = BorderFactory.createLineBorder(ThemeColorProvider.getInstance().getViewTabsBorderColor(), 1);
        this.validationErrorsTextArea.setBorder(BorderFactory.createCompoundBorder(outerLine, innerEmpty));
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.fill = 1;
        gbc.insets.top = 5;
        panel.add((Component)this.validationErrorsTextArea, gbc);
        return panel;
    }

    private static String formatValidationErrors(String validationErrors) {
        StringBuilder result = new StringBuilder();
        try {
            ObjectMapper mapper = new ObjectMapper();
            JsonNode rootNode = mapper.readTree(validationErrors);
            if (rootNode.isArray()) {
                for (int i = 0; i < rootNode.size(); ++i) {
                    JsonNode errorNode = rootNode.get(i);
                    String severity = errorNode.has(SEVERITY_PARAM) ? errorNode.get(SEVERITY_PARAM).asText() : "unknown";
                    String description = errorNode.has(DESCRIPTION_PARAM) ? errorNode.get(DESCRIPTION_PARAM).asText() : "";
                    result.append(severity.toUpperCase()).append(":  ");
                    result.append(description);
                    if (i >= rootNode.size() - 1) continue;
                    result.append("\n\n");
                }
            }
        }
        catch (Exception e) {
            log.error("Failed to parse validation errors: {}", (Object)e.getMessage(), (Object)e);
        }
        if (result.length() == 0) {
            result = new StringBuilder(LoggerUtil.writeValueAsPrettyJsonString((Object)validationErrors));
        }
        return result.toString();
    }

    public void showCorrectionInProgress() {
        this.currentStatus = ValidationErrorMessageNode.ValidationErrorStatus.FIXING_IN_PROGRESS;
        if (this.validationErrorNode != null) {
            this.validationErrorNode.setStatus(ValidationErrorMessageNode.ValidationErrorStatus.FIXING_IN_PROGRESS);
        }
        this.statusLabel.setText(Translator.getInstance().getTranslation("Fixing_In_Progress"));
        this.statusLabel.setVisible(true);
    }

    public void showCorrectionCompleted(boolean success) {
        this.currentStatus = ValidationErrorMessageNode.ValidationErrorStatus.FIXES_APPLIED;
        if (this.validationErrorNode != null) {
            this.validationErrorNode.setStatus(ValidationErrorMessageNode.ValidationErrorStatus.FIXES_APPLIED);
        }
        if (success) {
            this.statusLabel.setText(Translator.getInstance().getTranslation("Fixes_Applied"));
        } else {
            this.statusLabel.setText(Translator.getInstance().getTranslation("Error_Applying_Fixes"));
        }
        this.statusLabel.setVisible(true);
    }

    public void showCorrectionAborted(String textToNotify) {
        this.currentStatus = ValidationErrorMessageNode.ValidationErrorStatus.FIXES_ABORTED;
        if (this.validationErrorNode != null) {
            this.validationErrorNode.setStatus(ValidationErrorMessageNode.ValidationErrorStatus.FIXES_ABORTED);
        }
        this.statusLabel.setText(textToNotify);
        this.statusLabel.setVisible(true);
    }

    public ValidationErrorMessageNode.ValidationErrorStatus getCurrentStatus() {
        return this.currentStatus;
    }

    public String getValidationErrors() {
        return this.validationErrorsTextArea.getText();
    }
}

