/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.positron.plugin.chat;

import com.oxygenxml.positron.core.plugin.Translator;
import com.oxygenxml.positron.core.util.TextUtils;
import com.oxygenxml.positron.plugin.chat.EditMenuMouseListener;
import com.oxygenxml.positron.plugin.chat.MessageTextAreaCreator;
import com.oxygenxml.positron.plugin.chat.utils.ChatUtil;
import com.oxygenxml.positron.plugin.util.IconsLoader;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.List;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTextArea;
import javax.swing.KeyStroke;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.SAXException;
import ro.sync.basic.util.PlatformDetector;
import ro.sync.ecss.extensions.api.AuthorAccess;
import ro.sync.ecss.extensions.api.AuthorDocumentController;
import ro.sync.ecss.extensions.api.AuthorDocumentType;
import ro.sync.ecss.extensions.api.AuthorOperationException;
import ro.sync.ecss.extensions.api.access.AuthorEditorAccess;
import ro.sync.ecss.extensions.api.node.AuthorDocumentFragment;
import ro.sync.ecss.extensions.api.node.AuthorElement;
import ro.sync.exml.workspace.api.PluginWorkspaceProvider;
import ro.sync.exml.workspace.api.editor.WSEditor;
import ro.sync.exml.workspace.api.editor.page.author.WSAuthorEditorPage;
import ro.sync.exml.workspace.api.standalone.StandalonePluginWorkspace;
import ro.sync.exml.workspace.api.standalone.ui.OxygenUIComponentsFactory;

public class ResponseMessageComponent
extends JPanel {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)ResponseMessageComponent.class.getName());
    private static final Translator TRANSLATOR = Translator.getInstance();
    private static final Set<String> ALWAYS_ENABLED_ACTIONS = Set.of(TRANSLATOR.getTranslation("Edit_Copy"), TRANSLATOR.getTranslation("Select_all"));
    private final JTextArea messageTextArea;
    private Object previewComp;
    private JPopupMenu textAreaChatMessageMenu = OxygenUIComponentsFactory.createPopupMenu();
    private JPopupMenu authorPreviewChatMessageMenu = OxygenUIComponentsFactory.createPopupMenu();
    private AbstractAction authorPreviewCopyAction;
    private AbstractAction authorSelectAllAction;
    private Component authorSwingComp;
    private String detectedContentType = null;

    public ResponseMessageComponent() {
        this.messageTextArea = MessageTextAreaCreator.createMessageTextArea();
        this.messageTextArea.setBounds(0, 0, 200, 20);
        MessageTextAreaCreator.removeBasePopupMenuListener(this.messageTextArea);
        this.messageTextArea.addMouseListener(new EditMenuMouseListener(this.messageTextArea, () -> this.textAreaChatMessageMenu){

            @Override
            protected boolean shouldShowMenu() {
                return ResponseMessageComponent.this.messageTextArea.getDocument().getLength() > 0;
            }
        });
        this.setLayout(new BorderLayout());
        this.add((Component)this.messageTextArea, "North");
        this.messageTextArea.setVisible(false);
        this.createAuthorPreviewComponent();
    }

    private void createAuthorPreviewComponent() {
        if (PluginWorkspaceProvider.getPluginWorkspace() instanceof StandalonePluginWorkspace) {
            StandalonePluginWorkspace pw = (StandalonePluginWorkspace)PluginWorkspaceProvider.getPluginWorkspace();
            try {
                Method meth = pw.getClass().getDeclaredMethod("createAuthorPreviewComponentProvider", new Class[0]);
                this.previewComp = meth.invoke((Object)pw, new Object[0]);
                Method getComp = this.previewComp.getClass().getDeclaredMethod("getComponent", new Class[0]);
                this.authorSwingComp = (Component)getComp.invoke(this.previewComp, new Object[0]);
            }
            catch (NoSuchMethodException meth) {
            }
            catch (Throwable e) {
                LOGGER.error((Object)e, e);
            }
            this.authorPreviewCopyAction = this.createAuthorPreviewCopyAction();
            this.authorSelectAllAction = this.createAuthorSelectAllAction();
        }
    }

    private AbstractAction createAuthorSelectAllAction() {
        return new AbstractAction(Translator.getInstance().getTranslation("Select_all")){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    AuthorAccess authorAccess = ResponseMessageComponent.this.getAuthorAccess();
                    authorAccess.getEditorAccess().select(0, authorAccess.getDocumentController().getAuthorDocumentNode().getEndOffset());
                }
                catch (Exception e1) {
                    LOGGER.error((Object)e1, (Throwable)e1);
                }
            }
        };
    }

    public void clearCurrentResponse() {
        this.messageTextArea.setText("");
        this.presentTextComponent();
    }

    public void updateModelLabel() {
        this.presentTextComponent();
    }

    public void appendChunk(String messageChunk) {
        if (!this.messageTextArea.isVisible()) {
            this.messageTextArea.setVisible(true);
        }
        this.messageTextArea.append(messageChunk);
        if (this.detectedContentType == null && this.authorSwingComp != null) {
            this.detectAndImposeContentType(false);
        }
    }

    private void detectAndImposeContentType(boolean force) {
        String text = this.messageTextArea.getText();
        this.detectedContentType = TextUtils.getDetectedContentType((String)text);
        if (force || this.detectedContentType != null && !"text/html".equals(this.detectedContentType)) {
            OxygenUIComponentsFactory.changeContentType((JTextArea)this.messageTextArea, (String)this.detectedContentType);
            this.messageTextArea.setText(text);
        }
    }

    public String getSelectedText() {
        String selectedText = null;
        if (this.isShowingMessageInTextArea()) {
            selectedText = this.messageTextArea.getSelectedText();
        } else {
            try {
                AuthorAccess authorAccess = this.getAuthorAccess();
                AuthorEditorAccess editorAccess = authorAccess.getEditorAccess();
                if (editorAccess.hasSelection()) {
                    int selStart = editorAccess.getSelectionStart();
                    int selEnd = editorAccess.getSelectionEnd() - 1;
                    AuthorElement root = authorAccess.getDocumentController().getAuthorDocumentNode().getRootElement();
                    if (selStart <= root.getStartOffset() && root.getEndOffset() <= selEnd) {
                        selectedText = this.messageTextArea.getText();
                    } else {
                        AuthorDocumentFragment frag = authorAccess.getDocumentController().createDocumentFragment(selStart, selEnd);
                        selectedText = authorAccess.getDocumentController().serializeFragmentToXML(frag);
                    }
                }
            }
            catch (Exception e) {
                LOGGER.error((Object)e, (Throwable)e);
            }
        }
        return selectedText;
    }

    private boolean isShowingMessageInTextArea() {
        return this.messageTextArea.getParent() != null;
    }

    public boolean isShowingMessageInAuthorArea() {
        return this.authorSwingComp != null && this.authorSwingComp.getParent() != null;
    }

    public void finalizeResponse() {
        this.presentTextComponent();
        this.messageTextArea.setVisible(this.messageTextArea.getDocument().getLength() > 0);
        this.loadAndPresentAuthorComponent();
    }

    public void presentTextComponent() {
        this.changeComponent(true);
    }

    public void loadAndPresentAuthorComponent() {
        if (this.previewComp != null && this.isPreferAuthorResponse()) {
            this.tryUseAuthorPreviewComponent();
        }
    }

    private void tryUseAuthorPreviewComponent() {
        if (this.canRenderAuthorResponse()) {
            try {
                try {
                    this.loadPossibleXMLResponseInPreview(PluginWorkspaceProvider.getPluginWorkspace().getCurrentEditorAccess(0), this.messageTextArea.getText().trim());
                }
                catch (InvocationTargetException ex) {
                    throw ex.getCause();
                }
            }
            catch (IOException e) {
                if (e.getCause() instanceof SAXException) {
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug(e.getMessage(), e.getCause());
                    }
                } else {
                    LOGGER.error((Object)e, (Throwable)e);
                }
            }
            catch (SAXException | AuthorOperationException e) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug((Object)e, e);
                }
            }
            catch (Throwable e) {
                LOGGER.error((Object)e, e);
            }
        }
    }

    private void loadPossibleXMLResponseInPreview(WSEditor ed, String text) throws Exception {
        if (!(text = TextUtils.extractInsertionContentFromResponse((String)text, (String)ed.getContentType()).trim()).startsWith("<?xml") && !text.contains("<!DOCTYPE")) {
            this.handleCreatePreviewFromIncompleteXMLContent(ed, text);
        } else {
            Method loadMeth = this.previewComp.getClass().getDeclaredMethod("load", URL.class, Reader.class);
            loadMeth.invoke(this.previewComp, ed.getEditorLocation(), new StringReader(text));
        }
        AuthorAccess authorAccess = this.getAuthorAccess();
        JComponent authorComp = (JComponent)authorAccess.getEditorAccess().getAuthorComponent();
        authorComp.setFont(this.messageTextArea.getFont());
        authorComp.addMouseListener(new EditMenuMouseListener(authorComp, () -> this.authorPreviewChatMessageMenu){

            @Override
            protected boolean shouldShowMenu() {
                return true;
            }
        });
        this.registerShortcutActions(authorComp);
        this.changeComponent(false);
    }

    private void changeComponent(boolean changeToTextComponent) {
        if (changeToTextComponent && !this.isShowingMessageInTextArea() || !changeToTextComponent && this.authorSwingComp != null && this.authorSwingComp.getParent() == null) {
            this.removeAll();
            this.add(changeToTextComponent ? this.messageTextArea : this.authorSwingComp, "North");
            this.invalidate();
            Container parent = this.getParent();
            if (parent instanceof JComponent) {
                ((JComponent)parent).revalidate();
                ((JComponent)parent).doLayout();
                Container parentParent = ((JComponent)parent).getParent();
                if (parentParent != null) {
                    parentParent.doLayout();
                    parentParent.repaint();
                }
            }
        }
    }

    public boolean isPreferAuthorResponse() {
        return "true".equals(PluginWorkspaceProvider.getPluginWorkspace().getOptionsStorage().getOption("oxygen.positron.plugin.prefer.visual.author.response", "true"));
    }

    public boolean canRenderAuthorResponse() {
        WSEditor ed;
        if (this.authorSwingComp != null && (ed = PluginWorkspaceProvider.getPluginWorkspace().getCurrentEditorAccess(0)) != null && "Author".equals(ed.getCurrentPageID())) {
            return this.messageTextArea.getText().contains("<");
        }
        return false;
    }

    private void registerShortcutActions(JComponent authorComp) {
        String actionID = "copy_preview";
        authorComp.getActionMap().put(actionID, this.authorPreviewCopyAction);
        int modifierKey = PlatformDetector.isMacOS() ? 256 : 128;
        KeyStroke copyKeyStroke = KeyStroke.getKeyStroke(67, modifierKey);
        this.authorPreviewCopyAction.putValue("AcceleratorKey", copyKeyStroke);
        authorComp.getInputMap().put(copyKeyStroke, actionID);
        String selectAllActionID = "select_all_preview";
        authorComp.getActionMap().put(selectAllActionID, this.authorSelectAllAction);
        modifierKey = PlatformDetector.isMacOS() ? 256 : 128;
        KeyStroke selectAllKeyStroke = KeyStroke.getKeyStroke(65, modifierKey);
        this.authorSelectAllAction.putValue("AcceleratorKey", selectAllKeyStroke);
        authorComp.getInputMap().put(selectAllKeyStroke, selectAllActionID);
    }

    private AbstractAction createAuthorPreviewCopyAction() {
        AbstractAction copyAction = new AbstractAction(TRANSLATOR.getTranslation("Edit_Copy"), IconsLoader.loadIcon("/images/Copy16.png")){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    AuthorEditorAccess editorAccess = ResponseMessageComponent.this.getAuthorAccess().getEditorAccess();
                    Method copyMethod = editorAccess.getClass().getMethod("copy", new Class[0]);
                    copyMethod.invoke((Object)editorAccess, new Object[0]);
                }
                catch (Exception e1) {
                    LOGGER.debug(e1.getMessage(), (Throwable)e1);
                }
            }
        };
        return copyAction;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleCreatePreviewFromIncompleteXMLContent(WSEditor ed, String text) throws Exception {
        WSAuthorEditorPage editorPage = (WSAuthorEditorPage)ed.getCurrentPage();
        AuthorDocumentController ctrl = editorPage.getDocumentController();
        AuthorElement root = ctrl.getAuthorDocumentNode().getRootElement();
        AuthorDocumentFragment rootFrag = ctrl.createDocumentFragment(1, root.getStartOffset());
        AuthorDocumentType dt = ctrl.getDoctype();
        Object serializedRoot = editorPage.getDocumentController().serializeFragmentToXML(rootFrag);
        if (dt != null) {
            serializedRoot = dt.serializeDoctype() + (String)serializedRoot;
        }
        Method loadMeth = this.previewComp.getClass().getDeclaredMethod("load", URL.class, Reader.class);
        loadMeth.invoke(this.previewComp, ed.getEditorLocation(), new StringReader((String)serializedRoot));
        AuthorAccess authorAccess = this.getAuthorAccess();
        try {
            authorAccess.getEditorAccess().setEditable(true);
            AuthorElement insertedRoot = authorAccess.getDocumentController().getAuthorDocumentNode().getRootElement();
            authorAccess.getDocumentController().insertXMLFragment(text, insertedRoot.getStartOffset() + 1);
        }
        finally {
            authorAccess.getEditorAccess().setEditable(false);
        }
    }

    private AuthorAccess getAuthorAccess() throws Exception {
        Method getAuthAccess = this.previewComp.getClass().getDeclaredMethod("getAuthorAccess", new Class[0]);
        return (AuthorAccess)getAuthAccess.invoke(this.previewComp, new Object[0]);
    }

    public void updatePopupActions(List<AbstractAction> actions) {
        this.textAreaChatMessageMenu = ChatUtil.createChatMessagePopup(this.messageTextArea, actions);
        this.createAuthorPreviewPopup(actions);
    }

    private void createAuthorPreviewPopup(List<AbstractAction> actions) {
        this.authorPreviewChatMessageMenu = OxygenUIComponentsFactory.createPopupMenu();
        actions.forEach(action -> {
            if (this.authorPreviewCopyAction != null && this.authorPreviewCopyAction.getValue("Name").equals(action.getValue("Name"))) {
                this.authorPreviewChatMessageMenu.add(this.authorPreviewCopyAction);
            } else {
                this.authorPreviewChatMessageMenu.add((Action)action);
            }
        });
        this.authorPreviewChatMessageMenu.addSeparator();
        if (this.authorSelectAllAction != null) {
            this.authorPreviewChatMessageMenu.add(this.authorSelectAllAction);
        }
    }

    public String getText() {
        return this.messageTextArea.getText();
    }

    public void updatePopupActionsEnabledState(boolean enabled) {
        int componentCount = this.textAreaChatMessageMenu.getComponentCount();
        for (int i = 0; i < componentCount; ++i) {
            JMenuItem jMenuItem;
            Action action;
            String actionName;
            Component component = this.textAreaChatMessageMenu.getComponent(i);
            if (!(component instanceof JMenuItem) || ALWAYS_ENABLED_ACTIONS.contains(actionName = String.valueOf((action = (jMenuItem = (JMenuItem)component).getAction()).getValue("Name")))) continue;
            jMenuItem.setEnabled(enabled);
        }
    }
}

