/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.positron.plugin.chat;

import com.oxygenxml.positron.core.plugin.Translator;
import com.oxygenxml.positron.plugin.ui.CursorUtils;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.geom.Point2D;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.MessageFormat;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JTextArea;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultHighlighter;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import javax.swing.text.Position;
import javax.swing.text.View;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.sync.basic.util.PlatformDetector;
import ro.sync.exml.workspace.api.PluginWorkspaceProvider;
import ro.sync.exml.workspace.api.util.ColorTheme;

public class LinkClickInstaller {
    private static final Logger log = LoggerFactory.getLogger(LinkClickInstaller.class);
    private static final int SEARCH_RANGE = 300;
    private static final String URL_REGEX = "\\w+:/[A-Za-z\\d/_\\-%\\.\\?\\=\\&\\#:\\+]+";
    private static final Pattern URL_REGEX_PATTERN = Pattern.compile("\\w+:/[A-Za-z\\d/_\\-%\\.\\?\\=\\&\\#:\\+]+");

    static void addLinkClickListener(final JTextArea msgArea) {
        msgArea.addMouseMotionListener(new MouseMotionLinkHighlightManager(msgArea));
        msgArea.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                DetectedURLInfo urlAtMousePosition;
                if (LinkClickInstaller.isCmdOrCtrlPressed(e) && (urlAtMousePosition = LinkClickInstaller.getURLAtMousePosition(msgArea, e)) != null) {
                    PluginWorkspaceProvider.getPluginWorkspace().openInExternalApplication(urlAtMousePosition.url, true);
                }
            }
        });
    }

    private static DetectedURLInfo getURLAtMousePosition(JTextArea msgArea, MouseEvent e) {
        Point2D.Double point2D = new Point2D.Double(e.getX(), e.getY());
        int vtm = msgArea.viewToModel2D(point2D);
        return LinkClickInstaller.getURLAtOffset(msgArea, vtm);
    }

    public static DetectedURLInfo getURLAtOffset(JTextArea msgArea, int vtm) {
        block6: {
            int end;
            Document doc = msgArea.getDocument();
            int start = vtm - 300;
            if (start < 0) {
                start = 0;
            }
            if ((end = vtm + 300) > doc.getLength()) {
                end = doc.getLength();
            }
            try {
                String content = doc.getText(start, end - start);
                Matcher matcher = URL_REGEX_PATTERN.matcher(content);
                while (matcher.find()) {
                    if (start + matcher.start() > vtm || vtm > start + matcher.end()) continue;
                    return new DetectedURLInfo(new URL(content.substring(matcher.start(), matcher.end())), start + matcher.start(), start + matcher.end());
                }
            }
            catch (BadLocationException e1) {
                log.error(e1.getMessage(), (Throwable)e1);
            }
            catch (MalformedURLException e1) {
                if (!log.isDebugEnabled()) break block6;
                log.debug(e1.getMessage(), (Throwable)e1);
            }
        }
        return null;
    }

    private static boolean isCmdOrCtrlPressed(MouseEvent e) {
        int modifierKey = PlatformDetector.isMacOS() ? 256 : 128;
        return (e.getModifiersEx() & modifierKey) != 0;
    }

    private static class MouseMotionLinkHighlightManager
    extends MouseMotionAdapter {
        private JTextArea msgArea;
        private Object highlightTag;

        private MouseMotionLinkHighlightManager(JTextArea msgArea) {
            this.msgArea = msgArea;
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            if (this.highlightTag != null) {
                this.msgArea.getHighlighter().removeHighlight(this.highlightTag);
            }
            DetectedURLInfo urlAtMousePosition = LinkClickInstaller.getURLAtMousePosition(this.msgArea, e);
            String listenerId = "linkClick";
            if (LinkClickInstaller.isCmdOrCtrlPressed(e)) {
                if (urlAtMousePosition != null) {
                    CursorUtils.setCursorIfDifferent(this.msgArea, Cursor.getPredefinedCursor(12), listenerId);
                    this.addHighlight(this.msgArea, urlAtMousePosition);
                } else {
                    CursorUtils.setCursorIfDifferent(this.msgArea, CursorUtils.getDefaultCursor(this.msgArea), listenerId);
                }
            } else {
                CursorUtils.setCursorIfDifferent(this.msgArea, CursorUtils.getDefaultCursor(this.msgArea), listenerId);
                String tooltipText = null;
                if (urlAtMousePosition != null) {
                    tooltipText = MessageFormat.format(Translator.getInstance().getTranslation("Click_to_open_links"), PlatformDetector.isMacOS() ? "Command" : "Ctrl");
                }
                this.msgArea.setToolTipText(tooltipText);
            }
        }

        private void addHighlight(JTextArea msgArea, DetectedURLInfo urlAtMousePosition) {
            try {
                ColorTheme colorTheme = PluginWorkspaceProvider.getPluginWorkspace().getColorTheme();
                this.highlightTag = msgArea.getHighlighter().addHighlight(urlAtMousePosition.startOffset, urlAtMousePosition.endOffset, new LinkHighlighterPainter(colorTheme.isDarkTheme() ? Color.LIGHT_GRAY : Color.BLUE));
            }
            catch (BadLocationException e1) {
                log.error(e1.getMessage(), (Throwable)e1);
            }
        }
    }

    static class DetectedURLInfo {
        URL url;
        int startOffset;
        int endOffset;

        DetectedURLInfo(URL url, int startOffset, int endOffset) {
            this.url = url;
            this.startOffset = startOffset;
            this.endOffset = endOffset;
        }

        public String toString() {
            return "Detected URL " + this.url + " start:" + this.startOffset + " end:" + this.endOffset;
        }
    }

    private static class LinkHighlighterPainter
    extends DefaultHighlighter.DefaultHighlightPainter {
        private LinkHighlighterPainter(Color c) {
            super(c);
        }

        @Override
        public Shape paintLayer(Graphics g, int offs0, int offs1, Shape bounds, JTextComponent c, View view) {
            Color color = this.getColor();
            if (color == null) {
                g.setColor(c.getSelectionColor());
            } else {
                g.setColor(color);
            }
            Rectangle r = null;
            if (offs0 == view.getStartOffset() && offs1 == view.getEndOffset()) {
                r = bounds instanceof Rectangle ? (Rectangle)bounds : bounds.getBounds();
            } else {
                try {
                    Shape shape = view.modelToView(offs0, Position.Bias.Forward, offs1, Position.Bias.Backward, bounds);
                    r = shape instanceof Rectangle ? (Rectangle)shape : shape.getBounds();
                }
                catch (BadLocationException e) {
                    r = null;
                }
            }
            if (r != null) {
                g.drawLine(r.x, r.y + r.height - 1, r.x + r.width, r.y + r.height - 1);
            }
            return r;
        }
    }
}

