/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.positron.plugin.chat;

import com.oxygenxml.positron.core.plugin.Translator;
import com.oxygenxml.positron.core.tools.UnsafeFunctionInterceptor;
import com.oxygenxml.positron.plugin.chat.FunctionCallsDetailsDialog;
import com.oxygenxml.positron.plugin.ui.LinkLabel;
import com.oxygenxml.positron.plugin.ui.MultilineLabel;
import com.oxygenxml.positron.plugin.util.IconsLoader;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Desktop;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import java.io.StringReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.MessageFormat;
import java.util.List;
import java.util.regex.Pattern;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import javax.swing.JToolTip;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.sync.basic.util.URLUtil;
import ro.sync.basic.xml.BasicXmlUtil;
import ro.sync.exml.workspace.api.PluginWorkspace;
import ro.sync.exml.workspace.api.PluginWorkspaceProvider;
import ro.sync.exml.workspace.api.standalone.ui.OxygenUIComponentsFactory;
import ro.sync.exml.workspace.api.standalone.ui.ToolbarButton;

public class FunctionCallsAndDetailsPanel
extends JPanel {
    private static final Logger log = LoggerFactory.getLogger(FunctionCallsAndDetailsPanel.class);
    private static final Translator TRANSLATOR = Translator.getInstance();
    private static final Pattern URL_PATTERN = Pattern.compile("^([a-zA-Z][-a-zA-Z]*)://?[^\\s]+$");
    private JEditorPane functionCallsHTMLPane;
    private JButton functionCallInfoButton;
    private FunctionCallsDetailsDialog functionCallsDetailsDialog;

    public FunctionCallsAndDetailsPanel() {
        this.setOpaque(false);
        this.setLayout(new GridBagLayout());
        this.setVisible(false);
        this.functionCallInfoButton = new ToolbarButton(new AbstractAction(TRANSLATOR.getTranslation("Ai_Function_Calls_Details"), IconsLoader.loadIcon("/images/ToolsInspect.png")){

            @Override
            public void actionPerformed(ActionEvent e) {
                FunctionCallsAndDetailsPanel.this.functionCallsDetailsDialog.showDialog();
            }
        }, false){

            public JToolTip createToolTip() {
                return OxygenUIComponentsFactory.installMultilineTooltip((JComponent)FunctionCallsAndDetailsPanel.this.functionCallInfoButton);
            }
        };
    }

    private void initFunctionCallsDialogIfNecessary() {
        if (this.functionCallsDetailsDialog == null) {
            this.functionCallInfoButton.setVisible(true);
            this.functionCallsDetailsDialog = new FunctionCallsDetailsDialog();
        }
    }

    public void addFunctionExecutedStartedDetails(String toolId, String functionName, String params) {
        this.initFunctionCallsDialogIfNecessary();
        this.functionCallsDetailsDialog.addFunctionExecutionStarted(functionName, params);
        this.updateTooltip();
    }

    private void updateTooltip() {
        this.functionCallInfoButton.setToolTipText(TRANSLATOR.getTranslation("Ai_Function_Calls_Details") + "\n\n" + this.functionCallsDetailsDialog.getFunctionDetails());
    }

    public void addFunctionCallResultDetails(String toolId, String result) {
        this.initFunctionCallsDialogIfNecessary();
        this.functionCallsDetailsDialog.addFunctionExecutionResult(result);
        this.updateTooltip();
    }

    public void addFunctionCallErrorDetails(String error) {
        this.initFunctionCallsDialogIfNecessary();
        this.functionCallsDetailsDialog.addFunctionCallError(error);
        String errorMsg = "<div color='red'>ERROR: " + error + "</div>";
        this.addFunctionDetails(errorMsg);
        this.updateTooltip();
    }

    public void addFunctionCallsDetails(List<String> functionCalls) {
        this.initFunctionCallsDialogIfNecessary();
        this.functionCallsDetailsDialog.addAllFunctionCalls(functionCalls);
        this.updateTooltip();
    }

    private void addFunctionDetails(String toolHTMLDescription) {
        if (this.functionCallsHTMLPane == null) {
            this.functionCallsHTMLPane = OxygenUIComponentsFactory.createHTMLEditorPane((String)"<html><body>", (boolean)true);
            this.functionCallsHTMLPane.setEditable(false);
            this.addHyperlinkListener();
            GridBagConstraints constr = new GridBagConstraints();
            constr.gridx = 0;
            constr.gridy = 0;
            constr.weightx = 0.0;
            constr.weighty = 0.0;
            constr.fill = 0;
            constr.anchor = 12;
            this.add((Component)this.functionCallInfoButton, constr);
            ++constr.gridx;
            constr.weightx = 1.0;
            constr.weighty = 1.0;
            constr.fill = 1;
            constr.insets = new Insets(2, 0, 0, 0);
            this.add((Component)this.functionCallsHTMLPane, constr);
            this.setVisible(true);
        }
        Document doc = this.functionCallsHTMLPane.getDocument();
        try {
            this.functionCallsHTMLPane.getEditorKit().read(new StringReader(toolHTMLDescription), doc, doc.getLength());
        }
        catch (IOException | BadLocationException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
    }

    private void interceptUnsafeTool(String toolName, String arguments, final UnsafeFunctionInterceptor interceptor) {
        if (interceptor != null) {
            GridBagConstraints constr = new GridBagConstraints();
            constr.gridx = 0;
            constr.gridy = 1;
            constr.anchor = 12;
            ++constr.gridx;
            constr.weightx = 1.0;
            constr.weighty = 1.0;
            constr.fill = 1;
            constr.insets = new Insets(2, 0, 0, 0);
            final JPanel approvalPanel = new JPanel(new GridBagLayout());
            approvalPanel.setOpaque(false);
            approvalPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(Color.lightGray), BorderFactory.createEmptyBorder(2, 2, 2, 2)));
            this.add((Component)approvalPanel, constr);
            GridBagConstraints approvalConstr = new GridBagConstraints();
            approvalConstr.gridx = 0;
            approvalConstr.gridy = 1;
            approvalConstr.weightx = 1.0;
            approvalConstr.weighty = 1.0;
            approvalConstr.fill = 1;
            approvalConstr.anchor = 17;
            approvalConstr.gridwidth = 2;
            approvalConstr.insets = new Insets(2, 2, 2, 2);
            MultilineLabel warning = new MultilineLabel(MessageFormat.format(TRANSLATOR.getTranslation("External_unsafe_tool_call_proceed"), toolName, arguments), false);
            approvalPanel.add((Component)warning, approvalConstr);
            approvalConstr.weightx = 0.0;
            approvalConstr.fill = 0;
            ++approvalConstr.gridy;
            approvalConstr.gridwidth = 1;
            approvalPanel.add((Component)new LinkLabel(TRANSLATOR.getTranslation("Yes")){

                @Override
                public void performAction() {
                    interceptor.setAccepted(true);
                    approvalPanel.setVisible(false);
                }
            }, approvalConstr);
            ++approvalConstr.gridx;
            approvalPanel.add((Component)new LinkLabel(TRANSLATOR.getTranslation("No")){

                @Override
                public void performAction() {
                    interceptor.setAccepted(false);
                    approvalPanel.setVisible(false);
                }
            }, approvalConstr);
        }
    }

    private void addHyperlinkListener() {
        HyperlinkListener[] listeners = this.functionCallsHTMLPane.getHyperlinkListeners();
        if (listeners != null) {
            for (HyperlinkListener hyperlinkListener : listeners) {
                this.functionCallsHTMLPane.removeHyperlinkListener(hyperlinkListener);
            }
        }
        this.functionCallsHTMLPane.addHyperlinkListener(new HyperlinkListener(){

            @Override
            public void hyperlinkUpdate(HyperlinkEvent e) {
                URL url;
                final PluginWorkspace pwp = PluginWorkspaceProvider.getPluginWorkspace();
                if (HyperlinkEvent.EventType.ACTIVATED.equals(e.getEventType()) && (url = e.getURL()) != null) {
                    if (pwp.getUtilAccess().isUnhandledBinaryResourceURL(url)) {
                        pwp.openInExternalApplication(url, true);
                    } else {
                        final URL urlTOOpen = url;
                        new Thread("Open Link"){

                            @Override
                            public void run() {
                                File file = URLUtil.getCanonicalFileFromFileUrl((URL)urlTOOpen);
                                if (file != null && file.isDirectory()) {
                                    if (Desktop.isDesktopSupported() && Desktop.getDesktop().isSupported(Desktop.Action.BROWSE_FILE_DIR)) {
                                        Desktop.getDesktop().browseFileDirectory(file);
                                    }
                                } else {
                                    pwp.open(urlTOOpen);
                                }
                            }
                        }.start();
                    }
                }
                if (HyperlinkEvent.EventType.ENTERED.equals(e.getEventType())) {
                    FunctionCallsAndDetailsPanel.this.setCursor(Cursor.getPredefinedCursor(12));
                }
                if (HyperlinkEvent.EventType.EXITED.equals(e.getEventType())) {
                    FunctionCallsAndDetailsPanel.this.setCursor(Cursor.getDefaultCursor());
                }
            }
        });
    }

    public String getFunctionCallContentForTests() {
        if (this.functionCallsHTMLPane != null) {
            String normalized = this.functionCallsHTMLPane.getText().replaceAll("\\n", "").replaceAll("(\\s+)", " ").replace("</div>", "\n").replaceAll("<(.*?)>", "").trim();
            return normalized;
        }
        return "";
    }

    static String processHTMLLinks(String text) {
        int startLinkIndex = ((String)text).indexOf(40);
        int endLinkIndex = ((String)text).lastIndexOf(41);
        StringBuilder sb = new StringBuilder();
        if (startLinkIndex != -1 && endLinkIndex > startLinkIndex) {
            sb.append("<span>");
            sb.append(BasicXmlUtil.escape((String)((String)text).substring(0, startLinkIndex)));
            String paramContent = ((String)text).substring(startLinkIndex + 1, endLinkIndex).trim();
            File possibleFile = FunctionCallsAndDetailsPanel.extractLocalFile(paramContent);
            if (possibleFile != null) {
                Object fileName = possibleFile.getName();
                if (possibleFile.isDirectory()) {
                    fileName = (String)fileName + "/";
                }
                sb.append("(<a href=\"").append(URLUtil.convertToURL((String)paramContent)).append("\">").append(BasicXmlUtil.escape((String)URLUtil.uncorrect((String)fileName))).append("</a>)");
            } else if (URL_PATTERN.matcher(paramContent).matches()) {
                String fileName = null;
                if (!paramContent.startsWith("http")) {
                    fileName = URLUtil.extractFileName((String)paramContent);
                }
                if (fileName == null || fileName.isEmpty()) {
                    fileName = URLUtil.filterPasswords((String)paramContent);
                }
                sb.append("(<a href=\"").append(URLUtil.convertToURL((String)paramContent)).append("\">").append(BasicXmlUtil.escape((String)URLUtil.uncorrect((String)fileName))).append("</a>)");
            } else {
                sb.append("(<b>").append(BasicXmlUtil.escape((String)paramContent)).append("</b>)");
            }
        } else {
            if (((String)(text = BasicXmlUtil.escape((String)text))).contains("\n")) {
                text = "<span>" + ((String)text).replace("\n", "<br>") + "</span>";
            }
            return text;
        }
        sb.append(BasicXmlUtil.escape((String)((String)text).substring(endLinkIndex + 1)).replace("\n", "<br>"));
        sb.append("</span>");
        return sb.toString();
    }

    private static File extractLocalFile(String param) {
        File possibleFile = null;
        File f = new File(param);
        if (f.exists()) {
            possibleFile = f;
        } else {
            try {
                f = URLUtil.getCanonicalFileFromFileUrl((URL)new URL(param));
                if (f != null && f.exists()) {
                    possibleFile = f;
                }
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        return possibleFile;
    }

    public boolean hasMeaningfulContent() {
        return this.functionCallsHTMLPane != null;
    }

    public void appendFunction(String description) {
        String newCall = "<div>" + FunctionCallsAndDetailsPanel.processHTMLLinks(description) + "</div>";
        this.addFunctionDetails(newCall);
    }

    protected String getFunctionCallsDetails() {
        return this.functionCallsDetailsDialog.getFunctionDetails();
    }

    public void checkExecutionAllowed(String toolId, String name, String description, String arguments, UnsafeFunctionInterceptor interceptor) {
        this.interceptUnsafeTool(name, arguments, interceptor);
    }
}

