/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.positron.plugin.chat;

import com.jidesoft.swing.JideSplitPane;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

public class ChatSplitPanel
extends JideSplitPane {
    private static final int DIVIDER_SIZE = 5;
    public static final double INITIAL_PROPORTION_OF_TOP_PANEL = 0.7;
    public static final double MIN_PROPORTION_OF_TOP_PANEL = 0.6;
    private JPanel bottomPanel;
    private Color dividerBgColor;

    public ChatSplitPanel(JPanel topPanel, JPanel bottomPanel) {
        super(0);
        this.bottomPanel = bottomPanel;
        this.add(topPanel);
        this.add(bottomPanel);
        this.setContinuousLayout(true);
        this.setProportionalLayout(true);
        this.setDividerSize(5);
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                ChatSplitPanel.this.resetProportionsDefault();
            }
        });
    }

    public void resetProportionsDefault() {
        int totalHeight = this.getHeight();
        if (totalHeight > 0) {
            int minBottomHeight = this.bottomPanel.getMinimumSize().height;
            double minBottomProportion = (double)minBottomHeight / (double)totalHeight;
            double topProportion = Math.min(0.7, 1.0 - minBottomProportion);
            this.setProportions(new double[]{topProportion});
        } else {
            this.setProportions(new double[]{0.7});
        }
    }

    public void setDividerBackgroundColor(Color color) {
        this.dividerBgColor = color;
        SwingUtilities.invokeLater(this::applyDividerBgColor);
    }

    private void applyDividerBgColor() {
        if (this.dividerBgColor == null) {
            return;
        }
        for (Component child : this.getComponents()) {
            String className = child.getClass().getName().toLowerCase();
            if (!className.contains("divider")) continue;
            child.setBackground(this.dividerBgColor);
            if (!(child instanceof JComponent)) continue;
            ((JComponent)child).setOpaque(true);
        }
    }

    public void addNotify() {
        super.addNotify();
        SwingUtilities.invokeLater(this::applyDividerBgColor);
    }

    public void updateUI() {
        super.updateUI();
        SwingUtilities.invokeLater(this::applyDividerBgColor);
    }
}

