/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.positron.plugin.chat;

import com.oxygenxml.positron.api.connector.dto.AssistantMessage;
import com.oxygenxml.positron.api.connector.dto.CompletionToolCall;
import com.oxygenxml.positron.api.connector.dto.Message;
import com.oxygenxml.positron.api.connector.dto.MessageContent;
import com.oxygenxml.positron.api.connector.dto.MessageTextContent;
import com.oxygenxml.positron.api.connector.dto.RoleType;
import com.oxygenxml.positron.api.connector.dto.ToolCallResponseMessage;
import com.oxygenxml.positron.connector.ConnectorConfigurationsPO;
import com.oxygenxml.positron.core.actions.ActionInteractor;
import com.oxygenxml.positron.core.actions.DefaultActionInteractor;
import com.oxygenxml.positron.core.actions.ParamsExpander;
import com.oxygenxml.positron.core.actions.types.BaseActionInteractor;
import com.oxygenxml.positron.core.actions.types.UpdateEntireDocumentActionInteractor;
import com.oxygenxml.positron.core.auth.BrowserOpener;
import com.oxygenxml.positron.core.auth.exceptions.ServerRequestException;
import com.oxygenxml.positron.core.engines.EnginesManagerProvider;
import com.oxygenxml.positron.core.engines.IEnginesManager;
import com.oxygenxml.positron.core.interactions.DocumentDetailsProvider;
import com.oxygenxml.positron.core.plugin.Translator;
import com.oxygenxml.positron.core.tools.UnsafeFunctionInterceptor;
import com.oxygenxml.positron.core.util.XMLDocumentResponseTypeDetector;
import com.oxygenxml.positron.plugin.AIActionsInfoProvider;
import com.oxygenxml.positron.plugin.chat.ChatConnectionPanelListener;
import com.oxygenxml.positron.plugin.chat.ChatMessage;
import com.oxygenxml.positron.plugin.chat.ChatMessageNavigationLevel;
import com.oxygenxml.positron.plugin.chat.ChatMessageResponseWithActionsPanel;
import com.oxygenxml.positron.plugin.chat.ChatMessageResponseWithActionsPanelInterface;
import com.oxygenxml.positron.plugin.chat.ChatMessageSender;
import com.oxygenxml.positron.plugin.chat.ChatModel;
import com.oxygenxml.positron.plugin.chat.ChatScrollUpdater;
import com.oxygenxml.positron.plugin.chat.CurrentMessagePanel;
import com.oxygenxml.positron.plugin.chat.EditableMessagePanel;
import com.oxygenxml.positron.plugin.chat.ErrorMessagePanel;
import com.oxygenxml.positron.plugin.chat.GenericTranslationChatStartMessage;
import com.oxygenxml.positron.plugin.chat.MessagePanel;
import com.oxygenxml.positron.plugin.chat.MessageUpdater;
import com.oxygenxml.positron.plugin.chat.ResponseMessagePanel;
import com.oxygenxml.positron.plugin.chat.ValidationErrorMessagePanel;
import com.oxygenxml.positron.plugin.chat.actions.ActionPanelUpdater;
import com.oxygenxml.positron.plugin.chat.actions.BranchNavigator;
import com.oxygenxml.positron.plugin.chat.actions.ChatResponseActionsPanel;
import com.oxygenxml.positron.plugin.chat.history.CorrectionMessageNode;
import com.oxygenxml.positron.plugin.chat.history.MessageNode;
import com.oxygenxml.positron.plugin.chat.history.ToolCallInfo;
import com.oxygenxml.positron.plugin.chat.history.ToolsMessageNode;
import com.oxygenxml.positron.plugin.chat.history.ValidationErrorMessageNode;
import com.oxygenxml.positron.plugin.chat.utils.ChatCommonUtil;
import com.oxygenxml.positron.plugin.chat.utils.ChatUtil;
import com.oxygenxml.positron.plugin.ui.LinkLabel;
import com.oxygenxml.positron.plugin.util.AiPositronServiceAccess;
import com.oxygenxml.positron.plugin.util.IconsLoader;
import com.oxygenxml.positron.plugin.util.LinkOpener;
import com.oxygenxml.positron.utilities.ModelIdentifierUtil;
import com.oxygenxml.positron.utilities.json.AIActionDetails;
import com.oxygenxml.positron.utilities.json.Engine;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.text.BadLocationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.sync.basic.util.URLUtil;
import ro.sync.exml.workspace.api.PluginWorkspaceProvider;
import ro.sync.exml.workspace.api.options.ExternalPersistentObject;
import ro.sync.exml.workspace.api.options.WSOptionsStorage;
import ro.sync.exml.workspace.api.standalone.StandalonePluginWorkspace;

public class ChatPanelMessageUpdater
implements MessageUpdater {
    private static final Logger log = LoggerFactory.getLogger(ChatPanelMessageUpdater.class);
    private JPanel messagesPanel;
    private ChatMessageSender chatSender;
    private GridBagConstraints conversationMessagesConstraints = new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 11, 2, new Insets(5, 0, 5, 0), 0, 0);
    private CurrentMessagePanel lastMessageInUpdatePanel;
    private ResponseMessagePanel responseMessagePanel;
    private ValidationErrorMessagePanel lastValidationErrorPanel;
    private BrowserOpener browserOpener = new BrowserOpener();
    private ChatScrollUpdater chatScrollUpdater;
    private CurrentMessagePanel currentMessagePanel;
    private Engine actionEngine;
    private Supplier<DocumentDetailsProvider> documentDetailsProvider;
    private ChatConnectionPanelListener chatConnectionPanelListener;

    public ChatPanelMessageUpdater(JPanel messagesPanel, ChatMessageSender chatMessageSender, ChatScrollUpdater chatScrollUpdater, Supplier<DocumentDetailsProvider> documentDetailsProvider, StandalonePluginWorkspace pluginWS) {
        this.messagesPanel = messagesPanel;
        this.chatSender = chatMessageSender;
        this.chatScrollUpdater = chatScrollUpdater;
        this.documentDetailsProvider = documentDetailsProvider;
    }

    public void addEmptyAssistantMessageToConversationGui() {
        this.addEmptyAssistantMessageToConversationGui(null);
    }

    private void addEmptyAssistantMessageToConversationGui(String aiModelOptional) {
        if (this.responseMessagePanel != null) {
            this.responseMessagePanel.setCurrentResponse(false);
        }
        Optional<String> engineModelOptional = Optional.ofNullable(aiModelOptional);
        this.responseMessagePanel = new ResponseMessagePanel(engineModelOptional, this.hasResponseAsLastPanel(), this.actionEngine != null, this.chatScrollUpdater);
        if (this.currentMessagePanel != null) {
            this.currentMessagePanel.reconfigureChatMessageActions();
        }
        this.currentMessagePanel = new CurrentMessagePanel(this.responseMessagePanel);
        this.responseMessagePanel.setBranchNavigator(new BranchNavigator(){

            @Override
            public void right() {
                ChatPanelMessageUpdater.this.selectSiblingMessage(ChatPanelMessageUpdater.this.currentMessagePanel, true);
            }

            @Override
            public void left() {
                ChatPanelMessageUpdater.this.selectSiblingMessage(ChatPanelMessageUpdater.this.currentMessagePanel, false);
            }
        });
        this.lastMessageInUpdatePanel = this.currentMessagePanel;
        this.messagesPanel.add((Component)this.lastMessageInUpdatePanel, this.conversationMessagesConstraints);
        this.chatScrollUpdater.componentAddedToConversationThread();
    }

    public void addNormalMessageToConversationGUI(ChatMessage chatMessage, boolean isFirstMessageForAction, String aiModel, String originalActionInvocationContext) {
        this.addNormalMessageToConversationGUI(chatMessage, isFirstMessageForAction, aiModel, null, originalActionInvocationContext);
    }

    public void addNormalMessageToConversationGUI(ChatMessage chatMessage, boolean isFirstMessageForAction, String aiModel, ActionInteractor interactor, String originalActionInvocationContext) {
        boolean shoudCreateEditButton;
        Message message = chatMessage.getMessage();
        RoleType messageRole = message.getRole();
        ChatMessageResponseWithActionsPanel currentMessagePanel = null;
        boolean bl = shoudCreateEditButton = messageRole == RoleType.USER && (!isFirstMessageForAction || this.messagesPanel.getComponentCount() > 0);
        if (shoudCreateEditButton) {
            currentMessagePanel = new EditableMessagePanel(chatMessage, this);
            currentMessagePanel.setEditableMessageToolbarEnabled(true);
        } else if (messageRole == RoleType.ASSISTANT && chatMessage.getType() == ChatMessage.MessageType.NORMAL) {
            this.responseMessagePanel = new ResponseMessagePanel(Optional.ofNullable(aiModel), this.hasResponseAsLastPanel(), this.actionEngine != null, this.chatScrollUpdater);
            final CurrentMessagePanel panel = new CurrentMessagePanel(this.responseMessagePanel);
            this.responseMessagePanel.setBranchNavigator(new BranchNavigator(){

                @Override
                public void right() {
                    ChatPanelMessageUpdater.this.selectSiblingMessage(panel, true);
                }

                @Override
                public void left() {
                    ChatPanelMessageUpdater.this.selectSiblingMessage(panel, false);
                }
            });
            currentMessagePanel = panel;
            ChatMessageNavigationLevel computeNavigationLevel = this.computeNavigationLevel(currentMessagePanel);
            this.responseMessagePanel.updateUiForLevels(computeNavigationLevel);
            String messageContent = "";
            if (!message.getContent().isEmpty()) {
                messageContent = ((MessageTextContent)message.getContent().get(0)).getText();
                this.responseMessagePanel.appendChunk(messageContent);
                this.responseMessagePanel.hideAssistantProgress();
                this.responseMessagePanel.actionFinished();
            }
            this.updateActionInteractorInternal(currentMessagePanel, messageContent, interactor);
        } else {
            currentMessagePanel = new MessagePanel(chatMessage, this, originalActionInvocationContext);
        }
        this.addMessagePanelToConversationGUI(currentMessagePanel);
    }

    private void addNotSuccessfulMessageToConversationGUI(String errorMessage, boolean wasCancelled, boolean shouldAllowRetry, Map<String, String> links) {
        ErrorMessagePanel currentMessagePanel = new ErrorMessagePanel(new ChatMessage(new Message(RoleType.ASSISTANT, (MessageContent)new MessageTextContent(errorMessage)), wasCancelled ? ChatMessage.MessageType.NORMAL : ChatMessage.MessageType.ERROR), this);
        if (shouldAllowRetry || links != null && !links.isEmpty()) {
            JPanel actionsPanel = new JPanel(new FlowLayout(2, 10, 1));
            if (shouldAllowRetry) {
                this.addRetryAction(actionsPanel);
            }
            if (links != null && !links.isEmpty()) {
                for (final Map.Entry<String, String> link : links.entrySet()) {
                    LinkLabel linkLabel = new LinkLabel(link.getKey()){

                        @Override
                        public void performAction() {
                            new LinkOpener(ChatPanelMessageUpdater.this.browserOpener).openLink((String)link.getValue());
                        }
                    };
                    actionsPanel.add((Component)linkLabel, 0);
                }
            }
            actionsPanel.setOpaque(false);
            currentMessagePanel.addSouthPanel(actionsPanel);
        }
        this.addMessagePanelToConversationGUI(currentMessagePanel);
    }

    private void addMessagePanelToConversationGUI(JPanel messagePanel) {
        this.messagesPanel.add((Component)messagePanel, this.conversationMessagesConstraints);
        ++this.conversationMessagesConstraints.gridy;
        this.chatScrollUpdater.componentAddedToConversationThread();
    }

    private void addRetryAction(JPanel actionsPanel) {
        JButton retryBtn = ChatUtil.createResponseActionButtonWithIcon(Translator.getInstance().getTranslation("Retry"), null, IconsLoader.loadIcon("/images/Refresh16.png"), () -> {
            this.messagesPanel.remove(this.messagesPanel.getComponentCount() - 1);
            this.messagesPanel.remove(this.messagesPanel.getComponentCount() - 1);
            this.messagesPanel.revalidate();
            this.messagesPanel.repaint();
            SwingUtilities.invokeLater(this::addEmptyAssistantMessageToConversationGui);
            this.chatSender.sendChatMessages(null, null);
        });
        actionsPanel.add(retryBtn);
    }

    public void cancelMessageEditing() {
        Component[] components;
        for (Component component : components = this.messagesPanel.getComponents()) {
            EditableMessagePanel messagePanel;
            if (!(component instanceof EditableMessagePanel) || !(messagePanel = (EditableMessagePanel)component).isMessageBeingEdited()) continue;
            messagePanel.cancelEdit();
            break;
        }
    }

    public void setMessageEditingState(boolean enabled) {
        Component[] components;
        for (Component component : components = this.messagesPanel.getComponents()) {
            if (!(component instanceof EditableMessagePanel)) continue;
            EditableMessagePanel messagePanel = (EditableMessagePanel)component;
            messagePanel.setEditableMessageToolbarEnabled(enabled);
        }
    }

    public void setResponseActionsEnabled(boolean enabled, JComponent parent) {
        int componentCount = parent.getComponentCount();
        for (int i = 0; i < componentCount; ++i) {
            Component child = parent.getComponent(i);
            if (child instanceof ResponseMessagePanel) {
                ResponseMessagePanel rp = (ResponseMessagePanel)child;
                rp.updatePopupActionsEnabledState(enabled);
                continue;
            }
            if (child instanceof ChatResponseActionsPanel) {
                ChatResponseActionsPanel responseMessage = (ChatResponseActionsPanel)child;
                responseMessage.setResponseActionsEnabled(enabled);
                continue;
            }
            if (!(child instanceof JComponent)) continue;
            this.setResponseActionsEnabled(enabled, (JComponent)child);
        }
    }

    public void addStartChatMessagesForAction(AIActionDetails actionDetails, Map<String, String> actionParameters, List<Message> requestMessages, String imposedStartMessage, boolean ignoredFromAiIgnoreFile) {
        Message message = imposedStartMessage != null && !imposedStartMessage.isEmpty() ? new Message(RoleType.USER, (MessageContent)new MessageTextContent(imposedStartMessage)) : this.constructDisplayMessageForOxygenInitiative(actionDetails, requestMessages);
        SwingUtilities.invokeLater(() -> {
            String originalActionInvocationContext = null;
            if (!ignoredFromAiIgnoreFile) {
                originalActionInvocationContext = ChatPanelMessageUpdater.extractOriginalActionInvocationContext(actionDetails, requestMessages);
            }
            this.addNormalMessageToConversationGUI(new ChatMessage(message), true, null, originalActionInvocationContext);
            this.addEmptyAssistantMessageToConversationGui();
        });
    }

    private static String extractOriginalActionInvocationContext(AIActionDetails actionDetails, List<Message> requestMessages) {
        Message firstMessage;
        List contentMsgs;
        String actionInvocationContext = null;
        if (!(requestMessages == null || requestMessages.isEmpty() || ChatPanelMessageUpdater.isCopilotAction(actionDetails) || (contentMsgs = (firstMessage = requestMessages.get(0)).getContent()) == null || contentMsgs.isEmpty())) {
            actionInvocationContext = ((MessageTextContent)contentMsgs.get(0)).getText();
            actionInvocationContext = URLUtil.filterPasswords((String)actionInvocationContext);
        }
        return actionInvocationContext;
    }

    private static boolean isCopilotAction(AIActionDetails actionDetails) {
        return "pseudoaction.copilot.rewrite.content.based.on.instructions".equals(actionDetails.getId());
    }

    Message constructDisplayMessageForOxygenInitiative(AIActionDetails actionDetails, List<Message> requestMessages) {
        this.actionEngine = null;
        if (actionDetails.getParameters() != null) {
            this.actionEngine = actionDetails.getParameters().getEngine();
        }
        String messageContent = "";
        String actionID = actionDetails.getId();
        if (ChatPanelMessageUpdater.isCopilotAction(actionDetails) && requestMessages != null) {
            MessageTextContent requestTextContent = (MessageTextContent)requestMessages.get(0).getContent().get(0);
            messageContent = requestTextContent.getText();
        } else {
            Optional<GenericTranslationChatStartMessage> genericTranslationMsg;
            String longDescription;
            String shortDesc = actionDetails.getShortDescription();
            String string = longDescription = actionDetails.getDescription() != null ? actionDetails.getDescription() : "";
            if ("action.translate.to.lang".equals(actionID) && (genericTranslationMsg = ChatCommonUtil.getGenericTranslationChatStartMessage(actionDetails)).isPresent()) {
                GenericTranslationChatStartMessage msgDetails = genericTranslationMsg.get();
                shortDesc = msgDetails.getShortDescription();
                longDescription = msgDetails.getLongDescription();
            }
            StringBuilder contentBuilder = new StringBuilder();
            contentBuilder.append(shortDesc);
            if (longDescription != null && !longDescription.isEmpty()) {
                contentBuilder.append("\n").append(longDescription);
            }
            this.handleDevModeFlag(actionDetails, contentBuilder);
            messageContent = contentBuilder.toString();
        }
        return new Message(RoleType.USER, (MessageContent)new MessageTextContent(messageContent));
    }

    private void handleDevModeFlag(AIActionDetails actionDetails, StringBuilder contentBuilder) {
        boolean shouldShowDevInfo;
        String actionPrompt = actionDetails.getPrompt();
        List expandParams = actionDetails.getExpandParams();
        boolean devMode = Boolean.getBoolean("oxygen.ai.positron.development.mode");
        boolean internalDevMode = Boolean.getBoolean("oxygen.ai.positron.internal.development.mode");
        boolean bl = shouldShowDevInfo = internalDevMode || devMode && !actionDetails.isBuiltinAction();
        if (shouldShowDevInfo) {
            if (expandParams != null && !expandParams.isEmpty()) {
                HashMap expandedParams = new HashMap();
                DocumentDetailsProvider docProvider = this.documentDetailsProvider.get();
                ParamsExpander.expandParams((String)actionDetails.getId(), (List)expandParams, (DocumentDetailsProvider)docProvider, expandedParams);
                String expandedPrompt = actionPrompt;
                if (expandedPrompt != null && !expandedPrompt.isEmpty()) {
                    for (Map.Entry entry : expandedParams.entrySet()) {
                        expandedPrompt = expandedPrompt.replace("${" + (String)entry.getKey() + "}", (CharSequence)entry.getValue());
                    }
                    contentBuilder.append("\n\n**Expanded Action Prompt:**\n").append(expandedPrompt);
                }
                if (!expandedParams.isEmpty()) {
                    contentBuilder.append("\n\n**Expanded Parameters:**\n");
                    for (Map.Entry entry : expandedParams.entrySet()) {
                        contentBuilder.append("- ").append((String)entry.getKey()).append(": ").append((String)entry.getValue()).append("\n");
                    }
                }
            } else if (actionPrompt != null && !actionPrompt.isEmpty()) {
                contentBuilder.append("\n\n**Action Prompt:**\n").append(actionPrompt);
            }
        }
    }

    public void addStartChatMessagesForUserMessage(final Message userMessage) {
        Runnable runnableWrapper = new Runnable(){

            @Override
            public void run() {
                ChatPanelMessageUpdater.this.addNormalMessageToConversationGUI(new ChatMessage(userMessage), false, null, null);
                ChatPanelMessageUpdater.this.addEmptyAssistantMessageToConversationGui();
            }
        };
        if (SwingUtilities.isEventDispatchThread()) {
            runnableWrapper.run();
        } else {
            try {
                SwingUtilities.invokeAndWait(runnableWrapper::run);
            }
            catch (InterruptedException e) {
                log.debug(e.getMessage(), (Throwable)e);
                Thread.currentThread().interrupt();
            }
            catch (InvocationTargetException e) {
                log.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    public void addAssistantChunkMessage(String messageChunk) {
        SwingUtilities.invokeLater(() -> this.responseMessagePanel.appendChunk(messageChunk));
    }

    public void clearCurrentResponse() {
        SwingUtilities.invokeLater(() -> this.responseMessagePanel.clearResponse());
    }

    public void updateAIModelOnLabel(String model) {
        SwingUtilities.invokeLater(() -> this.responseMessagePanel.updateModel(model));
    }

    public void removeChatMessageForCurentResponseChunks() {
        if (this.lastMessageInUpdatePanel != null) {
            this.messagesPanel.remove(this.lastMessageInUpdatePanel);
            this.messagesPanel.revalidate();
            this.messagesPanel.repaint();
        }
    }

    public void markAssistantChunksAsFinished(ActionInteractor actionInteractor, String messageContent, boolean isIncomplete) {
        SwingUtilities.invokeLater(() -> {
            this.responseMessagePanel.hideAssistantProgress();
            if (!isIncomplete) {
                this.updateActionInteractorInternal(this.lastMessageInUpdatePanel, messageContent, actionInteractor);
            }
            ++this.conversationMessagesConstraints.gridy;
        });
    }

    private void updateActionInteractorInternal(ChatMessageResponseWithActionsPanel parentPanel, String messageContent, ActionInteractor actionInteractor) {
        if (actionInteractor == null) {
            DefaultActionInteractor defaultInteractor = this.chatSender.getDefaultActionInteractor();
            if (XMLDocumentResponseTypeDetector.isLikelyCompleteDocument((String)messageContent, (String)defaultInteractor.getContentType())) {
                UpdateEntireDocumentActionInteractor updateEntireDocumentActionInteractor = new UpdateEntireDocumentActionInteractor(this.chatSender.getChatModel().getActionDetails());
                defaultInteractor.transferContentInserterAndListenerTo((BaseActionInteractor)updateEntireDocumentActionInteractor);
                updateEntireDocumentActionInteractor.setAiInitialSuggestion(messageContent, null, null);
                actionInteractor = updateEntireDocumentActionInteractor;
            } else {
                Object object = actionInteractor = defaultInteractor.isDocumentOpened() ? defaultInteractor : null;
            }
        }
        if (actionInteractor instanceof BaseActionInteractor) {
            ((BaseActionInteractor)actionInteractor).setNewAISuggestion(messageContent);
        }
        ActionPanelUpdater.updateActionInteractor(actionInteractor, parentPanel, messageContent, this, this.chatScrollUpdater);
    }

    public void showMessageForNotSuccessfulAction(String errorMessage, boolean wasCancelled, boolean shouldAllowRetry, Map<String, String> links) {
        SwingUtilities.invokeLater(() -> {
            if (this.responseMessagePanel != null) {
                this.responseMessagePanel.hideAssistantProgress();
            }
            ++this.conversationMessagesConstraints.gridy;
            this.addNotSuccessfulMessageToConversationGUI(errorMessage, wasCancelled, shouldAllowRetry, links);
        });
    }

    public void notifyActionStopped() {
        if (this.responseMessagePanel != null) {
            SwingUtilities.invokeLater(() -> {
                this.responseMessagePanel.hideAssistantProgress();
                this.responseMessagePanel.actionFinished();
            });
        }
    }

    public void setModel(ChatModel newModel) {
        if (!newModel.isUserInitiative()) {
            List<Message> initialMessages = newModel.getInitialMessages();
            AIActionDetails actionDetails = newModel.getActionDetails();
            Message message = this.constructDisplayMessageForOxygenInitiative(actionDetails, initialMessages);
            String actionInvocationContext = ChatPanelMessageUpdater.extractOriginalActionInvocationContext(actionDetails, initialMessages);
            this.addNormalMessageToConversationGUI(new ChatMessage(message), true, null, actionInvocationContext);
        }
        List<MessageNode> chatMessages = newModel.getChatMessages();
        this.createChatMessagePanels(0, chatMessages);
    }

    @Override
    public void submitEditedMessage(ChatMessageResponseWithActionsPanelInterface messagePanel, String newText) {
        ChatModel chatModel = this.chatSender.getChatModel();
        List<Integer> currentIndexListToLastElem = this.trimConversation(messagePanel);
        Message editedMessage = new Message(RoleType.USER, (MessageContent)new MessageTextContent(newText));
        chatModel.editMessage(currentIndexListToLastElem, editedMessage, null);
        this.addStartChatMessagesForUserMessage(editedMessage);
        this.chatSender.sendChatMessages(null, null);
    }

    @Override
    public void selectSiblingMessage(ChatMessageResponseWithActionsPanelInterface messagePanel, boolean toNextMessage) {
        ChatModel chatModel = this.chatSender.getChatModel();
        int conversationLevelFromView = this.findMessagePanelIndex((JPanel)((Object)messagePanel), this.messagesPanel);
        int levelInModel = conversationLevelFromView - chatModel.getInitialMessages().size();
        List<Integer> siblingIndexPath = this.computeIndexPathForSibling(chatModel.getMessagesIndexPath(), levelInModel, toNextMessage);
        boolean conversationAvailableFor = chatModel.isConversationAvailableFor(siblingIndexPath);
        if (conversationAvailableFor) {
            this.trimMessagesUpToIndex(conversationLevelFromView);
            List<MessageNode> chatMessages = chatModel.findRightMostConversationFor(siblingIndexPath);
            this.createChatMessagePanels(levelInModel, chatMessages);
            SwingUtilities.invokeLater(() -> {
                this.messagesPanel.revalidate();
                this.messagesPanel.repaint();
            });
        }
    }

    private void createChatMessagePanels(int level, List<MessageNode> chatMessages) {
        for (int i = level; i < chatMessages.size(); ++i) {
            MessageNode messageNode = chatMessages.get(i);
            if (messageNode instanceof ToolsMessageNode) {
                this.addToolMessageToConversationGUI((ToolsMessageNode)messageNode, messageNode.getEngine());
                continue;
            }
            if (messageNode instanceof ValidationErrorMessageNode) {
                this.addValidationErrorToConversationGUI((ValidationErrorMessageNode)messageNode);
                continue;
            }
            if (messageNode instanceof CorrectionMessageNode) {
                this.addCorrectionToConversationGUI((CorrectionMessageNode)messageNode, null);
                continue;
            }
            Message message = messageNode.getMessage();
            boolean showEditButton = i == 0 && message.getRole() != RoleType.USER;
            this.addNormalMessageToConversationGUI(new ChatMessage(message), showEditButton, messageNode.getEngine(), null);
        }
    }

    private void addToolMessageToConversationGUI(ToolsMessageNode toolMessageNode, String aiModel) {
        this.responseMessagePanel = new ResponseMessagePanel(Optional.ofNullable(aiModel), this.hasResponseAsLastPanel(), this.actionEngine != null, this.chatScrollUpdater);
        CurrentMessagePanel panel = new CurrentMessagePanel(this.responseMessagePanel);
        Message message = toolMessageNode.getMessage();
        if (message instanceof AssistantMessage) {
            AssistantMessage assistantMessage = (AssistantMessage)message;
            List toolCalls = assistantMessage.getToolCalls();
            this.addFunctionCallsInResponsePanel(toolCalls.stream().map(f -> f.getFunction().getName()).collect(Collectors.toList()));
            if (assistantMessage.getContent() != null) {
                for (MessageContent content : assistantMessage.getContent()) {
                    if (!(content instanceof MessageTextContent)) continue;
                    this.responseMessagePanel.appendChunk(((MessageTextContent)content).getText());
                    this.responseMessagePanel.appendChunk("\n");
                }
            }
            List<ToolCallInfo> toolCallsInfos = toolMessageNode.getToolCallsInfos();
            int noOfCalls = toolCallsInfos.size();
            for (int i = 0; i < noOfCalls; ++i) {
                CompletionToolCall toolCall = (CompletionToolCall)toolCalls.get(i);
                ToolCallInfo toolCallInfo = toolCallsInfos.get(i);
                this.addFunctionExecutionInResponsePanel(toolCall.getId(), toolCall.getFunction().getName(), toolCallInfo.getToolCallDescription(), toolCall.getFunction().getArguments());
                if (toolCallInfo.getToolCallErrorMessage() != null) {
                    this.addFunctionExecutionErrorInResponePanel(toolCallInfo.getToolCallErrorMessage(), false);
                }
                if (toolCallInfo.getToolCallResponsesMessages() == null) continue;
                this.addExecutedFunctionInResponsePanel(toolCallInfo.getToolCallResponsesMessages());
            }
        }
        this.responseMessagePanel.hideAssistantProgress();
        this.responseMessagePanel.actionFinished();
        this.addMessagePanelToConversationGUI(panel);
    }

    private boolean hasResponseAsLastPanel() {
        int cc = this.messagesPanel.getComponentCount();
        boolean consecutiveResponse = cc > 0 && this.messagesPanel.getComponent(cc - 1) instanceof CurrentMessagePanel;
        return consecutiveResponse;
    }

    private void trimMessagesUpToIndex(int conversationLevelFromView) {
        for (int i = this.messagesPanel.getComponentCount() - 1; i >= conversationLevelFromView; --i) {
            this.messagesPanel.remove(conversationLevelFromView);
        }
    }

    private List<Integer> computeIndexPathForSibling(List<Integer> currentIndexPath, int levelInModel, boolean toNextMessage) {
        List<Integer> startPath = new ArrayList<Integer>(currentIndexPath);
        startPath = startPath.subList(0, levelInModel + 1);
        Integer val = startPath.get(levelInModel);
        if (toNextMessage) {
            Integer n = val;
            val = val + 1;
        } else {
            Integer n = val;
            val = val - 1;
        }
        startPath.set(levelInModel, val);
        return startPath;
    }

    @Override
    public ChatMessageNavigationLevel computeNavigationLevel(ChatMessageResponseWithActionsPanelInterface messagePanel) {
        ChatModel chatModel = this.chatSender.getChatModel();
        List<Integer> startPath = new ArrayList<Integer>(chatModel.getMessagesIndexPath());
        if (startPath.isEmpty()) {
            return new ChatMessageNavigationLevel(1, 1);
        }
        int conversationLevelFromView = this.findMessagePanelIndex((JPanel)((Object)messagePanel), this.messagesPanel);
        int levelInModel = conversationLevelFromView - chatModel.getInitialMessages().size();
        if (levelInModel < 0) {
            levelInModel = 0;
        } else if (levelInModel >= startPath.size()) {
            levelInModel = startPath.size() - 1;
        }
        int currentLevel = (Integer)startPath.get(levelInModel);
        startPath = startPath.subList(0, levelInModel + 1);
        int maxLevel = chatModel.getMaxLevelIndex(startPath);
        return new ChatMessageNavigationLevel(currentLevel + 1, maxLevel + 1);
    }

    private int findMessagePanelIndex(JPanel messagePanel, Container messagesPanel) {
        int editedComponentIndex;
        int errorPanelsEncountered = 0;
        Component[] components = messagesPanel.getComponents();
        for (editedComponentIndex = 0; editedComponentIndex < components.length; ++editedComponentIndex) {
            Component component = components[editedComponentIndex];
            if (!(component instanceof JPanel)) continue;
            JPanel panel = (JPanel)component;
            if (component instanceof ErrorMessagePanel) {
                ++errorPanelsEncountered;
            }
            if (panel == messagePanel) break;
        }
        return editedComponentIndex - errorPanelsEncountered;
    }

    public void setBrowserOpenerForTC(BrowserOpener browserOpener) {
        this.browserOpener = browserOpener;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void regenerateResponse(ChatMessageResponseWithActionsPanelInterface currentResponse, String regenerationModel) {
        boolean forceAiPositronServiceProvider;
        boolean bl = forceAiPositronServiceProvider = regenerationModel != null && regenerationModel.startsWith("aips") && AiPositronServiceAccess.getInstance().hasAccessToAiPositronService();
        if (forceAiPositronServiceProvider) {
            boolean connectedToAiPositronService = AIActionsInfoProvider.getInstance().isConnectedToAiPositronService();
            if (connectedToAiPositronService) {
                this.regenerateResponseNow(currentResponse, regenerationModel);
                return;
            } else {
                try {
                    AIActionsInfoProvider.getInstance().refreshAuthentication();
                    this.regenerateResponseNow(currentResponse, regenerationModel);
                    return;
                }
                catch (ServerRequestException e) {
                    if (this.chatConnectionPanelListener == null) return;
                    this.setAiPositronServiceAndRegenerationModelInPreferences(regenerationModel);
                    this.chatConnectionPanelListener.switchToConnectToPositronServicePanel();
                }
            }
            return;
        } else {
            this.regenerateResponseNow(currentResponse, regenerationModel);
        }
    }

    private void setAiPositronServiceAndRegenerationModelInPreferences(String regenerationModel) {
        WSOptionsStorage optionsStorage = PluginWorkspaceProvider.getPluginWorkspace().getOptionsStorage();
        ConnectorConfigurationsPO connectorConfigurations = (ConnectorConfigurationsPO)optionsStorage.getPersistentObjectOption("oxygen.positron.plugin.connector.configurations", (ExternalPersistentObject)new ConnectorConfigurationsPO());
        connectorConfigurations.setCurrentConfigurationId(null);
        optionsStorage.setPersistentObjectOption("oxygen.positron.plugin.connector.configurations", (ExternalPersistentObject)connectorConfigurations);
        IEnginesManager enginesManager = EnginesManagerProvider.getInstance().getEnginesManager();
        enginesManager.saveEngine(regenerationModel);
    }

    private void regenerateResponseNow(ChatMessageResponseWithActionsPanelInterface currentResponse, String regenerationModel) {
        List<Integer> currentIndexListToLastElem = this.trimConversation(currentResponse);
        this.addEmptyAssistantMessageToConversationGui(ModelIdentifierUtil.extractModelId((String)regenerationModel));
        this.chatSender.sendChatMessages(currentIndexListToLastElem, regenerationModel);
    }

    private List<Integer> trimConversation(ChatMessageResponseWithActionsPanelInterface currentResponse) {
        int editedComponentVisualIndex = this.findMessagePanelIndex((JPanel)((Object)currentResponse), this.messagesPanel);
        ChatModel chatModel = this.chatSender.getChatModel();
        List<Integer> currentIndexListToLastElem = chatModel.getMessagesIndexPath();
        for (int i = currentIndexListToLastElem.size() - 1; i > editedComponentVisualIndex - chatModel.getInitialMessages().size(); --i) {
            currentIndexListToLastElem.remove(i);
        }
        this.trimMessagesUpToIndex(editedComponentVisualIndex);
        return currentIndexListToLastElem;
    }

    public void updateResponseNavigationWidget() {
        this.responseMessagePanel.updateUiForLevels(this.computeNavigationLevel(this.lastMessageInUpdatePanel));
    }

    public void functionsExecutionStarted(List<String> functionCalls) {
        SwingUtilities.invokeLater(() -> this.addFunctionCallsInResponsePanel(functionCalls));
    }

    private void addFunctionCallsInResponsePanel(List<String> functionCalls) {
        this.responseMessagePanel.addFunctionCallsDetails(functionCalls);
    }

    public void updateForFunctionExecutionStarted(String toolId, String functionName, String description, String arguments) {
        SwingUtilities.invokeLater(() -> this.addFunctionExecutionInResponsePanel(toolId, functionName, description, arguments));
    }

    private void addFunctionExecutionInResponsePanel(String toolId, String functionName, String description, String arguments) {
        this.responseMessagePanel.appendFunction(description);
        this.responseMessagePanel.addFunctionExecutedStartedDetails(toolId, functionName, arguments);
    }

    public void updateForFunctionExecutionFailed(String errorMessage, boolean isFatalError) {
        SwingUtilities.invokeLater(() -> this.addFunctionExecutionErrorInResponePanel(errorMessage, isFatalError));
    }

    private void addFunctionExecutionErrorInResponePanel(String errorMessage, boolean isFatalError) {
        this.responseMessagePanel.addFunctionCallErrorDetails(errorMessage);
    }

    public void updateWhenFunctionExecuted(ToolCallResponseMessage toolCallResponseMessage) {
        SwingUtilities.invokeLater(() -> this.addExecutedFunctionInResponsePanel(toolCallResponseMessage));
    }

    private void addExecutedFunctionInResponsePanel(ToolCallResponseMessage toolCallResponseMessage) {
        StringBuilder result = new StringBuilder();
        List content = toolCallResponseMessage.getContent();
        for (int i = 0; i < content.size(); ++i) {
            MessageContent messageContent = (MessageContent)content.get(i);
            if (!(messageContent instanceof MessageTextContent)) continue;
            if (i > 0) {
                result.append("\n");
            }
            result.append(((MessageTextContent)messageContent).getText());
        }
        this.responseMessagePanel.addFunctionCallResultDetails(toolCallResponseMessage.getToolCallId(), result.toString());
    }

    public void updateWhenAllFunctionsExecuted() {
        SwingUtilities.invokeLater(() -> {
            this.responseMessagePanel.hideAssistantProgress();
            ++this.conversationMessagesConstraints.gridy;
            this.addEmptyAssistantMessageToConversationGui();
        });
    }

    public boolean hasTextInCurrentMessage() {
        return this.responseMessagePanel != null && this.responseMessagePanel.hasMeaningfulContent();
    }

    public void automaticallyUpdateDocumentIfActionImposedIt(ActionInteractor actionInteractor) {
        if (actionInteractor != null && actionInteractor.isDirectlyPerformAction()) {
            try {
                String chatMessageContent = this.lastMessageInUpdatePanel.getChatMessageContent();
                actionInteractor.applyChangesToDocument(chatMessageContent);
            }
            catch (BadLocationException e) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)e, (Throwable)e);
                }
                PluginWorkspaceProvider.getPluginWorkspace().showErrorMessage("Unable to insert content in document.");
            }
        }
    }

    public void addValidationErrorToConversationGUI(ValidationErrorMessageNode validationErrorNode) {
        this.lastValidationErrorPanel = new ValidationErrorMessagePanel(validationErrorNode);
        this.addMessagePanelToConversationGUI(this.lastValidationErrorPanel);
    }

    public void addCorrectionToConversationGUI(CorrectionMessageNode correctionNode, ActionInteractor actionInteractor) {
        ChatMessage chatMessage = new ChatMessage(correctionNode.getMessage());
        this.addNormalMessageToConversationGUI(chatMessage, false, correctionNode.getEngine(), actionInteractor, null);
    }

    public void showCorrectionInProgressMessage() {
        if (this.lastValidationErrorPanel != null) {
            this.lastValidationErrorPanel.showCorrectionInProgress();
        }
    }

    public void showCorrectionCompletedMessage(boolean success) {
        if (this.lastValidationErrorPanel != null) {
            this.lastValidationErrorPanel.showCorrectionCompleted(success);
        }
    }

    public void showCorrectionAbortedMessage(String textToNotify) {
        if (this.lastValidationErrorPanel != null) {
            this.lastValidationErrorPanel.showCorrectionAborted(textToNotify);
        }
    }

    public void setChatConnectionPanelListener(ChatConnectionPanelListener chatConnectionPanelListener) {
        this.chatConnectionPanelListener = chatConnectionPanelListener;
    }

    public void checkExecutionAllowed(String toolId, String name, String description, String arguments, UnsafeFunctionInterceptor interceptor) {
        SwingUtilities.invokeLater(() -> this.responseMessagePanel.checkExecutionAllowed(toolId, name, description, arguments, interceptor));
    }
}

