/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.positron.plugin.chat;

import com.google.common.annotations.VisibleForTesting;
import com.oxygenxml.positron.api.connector.dto.AssistantMessage;
import com.oxygenxml.positron.api.connector.dto.CompletionResponse;
import com.oxygenxml.positron.api.connector.dto.CompletionToolCall;
import com.oxygenxml.positron.api.connector.dto.Message;
import com.oxygenxml.positron.api.connector.dto.MessageContent;
import com.oxygenxml.positron.api.connector.dto.MessageTextContent;
import com.oxygenxml.positron.api.connector.dto.RoleType;
import com.oxygenxml.positron.api.connector.dto.ToolCallResponseMessage;
import com.oxygenxml.positron.core.AICompletionDetailsProvider;
import com.oxygenxml.positron.core.AICompletionStreamResponse;
import com.oxygenxml.positron.core.CannotComputeCompletionDetailsException;
import com.oxygenxml.positron.core.actions.ActionInteractor;
import com.oxygenxml.positron.core.actions.DefaultActionInteractor;
import com.oxygenxml.positron.core.actions.DefaultActionInteractorProvider;
import com.oxygenxml.positron.core.actions.ParamsExpander;
import com.oxygenxml.positron.core.actions.ReloadActionsListener;
import com.oxygenxml.positron.core.actions.types.BaseActionInteractor;
import com.oxygenxml.positron.core.actions.types.PositronAIActionBase;
import com.oxygenxml.positron.core.actions.types.ReplaceFragmentActionInteractor;
import com.oxygenxml.positron.core.actions.types.UpdateEntireDocumentActionInteractor;
import com.oxygenxml.positron.core.actions.validation.PathNodeUtils;
import com.oxygenxml.positron.core.aiignore.AiIgnoreManager;
import com.oxygenxml.positron.core.aiignore.AiIgnoreManagerProvider;
import com.oxygenxml.positron.core.aiignore.OperationCancelledByAiIgnoreException;
import com.oxygenxml.positron.core.api.CompletionResponseUtil;
import com.oxygenxml.positron.core.chat.ChatInteractor;
import com.oxygenxml.positron.core.chat.ProgressActionInteractor;
import com.oxygenxml.positron.core.interactions.DocumentDetailsProvider;
import com.oxygenxml.positron.core.interactions.NoOpenedDocumentDetailsProvider;
import com.oxygenxml.positron.core.plugin.Translator;
import com.oxygenxml.positron.core.responses.handler.ResponseParser;
import com.oxygenxml.positron.core.service.PositronErrorsUtil;
import com.oxygenxml.positron.core.service.PositronServiceUtil;
import com.oxygenxml.positron.core.tools.CannotExecuteFunctionException;
import com.oxygenxml.positron.core.tools.ChatToolsEnhancer;
import com.oxygenxml.positron.core.tools.ChatToolsExecutorListener;
import com.oxygenxml.positron.core.tools.ContextInfoSession;
import com.oxygenxml.positron.core.tools.ToolsConfirmationInteractor;
import com.oxygenxml.positron.core.tools.ToolsExecutionCapability;
import com.oxygenxml.positron.core.tools.ToolsExecutionHandler;
import com.oxygenxml.positron.core.tools.ToolsExecutorBase;
import com.oxygenxml.positron.core.tools.ToolsExecutorListener;
import com.oxygenxml.positron.core.tools.ToolsSessionManager;
import com.oxygenxml.positron.core.tools.UnsafeFunctionInterceptor;
import com.oxygenxml.positron.core.tools.thread.strategy.ThreadFunctionCallStrategyUtil;
import com.oxygenxml.positron.functions.SAToolsExecutionHandler;
import com.oxygenxml.positron.functions.ToolsDocumentsChangesManagerBase;
import com.oxygenxml.positron.plugin.CompletionActionsProvider;
import com.oxygenxml.positron.plugin.chat.ChatActionsAndConversationCardsComponent;
import com.oxygenxml.positron.plugin.chat.ChatConnectionPanelListener;
import com.oxygenxml.positron.plugin.chat.ChatImporterExporter;
import com.oxygenxml.positron.plugin.chat.ChatMessage;
import com.oxygenxml.positron.plugin.chat.ChatMessageSender;
import com.oxygenxml.positron.plugin.chat.ChatModel;
import com.oxygenxml.positron.plugin.chat.ChatModesUtil;
import com.oxygenxml.positron.plugin.chat.ChatPanelMessageUpdater;
import com.oxygenxml.positron.plugin.chat.ChatPanelMessagesVisibilityListener;
import com.oxygenxml.positron.plugin.chat.ChatPanelUserInputComponentWithAutoHeight;
import com.oxygenxml.positron.plugin.chat.ChatScrollUpdater;
import com.oxygenxml.positron.plugin.chat.ChatSplitPanel;
import com.oxygenxml.positron.plugin.chat.ChatSplitPanelProportionsUpdater;
import com.oxygenxml.positron.plugin.chat.ChatStartAndModesInteractor;
import com.oxygenxml.positron.plugin.chat.ChatUserInputInteractor;
import com.oxygenxml.positron.plugin.chat.DropPasteAttachmentsTransferHandler;
import com.oxygenxml.positron.plugin.chat.actions.ActionPanelUpdater;
import com.oxygenxml.positron.plugin.chat.attachments.AttachmentsChangedListener;
import com.oxygenxml.positron.plugin.chat.attachments.AttachmentsPanel;
import com.oxygenxml.positron.plugin.chat.editorvariables.EditorVariablesExpandException;
import com.oxygenxml.positron.plugin.chat.editorvariables.EditorVariablesManager;
import com.oxygenxml.positron.plugin.chat.editorvariables.EditorVariablesManagerUIHelper;
import com.oxygenxml.positron.plugin.chat.favorites.FavoritesManager;
import com.oxygenxml.positron.plugin.chat.history.ChatHistoryOptionsManager;
import com.oxygenxml.positron.plugin.chat.history.CorrectionMessageNode;
import com.oxygenxml.positron.plugin.chat.history.MessageNode;
import com.oxygenxml.positron.plugin.chat.history.ToolCallInfo;
import com.oxygenxml.positron.plugin.chat.history.ToolsMessageNode;
import com.oxygenxml.positron.plugin.chat.history.ValidationErrorMessageNode;
import com.oxygenxml.positron.plugin.chat.quickfind.QuickSearchItemDialog;
import com.oxygenxml.positron.plugin.chat.utils.ChatCommonUtil;
import com.oxygenxml.positron.plugin.completion.AICompletionProvidersManager;
import com.oxygenxml.positron.plugin.completion.AIConfigurationChangeListener;
import com.oxygenxml.positron.plugin.completion.CompletionActionsManager;
import com.oxygenxml.positron.plugin.ui.ScrollablePanel;
import com.oxygenxml.positron.plugin.ui.ThemeColorProvider;
import com.oxygenxml.positron.plugin.ui.history.HistoryComponent;
import com.oxygenxml.positron.plugin.util.RecordButtonUtil;
import com.oxygenxml.positron.plugin.util.UIUtil;
import com.oxygenxml.positron.utilities.exceptions.AccessDeniedException;
import com.oxygenxml.positron.utilities.exceptions.InvalidMessageException;
import com.oxygenxml.positron.utilities.functions.ChatFunctionSignature;
import com.oxygenxml.positron.utilities.functions.FunctionsAndRAGHelperProvider;
import com.oxygenxml.positron.utilities.functions.WriteFunctionSignature;
import com.oxygenxml.positron.utilities.json.AIActionDetails;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import javax.accessibility.AccessibleContext;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import javax.swing.plaf.BorderUIResource;
import javax.swing.text.BadLocationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.sync.basic.execution.StoppedByUserException;
import ro.sync.basic.util.URLUtil;
import ro.sync.exml.workspace.api.PluginWorkspace;
import ro.sync.exml.workspace.api.standalone.StandalonePluginWorkspace;
import ro.sync.exml.workspace.api.standalone.ui.OxygenUIComponentsFactory;
import ro.sync.exml.workspace.api.standalone.ui.SplitMenuButton;

public class ChatPanel
extends JPanel
implements ChatInteractor,
ChatMessageSender,
ChatUserInputInteractor,
ReloadActionsListener,
ChatScrollUpdater,
ChatImporterExporter {
    private static final int BOTTOM_TOLERANCE_PX = 15;
    private boolean isAutoScrollEnabled = true;
    private static final Logger logger = LoggerFactory.getLogger((String)ChatPanel.class.getName());
    private static final int PANELS_PREFERRED_WIDTH = 330;
    private static final int MESSAGES_PANE_MIN_HEIGHT = 100;
    private static final int SCROLL_PANES_MIN_WIDTH = 200;
    private static final Translator TRANSLATOR = Translator.getInstance();
    private AICompletionProvidersManager aiCompletionProviderManager;
    private JPanel conversationPanel;
    private ChatModel chatModel;
    private ChatStartAndModesInteractor newChatModesContainer;
    private JPanel inputAreaButtonsPanel;
    private JButton sendButton;
    private JButton stopButton;
    private SplitMenuButton editorVarsSplitMenuButton;
    private boolean isRequestBeingProcessed;
    private StandalonePluginWorkspace pluginWorkspaceAccess;
    private ThemeColorProvider themeColorProvider = ThemeColorProvider.getInstance();
    private DefaultActionInteractorProvider defaultActionInteractorProvider;
    private ActionInteractor actionInteractor;
    private CompletionActionsManager completionActionsManager;
    private ChatPanelMessageUpdater chatPanelMessageUpdater;
    private ChatActionsAndConversationCardsComponent actionsAndConvesationPanel;
    private ChatSplitPanel chatSplitPanel;
    private ChatPanelUserInputComponentWithAutoHeight chatUserInputComponent = null;
    private JScrollPane messagesScrollPane;
    private boolean isClearingChat;
    private final HistoryComponent<ChatModel> historyComponent = new HistoryComponent<ChatModel>(15){

        @Override
        public void historyObjectSelected(ChatModel historyModel) {
            SwingUtilities.invokeLater(() -> ChatPanel.this.setChatModelAsActiveChat(historyModel));
        }

        @Override
        protected void saveToDisk(ChatModel historyObject) {
            ChatHistoryOptionsManager.save(historyObject);
        }

        @Override
        protected void clearHistory() {
            ChatHistoryOptionsManager.clearHistory();
        }
    };
    private ProgressActionInteractor progressActionInteractor;
    private AtomicBoolean currentChatResponseWasStoppedByUser = new AtomicBoolean(false);
    private final Set<String> currentWriteToolCallIds = new HashSet<String>();
    private boolean wasWriteFunctionCallSuccessful;
    private FavoritesManager favoritesManager;
    private List<Integer> pathToNode;
    private DocumentDetailsProvider documentDetailsProvider;
    private CompletionActionsProvider completionActionsProvider;
    private JButton recordMicButton;
    private AttachmentsPanel attachmentsPanel;

    public ChatPanel(StandalonePluginWorkspace pluginWorkspaceAccess, AICompletionProvidersManager aiCompletionProviderManager, FavoritesManager favoritesManager) {
        this.pluginWorkspaceAccess = pluginWorkspaceAccess;
        this.aiCompletionProviderManager = aiCompletionProviderManager;
        this.favoritesManager = favoritesManager;
        if (ToolsSessionManager.getInstance().isToolsDocumentsChangesSupportAvailable()) {
            ((ToolsDocumentsChangesManagerBase)ToolsSessionManager.getInstance().getToolsDocumentsChangesManager()).setChatInteractor(this);
        }
    }

    public void initializeUI(CompletionActionsManager completionActionsManager) {
        if (this.completionActionsManager != null || this.defaultActionInteractorProvider != null) {
            throw new RuntimeException("The UI is already initialized!");
        }
        this.completionActionsManager = completionActionsManager;
        this.setDefaultActionInteractorProvider(completionActionsManager);
        completionActionsManager.addReloadActionListener(this);
        this.createChatToolbarComponents();
        this.createUIComponents();
        this.chatPanelMessageUpdater = new ChatPanelMessageUpdater(this.conversationPanel, this, this, () -> this.getDocumentDetailsProvider(), this.pluginWorkspaceAccess);
        this.installFocusListener(this, new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                ChatPanel.this.chatUserInputComponent.focusNow();
            }
        });
        ChatHistoryOptionsManager.load().forEach(h -> this.historyComponent.addHistoryObject((ChatModel)h, false));
    }

    private void createUIComponents() {
        this.setLayout(new BorderLayout());
        this.setFocusCycleRoot(true);
        JPanel userInputPanel = this.createUserInputPanel();
        userInputPanel.setPreferredSize(new Dimension(330, 150));
        JPanel topPanel = this.createTopPanel();
        this.actionsAndConvesationPanel = new ChatActionsAndConversationCardsComponent(topPanel, this.completionActionsManager, this.newChatModesContainer, this.chatUserInputComponent);
        this.actionsAndConvesationPanel.setPreferredSize(new Dimension(330, 600));
        this.chatSplitPanel = new ChatSplitPanel(this.actionsAndConvesationPanel, userInputPanel);
        if (this.chatUserInputComponent != null && this.chatUserInputComponent.getTextArea() != null) {
            this.chatSplitPanel.setDividerBackgroundColor(this.chatUserInputComponent.getTextArea().getBackground());
        }
        this.add((Component)((Object)this.chatSplitPanel), "Center");
    }

    private JPanel createTopPanel() {
        JScrollPane messagesPanelScrollPane;
        JPanel topPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.anchor = 13;
        gbc.fill = 2;
        this.messagesScrollPane = messagesPanelScrollPane = this.createMessagesPanel();
        gbc.insets = new Insets(0, 0, 0, 0);
        gbc.gridwidth = 2;
        gbc.weighty = 1.0;
        gbc.fill = 1;
        topPanel.add((Component)messagesPanelScrollPane, gbc);
        return topPanel;
    }

    private void createChatToolbarComponents() {
        this.newChatModesContainer = new ChatStartAndModesInteractor((PluginWorkspace)this.pluginWorkspaceAccess, this.completionActionsManager, () -> {
            this.clearChat();
            this.updateSelectionChip(null);
        });
        this.newChatModesContainer.setChatModeChangeListener(() -> this.actionsAndConvesationPanel.updateViewModeIfNecessary());
        this.setEnableHistory(true);
    }

    public boolean clearChat() {
        this.isClearingChat = true;
        try {
            if (!this.clearDocumentsChanges()) {
                boolean bl = false;
                return bl;
            }
            this.isAutoScrollEnabled = true;
            this.resetTrackingOfWriteToolsCalling();
            this.setEnableHistory(true);
            this.conversationPanel.removeAll();
            this.conversationPanel.revalidate();
            this.chatModel = null;
            this.actionInteractor = null;
            this.pathToNode = null;
            this.updateEditorVarsWidgetEnablingState();
            this.actionsAndConvesationPanel.showStartingChatPanel();
            this.newChatModesContainer.setActionThreadInProgress(false);
            boolean bl = true;
            return bl;
        }
        finally {
            this.isClearingChat = false;
        }
    }

    public boolean isClearingChat() {
        return this.isClearingChat;
    }

    private void resetTrackingOfWriteToolsCalling() {
        this.currentWriteToolCallIds.clear();
        this.wasWriteFunctionCallSuccessful = false;
    }

    private boolean clearDocumentsChanges() {
        ToolsSessionManager toolsSessionManager = ToolsSessionManager.getInstance();
        if (toolsSessionManager.isToolsDocumentsChangesSupportAvailable()) {
            toolsSessionManager.getToolsDocumentsChangesManager().showChangesForApproval();
            if (toolsSessionManager.getToolsDocumentsChangesManager().hasChanges()) {
                return false;
            }
        }
        return true;
    }

    private void installAutoScrollLogic(JScrollPane scrollPane) {
        final JScrollBar vBar = scrollPane.getVerticalScrollBar();
        vBar.addAdjustmentListener(new AdjustmentListener(){
            int lastScrollValue = -1;

            @Override
            public void adjustmentValueChanged(AdjustmentEvent e) {
                if (e.getValueIsAdjusting()) {
                    return;
                }
                int value = vBar.getValue();
                if (ChatPanel.this.isAutoScrollEnabled) {
                    if (value < this.lastScrollValue) {
                        ChatPanel.this.isAutoScrollEnabled = false;
                    }
                } else if (!ChatPanel.this.isAutoScrollEnabled) {
                    int maximum;
                    int extent = vBar.getModel().getExtent();
                    ChatPanel.this.isAutoScrollEnabled = value + extent >= (maximum = vBar.getMaximum()) - 15;
                }
                this.lastScrollValue = value;
            }
        });
    }

    private JScrollPane createMessagesPanel() {
        this.conversationPanel = new ScrollablePanel(){

            @Override
            public void scrollRectToVisible(Rectangle aRect) {
                if (ChatPanel.this.isAutoScrollEnabled) {
                    super.scrollRectToVisible(aRect);
                }
            }
        };
        this.conversationPanel.setLayout(new GridBagLayout());
        Color backgroundColor = this.themeColorProvider.getBackgroundColor();
        this.conversationPanel.setBackground(backgroundColor);
        AccessibleContext accessibleContext = this.conversationPanel.getAccessibleContext();
        accessibleContext.setAccessibleName("Chat panel");
        accessibleContext.setAccessibleDescription("This panel presents the current conversation between you andthe Positron artificial-intelligence-based platform.");
        JScrollPane messagesPanelScrollPane = UIUtil.createScrollPane(this.conversationPanel, 20, 31);
        messagesPanelScrollPane.setMinimumSize(new Dimension(200, 100));
        messagesPanelScrollPane.setBorder(new BorderUIResource.MatteBorderUIResource(0, 0, 1, 0, this.themeColorProvider.getViewTabsBorderColor()));
        this.installAutoScrollLogic(messagesPanelScrollPane);
        return messagesPanelScrollPane;
    }

    private JPanel createUserInputPanel() {
        JPanel userInputPanel = new JPanel(new GridBagLayout());
        this.attachmentsPanel = new AttachmentsPanel(() -> this.getCurrentDocumentSelection(), () -> this.chatUserInputComponent.updateReferencesWhenSelectionChanges(), true, false);
        GridBagConstraints constr = new GridBagConstraints();
        constr.gridx = 0;
        constr.gridy = 0;
        constr.weightx = 1.0;
        constr.weighty = 0.0;
        constr.gridwidth = 6;
        constr.fill = 2;
        constr.anchor = 11;
        userInputPanel.add((Component)this.attachmentsPanel, constr);
        ++constr.gridy;
        constr.weighty = 1.0;
        constr.fill = 1;
        constr.insets = new Insets(0, 0, 5, 0);
        this.chatUserInputComponent = new ChatPanelUserInputComponentWithAutoHeight(() -> this.showQuickSearchActionDialog(), new ChatSplitPanelProportionsUpdater(){

            @Override
            public void setProportions(double[] proportions) {
                ChatPanel.this.chatSplitPanel.setProportions(proportions);
            }

            @Override
            public double[] getProportions() {
                return ChatPanel.this.chatSplitPanel.getProportions();
            }

            @Override
            public int getHeightOfResizableComponents() {
                return ChatPanel.this.chatSplitPanel.getHeight() - ChatPanel.this.inputAreaButtonsPanel.getHeight() - ChatPanel.this.attachmentsPanel.getHeight();
            }
        }, this.attachmentsPanel);
        userInputPanel.add((Component)this.chatUserInputComponent.getScrollPane(), constr);
        this.attachmentsPanel.setOpaque(true);
        this.attachmentsPanel.setBackground(this.chatUserInputComponent.getTextArea().getBackground());
        ++constr.gridy;
        constr.gridwidth = 1;
        constr.weightx = 0.0;
        constr.weighty = 0.0;
        constr.fill = 0;
        constr.anchor = 13;
        this.inputAreaButtonsPanel = this.createUserInputToolbarPanel();
        userInputPanel.add((Component)this.inputAreaButtonsPanel, constr);
        JPanel filler = new JPanel();
        ++constr.gridx;
        constr.weightx = 1.0;
        constr.fill = 2;
        userInputPanel.add((Component)filler, constr);
        constr.anchor = 13;
        constr.weightx = 0.0;
        constr.fill = 0;
        ++constr.gridx;
        AbstractButton chatSwitchButton = this.newChatModesContainer.getChatModesSwitchButton();
        if (chatSwitchButton != null) {
            userInputPanel.add((Component)chatSwitchButton, constr);
            ++constr.gridx;
        }
        AbstractAction sendAction = new AbstractAction(TRANSLATOR.getTranslation("Send")){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (ChatPanel.this.isConversationJustStarting()) {
                    ChatPanel.this.clearDocumentsChanges();
                }
                String plainTextContentWithAttachmentsExpanded = ChatPanel.this.chatUserInputComponent.getPlainTextContentWithAttachmentsExpanded();
                ChatPanel.this.createAndSendUserMessage(plainTextContentWithAttachmentsExpanded);
                ChatPanel.this.removeSelectionChip();
                ChatPanel.this.chatSplitPanel.resetProportionsDefault();
            }
        };
        sendAction.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                ChatPanel.this.updateEditorVarsWidgetEnablingState();
            }
        });
        sendAction.setEnabled(false);
        this.sendButton = OxygenUIComponentsFactory.createButton((Action)sendAction);
        this.chatUserInputComponent.registerSubmitAction(sendAction);
        userInputPanel.add((Component)this.sendButton, constr);
        this.sendButton.setMultiClickThreshhold(700L);
        AbstractAction stopAction = new AbstractAction(TRANSLATOR.getTranslation("Stop")){

            @Override
            public void actionPerformed(ActionEvent e) {
                ChatPanel.this.stopChatNow();
            }
        };
        this.stopButton = OxygenUIComponentsFactory.createButton((Action)stopAction);
        ++constr.gridx;
        userInputPanel.add((Component)this.stopButton, constr);
        this.stopButton.setMultiClickThreshhold(700L);
        this.chatUserInputComponent.onTextUpdate(this::updateInputAreaButtons);
        this.attachmentsPanel.addAttachmentsChangedListener(new AttachmentsChangedListener(){

            @Override
            public void attachmentAdded(URL attachment) {
                ChatPanel.this.updateInputAreaButtons();
            }

            @Override
            public void attachmentRemoved(URL attachment) {
                ChatPanel.this.updateInputAreaButtons();
            }
        });
        this.updateInputAreaButtons();
        this.attachmentsPanel.setTransferHandler(new DropPasteAttachmentsTransferHandler(this.chatUserInputComponent));
        return userInputPanel;
    }

    private void addMicButtonReconfigureListener() {
        this.aiCompletionProviderManager.addConfigurationChangeListener(new AIConfigurationChangeListener(){

            @Override
            public void onConfigurationChanged() {
                ChatPanel.this.reconfigureRecordMicButton();
            }
        });
    }

    private void reconfigureRecordMicButton() {
        if (this.recordMicButton != null) {
            RecordButtonUtil.reconfigureRecordMicButtonVisibility(this.recordMicButton, () -> this.aiCompletionProviderManager.getCurrentCompletionProvider());
        }
    }

    private void stopChatNow() {
        this.currentChatResponseWasStoppedByUser.set(true);
        if (this.progressActionInteractor != null) {
            this.progressActionInteractor.stopProgressAction();
        }
    }

    private JPanel createUserInputToolbarPanel() {
        JPanel buttonsPanel = new JPanel(new GridBagLayout());
        GridBagConstraints constr = new GridBagConstraints();
        constr.gridx = 0;
        constr.gridy = 0;
        constr.weightx = 1.0;
        constr.weighty = 1.0;
        constr.gridwidth = 1;
        constr.fill = 0;
        constr.insets = new Insets(0, 0, 5, 0);
        SplitMenuButton favoritesSplitMenuButton = this.favoritesManager.createFavoritesDropDown(this.chatUserInputComponent, this.attachmentsPanel);
        buttonsPanel.add((Component)favoritesSplitMenuButton, constr);
        ++constr.gridx;
        this.editorVarsSplitMenuButton = EditorVariablesManagerUIHelper.createEditorVariablesDropDown(this.chatUserInputComponent);
        buttonsPanel.add((Component)this.editorVarsSplitMenuButton, constr);
        ++constr.gridx;
        this.recordMicButton = RecordButtonUtil.createRecordMicButton(this.chatUserInputComponent, () -> this.aiCompletionProviderManager.getCurrentCompletionProvider());
        RecordButtonUtil.reconfigureRecordMicButtonVisibility(this.recordMicButton, () -> this.aiCompletionProviderManager.getCurrentCompletionProvider());
        this.addMicButtonReconfigureListener();
        buttonsPanel.add((Component)this.recordMicButton, constr);
        return buttonsPanel;
    }

    private void showQuickSearchActionDialog() {
        QuickSearchItemDialog quickSearchDialog = new QuickSearchItemDialog(() -> this.chatUserInputComponent.getTextArea(), this.completionActionsProvider, true);
        quickSearchDialog.setVisible(true);
    }

    private void updateInputAreaButtons() {
        Component[] inputAreaButtons;
        this.stopButton.setVisible(this.isRequestBeingProcessed);
        this.sendButton.setVisible(!this.isRequestBeingProcessed);
        this.sendButton.getAction().setEnabled(this.hasUserProvidedInput() && !this.isRequestBeingProcessed);
        this.newChatModesContainer.setChatButtonsEnabled(!this.isRequestBeingProcessed);
        for (Component component : inputAreaButtons = this.inputAreaButtonsPanel.getComponents()) {
            component.setEnabled(!this.isRequestBeingProcessed);
        }
    }

    void createAndSendUserMessage(String userInput) {
        this.isAutoScrollEnabled = false;
        this.actionsAndConvesationPanel.showConversationPanel();
        boolean isConversationJustStarting = this.isConversationJustStarting();
        if (isConversationJustStarting) {
            try {
                this.chatModel = this.createChatMessageModelForUserInitiative();
            }
            catch (ExecutionException e) {
                this.showMessageForNotSuccessfulAction(e.getMessage(), false, false, false, null);
            }
        } else if (this.chatModel.isUserInitiative()) {
            this.updateChatModeInModelIfNeeded();
        }
        if (this.chatModel != null) {
            this.chatPanelMessageUpdater.cancelMessageEditing();
            try {
                if (isConversationJustStarting) {
                    this.checkIfContentIsAiIgnored((String)userInput);
                }
                userInput = ChatPanel.preProcessUserInput(this.defaultActionInteractorProvider, isConversationJustStarting, (String)userInput);
                userInput = (String)userInput + this.chatUserInputComponent.getUnreferencedAttachmentsWithMarkerToAddToModel();
                if (isConversationJustStarting) {
                    this.updateInputAreaHintBasedOnSelection(false);
                }
                Message userMessage = new Message(RoleType.USER, (MessageContent)new MessageTextContent((String)userInput));
                this.chatModel.addMessage(userMessage, null);
                this.chatPanelMessageUpdater.addStartChatMessagesForUserMessage(userMessage);
                this.sendChatMessages(null, null);
            }
            catch (EditorVariablesExpandException | BadLocationException ex) {
                this.pluginWorkspaceAccess.showInformationMessage(ex.getMessage());
            }
            catch (OperationCancelledByAiIgnoreException e) {
                this.handleAiIgnoreChatStartedAsUserIntiative((String)userInput);
            }
        }
        SwingUtilities.invokeLater(() -> {
            this.isAutoScrollEnabled = true;
            this.scrollToBottom();
        });
    }

    private void updateChatModeInModelIfNeeded() {
        try {
            AIActionDetails originalActionDetails;
            AIActionDetails currentChatModeDetails = ChatModesUtil.obtainChatActionDetails(this.completionActionsManager);
            if (currentChatModeDetails != null && !currentChatModeDetails.getId().equals(this.chatModel.getActionDetails().getId()) && (originalActionDetails = this.chatModel.getActionDetails()).getId() != null && originalActionDetails.getId().startsWith("pseudoaction.chat.message.")) {
                Map<String, String> existingParams = this.chatModel.getActionParameters();
                Map newChatModeParams = ParamsExpander.expandParams(null, (List)currentChatModeDetails.getExpandParams(), (DocumentDetailsProvider)this.documentDetailsProvider);
                HashMap<String, String> mergedParams = new HashMap<String, String>(newChatModeParams);
                mergedParams.putAll(existingParams);
                this.chatModel.resetActionDetails(currentChatModeDetails, mergedParams);
            }
        }
        catch (ExecutionException executionException) {
            // empty catch block
        }
    }

    private void handleAiIgnoreChatStartedAsUserIntiative(String userInput) {
        Message userMessage = new Message(RoleType.USER, (MessageContent)new MessageTextContent(userInput));
        this.chatModel.addMessage(userMessage, null);
        this.chatPanelMessageUpdater.addStartChatMessagesForUserMessage(userMessage);
        this.stopChatNow();
        this.notifyActionStopped();
        PositronServiceUtil.handleStreamResult((String)"", null, Arrays.asList(new Throwable[]{new OperationCancelledByAiIgnoreException()}), (AICompletionDetailsProvider)this.aiCompletionProviderManager.getCurrentCompletionProvider(), (ActionInteractor)this.actionInteractor, (ChatInteractor)this, null);
        this.chatUserInputComponent.setText("");
    }

    private boolean isConversationJustStarting() {
        return this.chatModel == null;
    }

    private void checkIfContentIsAiIgnored(String userInput) throws OperationCancelledByAiIgnoreException {
        block7: {
            AiIgnoreManager aiIgnoreChecker = AiIgnoreManagerProvider.getAiIgnoreChecker();
            if (aiIgnoreChecker != null && this.documentDetailsProvider != null) {
                String editorLocation = this.documentDetailsProvider.getEditorLocation();
                boolean containsContentRelatedToEditorVariables = EditorVariablesManager.containsContentRelatedEditorVariables(userInput);
                if (containsContentRelatedToEditorVariables) {
                    if (aiIgnoreChecker.isIgnoredFromAiIgnoreFile(URLUtil.convertToURL((String)editorLocation))) {
                        throw new OperationCancelledByAiIgnoreException();
                    }
                } else {
                    try {
                        DefaultActionInteractor defaultActionInteractor = this.defaultActionInteractorProvider.getDefaultActionInteractor();
                        String selectedContent = defaultActionInteractor.getSelectedContent(true);
                        if (selectedContent != null && aiIgnoreChecker.isIgnoredFromAiIgnoreFile(URLUtil.convertToURL((String)editorLocation))) {
                            throw new OperationCancelledByAiIgnoreException();
                        }
                    }
                    catch (BadLocationException e) {
                        if (!logger.isDebugEnabled()) break block7;
                        logger.debug((Object)e, (Throwable)e);
                    }
                }
            }
        }
    }

    private static String preProcessUserInput(DefaultActionInteractorProvider defaultActionInteractorProvider, boolean isConversationJustStarting, String originalText) throws EditorVariablesExpandException, BadLocationException, OperationCancelledByAiIgnoreException {
        Object userInput = EditorVariablesManager.expandEditorVariables(defaultActionInteractorProvider, originalText);
        if (isConversationJustStarting && !EditorVariablesManager.containsContentRelatedEditorVariables(originalText)) {
            try {
                String toExpand = "";
                userInput = (String)userInput + EditorVariablesManager.expandEditorVariables(defaultActionInteractorProvider, toExpand);
            }
            catch (EditorVariablesExpandException editorVariablesExpandException) {
                // empty catch block
            }
        }
        return userInput;
    }

    private static boolean canUseSelection(DocumentDetailsProvider documentDetailsProvider) {
        boolean canUseSelection = true;
        if (documentDetailsProvider != null) {
            try {
                FunctionsAndRAGHelperProvider.getProjectRAGHelper().checkDocumentAccessPermissions(documentDetailsProvider.getEditorLocation(), true, false);
            }
            catch (AccessDeniedException ex) {
                canUseSelection = false;
            }
        }
        return canUseSelection;
    }

    public void setChatConnectionPanelListener(ChatConnectionPanelListener chatConnectionPanelListener) {
        this.chatPanelMessageUpdater.setChatConnectionPanelListener(chatConnectionPanelListener);
    }

    @Override
    public void sendChatMessages(final List<Integer> pathToNode, final String regenerationModel) {
        this.pathToNode = pathToNode;
        final boolean isRegenerateResponse = pathToNode != null;
        this.currentChatResponseWasStoppedByUser.set(false);
        if (pathToNode == null) {
            this.updateChatModeInModelIfNeeded();
        }
        final StringBuilder aiCompletionBuilder = new StringBuilder();
        final StringBuilder responseAIModel = new StringBuilder();
        final ArrayList exceptions = new ArrayList();
        final ChatToolsExecutorListener[] chatToolsExecutorListener = new ChatToolsExecutorListener[1];
        final AIActionDetails actionToExecute = this.chatModel.getActionDetails();
        final AICompletionDetailsProvider aiCompletionProvider = this.aiCompletionProviderManager.getCompletionProviderForModel(actionToExecute, regenerationModel);
        if (aiCompletionProvider instanceof ToolsExecutionCapability) {
            chatToolsExecutorListener[0] = new ChatToolsExecutorListener((ChatInteractor)this, this.actionInteractor);
            aiCompletionProvider.setToolsExecutorListener((ToolsExecutorListener)chatToolsExecutorListener[0]);
            aiCompletionProvider.setToolsConfirmationInteractor((ToolsConfirmationInteractor)chatToolsExecutorListener[0]);
        }
        final ResponseParser[] parser = new ResponseParser[1];
        final SwingWorker<Optional<String>, String> swingWorker = new SwingWorker<Optional<String>, String>(){

            @Override
            protected Optional<String> doInBackground() {
                block7: {
                    try {
                        boolean shouldEnhance;
                        List<MessageNode> chatMessages;
                        ArrayList<Message> inputMessages = new ArrayList<Message>(ChatPanel.this.chatModel.getInitialMessages());
                        List<MessageNode> list = chatMessages = isRegenerateResponse ? ChatPanel.this.chatModel.getChatMessages(pathToNode) : ChatPanel.this.chatModel.getChatMessages();
                        if (isRegenerateResponse) {
                            ChatCommonUtil.removeLastAssistantMessage(pathToNode, chatMessages, ChatPanel.this.chatModel);
                        }
                        List<MessageNode> filteredValidationRelatedMessages = ChatPanel.this.chatModel.filterValidationRelatedMessages(chatMessages);
                        inputMessages.addAll(ChatPanel.this.applyFilteringToolCallsStrategies(filteredValidationRelatedMessages, aiCompletionProvider));
                        Map<String, String> actionParameters = ChatPanel.this.chatModel.getActionParameters();
                        actionParameters = ChatCommonUtil.createActionParamsForRegeneration(regenerationModel, isRegenerateResponse, actionParameters);
                        ParamsExpander.updateDocumentLocationParams((List)actionToExecute.getExpandParams(), (DocumentDetailsProvider)(ChatPanel.this.documentDetailsProvider != null ? ChatPanel.this.documentDetailsProvider : new NoOpenedDocumentDetailsProvider()), actionParameters);
                        AIActionDetails actionDetailsToUse = actionToExecute;
                        ArrayList<Message> messagesToCheck = new ArrayList<Message>();
                        for (MessageNode node : filteredValidationRelatedMessages) {
                            messagesToCheck.add(node.getMessage());
                        }
                        boolean bl = shouldEnhance = isRegenerateResponse ? ChatToolsEnhancer.shouldEnhanceWithChatTools((AIActionDetails)actionDetailsToUse, messagesToCheck) : ChatPanel.this.chatModel.shouldEnhanceWithChatTools();
                        if (shouldEnhance) {
                            try {
                                AIActionDetails chatActionDetails = ChatModesUtil.obtainChatActionDetails(ChatPanel.this.completionActionsManager);
                                actionDetailsToUse = ChatPanel.this.chatModel.getActionDetailsWithChatModeEnhancement(chatActionDetails);
                            }
                            catch (Exception e) {
                                logger.warn("Failed to enhance action with chat tools", (Throwable)e);
                            }
                        }
                        actionDetailsToUse = ChatPanel.this.addExtraFunctionRefs(actionDetailsToUse);
                        AICompletionStreamResponse aiCompletionResponse = aiCompletionProvider.executeActionIncremental(actionDetailsToUse, inputMessages, actionParameters);
                        parser[0] = new ResponseParser(aiCompletionResponse.isShouldBeStructuredResponse(), (ChatInteractor)ChatPanel.this);
                        aiCompletionResponse.getResponseContent().blockingSubscribe(chunk -> {
                            String content = CompletionResponseUtil.getCompletion((CompletionResponse)chunk);
                            String chunkModel = chunk.getModel();
                            if (chunkModel != null && responseAIModel.length() == 0) {
                                responseAIModel.append(chunkModel);
                                ChatPanel.this.showAIAssistantModel(chunkModel);
                            }
                            if (CompletionResponseUtil.hasToolCalls((CompletionResponse)chunk)) {
                                aiCompletionBuilder.setLength(0);
                            }
                            if (content != null) {
                                aiCompletionBuilder.append(content);
                                this.publish(content);
                            }
                        }, t -> {
                            if (t instanceof InterruptedException) {
                                Thread.currentThread().interrupt();
                            } else {
                                if (logger.isDebugEnabled()) {
                                    logger.debug(t.getMessage(), t);
                                }
                                exceptions.add(t);
                            }
                        });
                    }
                    catch (CannotComputeCompletionDetailsException | InvalidMessageException | RuntimeException e) {
                        logger.debug(e.getMessage(), e);
                        if (PositronErrorsUtil.isStoppedByUser((Throwable)e)) break block7;
                        exceptions.add(e);
                    }
                }
                return Optional.of(aiCompletionBuilder.toString());
            }

            @Override
            protected void process(List<String> chunks) {
                for (String chunk : chunks) {
                    parser[0].addNewChunk(chunk);
                }
            }

            @Override
            protected void done() {
                if (parser.length > 0 && parser[0] != null) {
                    parser[0].completionEnd();
                }
                if (aiCompletionProvider instanceof ToolsExecutionCapability) {
                    aiCompletionProvider.removeToolsExecutorListener();
                    aiCompletionProvider.removeToolsConfirmationInteractor();
                }
                try {
                    PositronServiceUtil.handleStreamResult((String)aiCompletionBuilder.toString(), (String)responseAIModel.toString(), (List)exceptions, (AICompletionDetailsProvider)aiCompletionProvider, (ActionInteractor)ChatPanel.this.actionInteractor, (ChatInteractor)ChatPanel.this, null);
                }
                finally {
                    ChatPanel.this.notifyActionStopped();
                    ChatPanel.this.newChatModesContainer.setChatButtonsEnabled(true);
                    ChatPanel.this.setEnableHistory(true);
                    ChatPanel.this.resetTrackingOfWriteToolsCalling();
                }
            }
        };
        this.chatUserInputComponent.setText("");
        this.attachmentsPanel.clearAttachments();
        this.isRequestBeingProcessed = true;
        this.setEnableHistory(false);
        this.chatPanelMessageUpdater.setMessageEditingState(false);
        this.chatPanelMessageUpdater.setResponseActionsEnabled(false, this);
        this.progressActionInteractor = new ProgressActionInteractor(){

            public void stopProgressAction() {
                exceptions.add(new StoppedByUserException());
                swingWorker.cancel(true);
                if (chatToolsExecutorListener != null && chatToolsExecutorListener[0] != null) {
                    chatToolsExecutorListener[0].stop();
                }
            }
        };
        this.updateInputAreaButtons();
        swingWorker.execute();
    }

    protected AIActionDetails addExtraFunctionRefs(AIActionDetails actionDetails) {
        return actionDetails;
    }

    @Override
    public DefaultActionInteractor getDefaultActionInteractor() {
        return this.defaultActionInteractorProvider.getDefaultActionInteractor();
    }

    protected List<Message> applyFilteringToolCallsStrategies(List<MessageNode> chatMessagesNodes, AICompletionDetailsProvider aiCompletionProvider) {
        ToolsExecutionHandler toolsExecutionHandler = null;
        if (aiCompletionProvider instanceof ToolsExecutionCapability) {
            toolsExecutionHandler = aiCompletionProvider.getToolsExecutionHandler();
        }
        ArrayList chatMessages = new ArrayList();
        chatMessagesNodes.forEach(node -> {
            Message message = node.getMessage();
            if (message != null) {
                if (node instanceof ToolsMessageNode) {
                    chatMessages.add(message);
                    List<ToolCallInfo> toolCallsInfos = ((ToolsMessageNode)node).getToolCallsInfos();
                    toolCallsInfos.forEach(callInfo -> {
                        ToolCallResponseMessage resp = callInfo.getToolCallResponsesMessages();
                        if (resp != null) {
                            chatMessages.add(resp);
                        }
                    });
                } else {
                    chatMessages.add(message);
                }
            }
        });
        return ThreadFunctionCallStrategyUtil.applyFilteringToolCallsStrategies(chatMessages, (ToolsExecutorBase)(toolsExecutionHandler != null ? toolsExecutionHandler.getToolsExecutor() : null));
    }

    @Override
    public ChatModel getChatModel() {
        return this.chatModel;
    }

    public void updateInputAreaHintBasedOnSelection(boolean selectionPresent) {
        boolean isAddSelectionInfo = this.isConversationJustStarting() && selectionPresent && ChatPanel.canUseSelection(this.documentDetailsProvider);
        String placeholder = isAddSelectionInfo ? TRANSLATOR.getTranslation("User_input_area_with_action_quickfind_and_selection_in_editor_placeholder") : TRANSLATOR.getTranslation("User_input_area_with_action_quickfind_placeholder");
        this.chatUserInputComponent.setPlaceholder(placeholder);
    }

    private boolean hasUserProvidedInput() {
        return !this.chatUserInputComponent.getText().trim().isEmpty() || this.attachmentsPanel.hasAttachments();
    }

    private void installFocusListener(Component comp, FocusListener focusListener) {
        comp.addFocusListener(focusListener);
        if (comp instanceof Container) {
            Container container = (Container)comp;
            int componentCount = container.getComponentCount();
            for (int i = 0; i < componentCount; ++i) {
                Component child = container.getComponent(i);
                this.installFocusListener(child, focusListener);
            }
        }
    }

    public void editorContextChanged(DocumentDetailsProvider documentDetailsProvider) {
        this.documentDetailsProvider = documentDetailsProvider;
        this.editorContextChanged();
    }

    public DocumentDetailsProvider getDocumentDetailsProvider() {
        return this.documentDetailsProvider;
    }

    public void startChatForAction(AIActionDetails actionDetails, Map<String, String> actionParameters, List<Message> requestMessages, String imposedStartMessage, boolean isShowSideView) throws OperationCancelledByAiIgnoreException {
        boolean canStartNewChat;
        this.isAutoScrollEnabled = true;
        if (!this.isShowing() && isShowSideView) {
            this.pluginWorkspaceAccess.showView("PositronPluginViewID", false);
        }
        if (SwingUtilities.isEventDispatchThread()) {
            canStartNewChat = this.clearChat();
        } else {
            AtomicBoolean result = new AtomicBoolean(false);
            try {
                SwingUtilities.invokeAndWait(() -> result.set(this.clearChat()));
            }
            catch (InvocationTargetException e) {
                logger.error((Object)e, (Throwable)e);
            }
            catch (InterruptedException e) {
                logger.error((Object)e, (Throwable)e);
                Thread.currentThread().interrupt();
            }
            canStartNewChat = result.get();
        }
        if (!canStartNewChat) {
            return;
        }
        UIUtil.invokeSynchronously(() -> this.actionsAndConvesationPanel.showConversationPanel());
        this.newChatModesContainer.setActionThreadInProgress(true);
        this.removeSelectionChip();
        this.chatModel = new ChatModel(actionDetails, actionParameters);
        this.isRequestBeingProcessed = true;
        this.currentChatResponseWasStoppedByUser.set(false);
        this.newChatModesContainer.setChatButtonsEnabled(false);
        this.setEnableHistory(false);
        this.updateInputAreaButtons();
        this.chatPanelMessageUpdater.setMessageEditingState(false);
        this.chatPanelMessageUpdater.setResponseActionsEnabled(false, this);
        boolean ignoredFromAiIgnoreFile = this.isIgnoreAIForDetails();
        this.chatPanelMessageUpdater.addStartChatMessagesForAction(actionDetails, actionParameters, requestMessages, imposedStartMessage, ignoredFromAiIgnoreFile);
        if (ignoredFromAiIgnoreFile) {
            this.setInitialActionMessages(Arrays.asList(new Message(RoleType.USER, (MessageContent)new MessageTextContent(""))));
            this.stopChatNow();
            this.notifyActionStopped();
            throw new OperationCancelledByAiIgnoreException();
        }
    }

    boolean isIgnoreAIForDetails() {
        if (AiIgnoreManagerProvider.getAiIgnoreChecker() != null && this.documentDetailsProvider != null) {
            String editorLocation = this.documentDetailsProvider.getEditorLocation();
            return AiIgnoreManagerProvider.getAiIgnoreChecker().isIgnoredFromAiIgnoreFile(URLUtil.convertToURL((String)editorLocation));
        }
        return false;
    }

    public void setCurrentActionProgressInteractor(ProgressActionInteractor progressActionInteractor) {
        this.progressActionInteractor = progressActionInteractor;
    }

    public void showAIAssistantChunkMessage(String messageChunk) {
        this.chatPanelMessageUpdater.addAssistantChunkMessage(messageChunk);
    }

    public void showAIAssistantCodeChunk(String codeblockName, String messageChunk) {
        this.chatPanelMessageUpdater.addAssistantChunkMessage("[code]: " + messageChunk);
    }

    public void showAIAssistantTextChunk(String textSectionName, String messageChunk) {
        this.chatPanelMessageUpdater.addAssistantChunkMessage("[text]: " + messageChunk);
    }

    public void showFunctionsExecutionStarted(List<CompletionToolCall> functionCalls, String extraInfoToolCall, String model, ActionInteractor actionInteractor) {
        ToolsExecutorBase toolsExecutor;
        this.chatPanelMessageUpdater.functionsExecutionStarted(functionCalls.stream().map(call -> call.getFunction().getName()).collect(Collectors.toList()));
        if (model != null) {
            this.chatPanelMessageUpdater.updateAIModelOnLabel(model);
        }
        this.chatModel.addToolCallsMessage((Message)new AssistantMessage(functionCalls, extraInfoToolCall), model);
        this.resetTrackingOfWriteToolsCalling();
        ToolsExecutionHandler handler = this.aiCompletionProviderManager.getCurrentCompletionProvider().getToolsExecutionHandler();
        ToolsExecutorBase toolsExecutorBase = toolsExecutor = handler != null ? handler.getToolsExecutor() : null;
        if (functionCalls != null && !functionCalls.isEmpty() && toolsExecutor != null) {
            for (CompletionToolCall call2 : functionCalls) {
                String functionName = call2.getFunction().getName();
                ChatFunctionSignature signature = toolsExecutor.searchForFunctionSignature(functionName);
                if (!(signature instanceof WriteFunctionSignature)) continue;
                this.currentWriteToolCallIds.add(call2.getId());
            }
        }
        this.bindActionInteractorToFunctions(actionInteractor);
    }

    public void showFunctionExecutionStarted(String toolId, String functionName, String description, String arguments, ActionInteractor actIntr) {
        this.chatPanelMessageUpdater.updateForFunctionExecutionStarted(toolId, functionName, description, arguments);
        this.chatModel.addToolCallDescription(description);
        this.bindActionInteractorToFunctions(actIntr);
    }

    private void bindActionInteractorToFunctions(ActionInteractor actIntr) {
        this.actionInteractor = actIntr;
        ToolsExecutionHandler toolsExecutionHandler = this.aiCompletionProviderManager.getCurrentCompletionProvider().getToolsExecutionHandler();
        if (toolsExecutionHandler instanceof SAToolsExecutionHandler) {
            SAToolsExecutionHandler saToolsExecutionHandler = (SAToolsExecutionHandler)toolsExecutionHandler;
            if (this.actionInteractor instanceof ContextInfoSession) {
                ContextInfoSession contextInfoSession = (ContextInfoSession)this.actionInteractor;
                saToolsExecutionHandler.setCurrentContextInfoSession(contextInfoSession);
            }
        }
    }

    public void showFunctionExecutionFailed(CannotExecuteFunctionException ex) {
        this.chatPanelMessageUpdater.updateForFunctionExecutionFailed(ex.getMessage(), ex.isFatal());
        this.chatModel.addToolCallError(ex.getMessage());
    }

    public void showFunctionExecuted(ToolCallResponseMessage toolCallResponseMessage) {
        this.chatPanelMessageUpdater.updateWhenFunctionExecuted(toolCallResponseMessage);
        this.chatModel.addToolCallsResponseMessage(toolCallResponseMessage);
        this.wasWriteFunctionCallSuccessful = this.wasWriteFunctionCallSuccessful(toolCallResponseMessage);
    }

    @VisibleForTesting
    boolean wasWriteFunctionCallSuccessful(ToolCallResponseMessage toolCallResponseMessage) {
        return toolCallResponseMessage != null && toolCallResponseMessage.getToolCallId() != null && this.currentWriteToolCallIds.contains(toolCallResponseMessage.getToolCallId());
    }

    public void showAllFunctionsExecuted() {
        this.chatPanelMessageUpdater.updateWhenAllFunctionsExecuted();
    }

    public void clearCurrentResponse() {
        this.chatPanelMessageUpdater.clearCurrentResponse();
    }

    public void removeChatMessageForCurentResponseChunks() {
        this.chatPanelMessageUpdater.removeChatMessageForCurentResponseChunks();
    }

    public void setInitialActionMessages(List<Message> messages) {
        this.chatModel.addInitialMessages(messages);
    }

    public void storeAIAssistantMessage(ActionInteractor actionInteractor, String model, Message message, boolean isIncomplete) {
        this.actionInteractor = actionInteractor;
        if (this.pathToNode != null) {
            this.chatModel.editMessage(this.pathToNode, message, model);
            this.chatPanelMessageUpdater.updateResponseNavigationWidget();
        } else {
            this.chatModel.addMessage(message, model);
        }
        this.historyComponent.addHistoryObject(this.chatModel);
        ActionInteractor actionInteractorToUseForThisMessage = this.wasWriteFunctionCallSuccessful ? this.getInteractorToUseWhenWriteFunctionCallSucceeded(actionInteractor) : actionInteractor;
        String messageContent = ((MessageTextContent)message.getContent().get(0)).getText();
        this.chatPanelMessageUpdater.markAssistantChunksAsFinished(actionInteractorToUseForThisMessage, messageContent, isIncomplete);
        this.markFinishStreamingStateInChat();
    }

    private ActionInteractor getInteractorToUseWhenWriteFunctionCallSucceeded(ActionInteractor originalActionInteractor) {
        final ActionInteractor delegate = originalActionInteractor == null ? this.getDefaultActionInteractor() : originalActionInteractor;
        return new ActionInteractor(){

            public String getActionChangeType() {
                return null;
            }

            public String getActionChangeDescription() {
                return null;
            }

            public String getPreviewChangeDescription() {
                return null;
            }

            public String getActionChangeIconPath() {
                return null;
            }

            public boolean canModifyDocument() {
                return false;
            }

            public boolean canPreviewDocumentModifications() {
                return false;
            }

            public void applyChangesToDocument(String response) throws BadLocationException {
            }

            public void previewDocumentModifications(String response) throws BadLocationException {
            }

            public boolean allowsExecutionRetargeting() {
                return delegate.allowsExecutionRetargeting();
            }

            public boolean isDirectlyPerformAction() {
                return delegate.isDirectlyPerformAction();
            }
        };
    }

    private void markFinishStreamingStateInChat() {
        this.isRequestBeingProcessed = false;
        SwingUtilities.invokeLater(() -> {
            this.updateInputAreaButtons();
            this.pluginWorkspaceAccess.showView("PositronPluginViewID", true);
            this.newChatModesContainer.setChatButtonsEnabled(true);
            this.setEnableHistory(true);
            this.chatPanelMessageUpdater.setMessageEditingState(true);
            this.chatPanelMessageUpdater.setResponseActionsEnabled(true, this);
            this.updateEditorVarsWidgetEnablingState();
            if (!this.currentChatResponseWasStoppedByUser.get()) {
                this.chatPanelMessageUpdater.automaticallyUpdateDocumentIfActionImposedIt(this.actionInteractor);
            }
        });
    }

    private void editorContextChanged() {
        this.actionInteractor = null;
        this.updateEditorVarsWidgetEnablingState();
        DefaultActionInteractor defaultAction = this.defaultActionInteractorProvider.getDefaultActionInteractor();
        ActionPanelUpdater.updateAllActions((DefaultActionInteractor)(defaultAction.isDocumentOpened() ? defaultAction : null), this);
        this.updateSelectionChip(TRANSLATOR.getTranslation("Current_document_selection") + ":\n");
    }

    public void showMessageForNotSuccessfulAction(String message, boolean wasCancelled, boolean shouldAllowRetry, boolean shouldStartNewChat, Map<String, String> links) {
        this.isRequestBeingProcessed = false;
        if (shouldStartNewChat && !this.clearChat()) {
            return;
        }
        if (!wasCancelled && !this.chatPanelMessageUpdater.hasTextInCurrentMessage()) {
            this.removeChatMessageForCurentResponseChunks();
        }
        this.chatPanelMessageUpdater.showMessageForNotSuccessfulAction(message, wasCancelled, shouldAllowRetry, links);
        SwingUtilities.invokeLater(() -> {
            this.pluginWorkspaceAccess.showView("PositronPluginViewID", true);
            this.newChatModesContainer.setChatButtonsEnabled(true);
            this.setEnableHistory(true);
            this.chatPanelMessageUpdater.setMessageEditingState(true);
            this.chatPanelMessageUpdater.setResponseActionsEnabled(true, this);
        });
    }

    public void notifyActionStopped() {
        this.isRequestBeingProcessed = false;
        this.newChatModesContainer.setActionThreadInProgress(false);
        this.chatPanelMessageUpdater.notifyActionStopped();
        this.chatPanelMessageUpdater.setMessageEditingState(true);
        this.chatPanelMessageUpdater.setResponseActionsEnabled(true, this);
        this.updateInputAreaButtons();
    }

    private void updateEditorVarsWidgetEnablingState() {
        this.editorVarsSplitMenuButton.setEnabled(this.chatUserInputComponent.canUserType() && this.actionInteractor == null);
    }

    private ChatModel createChatMessageModelForUserInitiative() throws ExecutionException {
        AIActionDetails actionDetails = ChatModesUtil.obtainChatActionDetails(this.completionActionsManager);
        Map params = ParamsExpander.expandParams(null, (List)actionDetails.getExpandParams(), (DocumentDetailsProvider)this.documentDetailsProvider);
        return new ChatModel(actionDetails, params);
    }

    public boolean isRequestBeingProcessed() {
        return this.isRequestBeingProcessed;
    }

    private void setEnableHistory(boolean enabled) {
        this.historyComponent.setEnabled(enabled);
    }

    @VisibleForTesting
    public JPanel getConversationPanelForTC() {
        return this.conversationPanel;
    }

    @VisibleForTesting
    public void sendTextToAiForTC(String text) {
        this.chatUserInputComponent.setText(text);
        this.sendButton.doClick();
    }

    public AbstractButton getNewChatButton() {
        return this.newChatModesContainer.getChatStartButton();
    }

    @VisibleForTesting
    AbstractButton getChatModesSwitchButton() {
        return this.newChatModesContainer.getChatModesSwitchButton();
    }

    public HistoryComponent<ChatModel> getHistoryComponent() {
        return this.historyComponent;
    }

    @VisibleForTesting
    public JButton getStopButton() {
        return this.stopButton;
    }

    @Override
    public void setUserInput(String userInput) {
        if (!this.isShowing()) {
            this.pluginWorkspaceAccess.showView("PositronPluginViewID", true);
        } else {
            this.chatUserInputComponent.focusNow();
        }
        this.chatUserInputComponent.setText(userInput);
    }

    public void actionsReloaded() {
        this.newChatModesContainer.actionsReloaded();
        this.actionsAndConvesationPanel.updateViewModeIfNecessary();
    }

    public void showAIAssistantModel(String model) {
        this.chatPanelMessageUpdater.updateAIModelOnLabel(model);
    }

    @Override
    public void setChatPanelMessagesVisibilityListener(ChatPanelMessagesVisibilityListener listener) {
        this.actionsAndConvesationPanel.setChatPanelMessagesVisibilityListener(listener);
    }

    @Override
    public void importChat(ChatModel model) {
        if (model != null) {
            this.setChatModelAsActiveChat(model);
            this.historyComponent.addHistoryObject(model, true);
            this.historyComponent.historyObjectSelected(model);
        }
    }

    @VisibleForTesting
    void setChatModelAsActiveChat(ChatModel model) {
        if (!this.clearChat()) {
            return;
        }
        this.chatModel = model;
        this.chatPanelMessageUpdater.setModel(this.chatModel);
        this.newChatModesContainer.setChatButtonsEnabled(true);
        this.actionsAndConvesationPanel.showConversationPanel();
        this.removeSelectionChip();
        this.isAutoScrollEnabled = true;
        SwingUtilities.invokeLater(this::scrollToTop);
    }

    public void showMessage(Message message) {
        SwingUtilities.invokeLater(() -> this.chatPanelMessageUpdater.addNormalMessageToConversationGUI(new ChatMessage(message), false, null, null));
    }

    public void storeMessage(Message message) {
        this.chatModel.addMessage(message, null);
    }

    public String showValidationErrors(String validationJson) {
        ValidationErrorMessageNode validationErrorNode = new ValidationErrorMessageNode(validationJson);
        this.chatModel.addValidationErrorMessage(validationErrorNode);
        SwingUtilities.invokeLater(() -> this.chatPanelMessageUpdater.addValidationErrorToConversationGUI(validationErrorNode));
        return this.getCurrentMessageContentId();
    }

    public void startCorrectionMessage(ProgressActionInteractor progressActionInteractor) {
        this.isRequestBeingProcessed = true;
        this.progressActionInteractor = progressActionInteractor;
        SwingUtilities.invokeLater(() -> {
            this.chatPanelMessageUpdater.addEmptyAssistantMessageToConversationGui();
            this.updateInputAreaButtons();
        });
    }

    public void showCorrectionMessageChunk(String correctedContentChunk) {
        SwingUtilities.invokeLater(() -> this.chatPanelMessageUpdater.addAssistantChunkMessage(correctedContentChunk));
    }

    public void finishCorrectingContentRange(String correctedContent, List<Throwable> errors, int startOffset, int endOffset, boolean isForAppliendContent) {
        ActionInteractor interactor = this.actionInteractor;
        if (isForAppliendContent) {
            ReplaceFragmentActionInteractor replaceActionInteractor = new ReplaceFragmentActionInteractor(this.chatModel.getActionDetails());
            this.defaultActionInteractorProvider.getDefaultActionInteractor().transferContentInserterAndListenerTo((BaseActionInteractor)replaceActionInteractor);
            try {
                replaceActionInteractor.setAiInitialSuggestion(correctedContent, startOffset, endOffset);
            }
            catch (BadLocationException e) {
                logger.debug("Error setting AI initial suggestion for content range correction", (Throwable)e);
            }
            interactor = replaceActionInteractor;
        }
        this.storeCorrectedContentCommon(correctedContent, errors, interactor);
    }

    public void finishCorrectingDocument(String correctedContent, List<Throwable> errors, String documentUrl, boolean isForAppliendContent) {
        ActionInteractor interactor = this.actionInteractor;
        if (isForAppliendContent) {
            UpdateEntireDocumentActionInteractor updateEntireDocumentActionInteractor = new UpdateEntireDocumentActionInteractor(this.chatModel.getActionDetails());
            this.defaultActionInteractorProvider.getDefaultActionInteractor().transferContentInserterAndListenerTo((BaseActionInteractor)updateEntireDocumentActionInteractor);
            updateEntireDocumentActionInteractor.setAiInitialSuggestion(correctedContent, null, null);
            interactor = updateEntireDocumentActionInteractor;
        }
        this.storeCorrectedContentCommon(correctedContent, errors, interactor);
    }

    private void storeCorrectedContentCommon(String correctedContent, List<Throwable> errors, ActionInteractor actionInteractor) {
        CorrectionMessageNode correctionNode = new CorrectionMessageNode(correctedContent, "");
        this.chatModel.addCorrectionMessage(correctionNode);
        this.historyComponent.addHistoryObject(this.chatModel);
        this.chatPanelMessageUpdater.markAssistantChunksAsFinished(actionInteractor, correctedContent, PositronErrorsUtil.hasStreamingIncomplete(errors));
        this.markFinishStreamingStateInChat();
        if (!errors.isEmpty()) {
            AICompletionDetailsProvider aiCompletionProvider = this.aiCompletionProviderManager.getCurrentCompletionProvider();
            String errorMsg = PositronServiceUtil.computeErrorMessage((Throwable)errors.get(0), (String)correctedContent, (AICompletionDetailsProvider)aiCompletionProvider);
            if (!errorMsg.isBlank()) {
                this.showMessageForNotSuccessfulAction(errorMsg, PositronErrorsUtil.hasStreamingCancelled(errors), false, false, aiCompletionProvider.computeErrorLink(errors.get(0)));
            }
        }
    }

    public void notifyValidationCorrectionInProgress() {
        SwingUtilities.invokeLater(() -> this.chatPanelMessageUpdater.showCorrectionInProgressMessage());
    }

    public void notifyValidationCorrectionCompleted(boolean success) {
        SwingUtilities.invokeLater(() -> this.chatPanelMessageUpdater.showCorrectionCompletedMessage(success));
    }

    public void notifyValidationCorrectionAborted(String textToNotify) {
        SwingUtilities.invokeLater(() -> this.chatPanelMessageUpdater.showCorrectionAbortedMessage(textToNotify));
    }

    public String getCurrentMessageContentId() {
        if (this.chatModel != null) {
            return PathNodeUtils.serializePathToNode(this.chatModel.getMessagesIndexPath());
        }
        return "";
    }

    public JScrollPane getMessagesScrollPane() {
        return this.messagesScrollPane;
    }

    private void scrollToBottom() {
        JScrollBar scrollBar = this.messagesScrollPane.getVerticalScrollBar();
        scrollBar.setValue(scrollBar.getMaximum() - scrollBar.getModel().getExtent());
    }

    private void scrollToTop() {
        JScrollBar scrollBar = this.messagesScrollPane.getVerticalScrollBar();
        scrollBar.setValue(0);
    }

    public int countTrailingValidationMessages() {
        List<MessageNode> messages = this.getChatModel().getChatMessages();
        int count = 0;
        for (int i = messages.size() - 1; i >= 0; --i) {
            MessageNode msg = messages.get(i);
            if (msg instanceof ValidationErrorMessageNode) {
                ++count;
                continue;
            }
            if (!(msg instanceof CorrectionMessageNode)) break;
        }
        return count;
    }

    @Override
    public void componentAddedToConversationThread() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (ChatPanel.this.isAutoScrollEnabled) {
                    ChatPanel.this.scrollToBottom();
                }
            }
        });
    }

    public ChatPanelUserInputComponentWithAutoHeight getChatUserInputComponent() {
        return this.chatUserInputComponent;
    }

    public void updateSelectionChip(String tooltipPrefix) {
        if (this.isConversationJustStarting() && ChatPanel.canUseSelection(this.documentDetailsProvider)) {
            this.attachmentsPanel.updateSelectionChip(this.getCurrentDocumentSelection(), tooltipPrefix, null);
        }
    }

    private void removeSelectionChip() {
        this.attachmentsPanel.updateSelectionChip(null, null, null);
    }

    private String getCurrentDocumentSelection() {
        try {
            return this.defaultActionInteractorProvider.getDefaultActionInteractor().getSelectedContent(false);
        }
        catch (OperationCancelledByAiIgnoreException | BadLocationException e) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)e, e);
            }
            return null;
        }
    }

    public AttachmentsPanel getAttachmentsPanelForTC() {
        return this.attachmentsPanel;
    }

    public void setSelectedChatMode(String chatModeId) {
        Optional<PositronAIActionBase> newChatModeOpt = this.completionActionsManager.getPseudoActions().stream().filter(action -> action.getActionDetails() != null && chatModeId.equals(action.getActionDetails().getId())).findFirst();
        if (newChatModeOpt.isPresent()) {
            this.newChatModesContainer.setSelectedChatMode(newChatModeOpt.get());
        }
    }

    @VisibleForTesting
    void setWasWriteFunctionCallSuccessful(boolean wasWriteFunctionCallSuccessful) {
        this.wasWriteFunctionCallSuccessful = wasWriteFunctionCallSuccessful;
    }

    @VisibleForTesting
    Set<String> getCurrentWriteToolCallIds() {
        return this.currentWriteToolCallIds;
    }

    public void checkExecutionAllowed(String toolId, String name, String description, String arguments, UnsafeFunctionInterceptor interceptor) {
        this.chatPanelMessageUpdater.checkExecutionAllowed(toolId, name, description, arguments, interceptor);
    }

    public void setDefaultActionInteractorProvider(DefaultActionInteractorProvider defaultActionInteractorProvider) {
        this.defaultActionInteractorProvider = defaultActionInteractorProvider;
    }

    public ChatPanelMessageUpdater getChatPanelMessageUpdater() {
        return this.chatPanelMessageUpdater;
    }

    public FavoritesManager getFavoritesManager() {
        return this.favoritesManager;
    }

    public void setCompletionActionsProvider(CompletionActionsProvider completionActionsProvider) {
        this.completionActionsProvider = completionActionsProvider;
    }
}

