/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.positron.plugin.chat;

import com.oxygenxml.positron.actions.AIActionsUtil;
import com.oxygenxml.positron.core.actions.ParamsExpander;
import com.oxygenxml.positron.core.actions.types.PositronAIActionBase;
import com.oxygenxml.positron.core.plugin.Translator;
import com.oxygenxml.positron.plugin.chat.ChatButtonsPanelSwitcher;
import com.oxygenxml.positron.plugin.chat.ChatStartAndModesInteractor;
import com.oxygenxml.positron.plugin.chat.DropPasteAttachmentsTransferHandler;
import com.oxygenxml.positron.plugin.chat.UserInputTextHandler;
import com.oxygenxml.positron.plugin.completion.CompletionActionsManager;
import com.oxygenxml.positron.plugin.ui.LinkLabel;
import com.oxygenxml.positron.plugin.ui.PositronScrollPane;
import com.oxygenxml.positron.plugin.ui.ScrollablePanel;
import com.oxygenxml.positron.plugin.ui.ThemeColorProvider;
import com.oxygenxml.positron.plugin.util.IconsLoader;
import com.oxygenxml.positron.utilities.json.AIActionDetails;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.List;
import java.util.stream.Collectors;
import javax.swing.AbstractAction;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextPane;
import javax.swing.JViewport;
import javax.swing.KeyStroke;
import javax.swing.TransferHandler;
import javax.swing.UIManager;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.plaf.BorderUIResource;
import javax.swing.text.BadLocationException;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.sync.exml.workspace.api.PluginWorkspace;
import ro.sync.exml.workspace.api.PluginWorkspaceProvider;

class ChatModeInfoPanel
extends JPanel {
    private static final int RELAXED_SPACING_BETWEEN_COMPONENTS = 10;
    private static final Logger logger = LoggerFactory.getLogger((String)ChatModeInfoPanel.class.getName());
    private static final long serialVersionUID = 1L;
    private AIActionDetails currentChatMode;
    private ThemeColorProvider themeColorProvider = ThemeColorProvider.getInstance();
    private ChatStartAndModesInteractor chatStartAndModesProvider;
    private CompletionActionsManager completionActionsManager;
    private ChatButtonsPanelSwitcher buttonsPanelSwitcher;
    private TransferHandler dropTransferHandler;

    public ChatModeInfoPanel(CompletionActionsManager completionActionsManager, ChatStartAndModesInteractor chatStartAndModesProvider, ChatButtonsPanelSwitcher buttonsPanelSwitcher, UserInputTextHandler userInputTextHandler) {
        this.completionActionsManager = completionActionsManager;
        this.chatStartAndModesProvider = chatStartAndModesProvider;
        this.buttonsPanelSwitcher = buttonsPanelSwitcher;
        this.setLayout(new GridBagLayout());
        Color backgroundColor = this.themeColorProvider.getBackgroundColor();
        this.setBackground(backgroundColor);
        AbstractAction quickFind = AIActionsUtil.createQuickFindAction(() -> this, completionActionsManager::getCompletionActions, false);
        this.getInputMap(2).put(KeyStroke.getKeyStroke(32, 128), "positron.quickSearch");
        this.getActionMap().put("positron.quickSearch", quickFind);
        if (userInputTextHandler != null) {
            this.dropTransferHandler = new DropPasteAttachmentsTransferHandler(userInputTextHandler);
            this.setTransferHandler(this.dropTransferHandler);
        }
    }

    public void updateChatMode(AIActionDetails chatModeDetails) {
        if (chatModeDetails != null) {
            this.currentChatMode = chatModeDetails;
            this.reloadContent();
        }
    }

    private void reloadContent() {
        String titleText = this.currentChatMode.getTitle();
        String descriptionText = this.currentChatMode.getDescription();
        this.removeAll();
        this.createCenteredContent(titleText, descriptionText);
        this.revalidate();
        this.repaint();
    }

    private void createCenteredContent(String titleText, String descriptionText) {
        ScrollablePanel contentPanel = new ScrollablePanel(){

            @Override
            public boolean getScrollableTracksViewportHeight() {
                Container parent = this.getParent();
                if (parent instanceof JViewport) {
                    int viewportHeight = ((JViewport)parent).getHeight();
                    return this.getPreferredSize().height < viewportHeight;
                }
                return false;
            }
        };
        contentPanel.setLayout(new GridBagLayout());
        contentPanel.setOpaque(false);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.fill = 1;
        gbc.weighty = 0.0;
        gbc.insets = new Insets(0, 10, 10, 10);
        gbc.fill = 0;
        JLabel iconLabel = new JLabel(IconsLoader.loadIcon("/images/AIAgentChat24.png"));
        iconLabel.setHorizontalAlignment(0);
        contentPanel.add((Component)iconLabel, gbc);
        ++gbc.gridy;
        gbc.insets = new Insets(0, 10, 0, 10);
        gbc.fill = 2;
        String centeredTitleHtml = "<html><div style='text-align:center; font-weight:bold;'>" + titleText + "</div></html>";
        JLabel titleLabel = new JLabel(centeredTitleHtml);
        titleLabel.setHorizontalAlignment(0);
        titleLabel.setFocusable(false);
        contentPanel.add((Component)titleLabel, gbc);
        ++gbc.gridy;
        gbc.anchor = 17;
        gbc.insets = new Insets(10, 10, 0, 10);
        gbc.fill = 2;
        JComponent centeredChatAgentDescriptionPane = this.createCenteredChatAgentDescriptionPane(descriptionText);
        contentPanel.add((Component)centeredChatAgentDescriptionPane, gbc);
        ++gbc.gridy;
        gbc.insets = new Insets(20, 10, 10, 10);
        gbc.fill = 0;
        JPanel linksPanel = this.createChatModesLinksPanel();
        linksPanel.setOpaque(false);
        contentPanel.add((Component)linksPanel, gbc);
        String contextContent = ParamsExpander.getProjectAIContextContents((PluginWorkspace)PluginWorkspaceProvider.getPluginWorkspace());
        if (contextContent == null) {
            ++gbc.gridy;
            gbc.insets = new Insets(10, 10, 0, 10);
            gbc.fill = 2;
            gbc.weightx = 1.0;
            gbc.anchor = 17;
            JPanel generateInstructionsPane = this.createGenerateInstructionsPane();
            generateInstructionsPane.setOpaque(false);
            contentPanel.add((Component)generateInstructionsPane, gbc);
        }
        gbc.weightx = 0.0;
        ++gbc.gridy;
        gbc.insets = new Insets(10, 10, 0, 10);
        gbc.fill = 2;
        gbc.anchor = 17;
        JPanel additionalInfoPanel = this.createAdditionalInfoPanel();
        additionalInfoPanel.setOpaque(false);
        contentPanel.add((Component)additionalInfoPanel, gbc);
        GridBagConstraints mainConstraints = new GridBagConstraints();
        mainConstraints.gridx = 0;
        mainConstraints.gridy = 0;
        mainConstraints.anchor = 17;
        mainConstraints.fill = 1;
        mainConstraints.weightx = 1.0;
        mainConstraints.weighty = 1.0;
        mainConstraints.insets = new Insets(0, 0, 0, 0);
        PositronScrollPane wrapperScrollPane = new PositronScrollPane(contentPanel);
        wrapperScrollPane.setBorder(new BorderUIResource.MatteBorderUIResource(0, 0, 1, 0, ThemeColorProvider.getInstance().getViewTabsBorderColor()));
        wrapperScrollPane.getScrollPane().setOpaque(false);
        wrapperScrollPane.getScrollPane().getViewport().setOpaque(false);
        this.add((Component)wrapperScrollPane.getScrollPane(), mainConstraints);
    }

    private JComponent createCenteredChatAgentDescriptionPane(String text) {
        JTextPane textPane = new JTextPane();
        textPane.setEditable(false);
        textPane.setFocusable(false);
        textPane.setOpaque(false);
        textPane.setMargin(new Insets(0, 0, 0, 0));
        textPane.setForeground(new JPanel().getForeground());
        StyledDocument doc = textPane.getStyledDocument();
        SimpleAttributeSet center = new SimpleAttributeSet();
        StyleConstants.setAlignment(center, 0);
        doc.setParagraphAttributes(0, doc.getLength(), center, false);
        textPane.setText(text);
        if (this.dropTransferHandler != null) {
            textPane.setTransferHandler(this.dropTransferHandler);
        }
        return textPane;
    }

    private JPanel createAdditionalInfoPanel() {
        JPanel additionalInfoPanel = new JPanel(new GridBagLayout());
        GridBagConstraints infoConstraints = new GridBagConstraints();
        infoConstraints.gridy = 0;
        infoConstraints.gridx = 0;
        infoConstraints.gridwidth = 1;
        infoConstraints.weightx = 1.0;
        infoConstraints.fill = 2;
        infoConstraints.insets = new Insets(0, 0, 0, 0);
        infoConstraints.anchor = 17;
        additionalInfoPanel.add((Component)this.createAttachTextPane(), infoConstraints);
        if (this.buttonsPanelSwitcher != null) {
            ++infoConstraints.gridy;
            infoConstraints.insets = new Insets(0, 0, 0, 0);
            LinkLabel viewAllActionsLink = this.createViewAllActionsLink();
            additionalInfoPanel.add((Component)viewAllActionsLink, infoConstraints);
        }
        return additionalInfoPanel;
    }

    private JTextPane createAttachTextPane() {
        String instructionsText = Translator.getInstance().getTranslation("Attach_and_quicksearch_instructions");
        JTextPane textPane = new JTextPane();
        textPane.setEditable(false);
        textPane.setFocusable(false);
        textPane.setOpaque(false);
        textPane.setMargin(new Insets(0, 0, 0, 0));
        textPane.setForeground(new JPanel().getForeground());
        textPane.setAlignmentX(0.0f);
        StyledDocument doc = textPane.getStyledDocument();
        try {
            String iconPlaceholder = "{ATTACH_ICON}";
            int iconPosition = instructionsText.indexOf(iconPlaceholder);
            if (iconPosition >= 0) {
                String textBeforeIcon = instructionsText.substring(0, iconPosition);
                if (!textBeforeIcon.isEmpty()) {
                    doc.insertString(doc.getLength(), textBeforeIcon, null);
                }
                textPane.setCaretPosition(doc.getLength());
                textPane.insertIcon(IconsLoader.loadIcon("/images/Attachment16.png"));
                String textAfterIcon = instructionsText.substring(iconPosition + iconPlaceholder.length());
                if (!textAfterIcon.isEmpty()) {
                    doc.insertString(doc.getLength(), textAfterIcon, null);
                }
            } else {
                doc.insertString(doc.getLength(), instructionsText, null);
            }
        }
        catch (BadLocationException e) {
            logger.debug("Bad insertion inside text pane:", (Throwable)e);
        }
        SimpleAttributeSet center = new SimpleAttributeSet();
        StyleConstants.setAlignment(center, 0);
        doc.setParagraphAttributes(0, doc.getLength(), center, false);
        if (this.dropTransferHandler != null) {
            textPane.setTransferHandler(this.dropTransferHandler);
        }
        return textPane;
    }

    private JPanel createGenerateInstructionsPane() {
        JPanel panel = new JPanel(new GridBagLayout());
        final PositronAIActionBase generateInstructionsAction = this.completionActionsManager.getPositronAIAction("action.generate.context.prompt.instructions");
        if (generateInstructionsAction != null) {
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = 0;
            gbc.anchor = 17;
            gbc.fill = 2;
            gbc.weightx = 1.0;
            JEditorPane editorPane = new JEditorPane("text/html", "<html><body style='margin: 0; padding: 0;'><a href='generate'>" + generateInstructionsAction.getActionDetails().getTitle() + "</a> - " + generateInstructionsAction.getActionDetails().getDescription() + "</body></html>");
            editorPane.setEditable(false);
            editorPane.setOpaque(false);
            editorPane.setFocusable(false);
            editorPane.setMargin(new Insets(0, 0, 0, 0));
            editorPane.setBorder(null);
            editorPane.setForeground(new JPanel().getForeground());
            editorPane.putClientProperty("JEditorPane.honorDisplayProperties", Boolean.TRUE);
            Font font = UIManager.getDefaults().getFont("TextArea.font");
            if (font != null) {
                this.setFont(font);
            }
            editorPane.addHyperlinkListener(new HyperlinkListener(){

                @Override
                public void hyperlinkUpdate(HyperlinkEvent e) {
                    if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                        generateInstructionsAction.actionPerformed(null);
                    }
                }
            });
            if (this.dropTransferHandler != null) {
                editorPane.setTransferHandler(this.dropTransferHandler);
            }
            panel.add((Component)editorPane, gbc);
        } else if (logger.isDebugEnabled()) {
            logger.debug("Could not find generate instructions action");
        }
        return panel;
    }

    private JPanel createChatModesLinksPanel() {
        JPanel linksPanel = new JPanel(new GridBagLayout());
        GridBagConstraints linkConstraints = new GridBagConstraints();
        linkConstraints.gridy = 0;
        linkConstraints.gridx = 0;
        linkConstraints.weightx = 0.0;
        linkConstraints.insets = new Insets(0, 0, 0, 3);
        linkConstraints.anchor = 17;
        JLabel exploreLabel = new JLabel(Translator.getInstance().getTranslation("Explore_other_chat_modes"));
        exploreLabel.setHorizontalAlignment(2);
        linksPanel.add((Component)exploreLabel, linkConstraints);
        JPanel linkButtonsPanel = new JPanel(new GridBagLayout());
        linkButtonsPanel.setOpaque(false);
        GridBagConstraints buttonConstraints = new GridBagConstraints();
        buttonConstraints.gridy = 0;
        buttonConstraints.insets = new Insets(0, 0, 0, 0);
        buttonConstraints.anchor = 17;
        List differentChatModes = this.completionActionsManager.getPseudoActions().stream().filter(action -> action.getActionDetails() != null && action.getActionDetails().getId() != null && action.getActionDetails().getId().startsWith("pseudoaction.chat.message.")).filter(action -> action.getActionDetails() != this.currentChatMode).collect(Collectors.toList());
        int linkCount = 0;
        for (PositronAIActionBase chatMode : differentChatModes) {
            if (linkCount > 0) {
                buttonConstraints.gridx = linkCount * 2 - 1;
                JLabel separator = new JLabel(" | ");
                separator.setForeground(ThemeColorProvider.getInstance().getGroupSeparatorColor());
                linkButtonsPanel.add((Component)separator, buttonConstraints);
            }
            buttonConstraints.gridx = linkCount * 2;
            LinkLabel modeLink = this.createChatModeLink(chatMode);
            linkButtonsPanel.add((Component)modeLink, buttonConstraints);
            ++linkCount;
        }
        ++linkConstraints.gridx;
        linkConstraints.insets = new Insets(0, 0, 0, 0);
        linksPanel.add((Component)linkButtonsPanel, linkConstraints);
        return linksPanel;
    }

    private LinkLabel createViewAllActionsLink() {
        String displayText = Translator.getInstance().getTranslation("Show_actions");
        LinkLabel linkLabel = new LinkLabel(displayText){

            @Override
            public void performAction() {
                if (ChatModeInfoPanel.this.buttonsPanelSwitcher != null) {
                    ChatModeInfoPanel.this.buttonsPanelSwitcher.switchToButtonsPanel();
                }
            }
        };
        linkLabel.setHorizontalAlignment(2);
        linkLabel.setToolTipText(Translator.getInstance().getTranslation("Switch_to_actions_buttons_view"));
        return linkLabel;
    }

    private LinkLabel createChatModeLink(final PositronAIActionBase chatMode) {
        final AIActionDetails actionDetails = chatMode.getActionDetails();
        String displayText = actionDetails.getTitle();
        LinkLabel linkLabel = new LinkLabel(displayText){

            @Override
            public void performAction() {
                ChatModeInfoPanel.this.updateChatMode(actionDetails);
                if (ChatModeInfoPanel.this.chatStartAndModesProvider != null) {
                    ChatModeInfoPanel.this.chatStartAndModesProvider.setSelectedChatMode(chatMode);
                }
            }
        };
        linkLabel.setHorizontalAlignment(2);
        linkLabel.setToolTipText(actionDetails.getDescription());
        return linkLabel;
    }
}

