/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.positron.plugin.chat;

import com.oxygenxml.positron.core.actions.ActionInteractor;
import com.oxygenxml.positron.core.actions.types.ReplaceCapableActionInteractor;
import com.oxygenxml.positron.core.plugin.Translator;
import com.oxygenxml.positron.plugin.chat.ChatMessageResponseWithActionsPanelInterface;
import com.oxygenxml.positron.plugin.chat.ChatScrollUpdater;
import com.oxygenxml.positron.plugin.chat.MessageUpdater;
import com.oxygenxml.positron.plugin.chat.actions.ChatResponseActionsPanel;
import com.oxygenxml.positron.plugin.util.IconsLoader;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.Toolkit;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import javax.swing.AbstractAction;
import javax.swing.JPanel;
import javax.swing.text.BadLocationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.sync.exml.workspace.api.PluginWorkspace;
import ro.sync.exml.workspace.api.PluginWorkspaceProvider;

public abstract class ChatMessageResponseWithActionsPanel
extends JPanel
implements ChatMessageResponseWithActionsPanelInterface {
    private static final String CANNOT_EXECUTE_ACTION_REASON = "Cannot execute action. Reason: ";
    private static final PluginWorkspace PLUGIN_WS = PluginWorkspaceProvider.getPluginWorkspace();
    private static final Logger LOGGER = LoggerFactory.getLogger((String)ChatResponseActionsPanel.class.getName());
    private static final Translator TRANSLATOR = Translator.getInstance();
    private ChatResponseActionsPanel chatResponse = null;

    protected ChatMessageResponseWithActionsPanel() {
        super(new BorderLayout());
    }

    private void updateMenuActions(ActionInteractor actionInteractor) {
        ArrayList<AbstractAction> contextualActions = new ArrayList<AbstractAction>();
        if (actionInteractor == null) {
            return;
        }
        boolean isAIResponseIdenticalToInputToBeReplaced = false;
        if (actionInteractor instanceof ReplaceCapableActionInteractor) {
            isAIResponseIdenticalToInputToBeReplaced = ((ReplaceCapableActionInteractor)actionInteractor).isAIResponseIdenticalToInput();
        }
        if (!isAIResponseIdenticalToInputToBeReplaced) {
            if (actionInteractor.canModifyDocument()) {
                contextualActions.add(this.createInsertOrReplaceMenuAction(actionInteractor));
            }
            if (actionInteractor.canPreviewDocumentModifications()) {
                contextualActions.add(this.createPreviewMenuAction(actionInteractor));
            }
        }
        contextualActions.add(this.createCopyMenuAction());
        this.setAdditionalMenuActions(contextualActions);
    }

    private AbstractAction createCopyMenuAction() {
        AbstractAction copyAction = new AbstractAction(TRANSLATOR.getTranslation("Edit_Copy"), IconsLoader.loadIcon("/images/Copy16.png")){

            @Override
            public void actionPerformed(ActionEvent e) {
                Toolkit.getDefaultToolkit().getSystemClipboard().setContents(new StringSelection(ChatMessageResponseWithActionsPanel.this.getChatMessageContent()), null);
            }
        };
        copyAction.putValue("ShortDescription", TRANSLATOR.getTranslation("Copy_to_clipboard"));
        return copyAction;
    }

    private AbstractAction createPreviewMenuAction(final ActionInteractor actionInteractor) {
        AbstractAction previewAction = new AbstractAction(TRANSLATOR.getTranslation("Preview")){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    actionInteractor.previewDocumentModifications(ChatMessageResponseWithActionsPanel.this.getChatMessageContent());
                }
                catch (BadLocationException ex) {
                    LOGGER.error((Object)ex, (Throwable)ex);
                    PLUGIN_WS.showErrorMessage(ChatMessageResponseWithActionsPanel.CANNOT_EXECUTE_ACTION_REASON + ex.getMessage());
                }
            }
        };
        previewAction.putValue("ShortDescription", actionInteractor.getPreviewChangeDescription());
        return previewAction;
    }

    private AbstractAction createInsertOrReplaceMenuAction(final ActionInteractor actionInteractor) {
        AbstractAction insertOrReplaceAction = new AbstractAction(actionInteractor.getActionChangeType()){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    actionInteractor.applyChangesToDocument(ChatMessageResponseWithActionsPanel.this.getChatMessageContent());
                }
                catch (BadLocationException ex) {
                    LOGGER.error((Object)ex, (Throwable)ex);
                    PLUGIN_WS.showErrorMessage(ChatMessageResponseWithActionsPanel.CANNOT_EXECUTE_ACTION_REASON + ex.getMessage());
                }
            }
        };
        insertOrReplaceAction.putValue("ShortDescription", actionInteractor.getActionChangeDescription());
        return insertOrReplaceAction;
    }

    @Override
    public void updateResponseAccessActions(ActionInteractor actionInteractor, String messageContent, MessageUpdater messageUpdater, ChatScrollUpdater scrollUpdater) {
        this.updateMenuActions(actionInteractor);
        this.chatResponse = new ChatResponseActionsPanel(actionInteractor, messageContent, this, messageUpdater);
        if (this.getLayout() instanceof BorderLayout) {
            this.add((Component)this.chatResponse, "South");
        } else {
            LOGGER.error("Avoid clas cast, probably running from tests");
            this.add((Component)this.chatResponse, new GridBagConstraints());
        }
        this.revalidate();
        scrollUpdater.componentAddedToConversationThread();
    }

    public void reconfigureChatMessageActions() {
        if (this.chatResponse != null) {
            this.chatResponse.reconfigure();
        }
    }
}

