/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.positron.plugin.chat;

import com.oxygenxml.positron.actions.AIActionsUtil;
import com.oxygenxml.positron.actions.ConfigDialogFloatingWindowUpdater;
import com.oxygenxml.positron.core.actions.types.PositronAIActionBase;
import com.oxygenxml.positron.plugin.chat.DropPasteAttachmentsTransferHandler;
import com.oxygenxml.positron.plugin.chat.UserInputTextHandler;
import com.oxygenxml.positron.plugin.completion.CompletionActionsManager;
import com.oxygenxml.positron.plugin.ui.PositronScrollPane;
import com.oxygenxml.positron.plugin.ui.SectionPane;
import com.oxygenxml.positron.plugin.ui.ThemeColorProvider;
import com.oxygenxml.positron.plugin.util.PlatformUtils;
import com.oxygenxml.positron.plugin.util.UIUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.util.List;
import java.util.Map;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.plaf.BorderUIResource;
import ro.sync.exml.workspace.api.standalone.ui.Button;
import ro.sync.exml.workspace.api.standalone.ui.OxygenUIComponentsFactory;

public class ButtonsPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private int numOfColsOfButtons = 2;
    private int maxButtonPreferredWidth = 100;
    private static final int MIN_NUMBER_OF_COLUMNS = 1;
    private static final int SPACING_BETWEEN_BUTTONS = PlatformUtils.isMacOS() ? 0 : 3;
    private static final int LEFT_RIGHT_MARGIN = PlatformUtils.isMacOS() ? 0 : 3;
    private Insets buttonMargin;
    private CompletionActionsManager completionActionsManager;
    private JPanel parentComponent;
    private final JPanel buttonsContentPanel = new JPanel(new GridBagLayout());
    private final PositronScrollPane buttonsScrollPane;

    public ButtonsPanel(JPanel parentComponent, CompletionActionsManager completionActionsManager, UserInputTextHandler userInputTextHandler) {
        this.parentComponent = parentComponent;
        this.completionActionsManager = completionActionsManager;
        Insets margin = new Button("Aux").getMargin();
        margin.left = LEFT_RIGHT_MARGIN;
        margin.right = LEFT_RIGHT_MARGIN;
        this.buttonMargin = margin;
        this.buttonsScrollPane = new PositronScrollPane(this.buttonsContentPanel);
        this.buttonsScrollPane.setBorder(new BorderUIResource.MatteBorderUIResource(0, 0, 1, 0, ThemeColorProvider.getInstance().getViewTabsBorderColor()));
        this.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.fill = 1;
        this.add((Component)this.buttonsScrollPane.getScrollPane(), gbc);
        this.buttonsScrollPane.getScrollPane().addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                ButtonsPanel.this.computeColumns();
            }
        });
        this.populateButtons();
        if (userInputTextHandler != null) {
            this.setTransferHandler(new DropPasteAttachmentsTransferHandler(userInputTextHandler));
        }
    }

    public void computeColumns() {
        if (this.maxButtonPreferredWidth > 0) {
            JScrollPane scrollPane = this.buttonsScrollPane.getScrollPane();
            int width = scrollPane.getWidth();
            JScrollBar verticalScrollBar = scrollPane.getVerticalScrollBar();
            if (verticalScrollBar != null && verticalScrollBar.isVisible()) {
                width -= verticalScrollBar.getSize().width;
            }
            int newCols = Math.max(1, width / (this.maxButtonPreferredWidth + 2 * SPACING_BETWEEN_BUTTONS));
            this.updateColumns(newCols);
        }
    }

    public void populateButtons() {
        UIUtil.runNowOrLaterOnAWT(this::populateButtonsInternal);
    }

    private void populateButtonsInternal() {
        this.buttonsContentPanel.removeAll();
        if (this.completionActionsManager == null) {
            return;
        }
        GridBagConstraints gbc = new GridBagConstraints();
        List<PositronAIActionBase> completionActions = this.completionActionsManager.getCompletionActions();
        Map<String, List<PositronAIActionBase>> groupedActions = AIActionsUtil.groupActionByCategory(completionActions);
        this.maxButtonPreferredWidth = UIUtil.calculateMaxButtonPreferredWidth(completionActions, this.buttonMargin);
        if (!groupedActions.isEmpty()) {
            gbc.weightx = 1.0;
            gbc.fill = 2;
            gbc.gridy = -1;
            for (String category : groupedActions.keySet()) {
                ++gbc.gridy;
                gbc.insets.left = 3;
                this.buttonsContentPanel.add((Component)new SectionPane(category, false), gbc);
                ++gbc.gridy;
                gbc.insets.left = 0;
                List<PositronAIActionBase> actionsList = groupedActions.get(category);
                this.buttonsContentPanel.add((Component)this.createPanelWithButtons(actionsList), gbc);
            }
        }
        ++gbc.gridy;
        gbc.gridx = 0;
        gbc.weighty = 1.0;
        gbc.fill = 1;
        gbc.anchor = 18;
        gbc.insets = UIUtil.getNoInsets();
        JPanel filler = new JPanel();
        this.buttonsContentPanel.add((Component)filler, gbc);
        this.buttonsContentPanel.revalidate();
        this.buttonsContentPanel.repaint();
    }

    private JPanel createPanelWithButtons(List<PositronAIActionBase> actionsList) {
        JPanel jPanel = new JPanel(new GridBagLayout());
        int size = actionsList.size();
        int k = 0;
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.insets = UIUtil.getSpacingInsetsNoTop();
        constraints.weightx = 1.0;
        constraints.anchor = 18;
        constraints.fill = 2;
        for (int y = 0; y < size / this.numOfColsOfButtons + 1 && k < size; ++y) {
            int x = 0;
            Insets insets = constraints.insets = PlatformUtils.isMacOS() ? new Insets(0, 0, 0, 0) : UIUtil.getSpacingInsetsNoTop();
            if (!PlatformUtils.isMacOS()) {
                constraints.insets.left = SPACING_BETWEEN_BUTTONS;
                constraints.insets.right = SPACING_BETWEEN_BUTTONS;
            }
            x = 0;
            while (x < this.numOfColsOfButtons && k < size) {
                constraints.gridx = x++;
                constraints.gridy = y;
                PositronAIActionBase action = actionsList.get(k);
                JButton button = OxygenUIComponentsFactory.createButton((Action)action);
                button.setMultiClickThreshhold(500L);
                button.setMargin(this.buttonMargin);
                button.setHorizontalAlignment(0);
                Dimension preferredSize = button.getPreferredSize();
                preferredSize.width = this.maxButtonPreferredWidth;
                button.setPreferredSize(preferredSize);
                new ConfigDialogFloatingWindowUpdater(button, this.parentComponent);
                jPanel.add((Component)button, constraints);
                ++k;
            }
            while (x < this.numOfColsOfButtons) {
                ++constraints.gridx;
                JPanel filler = new JPanel();
                Dimension preferredSize = filler.getPreferredSize();
                preferredSize.width = this.maxButtonPreferredWidth;
                filler.setPreferredSize(preferredSize);
                jPanel.add((Component)filler, constraints);
                ++x;
            }
        }
        return jPanel;
    }

    public void updateColumns(int newNumOfCols) {
        if (newNumOfCols != this.numOfColsOfButtons) {
            this.numOfColsOfButtons = Math.max(1, newNumOfCols);
            this.populateButtons();
        }
    }

    public JScrollPane getScrollPane() {
        return this.buttonsScrollPane.getScrollPane();
    }
}

