/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.positron.plugin.assist;

import com.google.common.annotations.VisibleForTesting;
import com.oxygenxml.positron.core.actions.types.PositronAIActionBase;
import com.oxygenxml.positron.core.actions.types.PositronCopilotProcessContentBasedOnUserInstructionsAction;
import com.oxygenxml.positron.core.plugin.Translator;
import com.oxygenxml.positron.plugin.assist.AuthorSelectionUtil;
import com.oxygenxml.positron.plugin.assist.InplacePromptDialog;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.AbstractAction;
import ro.sync.exml.workspace.api.editor.page.WSTextBasedEditorPage;

public class RewriteSelectionBasedOnUserInstructionsAction
extends AbstractAction {
    private PositronCopilotProcessContentBasedOnUserInstructionsAction copilotChatMessageAction;
    private WSTextBasedEditorPage editorPage;

    public RewriteSelectionBasedOnUserInstructionsAction(WSTextBasedEditorPage editorPage, PositronCopilotProcessContentBasedOnUserInstructionsAction positronAction) {
        super(Translator.getInstance().getTranslation("Rewrite_content") + "...");
        this.editorPage = editorPage;
        this.copilotChatMessageAction = positronAction;
        Translator translator = Translator.getInstance();
        this.putValue("ShortDescription", translator.getTranslation("Rewrite_content_description") + "\n\n" + translator.getTranslation("No_selection_current_para"));
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.prepareSelection();
        final InplacePromptDialog dlg = new InplacePromptDialog(this.editorPage, this.copilotChatMessageAction.getCompletionProviderResolver().getCurrentCompletionProvider());
        dlg.setVisible(true);
        dlg.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosed(WindowEvent e) {
                String userInstructions;
                int result = dlg.getResult();
                if (result == 1 && (userInstructions = dlg.getUserInstructions()) != null && !userInstructions.isBlank()) {
                    RewriteSelectionBasedOnUserInstructionsAction.this.copilotChatMessageAction.actionPerformedWithDirectInsertionInEditor(userInstructions);
                }
            }
        });
    }

    @VisibleForTesting
    void prepareSelection() {
        AuthorSelectionUtil.prepareSelection(this.editorPage, (PositronAIActionBase)this.copilotChatMessageAction);
    }
}

