/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.positron.plugin.assist;

import com.oxygenxml.positron.core.interactions.ContentInserter;
import com.oxygenxml.positron.core.plugin.Translator;
import com.oxygenxml.positron.core.util.TextUtils;
import com.oxygenxml.positron.plugin.assist.InplacePromptDialog;
import com.oxygenxml.positron.plugin.completion.CompletionActionsManager;
import com.oxygenxml.positron.utilities.functions.InvokeActionHelper;
import com.oxygenxml.positron.utilities.functions.InvokeActionHelperProvider;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.SwingWorker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.sync.exml.workspace.api.PluginWorkspaceProvider;
import ro.sync.exml.workspace.api.editor.page.WSEditorPage;
import ro.sync.exml.workspace.api.editor.page.WSTextBasedEditorPage;
import ro.sync.exml.workspace.api.editor.page.text.WSTextEditorPage;

public class GenerateCodeBasedOnUserInstructionsAction
extends AbstractAction {
    private static final Logger log = LoggerFactory.getLogger(GenerateCodeBasedOnUserInstructionsAction.class);
    private final Set<String> supportedContentTypes = Set.of("text/xquery", "text/css", "text/java", "text/php", "text/ant", "text/c", "text/cc", "text/batch", "text/shell", "text/powershell", "text/properties", "text/sql", "text/perl", "text/python", "XHTML", "text/html", "text/nvdl", "text/rnc", "text/rng", "text/javascript", "text/less", "text/dtd", "text/dockerfile", "text/xproc", "text/wsdl", "text/xspec", "SVG", "text/xsl", "text/sch", "text/xsd");
    private final Map<String, String> customActionIds = Map.of("text/xsl", "action.generate.code.xslt", "text/sch", "action.generate.code.sch", "text/xsd", "action.generate.code.xsd");
    private CompletionActionsManager completionActionsManager;

    public GenerateCodeBasedOnUserInstructionsAction(CompletionActionsManager completionActionsManager) {
        super(Translator.getInstance().getTranslation("Generate_code") + "...");
        this.completionActionsManager = completionActionsManager;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        WSEditorPage editorPage = PluginWorkspaceProvider.getPluginWorkspace().getCurrentEditorAccess(0).getCurrentPage();
        if (!(editorPage instanceof WSTextEditorPage)) {
            return;
        }
        final String contentType = editorPage.getParentEditor().getContentType();
        if (!this.supportedContentTypes.contains(contentType)) {
            return;
        }
        final InplacePromptDialog dlg = new InplacePromptDialog((WSTextBasedEditorPage)((WSTextEditorPage)editorPage), null);
        dlg.setVisible(true);
        dlg.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosed(WindowEvent e) {
                String userInstructions;
                int result = dlg.getResult();
                if (result == 1 && (userInstructions = dlg.getUserInstructions()) != null && !userInstructions.isBlank()) {
                    this.generateAndInsertContent(userInstructions);
                }
            }

            void generateAndInsertContent(final String userInstructions) {
                final InvokeActionHelper invokeActionHelper = InvokeActionHelperProvider.getInvokeActionHelper();
                final String actionId = GenerateCodeBasedOnUserInstructionsAction.this.customActionIds.getOrDefault(contentType, "action.generate.code");
                final ContentInserter completionInserter = GenerateCodeBasedOnUserInstructionsAction.this.completionActionsManager.getLastContentInserter();
                final int selectionStart = completionInserter != null ? completionInserter.getSelectionStart() : 0;
                final int selectionEnd = completionInserter != null ? completionInserter.getSelectionEnd() : 0;
                SwingWorker<String, Void> worker = new SwingWorker<String, Void>(){

                    @Override
                    protected String doInBackground() throws Exception {
                        return invokeActionHelper.invokeAction(actionId, null, userInstructions, new HashMap());
                    }

                    @Override
                    protected void done() {
                        try {
                            String generatedContent = (String)this.get();
                            if (completionInserter != null && generatedContent != null && !generatedContent.isBlank()) {
                                completionInserter.insert(selectionStart, selectionEnd, TextUtils.extractInsertionContentFromResponse((String)generatedContent, (String)contentType), null, true, true, false);
                            }
                        }
                        catch (Exception e) {
                            log.error("Error generating code based on user instructions", (Throwable)e);
                        }
                    }
                };
                worker.execute();
            }
        });
    }
}

