/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.positron.plugin.assist;

import com.oxygenxml.positron.core.plugin.Translator;
import com.oxygenxml.positron.plugin.assist.EmbeddedAssistPanel;
import com.oxygenxml.positron.plugin.chat.favorites.NewChatStarter;
import com.oxygenxml.positron.plugin.completion.CompletionActionsManager;
import com.oxygenxml.positron.plugin.util.PlatformUtils;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.KeyStroke;
import ro.sync.basic.util.Equaler;
import ro.sync.exml.workspace.api.PluginWorkspace;
import ro.sync.exml.workspace.api.PluginWorkspaceProvider;
import ro.sync.exml.workspace.api.editor.page.WSTextBasedEditorPage;
import ro.sync.exml.workspace.api.options.WSOptionChangedEvent;
import ro.sync.exml.workspace.api.options.WSOptionListener;
import ro.sync.exml.workspace.api.options.WSOptionsStorage;
import ro.sync.exml.workspace.api.standalone.StandalonePluginWorkspace;

public class EmbeddedAssistantInstaller {
    private EmbeddedAssistPanel currentPanel;
    private AbstractAction quickAssistAction;
    private NewChatStarter chatStarter;
    private WSTextBasedEditorPage embeddedEditorPage;
    private CompletionActionsManager currentCompletionActionsManager;
    private WSOptionListener embedWidgetOptionListener;

    public void initialize(StandalonePluginWorkspace ws) {
        String quickAssistActionName = Translator.getInstance().getTranslation("AI_Assistant") + " - " + Translator.getInstance().getTranslation("Quick_assist");
        this.quickAssistAction = new AbstractAction(quickAssistActionName){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (EmbeddedAssistantInstaller.this.currentPanel != null) {
                    EmbeddedAssistantInstaller.this.currentPanel.showChoices();
                }
            }
        };
        ws.getActionsProvider().registerAction("emedded_ai_assistant_quick_assist", (Object)this.quickAssistAction, KeyStroke.getKeyStroke(10, PlatformUtils.isMacOS() ? 128 : 640).toString());
        WSOptionsStorage optionsStorage = ws.getOptionsStorage();
        if (optionsStorage != null) {
            this.embedWidgetOptionListener = new WSOptionListener(){

                public void optionValueChanged(WSOptionChangedEvent event) {
                    Object val = event.getNewValueObject();
                    boolean shouldBeShowing = Boolean.parseBoolean((String)val);
                    if (!shouldBeShowing) {
                        if (EmbeddedAssistantInstaller.this.currentPanel != null) {
                            EmbeddedAssistantInstaller.this.currentPanel.unhook();
                            EmbeddedAssistantInstaller.this.currentPanel = null;
                        }
                    } else if (EmbeddedAssistantInstaller.this.embeddedEditorPage != null && EmbeddedAssistantInstaller.this.currentCompletionActionsManager != null) {
                        EmbeddedAssistantInstaller.this.addEmbeddedPanel(EmbeddedAssistantInstaller.this.embeddedEditorPage, EmbeddedAssistantInstaller.this.currentCompletionActionsManager);
                    }
                }
            };
            this.embedWidgetOptionListener.setKey("oxygen.positron.plugin.enable.embedded.widget");
            optionsStorage.addOptionListener(this.embedWidgetOptionListener);
        }
    }

    public void disableEmbeddedAssistant(StandalonePluginWorkspace pluginWS) {
        WSOptionsStorage optionsStorage;
        pluginWS.getActionsProvider().unregisterAction("emedded_ai_assistant_quick_assist");
        if (this.currentPanel != null) {
            this.currentPanel.unhook();
            this.currentPanel = null;
        }
        if ((optionsStorage = pluginWS.getOptionsStorage()) != null && this.embedWidgetOptionListener != null) {
            optionsStorage.removeOptionListener(this.embedWidgetOptionListener);
        }
    }

    public void addEmbeddedPanel(WSTextBasedEditorPage editorPage, CompletionActionsManager completionActionsManager) {
        PluginWorkspace pluginWorkspace;
        WSOptionsStorage optionsStorage;
        boolean enableWidget;
        this.embeddedEditorPage = editorPage;
        this.currentCompletionActionsManager = completionActionsManager;
        if (this.currentPanel != null) {
            this.currentPanel.unhook();
        }
        this.currentPanel = (enableWidget = Boolean.parseBoolean((optionsStorage = (pluginWorkspace = PluginWorkspaceProvider.getPluginWorkspace()).getOptionsStorage()).getOption("oxygen.positron.plugin.enable.embedded.widget", String.valueOf(Boolean.TRUE)))) ? new EmbeddedAssistPanel(editorPage, completionActionsManager, this.quickAssistAction, this.chatStarter) : null;
    }

    public void removeEmbeddedPanel(WSTextBasedEditorPage unhookedPage) {
        if (unhookedPage != null && unhookedPage.getParentEditor() != null && this.currentPanel != null && Equaler.verifyEquals((Object)unhookedPage.getParentEditor().getEditorLocation(), (Object)this.currentPanel.getEditorLocation())) {
            this.currentPanel.unhook();
            this.currentPanel = null;
            this.embeddedEditorPage = null;
            this.currentCompletionActionsManager = null;
        }
    }

    public void refreshActions() {
        if (this.currentPanel != null) {
            this.currentPanel.refreshActions();
        }
    }

    public void setNewChatCreator(NewChatStarter chatStarter) {
        this.chatStarter = chatStarter;
    }
}

