/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.positron.plugin.assist;

import com.oxygenxml.positron.core.actions.types.PositronAIActionBase;
import com.oxygenxml.positron.core.actions.types.PositronCopilotProcessContentBasedOnUserInstructionsAction;
import com.oxygenxml.positron.core.plugin.Translator;
import com.oxygenxml.positron.core.util.ActionMatcherUtil;
import com.oxygenxml.positron.plugin.assist.AuthorSelectionUtil;
import com.oxygenxml.positron.plugin.assist.RewriteSelectionBasedOnUserInstructionsAction;
import com.oxygenxml.positron.plugin.chat.favorites.NewChatStarter;
import com.oxygenxml.positron.plugin.completion.CompletionActionsManager;
import com.oxygenxml.positron.plugin.preferences.OpenPreferencesPageAction;
import com.oxygenxml.positron.plugin.util.IconsLoader;
import com.oxygenxml.positron.plugin.util.UIUtil;
import com.oxygenxml.positron.utilities.json.AIActionDetails;
import com.oxygenxml.positron.utilities.json.InputContext;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import javax.swing.AbstractAction;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import ro.sync.exml.workspace.api.PluginWorkspaceProvider;
import ro.sync.exml.workspace.api.editor.page.WSTextBasedEditorPage;
import ro.sync.exml.workspace.api.editor.page.author.WSAuthorEditorPage;
import ro.sync.exml.workspace.api.standalone.StandalonePluginWorkspace;
import ro.sync.exml.workspace.api.standalone.ui.SplitMenuButton;

public class EmbeddedAssistPanel
extends JPanel {
    private static final String REWRITE_CONTENT_BASED_ON_USER_INSTRUCTIONS_ID = "rewrite_content_based_on_user_instructions";
    private WSTextBasedEditorPage editorPage;
    private CompletionActionsManager completionActionsManager;
    private SplitMenuButton actionsButton;
    private JComponent currentPageSwingComponent;
    private AncestorListener ancestorListener;
    private ComponentListener componentModificationsListener;
    private AbstractAction quickAssistAction;
    private NewChatStarter chatStarter;
    private static final Translator TRANSLATOR = Translator.getInstance();
    private static final List<String> PREFERRED_ACTION_IDS_ORDER = Arrays.asList("action.expand.topic.draft", "action.improve.structure", "action.correct.grammar", "action.improve.readability", "action.use.active.voice", "action.add.comments.proof.read", "action.resolve.comments");
    private Point delta;

    public EmbeddedAssistPanel(final WSTextBasedEditorPage editorPage, CompletionActionsManager completionActionsManager, AbstractAction quickAssistAction, NewChatStarter chatStarter) {
        this.chatStarter = chatStarter;
        quickAssistAction.setEnabled(false);
        this.editorPage = editorPage;
        this.completionActionsManager = completionActionsManager;
        this.quickAssistAction = quickAssistAction;
        this.setLayout(new BorderLayout());
        if (editorPage instanceof WSAuthorEditorPage) {
            WSAuthorEditorPage authorPage = (WSAuthorEditorPage)editorPage;
            this.currentPageSwingComponent = (JComponent)authorPage.getAuthorComponent();
            this.createActionsButton(quickAssistAction);
            this.reconfigureComponentLocationAndActionsInternal(this.currentPageSwingComponent, editorPage, -1);
            this.ancestorListener = new AncestorListener(){

                @Override
                public void ancestorRemoved(AncestorEvent event) {
                    EmbeddedAssistPanel.this.reconfigureComponentLocationAndActionsInternal(EmbeddedAssistPanel.this.currentPageSwingComponent, editorPage, -1);
                }

                @Override
                public void ancestorMoved(AncestorEvent event) {
                    EmbeddedAssistPanel.this.reconfigureComponentLocationAndActionsInternal(EmbeddedAssistPanel.this.currentPageSwingComponent, editorPage, -1);
                }

                @Override
                public void ancestorAdded(AncestorEvent event) {
                    EmbeddedAssistPanel.this.reconfigureComponentLocationAndActionsInternal(EmbeddedAssistPanel.this.currentPageSwingComponent, editorPage, -1);
                }
            };
            this.currentPageSwingComponent.addAncestorListener(this.ancestorListener);
            this.componentModificationsListener = new ComponentListener(){

                @Override
                public void componentShown(ComponentEvent e) {
                    EmbeddedAssistPanel.this.reconfigureComponentLocationAndActionsInternal(EmbeddedAssistPanel.this.currentPageSwingComponent, editorPage, -1);
                }

                @Override
                public void componentResized(ComponentEvent e) {
                    EmbeddedAssistPanel.this.reconfigureComponentLocationAndActionsInternal(EmbeddedAssistPanel.this.currentPageSwingComponent, editorPage, -1);
                }

                @Override
                public void componentMoved(ComponentEvent e) {
                    EmbeddedAssistPanel.this.reconfigureComponentLocationAndActionsInternal(EmbeddedAssistPanel.this.currentPageSwingComponent, editorPage, -1);
                }

                @Override
                public void componentHidden(ComponentEvent e) {
                    EmbeddedAssistPanel.this.reconfigureComponentLocationAndActionsInternal(EmbeddedAssistPanel.this.currentPageSwingComponent, editorPage, -1);
                }
            };
            this.currentPageSwingComponent.getParent().addComponentListener(this.componentModificationsListener);
        }
    }

    private void createActionsButton(AbstractAction quickAssistAction) {
        this.actionsButton = new SplitMenuButton(null, IconsLoader.loadIcon("/images/DockableFramePositron16.png"), false, false, true, false){

            protected Point getPopupMenuOrigin() {
                Point origin = super.getPopupMenuOrigin();
                if (EmbeddedAssistPanel.this.delta != null) {
                    origin.x += EmbeddedAssistPanel.this.delta.x;
                    origin.y += EmbeddedAssistPanel.this.delta.y;
                    EmbeddedAssistPanel.this.delta = null;
                }
                return origin;
            }
        };
        Object accel = "";
        KeyStroke accelValue = (KeyStroke)quickAssistAction.getValue("AcceleratorKey");
        if (accelValue != null) {
            accel = " [" + UIUtil.getKeystrokeTooltipRepresentation(accelValue) + "]";
        }
        this.actionsButton.setToolTipText(Translator.getInstance().getTranslation("AI_Assistant") + (String)accel);
        this.add((Component)this.actionsButton, "Center");
    }

    private void reconfigureComponentLocationAndActionsInternal(JComponent internalComponent, WSTextBasedEditorPage editorPage, int caretOffset) {
        this.quickAssistAction.setEnabled(false);
        boolean wereActionsAdded = this.reconfigureActions(editorPage, this.completionActionsManager);
        if (internalComponent.isShowing() && wereActionsAdded) {
            this.quickAssistAction.setEnabled(true);
            Rectangle visibleRect = internalComponent.getVisibleRect();
            if (this.getParent() == null) {
                internalComponent.add(this);
            }
            int visibleXRightCorner = visibleRect.x + visibleRect.width - this.actionsButton.getPreferredSize().width;
            this.setBounds(visibleXRightCorner, visibleRect.y, this.getPreferredSize().width, this.getPreferredSize().height);
            internalComponent.repaint();
            this.delta = null;
            if (caretOffset != -1) {
                ro.sync.exml.view.graphics.Rectangle mtv = editorPage.modelToViewRectangle(editorPage.getCaretOffset());
                this.delta = new Point(mtv.x - visibleRect.x - visibleRect.width, mtv.y - visibleRect.y);
            }
        } else {
            this.hideButton();
        }
    }

    private boolean reconfigureActions(WSTextBasedEditorPage editorPage, CompletionActionsManager completionActionsManager) {
        Optional<PositronAIActionBase> copilotChatPseudoAction;
        ArrayList<AbstractAction> filteredActions = new ArrayList<AbstractAction>();
        boolean containsSpecializedActions = false;
        if (this.chatStarter != null) {
            filteredActions.add(new AbstractAction(TRANSLATOR.getTranslation("New_chat")){

                @Override
                public void actionPerformed(ActionEvent e) {
                    EmbeddedAssistPanel.this.chatStarter.start();
                }
            });
        }
        if ((copilotChatPseudoAction = completionActionsManager.getPseudoActions().stream().filter(action -> "pseudoaction.copilot.rewrite.content.based.on.instructions".equals(action.getActionDetails().getId())).findFirst()).isPresent()) {
            PositronCopilotProcessContentBasedOnUserInstructionsAction copilotChatAction = (PositronCopilotProcessContentBasedOnUserInstructionsAction)copilotChatPseudoAction.get();
            RewriteSelectionBasedOnUserInstructionsAction rewriteContentMenuAction = new RewriteSelectionBasedOnUserInstructionsAction(editorPage, copilotChatAction);
            filteredActions.add(rewriteContentMenuAction);
            StandalonePluginWorkspace pluginWS = (StandalonePluginWorkspace)PluginWorkspaceProvider.getPluginWorkspace();
            pluginWS.getActionsProvider().unregisterAction(REWRITE_CONTENT_BASED_ON_USER_INSTRUCTIONS_ID);
            pluginWS.getActionsProvider().registerAction(REWRITE_CONTENT_BASED_ON_USER_INSTRUCTIONS_ID, (Object)rewriteContentMenuAction, "M1 M3 R");
        }
        this.addSeparatorToMenuActionsList(filteredActions);
        List<PositronAIActionBase> complActions = completionActionsManager.getCompletionActions();
        if (complActions != null) {
            List<PositronAIActionBase> matchedActions = this.gatherActionsMatchedByDocumentType(editorPage, complActions);
            containsSpecializedActions = !matchedActions.isEmpty();
            matchedActions.sort((o1, o2) -> PREFERRED_ACTION_IDS_ORDER.indexOf(o1.getActionDetails().getId()) - PREFERRED_ACTION_IDS_ORDER.indexOf(o2.getActionDetails().getId()));
            List<PositronAIActionBase> actionsWithSeparators = this.addSeparatorsBetweenConsecutiveCategories(matchedActions);
            for (PositronAIActionBase positronAction : actionsWithSeparators) {
                if (positronAction != null) {
                    filteredActions.add(this.wrapAction(editorPage, positronAction));
                    continue;
                }
                this.addSeparatorToMenuActionsList(filteredActions);
            }
        }
        if (containsSpecializedActions) {
            this.addSeparatorToMenuActionsList(filteredActions);
        }
        filteredActions.add(new OpenPreferencesPageAction());
        this.actionsButton.setMenuActions(filteredActions);
        return containsSpecializedActions;
    }

    private void addSeparatorToMenuActionsList(List<AbstractAction> menuActions) {
        menuActions.add(null);
    }

    private AbstractAction wrapAction(final WSTextBasedEditorPage editorPage, final PositronAIActionBase positronAction) {
        AbstractAction actionWrapper = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AuthorSelectionUtil.prepareSelection(editorPage, positronAction);
                positronAction.actionPerformed(true);
            }
        };
        for (Object key : positronAction.getKeys()) {
            actionWrapper.putValue((String)key, positronAction.getValue((String)key));
        }
        if (positronAction.getActionDetails().getInputContext() == InputContext.AUTO_SELECTION_DOCUMENT && editorPage instanceof WSAuthorEditorPage) {
            Object description = (String)positronAction.getValue("ShortDescription");
            description = description != null ? (String)description + "\n\n" : "";
            description = (String)description + Translator.getInstance().getTranslation("No_selection_current_para");
            actionWrapper.putValue("ShortDescription", description);
        }
        return actionWrapper;
    }

    private List<PositronAIActionBase> addSeparatorsBetweenConsecutiveCategories(List<PositronAIActionBase> matchedActions) {
        ArrayList<PositronAIActionBase> actionsWithSeparators = new ArrayList<PositronAIActionBase>();
        String prevCategoryID = null;
        for (PositronAIActionBase positronAIActionBase : matchedActions) {
            boolean isNewCategory;
            String currentCategoryID = positronAIActionBase.getActionDetails().getCategoryId();
            boolean bl = isNewCategory = prevCategoryID != null && !prevCategoryID.equals(currentCategoryID);
            if (isNewCategory) {
                actionsWithSeparators.add(null);
            }
            actionsWithSeparators.add(positronAIActionBase);
            prevCategoryID = currentCategoryID;
        }
        return actionsWithSeparators;
    }

    private List<PositronAIActionBase> gatherActionsMatchedByDocumentType(WSTextBasedEditorPage editorPage, List<PositronAIActionBase> complActions) {
        String docType = null;
        if (editorPage.getParentEditor().getDocumentTypeInformation() != null) {
            docType = editorPage.getParentEditor().getDocumentTypeInformation().getName();
        }
        Optional<Object> currentDocumentType = Optional.ofNullable(docType);
        Optional<String> currentContentType = Optional.ofNullable(editorPage.getParentEditor().getContentType());
        ArrayList<PositronAIActionBase> matchedActions = new ArrayList<PositronAIActionBase>();
        for (PositronAIActionBase positronAction : complActions) {
            boolean isActionAcceptedByDocument;
            AIActionDetails actionDetails = positronAction.getActionDetails();
            boolean bl = isActionAcceptedByDocument = ActionMatcherUtil.shouldAddAction(currentDocumentType, (AIActionDetails)actionDetails) || ActionMatcherUtil.shouldAddAction(currentContentType, (AIActionDetails)actionDetails);
            if (!actionDetails.isEmbedAssist() || !isActionAcceptedByDocument) continue;
            matchedActions.add(positronAction);
        }
        return matchedActions;
    }

    public void unhook() {
        this.hideButton();
        if (this.currentPageSwingComponent != null) {
            this.removeListenersFromCurrentPageComponent();
        }
    }

    private void removeListenersFromCurrentPageComponent() {
        if (this.ancestorListener != null) {
            this.currentPageSwingComponent.removeAncestorListener(this.ancestorListener);
        }
        if (this.componentModificationsListener != null && this.currentPageSwingComponent.getParent() != null) {
            this.currentPageSwingComponent.getParent().removeComponentListener(this.componentModificationsListener);
        }
    }

    private void hideButton() {
        Container parent = this.getParent();
        if (parent != null) {
            parent.remove(this);
            parent.repaint();
        }
    }

    public URL getEditorLocation() {
        return this.editorPage.getParentEditor().getEditorLocation();
    }

    public void refreshActions() {
        this.reconfigureActions(this.editorPage, this.completionActionsManager);
    }

    public void showChoices() {
        if (this.isVisible() && this.editorPage != null) {
            this.reconfigureComponentLocationAndActionsInternal(this.currentPageSwingComponent, this.editorPage, this.editorPage.getCaretOffset());
            this.actionsButton.doClick();
        }
    }
}

