/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.positron.plugin;

import com.oxygenxml.positron.actions.ParamExpanderUIProvider;
import com.oxygenxml.positron.actions.ParamExpanderUi;
import com.oxygenxml.positron.actions.dialog.impl.SwingUiComponentsInteractor;
import com.oxygenxml.positron.connector.AIConnectorConfigsManager;
import com.oxygenxml.positron.connector.auth.OAuthCodeFlowHelper;
import com.oxygenxml.positron.core.AIActionsProvider;
import com.oxygenxml.positron.core.AICompletionDetailsProvider;
import com.oxygenxml.positron.core.AICompletionDetailsProviderFactory;
import com.oxygenxml.positron.core.actions.ReloadActionsListener;
import com.oxygenxml.positron.core.actions.loader.AdditionalActionsProvider;
import com.oxygenxml.positron.core.actions.types.AIAutocompletionProvider;
import com.oxygenxml.positron.core.actions.validation.AIContentEventListener;
import com.oxygenxml.positron.core.actions.validation.AutoValidationManager;
import com.oxygenxml.positron.core.aiignore.AiIgnoreManager;
import com.oxygenxml.positron.core.aiignore.AiIgnoreManagerProvider;
import com.oxygenxml.positron.core.aiignore.StandaloneAiIgnoreManager;
import com.oxygenxml.positron.core.auth.requests.AuthenticationInfoManager;
import com.oxygenxml.positron.core.auth.requests.ServerUrlProvider;
import com.oxygenxml.positron.core.chat.ChatInteractor;
import com.oxygenxml.positron.core.engines.EnginesManagerProvider;
import com.oxygenxml.positron.core.engines.IEnginesManager;
import com.oxygenxml.positron.core.interactions.IDocumentCreator;
import com.oxygenxml.positron.core.interactions.IUserInputProvider;
import com.oxygenxml.positron.core.tools.FunctionExecutor;
import com.oxygenxml.positron.core.tools.ToolsSessionManager;
import com.oxygenxml.positron.core.tools.internal.FilesValidator;
import com.oxygenxml.positron.core.tools.internal.SATreeAccess;
import com.oxygenxml.positron.core.tools.internal.TreeAccess;
import com.oxygenxml.positron.core.tools.internal.TreeAccessProvider;
import com.oxygenxml.positron.core.tools.internal.ValidateContentHelperImpl;
import com.oxygenxml.positron.core.util.AIApplicationInstaller;
import com.oxygenxml.positron.core.util.IModelsProvider;
import com.oxygenxml.positron.core.util.InvokeActionHelperImpl;
import com.oxygenxml.positron.core.util.PositronOptionsUtil;
import com.oxygenxml.positron.core.util.WSEditorUtils;
import com.oxygenxml.positron.core.util.XMLRefactoringHelperProviderInstaller;
import com.oxygenxml.positron.functions.AIFunctionBase;
import com.oxygenxml.positron.functions.SAToolsExecutionHandler;
import com.oxygenxml.positron.functions.SaxonAIFunctionExecutor;
import com.oxygenxml.positron.functions.ToolsDocumentsChangesManager;
import com.oxygenxml.positron.mcp.MCPManager;
import com.oxygenxml.positron.plugin.AIActionsInfoProvider;
import com.oxygenxml.positron.plugin.EditorChangeListenerBase;
import com.oxygenxml.positron.plugin.EnablePositronController;
import com.oxygenxml.positron.plugin.EnterpriseConnectorLoader;
import com.oxygenxml.positron.plugin.MCPInstaller;
import com.oxygenxml.positron.plugin.OperationProgressPresenterImpl;
import com.oxygenxml.positron.plugin.PositronAssistantPanel;
import com.oxygenxml.positron.plugin.SAMessagePresenter;
import com.oxygenxml.positron.plugin.assist.EmbeddedAssistantInstaller;
import com.oxygenxml.positron.plugin.assist.GenerateCodeBasedOnUserInstructionsAction;
import com.oxygenxml.positron.plugin.assist.ReviewCommentsResolverInstallerListener;
import com.oxygenxml.positron.plugin.chat.ChatPanel;
import com.oxygenxml.positron.plugin.chat.favorites.FavoritesManager;
import com.oxygenxml.positron.plugin.chat.favorites.NewChatStarter;
import com.oxygenxml.positron.plugin.chat.project.SAProjectHelper;
import com.oxygenxml.positron.plugin.completion.AICompletionProvidersManager;
import com.oxygenxml.positron.plugin.completion.CompletionActionsManager;
import com.oxygenxml.positron.plugin.completion.author.CompletionImplementationProviderForAuthorPage;
import com.oxygenxml.positron.plugin.completion.text.CompletionImplementationProviderForTextPage;
import com.oxygenxml.positron.plugin.credits.CreditsNotifierImpl;
import com.oxygenxml.positron.plugin.customizer.PositronMenuBarCustomizer;
import com.oxygenxml.positron.plugin.customizer.PositronPopupMenuCustomizer;
import com.oxygenxml.positron.plugin.customizer.PositronViewComponentCustomizer;
import com.oxygenxml.positron.plugin.customizer.ProjectMenuCustomizer;
import com.oxygenxml.positron.plugin.engine.EnterpriseEnginesManager;
import com.oxygenxml.positron.plugin.fix.AIFixProvider;
import com.oxygenxml.positron.plugin.fix.QuickFixInstaller;
import com.oxygenxml.positron.plugin.fix.QuickFixUtil;
import com.oxygenxml.positron.plugin.framework.CatalogUtils;
import com.oxygenxml.positron.plugin.ghosttext.AIGhostTextProvider;
import com.oxygenxml.positron.plugin.ghosttext.GhostTextProxyFactory;
import com.oxygenxml.positron.plugin.license.AskForLicenseDialog;
import com.oxygenxml.positron.plugin.license.DirectConnectionLicenseManager;
import com.oxygenxml.positron.plugin.oauth.DesktopOAuthAuthorizationCodeProvider;
import com.oxygenxml.positron.plugin.recordexamples.EditorRecorder;
import com.oxygenxml.positron.plugin.recordexamples.StartRecordingDialog;
import com.oxygenxml.positron.plugin.util.DirectConnectionConfigurationHelper;
import com.oxygenxml.positron.utilities.functions.FunctionsAndRAGHelper;
import com.oxygenxml.positron.utilities.functions.FunctionsAndRAGHelperProvider;
import com.oxygenxml.positron.utilities.functions.InvokeActionHelper;
import com.oxygenxml.positron.utilities.functions.InvokeActionHelperProvider;
import com.oxygenxml.positron.utilities.functions.ValidateContentHelper;
import com.oxygenxml.positron.utilities.functions.ValidateContentHelperProvider;
import com.oxygenxml.positron.utilities.json.AIActionDetails;
import java.io.IOException;
import java.net.URL;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.event.CaretListener;
import javax.swing.text.Document;
import ro.sync.basic.util.URLUtil;
import ro.sync.ecss.extensions.api.AuthorCaretListener;
import ro.sync.ecss.extensions.api.AuthorDocumentController;
import ro.sync.exml.plugin.workspace.WorkspaceAccessPluginExtension;
import ro.sync.exml.validate.ValidationProblemDPI;
import ro.sync.exml.workspace.api.PluginWorkspace;
import ro.sync.exml.workspace.api.PluginWorkspaceProvider;
import ro.sync.exml.workspace.api.editor.WSEditor;
import ro.sync.exml.workspace.api.editor.page.WSTextBasedEditorPage;
import ro.sync.exml.workspace.api.editor.page.author.WSAuthorEditorPage;
import ro.sync.exml.workspace.api.editor.page.text.WSTextEditorPage;
import ro.sync.exml.workspace.api.editor.validation.ValidationProblems;
import ro.sync.exml.workspace.api.editor.validation.ValidationProblemsFilter;
import ro.sync.exml.workspace.api.listeners.WSEditorChangeListener;
import ro.sync.exml.workspace.api.listeners.WSEditorListener;
import ro.sync.exml.workspace.api.options.WSOptionChangedEvent;
import ro.sync.exml.workspace.api.options.WSOptionListener;
import ro.sync.exml.workspace.api.options.WSOptionsStorage;
import ro.sync.exml.workspace.api.standalone.MenuBarCustomizer;
import ro.sync.exml.workspace.api.standalone.StandalonePluginWorkspace;
import ro.sync.exml.workspace.api.standalone.ViewComponentCustomizer;
import ro.sync.exml.workspace.api.standalone.actions.MenusAndToolbarsContributorCustomizer;
import ro.sync.exml.workspace.api.standalone.project.ProjectPopupMenuCustomizer;
import ro.sync.exml.workspace.api.standalone.proxy.ProxyDetailsProvider;
import ro.sync.exml.workspace.api.standalone.ui.Menu;

public class PositronPluginExtension
implements WorkspaceAccessPluginExtension {
    private PositronAssistantPanel positronAssistantPanel;
    protected AICompletionProvidersManager aiCompletionProviderManager;
    private CompletionActionsManager completionActionsManager;
    private SAToolsExecutionHandler toolsExecutor;
    private final EmbeddedAssistantInstaller embeddedAssistantInstaller = new EmbeddedAssistantInstaller();
    private Boolean positronEnabledCurrentState;
    private Menu aiMenu;
    private ReviewCommentsResolverInstallerListener reviewCommentsResolverListener = null;
    private final StandaloneAiIgnoreManager aiIgnoreChecker = new StandaloneAiIgnoreManager();
    private AutoValidationManager autoValidationManager;
    private AIGhostTextProvider aiGhostTextProvider;
    private MCPManager mcpManager;

    public void applicationStarted(final StandalonePluginWorkspace pluginWorkspaceAccess) {
        boolean firstStartAfterUpdate;
        WSOptionsStorage optionsStorage = pluginWorkspaceAccess.getOptionsStorage();
        this.mcpManager = MCPInstaller.installMCPManager(pluginWorkspaceAccess, () -> this.toolsExecutor);
        EnterpriseConnectorLoader.getInstance().loadConnectorConfigurationIfPresent();
        AIConnectorConfigsManager.getInstance().setOAuthCodeFlowHelper((OAuthCodeFlowHelper)new DesktopOAuthAuthorizationCodeProvider());
        PositronViewComponentCustomizer viewCustomizer = new PositronViewComponentCustomizer();
        pluginWorkspaceAccess.addViewComponentCustomizer((ViewComponentCustomizer)viewCustomizer);
        PositronMenuBarCustomizer mbCustomizer = new PositronMenuBarCustomizer(this.aiMenu);
        pluginWorkspaceAccess.addMenuBarCustomizer((MenuBarCustomizer)mbCustomizer);
        FunctionsAndRAGHelperProvider.setProjectRAGHelper((FunctionsAndRAGHelper)new SAProjectHelper());
        XMLRefactoringHelperProviderInstaller.installXMLRefactoringHelperProvider();
        AiIgnoreManagerProvider.setAiIgnoreChecker((AiIgnoreManager)this.aiIgnoreChecker);
        ParamExpanderUIProvider.setParamExpanderUI(new ParamExpanderUi());
        TreeAccessProvider.setTreeAccess((TreeAccess)new SATreeAccess());
        DirectConnectionLicenseManager.setAskForLicensDialogProvider(() -> new AskForLicenseDialog());
        final EditorChangeListener editorChangeListener = new EditorChangeListener(pluginWorkspaceAccess);
        pluginWorkspaceAccess.addEditorChangeListener((WSEditorChangeListener)editorChangeListener, 0);
        optionsStorage.addOptionListener(new WSOptionListener("oxygen.positron.plugin.retrieval.sandbox.rag"){

            public void optionValueChanged(WSOptionChangedEvent event) {
                PositronPluginExtension.this.positronAssistantPanel.selectionChanged(editorChangeListener.hasSelection());
            }
        });
        ProxyDetailsProvider proxyDetailsProvider = pluginWorkspaceAccess.getProxyDetailsProvider();
        AuthenticationInfoManager authenticationInfoManager = new AuthenticationInfoManager(proxyDetailsProvider);
        AIActionsInfoProvider.getInstance().setAuthInfoManager(authenticationInfoManager);
        CreditsNotifierImpl creditsNotifier = new CreditsNotifierImpl(optionsStorage, (ServerUrlProvider)authenticationInfoManager);
        this.toolsExecutor = this.createToolsExecutorHandler();
        EnterpriseEnginesManager enginesManager = new EnterpriseEnginesManager();
        EnginesManagerProvider.getInstance().setEnginesManager((IEnginesManager)enginesManager);
        ToolsSessionManager.getInstance().setToolsDocumentsChangesManager((com.oxygenxml.positron.core.tools.internal.ToolsDocumentsChangesManager)new ToolsDocumentsChangesManager());
        this.aiCompletionProviderManager = new AICompletionProvidersManager(authenticationInfoManager, proxyDetailsProvider, creditsNotifier, this.toolsExecutor);
        FavoritesManager favoritesManager = new FavoritesManager((PluginWorkspace)pluginWorkspaceAccess);
        OperationProgressPresenterImpl operationsStatusPresenter = new OperationProgressPresenterImpl();
        final ChatPanel chatInteractor = this.createChatPanel(pluginWorkspaceAccess, favoritesManager);
        optionsStorage.addOptionListener(new WSOptionListener("oxygen.positron.plugin.show.actions.as.buttons.chat"){

            public void optionValueChanged(WSOptionChangedEvent event) {
                SwingUtilities.invokeLater(chatInteractor::actionsReloaded);
            }
        });
        NewChatStarter chatStarter = () -> SwingUtilities.invokeLater(() -> {
            chatInteractor.clearChat();
            ((StandalonePluginWorkspace)PluginWorkspaceProvider.getPluginWorkspace()).showView("PositronPluginViewID", true);
        });
        favoritesManager.setNewChatCreator(chatStarter);
        this.embeddedAssistantInstaller.setNewChatCreator(chatStarter);
        this.autoValidationManager = new AutoValidationManager((ChatInteractor)chatInteractor);
        this.completionActionsManager = new CompletionActionsManager((PluginWorkspace)pluginWorkspaceAccess, new SAMessagePresenter(operationsStatusPresenter), chatInteractor, this.aiCompletionProviderManager, operationsStatusPresenter, new AdditionalActionsProvider(), new IUserInputProvider(){

            public String askUserForInput(String dialogTitle, String dialogDescription, String hintText, String okButtonText, String initialContent, boolean selectInitialContent) {
                return SwingUiComponentsInteractor.getPromptFromUser(dialogTitle, dialogDescription, hintText, okButtonText, initialContent, selectInitialContent);
            }
        }, new IDocumentCreator(){

            public URL createNewEditor(String extension, String contentType, String content) {
                return SwingUiComponentsInteractor.createNewEditor(extension, contentType, content);
            }
        }, (AIContentEventListener)this.autoValidationManager);
        this.completionActionsManager.addReloadActionListener(new ReloadActionsListener(){

            public void actionsReloaded() {
                PositronPluginExtension.this.embeddedAssistantInstaller.refreshActions();
            }
        });
        chatInteractor.setCompletionActionsProvider(() -> this.completionActionsManager.getCompletionActions());
        this.reviewCommentsResolverListener = new ReviewCommentsResolverInstallerListener(pluginWorkspaceAccess, this.completionActionsManager);
        pluginWorkspaceAccess.addEditorChangeListener((WSEditorChangeListener)this.reviewCommentsResolverListener, 0);
        EnablePositronController enablePositronController = new EnablePositronController(){

            @Override
            public void reconfigurePositronUIComponents() {
                PositronPluginExtension.this.reconfigurePositronUIComponents(pluginWorkspaceAccess);
            }
        };
        this.positronAssistantPanel = new PositronAssistantPanel(pluginWorkspaceAccess, authenticationInfoManager, proxyDetailsProvider, this.completionActionsManager, operationsStatusPresenter, chatInteractor, enablePositronController, this.aiCompletionProviderManager);
        AIFunctionBase.setOpenAiFunctionExecutor(new SaxonAIFunctionExecutor());
        AICompletionDetailsProviderFactory complDetailsProviderFactory = new AICompletionDetailsProviderFactory(){

            public AICompletionDetailsProvider retrieveCompletionDetailsProvider(AIActionDetails action, Map<String, Object> parameters) throws IOException {
                return PositronPluginExtension.this.aiCompletionProviderManager.getCompletionProviderForModel(action, (String)parameters.get("model"));
            }

            public List<AIActionDetails> getAIActionDetails(Map<String, Object> parameters) throws IOException {
                return PositronPluginExtension.this.completionActionsManager.getCompletionActionsDetails();
            }
        };
        AIApplicationInstaller.setAiAPIExecutor((StandalonePluginWorkspace)pluginWorkspaceAccess, (AICompletionDetailsProviderFactory)complDetailsProviderFactory, (AIActionsProvider)this.completionActionsManager, (ChatInteractor)chatInteractor, (IModelsProvider)enginesManager);
        InvokeActionHelperProvider.setInvokeActionHelper((InvokeActionHelper)new InvokeActionHelperImpl(complDetailsProviderFactory, (AIActionsProvider)this.completionActionsManager));
        EditorRecorder.setStartRecordingDialogProvider(() -> new StartRecordingDialog());
        if (FilesValidator.allowsValidationWithCustomContent()) {
            ValidateContentHelperProvider.setInvokeActionHelper((ValidateContentHelper)new ValidateContentHelperImpl());
        }
        mbCustomizer.setPositronAssistantPanel(this.positronAssistantPanel);
        viewCustomizer.setPositronViewComponentCustomizer(this.positronAssistantPanel);
        pluginWorkspaceAccess.addMenusAndToolbarsContributorCustomizer((MenusAndToolbarsContributorCustomizer)new PositronPopupMenuCustomizer(pluginWorkspaceAccess, authenticationInfoManager, this.completionActionsManager, this.aiCompletionProviderManager, this.positronAssistantPanel, chatInteractor));
        pluginWorkspaceAccess.getProjectManager().addPopUpMenuCustomizer((ProjectPopupMenuCustomizer)new ProjectMenuCustomizer(pluginWorkspaceAccess, authenticationInfoManager, this.completionActionsManager, this.aiCompletionProviderManager));
        this.reconfigurePositronUIComponents(pluginWorkspaceAccess);
        CatalogUtils.registerActionsJSONSchemaURIResolver((PluginWorkspace)pluginWorkspaceAccess);
        if (DirectConnectionConfigurationHelper.isLicenseForDirectConnectionValid()) {
            MCPInstaller.startMCPServer(() -> this.toolsExecutor);
        }
        boolean bl = firstStartAfterUpdate = optionsStorage.getOption("oxygen.positron.plugin.enable.positron.service", null) == null;
        if (firstStartAfterUpdate) {
            List configurations = AIConnectorConfigsManager.getInstance().getConfigurations();
            optionsStorage.setOption("oxygen.positron.plugin.enable.positron.service", Boolean.valueOf(configurations.isEmpty()).toString());
        }
    }

    private ChatPanel createChatPanel(final StandalonePluginWorkspace pluginWorkspaceAccess, FavoritesManager favoritesManager) {
        return new ChatPanel(pluginWorkspaceAccess, this.aiCompletionProviderManager, favoritesManager){

            @Override
            protected AIActionDetails addExtraFunctionRefs(AIActionDetails actionDetails) {
                return MCPInstaller.addExtraFunctionRefs(pluginWorkspaceAccess.getOptionsStorage(), PositronPluginExtension.this.mcpManager, actionDetails);
            }
        };
    }

    private SAToolsExecutionHandler createToolsExecutorHandler() {
        this.toolsExecutor = new SAToolsExecutionHandler(){

            @Override
            protected void loadExtraExecutors(Map<String, FunctionExecutor> executors) {
                List mcpTools = PositronPluginExtension.this.mcpManager.getTools();
                for (FunctionExecutor functionExecutor : mcpTools) {
                    executors.put(functionExecutor.getFunctionSignature().getName(), functionExecutor);
                }
            }
        };
        return this.toolsExecutor;
    }

    private void reconfigurePositronUIComponents(StandalonePluginWorkspace pluginWorkspaceAccess) {
        if (PositronOptionsUtil.isPositronEnabled()) {
            if (this.positronEnabledCurrentState == null || !this.positronEnabledCurrentState.booleanValue()) {
                this.enablePositron(pluginWorkspaceAccess);
            }
        } else if (this.positronEnabledCurrentState == null || this.positronEnabledCurrentState.booleanValue()) {
            this.disablePositron(pluginWorkspaceAccess);
        }
        this.positronEnabledCurrentState = PositronOptionsUtil.isPositronEnabled();
    }

    private void disablePositron(StandalonePluginWorkspace pluginWorkspaceAccess) {
        AIFixProvider.uninstall((PluginWorkspace)pluginWorkspaceAccess);
        if (this.aiGhostTextProvider != null) {
            this.aiGhostTextProvider.uninstall();
        }
        this.embeddedAssistantInstaller.disableEmbeddedAssistant(pluginWorkspaceAccess);
        this.positronAssistantPanel.getAssistantController().addDisabledPositronPluginToolMenu();
        if (this.reviewCommentsResolverListener != null) {
            this.reviewCommentsResolverListener.disableInstaller();
        }
    }

    private void enablePositron(StandalonePluginWorkspace pluginWorkspaceAccess) {
        AIFixProvider.install((PluginWorkspace)pluginWorkspaceAccess, this.completionActionsManager);
        this.installAIAutocompletion(pluginWorkspaceAccess);
        this.embeddedAssistantInstaller.initialize(pluginWorkspaceAccess);
        this.positronAssistantPanel.getAssistantController().forceLoadAllAiActions();
        if (this.reviewCommentsResolverListener != null) {
            this.reviewCommentsResolverListener.enableInstaller();
        }
    }

    private void installAIAutocompletion(StandalonePluginWorkspace pluginWorkspaceAccess) {
        if (GhostTextProxyFactory.isGhostTextProviderInterfaceAvailable()) {
            this.aiGhostTextProvider = new AIGhostTextProvider((PluginWorkspace)pluginWorkspaceAccess, this.completionActionsManager);
        }
    }

    public boolean applicationClosing() {
        SaxonAIFunctionExecutor.saveCache();
        if (this.autoValidationManager != null) {
            this.autoValidationManager.shutdown();
        }
        this.mcpManager.shutdownAllServers();
        return true;
    }

    private class EditorChangeListener
    extends EditorChangeListenerBase {
        private static final String GENERATE_CODE_BASED_ON_USER_INSTRUCTIONS_ACTION_ID = "generate_code_based_on_user_instructions";
        private final QuickFixInstaller quickFixInstaller;
        private CompletionImplementationProviderForAuthorPage authorCompletionImplProvider;
        private CompletionImplementationProviderForTextPage textPageCompletionImplProvider;
        private Map<String, WSEditorListener> addedEditorListeners;
        private AuthorCaretListener authorCaretListener;
        private CaretListener textCaretListener;

        private EditorChangeListener(StandalonePluginWorkspace pluginWorkspaceAccess) {
            super((PluginWorkspace)pluginWorkspaceAccess);
            this.quickFixInstaller = new QuickFixInstaller();
            this.addedEditorListeners = new HashMap<String, WSEditorListener>();
        }

        @Override
        protected void doHook(WSAuthorEditorPage authorEditorPage) {
            AuthorDocumentController controller = authorEditorPage.getAuthorAccess().getDocumentController();
            this.authorCompletionImplProvider = new CompletionImplementationProviderForAuthorPage(controller, authorEditorPage);
            PositronPluginExtension.this.positronAssistantPanel.setCompletionImplementationProvider(this.authorCompletionImplProvider);
            PositronPluginExtension.this.toolsExecutor.setDocumentContentExtractor(this.authorCompletionImplProvider.getPrefixExtractor());
            if (PositronOptionsUtil.isPositronEnabled()) {
                this.quickFixInstaller.addQuickAssistProcessor((WSTextBasedEditorPage)authorEditorPage, PositronPluginExtension.this.completionActionsManager);
                PositronPluginExtension.this.embeddedAssistantInstaller.addEmbeddedPanel((WSTextBasedEditorPage)authorEditorPage, PositronPluginExtension.this.completionActionsManager);
                this.authorCaretListener = caretEvent -> {
                    boolean isContentSelected = authorEditorPage.hasSelection();
                    PositronPluginExtension.this.positronAssistantPanel.selectionChanged(isContentSelected);
                };
                authorEditorPage.addAuthorCaretListener(this.authorCaretListener);
            }
        }

        @Override
        protected void doHook(WSTextEditorPage textEditorPage) {
            this.textPageCompletionImplProvider = new CompletionImplementationProviderForTextPage(textEditorPage);
            PositronPluginExtension.this.positronAssistantPanel.setCompletionImplementationProvider(this.textPageCompletionImplProvider);
            PositronPluginExtension.this.toolsExecutor.setDocumentContentExtractor(this.textPageCompletionImplProvider.getPrefixExtractor());
            if (PositronOptionsUtil.isPositronEnabled()) {
                this.quickFixInstaller.addQuickAssistProcessor((WSTextBasedEditorPage)textEditorPage, PositronPluginExtension.this.completionActionsManager);
                String contentType = textEditorPage.getParentEditor().getContentType();
                if (PositronPluginExtension.this.aiGhostTextProvider != null && AIAutocompletionProvider.getActionId((String)contentType) != null) {
                    Document document = textEditorPage.getDocument();
                    PositronPluginExtension.this.aiGhostTextProvider.installOnDocument(document);
                }
                JTextArea jta = (JTextArea)textEditorPage.getTextComponent();
                this.textCaretListener = caretEvent -> PositronPluginExtension.this.positronAssistantPanel.selectionChanged(jta.getSelectionStart() != jta.getSelectionEnd());
                jta.addCaretListener(this.textCaretListener);
            }
            this.registerGenerateCodeAction();
        }

        @Override
        protected void doUnhook(WSAuthorEditorPage authorEditorPage) {
            if (this.authorCompletionImplProvider != null) {
                this.authorCompletionImplProvider.getCompletionInserter().cleanUp();
                this.authorCompletionImplProvider.getPrefixExtractor().cleanUp();
                this.authorCompletionImplProvider = null;
            }
            if (this.authorCaretListener != null) {
                authorEditorPage.removeAuthorCaretListener(this.authorCaretListener);
            }
            PositronPluginExtension.this.positronAssistantPanel.setCompletionImplementationProvider(null);
            this.quickFixInstaller.removeQuickAssistProcessor((WSTextBasedEditorPage)authorEditorPage);
            PositronPluginExtension.this.embeddedAssistantInstaller.removeEmbeddedPanel((WSTextBasedEditorPage)authorEditorPage);
            PositronPluginExtension.this.toolsExecutor.setDocumentContentExtractor(null);
        }

        @Override
        protected void doUnhook(WSTextEditorPage hookedPage) {
            if (this.textPageCompletionImplProvider != null) {
                this.textPageCompletionImplProvider.getCompletionInserter().cleanUp();
                this.textPageCompletionImplProvider.getPrefixExtractor().cleanUp();
                this.textPageCompletionImplProvider = null;
            }
            if (this.textCaretListener != null) {
                JTextArea jta = (JTextArea)hookedPage.getTextComponent();
                jta.removeCaretListener(this.textCaretListener);
            }
            PositronPluginExtension.this.positronAssistantPanel.setCompletionImplementationProvider(null);
            this.quickFixInstaller.removeQuickAssistProcessor((WSTextBasedEditorPage)hookedPage);
            PositronPluginExtension.this.toolsExecutor.setDocumentContentExtractor(null);
            this.unregisterGenerateCodeAction();
        }

        @Override
        public void editorOpened(URL editorLocation) {
            super.editorOpened(editorLocation);
            final WSEditor editor = this.pluginWorkspaceAccess.getEditorAccess(editorLocation, 0);
            if (editor != null) {
                boolean mayBeActionRelatedFile;
                this.installReviewUpdaterForNewDocuments(editorLocation, editor);
                String editorContentType = this.pluginWorkspaceAccess.getUtilAccess().getContentType(editorLocation.toExternalForm());
                boolean mayBeReferencedPromptFile = "text/plain".equals(editorContentType) || "text/markdown".equals(editorContentType);
                boolean bl = mayBeActionRelatedFile = URLUtil.isFromLocalDrive((URL)editorLocation) && editorContentType != null && (editorContentType.toLowerCase().contains("json") || mayBeReferencedPromptFile);
                if (mayBeActionRelatedFile) {
                    WSEditorListener wsEditorListener = new WSEditorListener(){

                        public void editorSaved(int operationType) {
                            PositronPluginExtension.this.positronAssistantPanel.getAssistantController().localFileSaved(editor.getEditorLocation());
                        }
                    };
                    editor.addEditorListener(wsEditorListener);
                    this.addedEditorListeners.put(editor.getEditorLocation().toExternalForm(), wsEditorListener);
                }
                ValidationProblemsFilter validationProblemsFilter = new ValidationProblemsFilter(){

                    public void filterValidationProblems(ValidationProblems validationProblems) {
                        List problemsList = validationProblems.getProblemsList();
                        if (problemsList != null) {
                            problemsList.stream().filter(problem -> problem instanceof ValidationProblemDPI).forEach(problem -> QuickFixUtil.addQuickFixForAIProblem((ValidationProblemDPI)problem, PositronPluginExtension.this.completionActionsManager));
                        }
                    }
                };
                editor.addValidationProblemsFilter(validationProblemsFilter);
            }
        }

        private void installReviewUpdaterForNewDocuments(URL editorLocation, final WSEditor editor) {
            if (WSEditorUtils.isNewDocument((WSEditor)editor) && ToolsSessionManager.getInstance().isToolsDocumentsChangesSupportAvailable()) {
                final URL originalURL = editorLocation;
                WSEditorListener saveListener = new WSEditorListener(){

                    public void editorSaved(int operationType) {
                        ToolsSessionManager toolsSessionManager = ToolsSessionManager.getInstance();
                        if (toolsSessionManager.getToolsDocumentsChangesManager().hasChangesForURL(originalURL)) {
                            toolsSessionManager.getToolsDocumentsChangesManager().acceptChanges(originalURL);
                        }
                        editor.removeEditorListener((WSEditorListener)this);
                    }
                };
                editor.addEditorListener(saveListener);
            }
        }

        @Override
        public boolean editorAboutToBeClosed(URL editorLocation) {
            WSEditor editor = this.pluginWorkspaceAccess.getEditorAccess(editorLocation, 0);
            if (editor != null && this.addedEditorListeners.containsKey(editorLocation.toExternalForm())) {
                editor.removeEditorListener(this.addedEditorListeners.get(editorLocation.toExternalForm()));
            }
            return super.editorAboutToBeClosed(editorLocation);
        }

        private boolean hasSelection() {
            boolean hasSelection = false;
            if (this.authorCompletionImplProvider != null) {
                hasSelection = this.authorCompletionImplProvider.getPrefixExtractor().hasSelection();
            } else if (this.textPageCompletionImplProvider != null) {
                hasSelection = this.textPageCompletionImplProvider.getPrefixExtractor().hasSelection();
            }
            return hasSelection;
        }

        private void registerGenerateCodeAction() {
            ((StandalonePluginWorkspace)this.pluginWorkspaceAccess).getActionsProvider().registerAction(GENERATE_CODE_BASED_ON_USER_INSTRUCTIONS_ACTION_ID, (Object)new GenerateCodeBasedOnUserInstructionsAction(PositronPluginExtension.this.completionActionsManager), "M1 G");
        }

        private void unregisterGenerateCodeAction() {
            ((StandalonePluginWorkspace)this.pluginWorkspaceAccess).getActionsProvider().unregisterAction(GENERATE_CODE_BASED_ON_USER_INSTRUCTIONS_ACTION_ID);
        }
    }
}

