/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.positron.plugin;

import com.oxygenxml.positron.core.progress.OperationProgressPresenter;
import java.awt.Dimension;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import javax.swing.BorderFactory;
import javax.swing.SwingUtilities;
import javax.swing.text.JTextComponent;
import javax.swing.text.View;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.sync.basic.util.Equaler;
import ro.sync.exml.workspace.api.standalone.ui.OxygenUIComponentsFactory;

public class OperationProgressPresenterImpl
implements OperationProgressPresenter {
    private static final Logger logger = LoggerFactory.getLogger((String)OperationProgressPresenterImpl.class.getName());
    private JTextComponent textPresenter = (JTextComponent)OxygenUIComponentsFactory.createMultilineLabel((String)"", (boolean)false);

    public OperationProgressPresenterImpl() {
        this.textPresenter.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.textPresenter.setMinimumSize(new Dimension(this.textPresenter.getFont().getSize(), this.textPresenter.getMinimumSize().height));
        this.textPresenter.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                OperationProgressPresenterImpl.this.computeSizeToFitContent();
            }
        });
    }

    private void computeSizeToFitContent() {
        View view = this.textPresenter.getUI().getRootView(this.textPresenter);
        float preferredHeight = view.getPreferredSpan(1);
        int lineHeight = this.textPresenter.getFontMetrics(this.textPresenter.getFont()).getHeight();
        int textAreaNeededLines = (int)Math.ceil(preferredHeight / (float)lineHeight);
        int textAreaNeededHeightToDisplyCurrentText = textAreaNeededLines * lineHeight;
        this.textPresenter.setPreferredSize(new Dimension(this.textPresenter.getPreferredSize().width, textAreaNeededHeightToDisplyCurrentText));
        this.textPresenter.setMinimumSize(this.textPresenter.getPreferredSize());
        this.textPresenter.revalidate();
        this.textPresenter.repaint();
    }

    public void updateMessage(String message) {
        if (!Equaler.verifyEquals((Object)this.textPresenter.getText(), (Object)message)) {
            try {
                this.textPresenter.setText(message);
                this.textPresenter.setToolTipText(message);
                this.textPresenter.setCaretPosition(0);
                this.computeSizeToFitContent();
            }
            catch (Exception e) {
                logger.error((Object)e, (Throwable)e);
            }
        }
        SwingUtilities.invokeLater(() -> this.setVisible(!this.isEmpty()));
    }

    public void addCancelListener(ActionListener cancelListener) {
    }

    public void removeCancelListener(ActionListener cancelListener) {
    }

    public void showCancelButton(boolean visible) {
    }

    public void taskStarted() {
    }

    public void taskFinished() {
    }

    public void taskCanceled() {
    }

    public boolean isCanceled() {
        return false;
    }

    private boolean isEmpty() {
        return this.textPresenter.getText() == null || this.textPresenter.getText().trim().isEmpty();
    }

    public JTextComponent getTextPresenter() {
        return this.textPresenter;
    }

    public void setVisible(boolean visible) {
        this.textPresenter.setVisible(visible);
    }
}

