/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.positron.plugin;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.annotations.VisibleForTesting;
import com.oxygenxml.positron.api.connector.AIConnector;
import com.oxygenxml.positron.api.connector.param.ConnectorParamType;
import com.oxygenxml.positron.connector.AIConnectorConfigsManager;
import com.oxygenxml.positron.connector.AIConnectorConfiguration;
import com.oxygenxml.positron.connector.ConnectorConfigurationsPO;
import com.oxygenxml.positron.core.auth.requests.OxygenEncryptionSupport;
import com.oxygenxml.positron.core.util.PositronOptionsUtil;
import com.oxygenxml.positron.core.util.SecurityUtils;
import com.oxygenxml.positron.plugin.ConnectionConfigUtil;
import com.oxygenxml.positron.plugin.EnterpriseConnectorSecurityDTO;
import com.oxygenxml.positron.plugin.PositronPlugin;
import com.oxygenxml.positron.plugin.util.DirectConnectionConfigurationHelper;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.sync.basic.io.IOUtil;
import ro.sync.basic.util.Crypto;
import ro.sync.basic.util.URLUtil;
import ro.sync.exml.plugin.PluginDescriptor;
import ro.sync.exml.workspace.api.PluginWorkspaceProvider;
import ro.sync.exml.workspace.api.options.ExternalPersistentObject;
import ro.sync.exml.workspace.api.options.WSOptionsStorage;

public class EnterpriseConnectorLoader {
    private static final Logger log = LoggerFactory.getLogger(EnterpriseConnectorLoader.class);
    private static final Logger logger = LoggerFactory.getLogger((String)EnterpriseConnectorLoader.class.getName());
    public static final String OPTION_PREFIX = "oxygen.positron.plugin.";
    public static final String DIRECT_CONNECTOR_PARAM = "oxygen.positron.plugin.direct.connector.param";
    public static final String DIRECT_CONNECTOR_ID = "oxygen.positron.plugin.direct.connector";
    public static final String SECURE_CONNECTOR_CONFIG_HASH = "oxygen.positron.plugin.secure.connector.config.loaded.hash";
    public static final String PASSWORD_PARAM_ENCRYPTED_URL_SUFFIX = "_encrypted_url";
    public static final String PASSWORD_PARAM_SEED_URL_SUFFIX = "_seed_url";
    private static EnterpriseConnectorLoader instance = null;
    private static final String CONNECTOR_PROPERTIES_FILENAME = "ai-service-configuration.json";

    protected EnterpriseConnectorLoader() {
    }

    public static EnterpriseConnectorLoader getInstance() {
        if (instance == null) {
            instance = new EnterpriseConnectorLoader();
        }
        return instance;
    }

    public boolean isConnectorFilePresent() {
        File connectorPropertiesFile = this.getConfigurationFile();
        return connectorPropertiesFile != null && connectorPropertiesFile.exists();
    }

    protected Optional<String> fetchContentFromUrl(String url) {
        Optional<String> toRet = Optional.empty();
        URL urlToRead = URLUtil.convertToURL((String)url);
        if (urlToRead != null) {
            try {
                log.debug("Fetching content from URL: {}", (Object)url);
                String readContent = IOUtil.readURL((URL)urlToRead, null);
                toRet = Optional.of(readContent.trim());
            }
            catch (IOException e) {
                log.error("I/O error while fetching content from URL: " + url, (Throwable)e);
            }
        }
        return toRet;
    }

    @VisibleForTesting
    EnterpriseConnectorSecurityDTO readConnectorConfiguration(File connectorPropertiesFile) {
        EnterpriseConnectorSecurityDTO enterpriseConnectorSecurityDTO;
        if (connectorPropertiesFile == null) {
            log.error("The connectorPropertiesFile is null.");
            return null;
        }
        ObjectMapper mapper = new ObjectMapper();
        FileInputStream input = new FileInputStream(connectorPropertiesFile);
        try {
            enterpriseConnectorSecurityDTO = (EnterpriseConnectorSecurityDTO)mapper.readValue((InputStream)input, EnterpriseConnectorSecurityDTO.class);
        }
        catch (Throwable throwable) {
            try {
                try {
                    ((InputStream)input).close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                log.error("Error loading connector properties: " + e.getMessage(), (Throwable)e);
                return null;
            }
        }
        ((InputStream)input).close();
        return enterpriseConnectorSecurityDTO;
    }

    private boolean checkHashOfFile(String optionsHash) {
        return this.getCurrentConfigFileHash().stream().anyMatch(currentHash -> currentHash.equalsIgnoreCase(optionsHash));
    }

    public void loadConnectorConfigurationIfPresent() {
        if (!this.isConnectorFilePresent()) {
            PluginWorkspaceProvider.getPluginWorkspace().getOptionsStorage().setOption(SECURE_CONNECTOR_CONFIG_HASH, "");
            return;
        }
        String optionsAPIkey = PluginWorkspaceProvider.getPluginWorkspace().getOptionsStorage().getOption(SECURE_CONNECTOR_CONFIG_HASH, "");
        if (!"".equals(optionsAPIkey) && this.checkHashOfFile(optionsAPIkey)) {
            return;
        }
        PositronPlugin pluginInstance = PositronPlugin.getInstance();
        File connectorPropertiesFile = null;
        if (pluginInstance != null && pluginInstance.getDescriptor() != null && pluginInstance.getDescriptor().getBaseDir() != null) {
            connectorPropertiesFile = this.getConfigurationFile();
        }
        EnterpriseConnectorSecurityDTO connectorParams = this.readConnectorConfiguration(connectorPropertiesFile);
        this.saveConnectorOptions(connectorParams);
    }

    void saveConnectorOptions(EnterpriseConnectorSecurityDTO connectorParams) {
        if (connectorParams == null) {
            return;
        }
        String connectorId = connectorParams.getConnectorId();
        WSOptionsStorage optionsStorage = PluginWorkspaceProvider.getPluginWorkspace().getOptionsStorage();
        AIConnector connector = AIConnectorConfigsManager.getInstance().getConnectorTypes().stream().filter(c -> connectorId != null && connectorId.equals(c.getConnectorId())).findFirst().orElse(null);
        if (connector == null) {
            log.error("AI Connector is missing: {}", (Object)connectorId);
            return;
        }
        String configurationName = connectorParams.getConnectionName() != null ? connectorParams.getConnectionName() : connector.getConnectorName();
        AIConnectorConfiguration connectorConfig = new AIConnectorConfiguration(configurationName, connector);
        ConnectorConfigurationsPO connectorConfigurations = (ConnectorConfigurationsPO)optionsStorage.getPersistentObjectOption("oxygen.positron.plugin.connector.configurations", (ExternalPersistentObject)new ConnectorConfigurationsPO());
        ConnectionConfigUtil.deletePasswordOptionsForConfigurations(optionsStorage, connectorConfigurations);
        connectorConfigurations = new ConnectorConfigurationsPO();
        connectorConfigurations.addConfiguration(connectorConfig, connectorId);
        connectorConfigurations.setCurrentConfigurationId(connectorConfig.getConfigurationId());
        List<String> missingParams = this.processConnectorParameters(connectorConfig, connectorParams, connectorConfigurations, optionsStorage);
        if (!missingParams.isEmpty()) {
            log.warn("Missing values for the following parameters in connector configuration: {}", missingParams);
        }
        optionsStorage.setPersistentObjectOption("oxygen.positron.plugin.connector.configurations", (ExternalPersistentObject)connectorConfigurations);
        optionsStorage.setOption(SECURE_CONNECTOR_CONFIG_HASH, this.getCurrentConfigFileHash().orElse(""));
    }

    @VisibleForTesting
    Optional<String> getCurrentConfigFileHash() {
        File connectorPropertiesFile = this.getConfigurationFile();
        try {
            String fileContent = IOUtil.readFile((File)connectorPropertiesFile, (String)"UTF-8");
            String fileMD5hash = SecurityUtils.hash((byte[])fileContent.getBytes());
            return Optional.of(fileMD5hash);
        }
        catch (IOException e) {
            logger.error("Configuration file cannot be read.", (Throwable)e);
        }
        catch (NoSuchAlgorithmException e) {
            logger.error("MD5 hashing algorithm is not found.", (Throwable)e);
        }
        return Optional.empty();
    }

    private File getConfigurationFile() {
        PluginDescriptor descriptor;
        PositronPlugin positronPlugin = PositronPlugin.getInstance();
        if (positronPlugin != null && (descriptor = positronPlugin.getDescriptor()) != null) {
            File enterpriseAddonLocation = descriptor.getBaseDir();
            return new File(enterpriseAddonLocation, CONNECTOR_PROPERTIES_FILENAME);
        }
        return null;
    }

    private List<String> processConnectorParameters(AIConnectorConfiguration connectorConfig, EnterpriseConnectorSecurityDTO connectorParams, ConnectorConfigurationsPO connectorConfigurations, WSOptionsStorage optionsStorage) {
        ArrayList<String> missingParams = new ArrayList<String>();
        if (connectorParams.getConnectorParams() == null) {
            return missingParams;
        }
        connectorConfig.getConnector().getParametersList().forEach(param -> {
            String paramId = param.getId();
            Object paramValue = null;
            if (param.getType() == ConnectorParamType.PASSWORD_TEXT_FIELD) {
                paramValue = this.processPasswordParameter(paramId, connectorParams, missingParams);
                if (paramValue != null) {
                    String paramOptionId = DirectConnectionConfigurationHelper.computeOptionIdentifier(connectorConfig, param);
                    optionsStorage.setOption(paramOptionId, PositronOptionsUtil.toStringValue((Object)paramValue));
                }
            } else {
                paramValue = connectorParams.getParamById(paramId);
                if (paramValue != null) {
                    connectorConfigurations.setConfigurationParameter(connectorConfig.getConfigurationId(), paramId, PositronOptionsUtil.toStringValue((Object)paramValue));
                }
            }
            if (paramValue == null) {
                missingParams.add(paramId);
            }
        });
        return missingParams;
    }

    protected Object processPasswordParameter(String paramId, EnterpriseConnectorSecurityDTO connectorParams, List<String> missingParams) {
        String encryptedAPIKeyURL = (String)connectorParams.getParamById(paramId + PASSWORD_PARAM_ENCRYPTED_URL_SUFFIX);
        String decryptionKeyURL = (String)connectorParams.getParamById(paramId + PASSWORD_PARAM_SEED_URL_SUFFIX);
        if (encryptedAPIKeyURL == null || decryptionKeyURL == null) {
            missingParams.add(paramId + " (missing URL parameters: " + (encryptedAPIKeyURL == null ? "encrypted URL" : "") + (String)(decryptionKeyURL == null ? (encryptedAPIKeyURL == null ? ", " : "") + "decryption key URL" : "") + ")");
            return null;
        }
        Optional<String> decryptionKey = this.fetchContentFromUrl(decryptionKeyURL);
        Optional<String> encryptedAPIKey = this.fetchContentFromUrl(encryptedAPIKeyURL);
        if (!encryptedAPIKey.isPresent() || !decryptionKey.isPresent()) {
            missingParams.add(paramId + " (missing encrypted keys content)");
            return null;
        }
        String decryptedKey = Crypto.decrypt((String)decryptionKey.get(), (String)encryptedAPIKey.get(), (boolean)true);
        return new OxygenEncryptionSupport().encrypt(decryptedKey);
    }
}

