/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.positron.plugin;

import java.net.URL;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.sync.exml.workspace.api.PluginWorkspace;
import ro.sync.exml.workspace.api.editor.WSEditor;
import ro.sync.exml.workspace.api.editor.page.WSEditorPage;
import ro.sync.exml.workspace.api.editor.page.WSTextBasedEditorPage;
import ro.sync.exml.workspace.api.editor.page.author.WSAuthorEditorPage;
import ro.sync.exml.workspace.api.editor.page.text.WSTextEditorPage;
import ro.sync.exml.workspace.api.listeners.WSEditorChangeListener;

public abstract class EditorChangeListenerBase
extends WSEditorChangeListener {
    private static final Logger logger = LoggerFactory.getLogger(EditorChangeListenerBase.class);
    protected PluginWorkspace pluginWorkspaceAccess;
    private WSTextBasedEditorPage hookedPage;

    protected EditorChangeListenerBase(PluginWorkspace pluginWorkspaceAccess) {
        this.pluginWorkspaceAccess = pluginWorkspaceAccess;
    }

    private void hookUnhook() {
        WSEditor editorAccess = this.pluginWorkspaceAccess.getCurrentEditorAccess(0);
        if (editorAccess != null) {
            WSEditorPage currentPage = editorAccess.getCurrentPage();
            if (currentPage instanceof WSTextBasedEditorPage) {
                this.hook((WSTextBasedEditorPage)currentPage);
            } else {
                this.unhook();
            }
        } else {
            this.unhook();
        }
    }

    private void hook(WSTextBasedEditorPage currentPage) {
        if (this.hookedPage != currentPage) {
            this.unhook();
            this.hookedPage = currentPage;
            if (currentPage instanceof WSTextEditorPage) {
                logger.debug("Hooking.... to {}", (Object)currentPage);
                this.doHook((WSTextEditorPage)currentPage);
            } else if (currentPage instanceof WSAuthorEditorPage) {
                logger.debug("Hooking.... to {}", (Object)currentPage);
                this.doHook((WSAuthorEditorPage)currentPage);
            }
        } else if (currentPage != null) {
            logger.debug("Already hooked to {}", (Object)currentPage);
        }
    }

    protected String getContentType(WSTextBasedEditorPage currentPage) {
        return currentPage.getParentEditor().getContentType();
    }

    private void unhook() {
        if (this.hookedPage != null) {
            logger.debug("Unhooking from {}", (Object)this.hookedPage);
            if (this.hookedPage instanceof WSTextEditorPage) {
                this.doUnhook((WSTextEditorPage)this.hookedPage);
            } else if (this.hookedPage instanceof WSAuthorEditorPage) {
                this.doUnhook((WSAuthorEditorPage)this.hookedPage);
            }
            this.hookedPage = null;
        }
    }

    protected abstract void doHook(WSAuthorEditorPage var1);

    protected abstract void doHook(WSTextEditorPage var1);

    protected abstract void doUnhook(WSAuthorEditorPage var1);

    protected abstract void doUnhook(WSTextEditorPage var1);

    public boolean editorAboutToBeOpenedVeto(URL editorLocation) {
        return true;
    }

    public void editorOpened(URL editorLocation) {
        this.hookUnhook();
    }

    public boolean editorAboutToBeClosed(URL editorLocation) {
        return true;
    }

    public void editorClosed(URL editorLocation) {
        this.hookUnhook();
    }

    public void editorRelocated(URL previousEditorLocation, URL newEditorLocation) {
        this.hookUnhook();
    }

    public void editorPageChanged(URL editorLocation) {
        this.hookUnhook();
    }

    public void editorSelected(URL editorLocation) {
        this.hookUnhook();
    }

    public void editorActivated(URL editorLocation) {
        this.hookUnhook();
    }

    void setPluginWorkspaceAccess(PluginWorkspace pluginWorkspaceAccess) {
        this.pluginWorkspaceAccess = pluginWorkspaceAccess;
    }
}

