/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.positron.plugin;

import com.oxygenxml.positron.core.actions.ExcludedPositronActions;
import com.oxygenxml.positron.core.auth.exceptions.ServerRequestException;
import com.oxygenxml.positron.core.auth.requests.AuthenticationInfoManager;
import com.oxygenxml.positron.plugin.util.DirectConnectionConfigurationHelper;
import com.oxygenxml.positron.utilities.json.AIActionDetails;
import java.util.List;
import ro.sync.exml.workspace.api.PluginWorkspaceProvider;
import ro.sync.exml.workspace.api.options.WSOptionsStorage;

public class AIActionsInfoProvider {
    private static AIActionsInfoProvider instance;
    private AuthenticationInfoManager authInfoManager;
    private List<AIActionDetails> allCompletionActionsDetails;

    public static AIActionsInfoProvider getInstance() {
        if (instance == null) {
            instance = new AIActionsInfoProvider();
        }
        return instance;
    }

    public ExcludedPositronActions getExcludedActions() {
        WSOptionsStorage optionsStorage = PluginWorkspaceProvider.getPluginWorkspace().getOptionsStorage();
        String ignoredActionIds = optionsStorage.getOption("oxygen.positron.plugin.ignore.actions", "");
        return new ExcludedPositronActions(ignoredActionIds, true, null);
    }

    public boolean isUserConnectedToPositron() {
        return this.authInfoManager.isConnected() || DirectConnectionConfigurationHelper.isDirectConnection();
    }

    public boolean isConnectedToAiPositronService() {
        return this.authInfoManager.isConnected();
    }

    public void refreshAuthentication() throws ServerRequestException {
        this.authInfoManager.refreshAuthentication();
    }

    public void setAuthInfoManager(AuthenticationInfoManager authInfoManager) {
        this.authInfoManager = authInfoManager;
    }

    public List<AIActionDetails> getAllCompletionActionsDetails() {
        return this.allCompletionActionsDetails;
    }

    public void setAllCompletionActionsDetails(List<AIActionDetails> allCompletionActionsDetails) {
        this.allCompletionActionsDetails = allCompletionActionsDetails;
    }
}

