/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.positron.functions;

import com.oxygenxml.positron.api.connector.dto.Message;
import com.oxygenxml.positron.api.connector.dto.MessageContent;
import com.oxygenxml.positron.api.connector.dto.MessageTextContent;
import com.oxygenxml.positron.api.connector.dto.ModelDescriptor;
import com.oxygenxml.positron.api.connector.dto.RoleType;
import com.oxygenxml.positron.core.aiignore.AiIgnoreManager;
import com.oxygenxml.positron.core.aiignore.AiIgnoreManagerProvider;
import com.oxygenxml.positron.core.engines.EnginesManagerProvider;
import com.oxygenxml.positron.core.plugin.Translator;
import com.oxygenxml.positron.core.util.PositronOptionsUtil;
import com.oxygenxml.positron.functions.FunctionsPromptToResponsePO;
import com.oxygenxml.positron.utilities.functions.InvokeActionHelperProvider;
import java.awt.Component;
import java.awt.GridLayout;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.swing.JCheckBox;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.trans.XPathException;
import ro.sync.basic.util.NumberFormatException;
import ro.sync.basic.util.NumberParserUtil;
import ro.sync.basic.util.URLUtil;
import ro.sync.exml.workspace.api.PluginWorkspaceProvider;
import ro.sync.exml.workspace.api.options.ExternalPersistentObject;
import ro.sync.exml.workspace.api.options.WSOptionsStorage;
import ro.sync.security.Sandbox;

public class SaxonAIFunctionExecutor {
    public static final String AI_INSTRUCTION_PARAM = "aiInstruction";
    private static FunctionsPromptToResponsePO functionsCache = null;
    public static final String FUNCTIONS_DISABLED_WARNING_MESSAGE = "The AI XPath functions are disabled. You can enable them in: Options -> Preferences -> Plugins / Oxygen AI Positron.";
    private int functionsRequests;

    public String executeAIAction(XPathContext context, String actionId, Map<String, String> parameters, String content, String ... historyContext) throws XPathException {
        AiIgnoreManager aiIgnoreChecker;
        String baseURI;
        if (!PositronOptionsUtil.isPositronEnabled()) {
            throw new XPathException("AI Positron is not enabled.");
        }
        Item contextItem = context.getContextItem();
        if (contextItem instanceof NodeInfo && (baseURI = ((NodeInfo)contextItem).getBaseURI()) != null && (aiIgnoreChecker = AiIgnoreManagerProvider.getAiIgnoreChecker()) != null && aiIgnoreChecker.isIgnoredFromAiIgnoreFile(URLUtil.convertToURL((String)baseURI))) {
            throw new XPathException(Translator.getInstance().getTranslation("File_ignored_based_on_ai_ignore_settings"));
        }
        boolean isXPathSupportEnabled = Boolean.parseBoolean(SaxonAIFunctionExecutor.getOptionsStorage().getOption("oxygen.positron.plugin.enable.xpath.functions", String.valueOf(Boolean.TRUE)));
        if (isXPathSupportEnabled) {
            boolean cacheFunctionsResponse = Boolean.parseBoolean(SaxonAIFunctionExecutor.getOptionsStorage().getOption("oxygen.positron.plugin.cache.functions.response", String.valueOf(Boolean.TRUE)));
            String openaiCompletion = null;
            Object functionPromptHash = null;
            FunctionsPromptToResponsePO localFunctionsCache = SaxonAIFunctionExecutor.getFunctionsCache();
            if (cacheFunctionsResponse && localFunctionsCache != null) {
                StringBuilder functionPromptBuilder = new StringBuilder();
                ModelDescriptor currentEngine = EnginesManagerProvider.getInstance().getEnginesManager().getCurrentEngineDescriptor();
                functionPromptBuilder.append(actionId).append(currentEngine != null ? currentEngine.getId() : "").append(parameters.values().stream().collect(Collectors.joining())).append(content);
                functionPromptHash = localFunctionsCache.hash(functionPromptBuilder.toString());
                if (historyContext.length > 0) {
                    int historyHashCode = Arrays.deepHashCode(historyContext);
                    functionPromptHash = (String)functionPromptHash + historyHashCode;
                }
                openaiCompletion = localFunctionsCache.getCachedResponse((String)functionPromptHash);
            }
            if (openaiCompletion == null) {
                try {
                    this.checkRequestsNumberAndNotify();
                }
                catch (NumberFormatException functionPromptBuilder) {
                    // empty catch block
                }
                List<Message> messages = this.createHistoryContextMessages(historyContext);
                messages.add(new Message(RoleType.USER, (MessageContent)new MessageTextContent(content)));
                openaiCompletion = this.getSuggestionFromOpenAI(actionId, messages, parameters);
                if (cacheFunctionsResponse && localFunctionsCache != null) {
                    localFunctionsCache.save((String)functionPromptHash, openaiCompletion);
                }
            }
            return openaiCompletion;
        }
        throw new XPathException(FUNCTIONS_DISABLED_WARNING_MESSAGE);
    }

    private List<Message> createHistoryContextMessages(String ... historyContext) {
        ArrayList<Message> messages = new ArrayList<Message>();
        if (historyContext != null) {
            for (int i = 0; i < historyContext.length; ++i) {
                messages.add(new Message(i % 2 == 0 ? RoleType.USER : RoleType.ASSISTANT, (MessageContent)new MessageTextContent(historyContext[i])));
            }
        }
        return messages;
    }

    private JPanel createPanelForConfirmDialog(int requestsNumberToNotify) {
        Translator translator = Translator.getInstance();
        JPanel innerPanel = new JPanel(new GridLayout(2, 1));
        innerPanel.add(new JTextArea(MessageFormat.format(translator.getTranslation("XPath_functions_sent_requests"), requestsNumberToNotify)));
        JCheckBox dontAskAgainCB = new JCheckBox(translator.getTranslation("Never_ask_me_again"));
        dontAskAgainCB.addActionListener(e -> {
            JCheckBox cb = (JCheckBox)e.getSource();
            SaxonAIFunctionExecutor.getOptionsStorage().setOption("oxygen.positron.plugin.never.ask.again.functions.requests", String.valueOf(cb.isSelected()));
        });
        innerPanel.add(dontAskAgainCB);
        return innerPanel;
    }

    private String getSuggestionFromOpenAI(final String actionId, final List<Message> messages, final Map<String, String> parameters) throws XPathException {
        try {
            return (String)Sandbox.runWithAllPerms((PrivilegedExceptionAction)new PrivilegedExceptionAction<String>(){

                @Override
                public String run() throws Exception {
                    return InvokeActionHelperProvider.getInvokeActionHelper().invokeAction(actionId, messages, parameters);
                }
            });
        }
        catch (PrivilegedActionException ex) {
            throw new XPathException((Throwable)ex.getException());
        }
    }

    public static FunctionsPromptToResponsePO getFunctionsCache() {
        if (functionsCache == null) {
            functionsCache = (FunctionsPromptToResponsePO)SaxonAIFunctionExecutor.getOptionsStorage().getPersistentObjectOption("oxygen.positron.plugin.functions.cache.encrypted", (ExternalPersistentObject)new FunctionsPromptToResponsePO());
            FunctionsPromptToResponsePO oldUnencryptedCache = (FunctionsPromptToResponsePO)SaxonAIFunctionExecutor.getOptionsStorage().getPersistentObjectOption("oxygen.positron.plugin.functions.cache", null);
            if (oldUnencryptedCache != null) {
                SaxonAIFunctionExecutor.getOptionsStorage().setPersistentObjectOption("oxygen.positron.plugin.functions.cache", null);
            }
        }
        return functionsCache;
    }

    public static void resetFunctionsCache() {
        functionsCache = null;
    }

    public int getCurrentRequestsNumber() {
        return this.functionsRequests;
    }

    public static void saveCache() {
        boolean cacheFunctionsResponse = Boolean.parseBoolean(SaxonAIFunctionExecutor.getOptionsStorage().getOption("oxygen.positron.plugin.cache.functions.response", String.valueOf(Boolean.TRUE)));
        FunctionsPromptToResponsePO functionsCache = SaxonAIFunctionExecutor.getFunctionsCache();
        if (cacheFunctionsResponse && functionsCache != null) {
            SaxonAIFunctionExecutor.getOptionsStorage().setPersistentObjectOption("oxygen.positron.plugin.functions.cache.encrypted", (ExternalPersistentObject)functionsCache);
        }
    }

    private void checkRequestsNumberAndNotify() throws XPathException, NumberFormatException {
        boolean dontAskAgainAboutRequests = Boolean.parseBoolean(SaxonAIFunctionExecutor.getOptionsStorage().getOption("oxygen.positron.plugin.never.ask.again.functions.requests", String.valueOf(Boolean.FALSE)));
        boolean notifyAboutRequestsNumber = Boolean.parseBoolean(SaxonAIFunctionExecutor.getOptionsStorage().getOption("oxygen.positron.plugin.notify.about.requests.number", String.valueOf(Boolean.TRUE)));
        int requestsNumberToNotify = NumberParserUtil.parseInt((String)SaxonAIFunctionExecutor.getOptionsStorage().getOption("oxygen.positron.plugin.requests.number.to.notify", "100"));
        if (!dontAskAgainAboutRequests && notifyAboutRequestsNumber && this.functionsRequests++ >= requestsNumberToNotify) {
            boolean confirm = this.showConfirmDialog(requestsNumberToNotify);
            if (!confirm) {
                SaxonAIFunctionExecutor.getOptionsStorage().setOption("oxygen.positron.plugin.enable.xpath.functions", String.valueOf(false));
                throw new XPathException(FUNCTIONS_DISABLED_WARNING_MESSAGE);
            }
            this.functionsRequests = 0;
        }
    }

    protected boolean showConfirmDialog(int requestsNumberToNotify) {
        Object parentFrame = PluginWorkspaceProvider.getPluginWorkspace().getParentFrame();
        if (parentFrame != null) {
            return (Integer)Sandbox.runWithAllPerms(() -> JOptionPane.showConfirmDialog((Component)parentFrame, this.createPanelForConfirmDialog(requestsNumberToNotify), Translator.getInstance().getTranslation("XPath_functions_usage_information"), 0)) == 0;
        }
        return true;
    }

    private static WSOptionsStorage getOptionsStorage() {
        return PluginWorkspaceProvider.getPluginWorkspace().getOptionsStorage();
    }
}

