/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.positron.functions;

import com.oxygenxml.positron.plugin.util.SecurityHelper;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Map;
import javax.xml.bind.DatatypeConverter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.sync.basic.util.NumberFormatException;
import ro.sync.basic.util.NumberParserUtil;
import ro.sync.exml.workspace.api.PluginWorkspaceProvider;
import ro.sync.exml.workspace.api.options.ExternalPersistentObject;
import ro.sync.exml.workspace.api.options.WSOptionsStorage;
import ro.sync.options.InvalidPersistentObjException;
import ro.sync.options.SerializableLinkedHashMap;

public class FunctionsPromptToResponsePO
implements ExternalPersistentObject {
    private static final SecurityHelper SECURITY_HELPER = SecurityHelper.getInstance();
    private static final WSOptionsStorage OPTIONS_STORAGE = PluginWorkspaceProvider.getPluginWorkspace().getOptionsStorage();
    private static final Logger logger = LoggerFactory.getLogger((String)FunctionsPromptToResponsePO.class.getName());
    private SerializableLinkedHashMap<String, String> promptToResponseMap = new SerializableLinkedHashMap<String, String>(){

        protected boolean removeEldestEntry(Map.Entry<String, String> eldest) {
            return this.size() > cacheSize;
        }
    };
    private static int cacheSize;

    public void save(String promptHash, String response) {
        this.promptToResponseMap.put((Object)promptHash, (Object)SECURITY_HELPER.encryptText(response));
    }

    public String getCachedResponse(String promptHash) {
        return SECURITY_HELPER.decryptText((String)this.promptToResponseMap.get((Object)promptHash));
    }

    int getCacheSize() {
        return this.promptToResponseMap.size();
    }

    public void clearCache() {
        this.promptToResponseMap.clear();
    }

    public void checkValid() throws InvalidPersistentObjException {
    }

    public String[] getNotPersistentFieldNames() {
        return new String[0];
    }

    public static void setMaxCacheSize(int size) {
        cacheSize = size;
    }

    public Object clone() {
        try {
            FunctionsPromptToResponsePO superObject = (FunctionsPromptToResponsePO)super.clone();
            if (superObject != null) {
                if (this.promptToResponseMap != null) {
                    superObject.promptToResponseMap = (SerializableLinkedHashMap)this.promptToResponseMap.clone();
                }
                return superObject;
            }
        }
        catch (CloneNotSupportedException e) {
            logger.error((Object)e, (Throwable)e);
        }
        return this;
    }

    public String toString() {
        return "Persistent: " + this.promptToResponseMap;
    }

    String hash(String prompt) {
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            byte[] digest = md.digest(prompt.getBytes(StandardCharsets.UTF_8));
            return DatatypeConverter.printHexBinary((byte[])digest);
        }
        catch (NoSuchAlgorithmException e) {
            return prompt;
        }
    }

    static {
        try {
            cacheSize = NumberParserUtil.parseInt((String)OPTIONS_STORAGE.getOption("oxygen.positron.plugin.functions.cache.size", "500"));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }
}

