/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.positron.functions;

import com.oxygenxml.positron.actions.dialog.internal.CustomWrapDocument;
import com.oxygenxml.positron.core.plugin.Translator;
import com.oxygenxml.positron.core.tools.ToolsSessionManager;
import com.oxygenxml.positron.functions.DocumentChange;
import com.oxygenxml.positron.functions.ToolsDocumentsChangesManagerBase;
import com.oxygenxml.positron.plugin.ui.OKOtherAndCancelDialog;
import com.oxygenxml.positron.plugin.util.UIUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.stream.Collectors;
import javax.swing.DefaultListModel;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.ListCellRenderer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.sync.basic.util.URLUtil;
import ro.sync.exml.workspace.api.PluginWorkspaceProvider;
import ro.sync.exml.workspace.api.standalone.ui.OxygenUIComponentsFactory;

public class ConfirmToolsDocumentChangesDialog
extends OKOtherAndCancelDialog {
    private static final Logger log = LoggerFactory.getLogger(ConfirmToolsDocumentChangesDialog.class);
    public static final int FILES_SCROLLPANE_PREFERRED_WIDTH = 300;
    public static final int FILES_SCROLLPANE_PREFERRED_HEIGHT = 100;
    private final List<DocumentChange> remainingChanges;
    private final List<DocumentChange> acceptedChangesByUser = new ArrayList<DocumentChange>();

    public ConfirmToolsDocumentChangesDialog(List<DocumentChange> changes) {
        super((Frame)PluginWorkspaceProvider.getPluginWorkspace().getParentFrame(), Translator.getInstance().getTranslation("Review_Changes"), true);
        this.remainingChanges = changes.stream().sorted((c1, c2) -> c1.getDocURL().toExternalForm().compareTo(c2.getDocURL().toExternalForm())).collect(Collectors.toList());
        this.createUI();
    }

    protected void createUI() {
        JPanel panel = new JPanel(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.insets = new Insets(0, 5, 5, 10);
        gbc.anchor = 17;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.gridheight = 1;
        JTextArea textArea = UIUtil.createMessageArea("");
        textArea.setDocument(new CustomWrapDocument());
        textArea.setLineWrap(false);
        textArea.setText(Translator.getInstance().getTranslation("AI_Proposed_Changes_Label"));
        gbc.fill = 2;
        gbc.weightx = 1.0;
        panel.add((Component)textArea, gbc);
        ++gbc.gridy;
        JPanel linksPanel = new JPanel(new GridBagLayout());
        GridBagConstraints panelGBC = new GridBagConstraints();
        panelGBC.gridwidth = 1;
        panelGBC.gridheight = 1;
        panelGBC.weightx = 0.0;
        panelGBC.weighty = 0.0;
        panelGBC.gridy = 0;
        panelGBC.gridx = 0;
        panelGBC.fill = 0;
        panelGBC.anchor = 17;
        DefaultListModel<DocumentChange> model = new DefaultListModel<DocumentChange>();
        this.remainingChanges.forEach(model::addElement);
        final JList<DocumentChange> itemsList = new JList<DocumentChange>(model);
        itemsList.addMouseListener(this.createShowDiffOnDoubleClickListener(model, itemsList));
        final ListCellRenderer<DocumentChange> defaultCellRender = itemsList.getCellRenderer();
        itemsList.setCellRenderer(new ListCellRenderer<DocumentChange>(){

            @Override
            public Component getListCellRendererComponent(JList<? extends DocumentChange> list, DocumentChange value, int index, boolean isSelected, boolean cellHasFocus) {
                Component toReturn = defaultCellRender.getListCellRendererComponent(itemsList, value, index, isSelected, cellHasFocus);
                if (toReturn instanceof JLabel) {
                    OxygenUIComponentsFactory.installMultilineTooltip((JComponent)((JLabel)toReturn));
                    ((JLabel)toReturn).setToolTipText(value.getDocURL().toExternalForm());
                    ((JLabel)toReturn).setText(URLUtil.extractFileName((URL)value.getDocURL()));
                }
                return toReturn;
            }
        });
        JScrollPane scollPane = new JScrollPane(itemsList);
        scollPane.setPreferredSize(new Dimension(300, 100));
        gbc.anchor = 17;
        gbc.fill = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.gridheight = 1;
        panel.add((Component)scollPane, gbc);
        gbc.anchor = 17;
        gbc.fill = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.gridheight = 1;
        panelGBC.fill = 1;
        panelGBC.weightx = 1.0;
        panelGBC.weighty = 1.0;
        linksPanel.add((Component)new JPanel(), panelGBC);
        panel.add((Component)linksPanel, gbc);
        ++gbc.gridy;
        textArea = UIUtil.createMessageArea("");
        textArea.setDocument(new CustomWrapDocument());
        textArea.setLineWrap(false);
        textArea.setText(Translator.getInstance().getTranslation("AI_Proposed_Changes_Question"));
        gbc.anchor = 17;
        gbc.fill = 2;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.gridheight = 1;
        panel.add((Component)textArea, gbc);
        this.getCancelButton().setVisible(true);
        this.getOKButton().setVisible(true);
        this.getOtherButton().setVisible(true);
        this.setOKButtonText(Translator.getInstance().getTranslation("See_changes"));
        this.setOtherButtonText(Translator.getInstance().getTranslation("Accept_Changes"));
        this.setCancelButtonText(Translator.getInstance().getTranslation("Reject_Changes"));
        this.getOKButton().addActionListener(e -> {
            ToolsDocumentsChangesManagerBase changesManager = (ToolsDocumentsChangesManagerBase)ToolsSessionManager.getInstance().getToolsDocumentsChangesManager();
            List<URL> acceptedChanges = changesManager.showDocumentsChanges(new LinkedHashSet<DocumentChange>(this.remainingChanges));
            if (!acceptedChanges.isEmpty()) {
                this.acceptedChangesByUser.addAll(this.remainingChanges.stream().filter(change -> acceptedChanges.contains(change.getDocURL())).collect(Collectors.toList()));
                this.remainingChanges.removeIf(change -> acceptedChanges.contains(change.getDocURL()));
                for (int i = model.getSize() - 1; i >= 0; --i) {
                    DocumentChange change2 = (DocumentChange)model.getElementAt(i);
                    if (!acceptedChanges.contains(change2.getDocURL())) continue;
                    model.remove(i);
                }
                if (this.remainingChanges.isEmpty()) {
                    this.getOtherButton().doClick();
                }
            }
        });
        this.getContentPanel().add(panel);
        this.setMinimumSize(new Dimension(300, 150));
        this.pack();
    }

    private MouseAdapter createShowDiffOnDoubleClickListener(final DefaultListModel<DocumentChange> model, final JList<DocumentChange> itemsList) {
        return new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                int index;
                if (e.getClickCount() == 2 && (index = itemsList.locationToIndex(e.getPoint())) != -1) {
                    DocumentChange selectedChange = (DocumentChange)model.getElementAt(index);
                    ((ToolsDocumentsChangesManagerBase)ToolsSessionManager.getInstance().getToolsDocumentsChangesManager()).showDocumentsChanges(new HashSet<DocumentChange>(Arrays.asList(selectedChange)));
                }
            }
        };
    }

    @Override
    public void dispose() {
        if (this.getResult() != 1) {
            super.dispose();
        }
    }

    public List<DocumentChange> getAcceptedChangesByUser() {
        ArrayList<DocumentChange> acceptedChanges = new ArrayList<DocumentChange>(this.acceptedChangesByUser);
        if (this.getResult() == 2) {
            acceptedChanges.addAll(this.remainingChanges);
        }
        return acceptedChanges;
    }

    public List<DocumentChange> getRejectedChangesByUser() {
        return this.getResult() == 0 ? this.remainingChanges : Collections.emptyList();
    }
}

