/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.positron.functions;

import com.oxygenxml.positron.functions.AIFunctionBase;
import java.util.HashMap;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.lib.ExtensionFunctionCall;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.BooleanValue;
import net.sf.saxon.value.SequenceType;

public class AIVerifyContentFunction
extends AIFunctionBase {
    public static final String FUNCTION_NAME = "verify-content";

    public AIVerifyContentFunction() {
        super(FUNCTION_NAME);
    }

    public SequenceType[] getArgumentTypes() {
        return new SequenceType[]{SequenceType.SINGLE_STRING, SequenceType.SINGLE_STRING};
    }

    public int getMaximumNumberOfArguments() {
        return 20;
    }

    public int getMinimumNumberOfArguments() {
        return 2;
    }

    public SequenceType getResultType(SequenceType[] suppliedArgumentTypes) {
        return SequenceType.SINGLE_BOOLEAN;
    }

    public ExtensionFunctionCall makeCallExpression() {
        return new ExtensionFunctionCall(){

            public Sequence call(XPathContext context, Sequence[] arguments) throws XPathException {
                String aiInstruction = arguments[0].head().getStringValue();
                String contentToVerify = arguments[arguments.length - 1].head().getStringValue();
                String[] historyContext = new String[arguments.length - 2];
                for (int i = 1; i < arguments.length - 1; ++i) {
                    historyContext[i - 1] = arguments[i].head().getStringValue();
                }
                boolean isContentCorrect = AIVerifyContentFunction.this.checkContentWithAI(context, aiInstruction, contentToVerify, historyContext);
                return BooleanValue.get((boolean)isContentCorrect);
            }
        };
    }

    public boolean checkContentWithAI(XPathContext context, String aiInstruction, String content, String ... historyContext) throws XPathException {
        if (aiInstruction.isEmpty()) {
            return false;
        }
        boolean toReturn = false;
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("aiInstruction", aiInstruction);
        String suggestion = aiFunctionExecutor.executeAIAction(context, FUNCTION_NAME, parameters, content, historyContext);
        if (suggestion != null) {
            int dotIdx = suggestion.indexOf(46);
            if (dotIdx != -1) {
                suggestion = suggestion.substring(0, dotIdx);
            }
            toReturn = Boolean.valueOf(suggestion);
        }
        return toReturn;
    }
}

