/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.positron.functions;

import com.oxygenxml.positron.functions.AIFunctionBase;
import java.util.HashMap;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.lib.ExtensionFunctionCall;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.SequenceType;
import net.sf.saxon.value.StringValue;

public class AITransformContentFunction
extends AIFunctionBase {
    public static final String FUNCTION_NAME = "transform-content";

    public AITransformContentFunction() {
        super(FUNCTION_NAME);
    }

    public int getMinimumNumberOfArguments() {
        return 2;
    }

    public int getMaximumNumberOfArguments() {
        return 20;
    }

    public SequenceType[] getArgumentTypes() {
        return new SequenceType[]{SequenceType.SINGLE_STRING, SequenceType.SINGLE_STRING};
    }

    public SequenceType getResultType(SequenceType[] suppliedArgumentTypes) {
        return SequenceType.SINGLE_STRING;
    }

    public ExtensionFunctionCall makeCallExpression() {
        return new ExtensionFunctionCall(){

            public Sequence call(XPathContext context, Sequence[] arguments) throws XPathException {
                String aiInstruction = arguments[0].head().getStringValue();
                String contentToTransform = arguments[arguments.length - 1].head().getStringValue();
                String[] historyContext = new String[arguments.length - 2];
                for (int i = 1; i < arguments.length - 1; ++i) {
                    historyContext[i - 1] = arguments[i].head().getStringValue();
                }
                String correctContent = AITransformContentFunction.this.transformContentWithOpenAI(context, aiInstruction, contentToTransform, historyContext);
                return StringValue.makeStringValue((CharSequence)correctContent);
            }
        };
    }

    private String transformContentWithOpenAI(XPathContext context, String aiInstruction, String content, String ... historyContext) throws XPathException {
        if (aiInstruction.isEmpty()) {
            return content;
        }
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("aiInstruction", aiInstruction);
        String suggestion = aiFunctionExecutor.executeAIAction(context, FUNCTION_NAME, parameters, content, historyContext);
        return suggestion != null ? suggestion : content;
    }
}

