/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.positron.connection.ui;

import com.oxygenxml.positron.connector.ConnectorConfigurationsPO;
import com.oxygenxml.positron.core.plugin.Translator;
import com.oxygenxml.positron.plugin.PositronAssistantPanelController;
import com.oxygenxml.positron.plugin.PositronPlugin;
import com.oxygenxml.positron.plugin.ui.JComposedLinkLabel;
import com.oxygenxml.positron.plugin.util.IconsLoader;
import java.awt.event.ActionEvent;
import java.text.MessageFormat;
import java.util.Optional;
import javax.swing.AbstractAction;
import ro.sync.exml.plugin.Plugin;
import ro.sync.exml.plugin.PluginDescriptor;
import ro.sync.exml.workspace.api.PluginWorkspaceProvider;
import ro.sync.exml.workspace.api.options.ExternalPersistentObject;
import ro.sync.exml.workspace.api.options.WSOptionsStorage;

public class LinkLabelActionCreator {
    private static final Translator I18N = Translator.getInstance();

    private LinkLabelActionCreator() {
        throw new UnsupportedOperationException("Instantiation of this utility class is not allowed!");
    }

    public static JComposedLinkLabel newConnectToOtherAiServicesLinkLabel() {
        AbstractAction showAiServiceConfigurationOptionPageAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PluginWorkspaceProvider.getPluginWorkspace().showPreferencesPages(new String[]{"Positron_addon_preferences_engine_page"}, "Positron_addon_preferences_engine_page", true);
            }
        };
        JComposedLinkLabel connectToOtherAiServices = new JComposedLinkLabel(showAiServiceConfigurationOptionPageAction, I18N.getTranslation("Connect_to_other_AI_services"), I18N.getTranslation("Connect_to_other_AI_services_benefits"), IconsLoader.loadIcon("/images/Connect24.png"));
        connectToOtherAiServices.setToolTipText(I18N.getTranslation("Connect_to_other_AI_services_benefits"));
        return connectToOtherAiServices;
    }

    public static JComposedLinkLabel newConnectToAIPositronServiceLinkLabel(final PositronAssistantPanelController controller) {
        AbstractAction action = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!controller.isPositronServiceUserConnected()) {
                    controller.getConnectAction().actionPerformed(null);
                } else {
                    controller.refreshConnection();
                }
                WSOptionsStorage optionsStorage = PluginWorkspaceProvider.getPluginWorkspace().getOptionsStorage();
                ConnectorConfigurationsPO connectorConfigurations = (ConnectorConfigurationsPO)optionsStorage.getPersistentObjectOption("oxygen.positron.plugin.connector.configurations", (ExternalPersistentObject)new ConnectorConfigurationsPO());
                connectorConfigurations.setCurrentConfigurationId(null);
                optionsStorage.setPersistentObjectOption("oxygen.positron.plugin.connector.configurations", (ExternalPersistentObject)connectorConfigurations);
            }
        };
        JComposedLinkLabel connectToAiPositronService = new JComposedLinkLabel(action, I18N.getTranslation("Connect_to_AI_Positron_Service"), I18N.getTranslation("Connect_to_AI_Positron_service_benefits"), IconsLoader.loadIcon("/images/PositronConnect24.png"));
        String format = MessageFormat.format(Translator.getInstance().getTranslation("Before_using_connect_to_server"), "Oxygen AI Positron", Optional.ofNullable(PositronPlugin.getInstance()).map(Plugin::getDescriptor).map(PluginDescriptor::getName).orElse(null));
        connectToAiPositronService.setToolTipText(format);
        return connectToAiPositronService;
    }
}

