/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.positron.connection.ui;

import com.oxygenxml.positron.connection.ui.LinkLabelActionCreator;
import com.oxygenxml.positron.plugin.PositronAssistantPanelController;
import com.oxygenxml.positron.plugin.ui.JComposedLinkLabel;
import com.oxygenxml.positron.plugin.ui.PositronScrollable;
import com.oxygenxml.positron.plugin.ui.ThemeColorProvider;
import com.oxygenxml.positron.plugin.util.AiPositronServiceAccess;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.JPanel;
import ro.sync.exml.workspace.api.PluginWorkspaceProvider;
import ro.sync.exml.workspace.api.options.WSOptionChangedEvent;
import ro.sync.exml.workspace.api.options.WSOptionListener;

public class ChoosePositronDistributionPanel
extends JPanel
implements PositronScrollable {
    public ChoosePositronDistributionPanel(PositronAssistantPanelController controller, boolean showAiPositronServiceFirst) {
        super(new GridBagLayout());
        this.setBackground(ThemeColorProvider.getInstance().getBackgroundColor());
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.fill = 2;
        c.anchor = 18;
        c.insets = new Insets(10, 10, 10, 10);
        final JComposedLinkLabel connectToAIPositronService = AiPositronServiceAccess.getInstance().hasAccessToAiPositronService() ? LinkLabelActionCreator.newConnectToAIPositronServiceLinkLabel(controller) : null;
        JComposedLinkLabel configYourOwnLLM = LinkLabelActionCreator.newConnectToOtherAiServicesLinkLabel();
        if (showAiPositronServiceFirst) {
            if (connectToAIPositronService != null) {
                this.add((Component)connectToAIPositronService, c);
                ++c.gridy;
            }
            this.add((Component)configYourOwnLLM, c);
        } else {
            this.add((Component)configYourOwnLLM, c);
            if (connectToAIPositronService != null) {
                ++c.gridy;
                this.add((Component)connectToAIPositronService, c);
            }
        }
        if (connectToAIPositronService != null) {
            connectToAIPositronService.setVisible(AiPositronServiceAccess.getInstance().isAiPositronServiceConnectionEnabledFromAiServicePreferences());
        }
        if (AiPositronServiceAccess.getInstance().hasAccessToAiPositronService()) {
            PluginWorkspaceProvider.getPluginWorkspace().getOptionsStorage().addOptionListener(new WSOptionListener("oxygen.positron.plugin.enable.positron.service"){

                public void optionValueChanged(WSOptionChangedEvent event) {
                    Object val = event.getNewValueObject();
                    boolean positronServiceEnabled = Boolean.parseBoolean((String)val);
                    if (connectToAIPositronService != null) {
                        connectToAIPositronService.setVisible(positronServiceEnabled);
                    }
                }
            });
        }
    }

    @Override
    public Dimension getPreferredScrollableViewportSize() {
        return this.getPreferredSize();
    }
}

