/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.positron.actions.dialog.impl;

import com.oxygenxml.positron.actions.dialog.GenerateNewDocumentContentHandler;
import com.oxygenxml.positron.actions.dialog.SessionStorage;
import com.oxygenxml.positron.plugin.chat.attachments.TextAreaWithAttachmentsSupport;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.Optional;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import ro.sync.exml.workspace.api.PluginWorkspaceProvider;
import ro.sync.exml.workspace.api.WorkspaceUtilities;
import ro.sync.exml.workspace.api.standalone.ui.OKCancelDialog;

public class SwingPromptUserDialog
extends OKCancelDialog
implements GenerateNewDocumentContentHandler {
    private static final int PREFERRED_DIALOG_WIDTH = 500;
    private static final long serialVersionUID = 1L;
    private final String currentTitle;
    private final TextAreaWithAttachmentsSupport textArea = new TextAreaWithAttachmentsSupport("");
    private final JLabel hintLabel = new JLabel(){

        @Override
        public Dimension getPreferredSize() {
            Dimension preferredSize = super.getPreferredSize();
            if (preferredSize.width > 500) {
                preferredSize.width = 500;
            }
            return preferredSize;
        }
    };
    private static final String FALLBACK_TITLE = "Generate Document";
    private static final String FALLBACK_DESCRIPTION = "Generate a new document from the content provided below.";

    public SwingPromptUserDialog(String dialogTitle, String dialogDescription, String hintButtonText, String okButtonText) {
        super((JFrame)Optional.ofNullable(PluginWorkspaceProvider.getPluginWorkspace()).map(WorkspaceUtilities::getParentFrame).map(JFrame.class::cast).orElse(null), Optional.ofNullable(dialogTitle).orElse(FALLBACK_TITLE), true);
        this.currentTitle = Optional.ofNullable(dialogTitle).orElse(FALLBACK_TITLE);
        this.setResizable(true);
        this.hintLabel.setText(String.format("<html>%s<br/>" + hintButtonText + "</html>", Optional.ofNullable(dialogDescription).orElse(FALLBACK_DESCRIPTION)));
        this.textArea.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void removeUpdate(DocumentEvent e) {
                SwingPromptUserDialog.this.updateOkButtonState();
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                SwingPromptUserDialog.this.updateOkButtonState();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                SwingPromptUserDialog.this.updateOkButtonState();
            }
        });
        this.initLayout();
        this.setOkButtonText(okButtonText);
    }

    private void initLayout() {
        GridBagLayout gbLayout = new GridBagLayout();
        this.setLayout(gbLayout);
        GridBagConstraints cst = new GridBagConstraints();
        cst.gridx = 0;
        cst.gridy = 0;
        cst.anchor = 17;
        cst.fill = 2;
        cst.insets = new Insets(0, 0, 5, 0);
        this.getContentPane().add((Component)this.hintLabel, cst);
        ++cst.gridy;
        cst.weightx = 1.0;
        cst.weighty = 1.0;
        cst.fill = 1;
        this.textArea.setPreferredSize(new Dimension(500, 300));
        this.getContentPane().add((Component)this.textArea, cst);
        this.pack();
    }

    public void showDialog(String initialContent, boolean selectInitialContent) {
        String last = SessionStorage.getInstance().getValue("key.user.input.generate.file" + this.currentTitle.hashCode());
        if (last != null) {
            this.textArea.setText(last);
            this.textArea.selectAll();
        } else if (initialContent != null && !initialContent.trim().isEmpty()) {
            this.textArea.setText(initialContent);
            if (selectInitialContent) {
                this.textArea.selectAll();
            }
        }
        this.updateOkButtonState();
        this.setVisible(true);
    }

    @Override
    public String getUserInput() {
        if (this.getResult() == 1) {
            String textContent = this.textArea.getText();
            SessionStorage.getInstance().setValue("key.user.input.generate.file" + this.currentTitle.hashCode(), textContent);
            return textContent;
        }
        return null;
    }

    private void updateOkButtonState() {
        String content = this.textArea.getText();
        this.getOkButton().setEnabled(content != null && !content.trim().isEmpty());
    }
}

