/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.positron.actions;

import com.oxygenxml.positron.core.actions.types.PositronAIActionBase;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import ro.sync.exml.workspace.api.PluginWorkspaceProvider;

public final class RecentlyUsedActionsOptionsStorageUtil {
    private static final int MAX_RECENTLY_USED_ACTIONS = 5;
    public static final String RECENTLY_USED_ACTION_ID_AND_PARAMS_SEPARATOR = "%#%#%";
    static final String RECENTLY_USED_ACTION_PARAMS_SEPARATOR = "$$%%$$";
    private static final String RECENTLY_USED_ACTION_PARAM_VALS_SEPARATOR = "--$$$--";

    private RecentlyUsedActionsOptionsStorageUtil() {
        throw new UnsupportedOperationException("Instantiation of this utility class is not allowed!");
    }

    public static void addToRecentlyUsedTheIdOfImmediatelyExecutingAction(PositronAIActionBase action) {
        ArrayList<String> recentlyUsedActionDataToStore = new ArrayList<String>();
        String actionId = action.getActionDetails().getId();
        recentlyUsedActionDataToStore.add(actionId);
        String[] currentRecentlyUsedDataItems = RecentlyUsedActionsOptionsStorageUtil.getRecentlyUsedActionsData();
        if (currentRecentlyUsedDataItems != null) {
            for (int i = 0; i < currentRecentlyUsedDataItems.length && recentlyUsedActionDataToStore.size() < 5; ++i) {
                boolean wasAlreadyAdded = recentlyUsedActionDataToStore.contains(currentRecentlyUsedDataItems[i]);
                if (wasAlreadyAdded || RecentlyUsedActionsOptionsStorageUtil.isIgnoreOldRecentlyUsedWhenAddingIdOfImmediatelyExecutingAction(actionId, currentRecentlyUsedDataItems[i])) continue;
                recentlyUsedActionDataToStore.add(currentRecentlyUsedDataItems[i]);
            }
        }
        PluginWorkspaceProvider.getPluginWorkspace().getOptionsStorage().setStringArrayOption("oxygen.positron.plugin.recently.used.action.ids", recentlyUsedActionDataToStore.toArray(new String[0]));
    }

    static boolean isIgnoreOldRecentlyUsedWhenAddingIdOfImmediatelyExecutingAction(String recentlyAddedAction, String oldRecentlyUsedAction) {
        boolean isIgnoreEntry = false;
        boolean isCurrentRecentActionATranslateToAnyLangAction = oldRecentlyUsedAction.startsWith("action.translate.to.lang");
        if (isCurrentRecentActionATranslateToAnyLangAction) {
            if (oldRecentlyUsedAction.contains(RECENTLY_USED_ACTION_ID_AND_PARAMS_SEPARATOR)) {
                String[] split = oldRecentlyUsedAction.split(RECENTLY_USED_ACTION_ID_AND_PARAMS_SEPARATOR);
                String[] paramNameAndLangValue = split[1].split("=");
                if (paramNameAndLangValue.length == 2) {
                    String lang = paramNameAndLangValue[1];
                    isIgnoreEntry = recentlyAddedAction.equalsIgnoreCase("action.translate.to." + lang);
                } else {
                    isIgnoreEntry = true;
                }
            } else {
                isIgnoreEntry = true;
            }
        }
        return isIgnoreEntry;
    }

    public static void promoteRecentTranslateToUserProvidedLanguageAction(String providedLang) {
        ArrayList<Object> recentlyUsedActionDataToStore = new ArrayList<Object>();
        recentlyUsedActionDataToStore.add("action.translate.to.lang%#%#%translationLanguage=" + providedLang);
        String[] currentRecentlyUsedDataItems = RecentlyUsedActionsOptionsStorageUtil.getRecentlyUsedActionsData();
        if (currentRecentlyUsedDataItems != null) {
            for (int i = 0; i < currentRecentlyUsedDataItems.length && recentlyUsedActionDataToStore.size() < 5; ++i) {
                if (recentlyUsedActionDataToStore.contains(currentRecentlyUsedDataItems[i])) continue;
                recentlyUsedActionDataToStore.add(currentRecentlyUsedDataItems[i]);
            }
        }
        PluginWorkspaceProvider.getPluginWorkspace().getOptionsStorage().setStringArrayOption("oxygen.positron.plugin.recently.used.action.ids", recentlyUsedActionDataToStore.toArray(new String[0]));
    }

    public static void addToRecentlyUsedInfoAboutActionThatStartsWithConfiguration(String actionId, Map<String, Set<String>> params) {
        ArrayList<String> recentlyUsedActionDataToStore = new ArrayList<String>();
        String recentlyUsedInfo = RecentlyUsedActionsOptionsStorageUtil.createRecentlyUsedInfoForActionThatStartsWithConfiguration(actionId, params);
        recentlyUsedActionDataToStore.add(recentlyUsedInfo);
        String[] currentRecentlyUsedDataItems = RecentlyUsedActionsOptionsStorageUtil.getRecentlyUsedActionsData();
        if (currentRecentlyUsedDataItems != null) {
            for (int i = 0; i < currentRecentlyUsedDataItems.length && recentlyUsedActionDataToStore.size() < 5; ++i) {
                boolean isIgnoreEntry;
                if (recentlyUsedActionDataToStore.contains(currentRecentlyUsedDataItems[i]) || (isIgnoreEntry = RecentlyUsedActionsOptionsStorageUtil.isIgnoreOldRecentlyUsedWhenAddingInfoAboutActionThatStartsWithConfig(recentlyUsedInfo, currentRecentlyUsedDataItems[i]))) continue;
                recentlyUsedActionDataToStore.add(currentRecentlyUsedDataItems[i]);
            }
        }
        PluginWorkspaceProvider.getPluginWorkspace().getOptionsStorage().setStringArrayOption("oxygen.positron.plugin.recently.used.action.ids", recentlyUsedActionDataToStore.toArray(new String[0]));
    }

    static boolean isIgnoreOldRecentlyUsedWhenAddingInfoAboutActionThatStartsWithConfig(String recentlyUsedInfo, String currentRecentlyUsedDataItem) {
        boolean isIgnoreEntry = false;
        if (currentRecentlyUsedDataItem.startsWith("action.translate.to.")) {
            String langFromCurrentActionID = currentRecentlyUsedDataItem.substring("action.translate.to.".length());
            String langParamAndValue = "translationLanguage=" + langFromCurrentActionID;
            isIgnoreEntry = recentlyUsedInfo.toLowerCase().contains(langParamAndValue.toLowerCase());
        }
        return isIgnoreEntry;
    }

    private static String createRecentlyUsedInfoForActionThatStartsWithConfiguration(String actionId, Map<String, Set<String>> params) {
        StringBuilder infoBuilder = new StringBuilder(actionId).append(RECENTLY_USED_ACTION_ID_AND_PARAMS_SEPARATOR);
        Iterator<String> keysIter = params.keySet().iterator();
        while (keysIter.hasNext()) {
            String paramName = keysIter.next();
            Set<String> chosenVals = params.get(paramName);
            StringBuilder choice = new StringBuilder();
            Iterator<String> chosenValsIter = chosenVals.iterator();
            while (chosenValsIter.hasNext()) {
                choice.append(chosenValsIter.next());
                if (!chosenValsIter.hasNext()) continue;
                choice.append(RECENTLY_USED_ACTION_PARAM_VALS_SEPARATOR);
            }
            infoBuilder.append(paramName).append("=").append(choice.toString());
            if (!keysIter.hasNext()) continue;
            infoBuilder.append(RECENTLY_USED_ACTION_PARAMS_SEPARATOR);
        }
        return infoBuilder.toString();
    }

    public static void clearRecentlyUsedActionsData() {
        PluginWorkspaceProvider.getPluginWorkspace().getOptionsStorage().setStringArrayOption("oxygen.positron.plugin.recently.used.action.ids", new String[0]);
    }

    public static String[] getRecentlyUsedActionsData() {
        return PluginWorkspaceProvider.getPluginWorkspace().getOptionsStorage().getStringArrayOption("oxygen.positron.plugin.recently.used.action.ids", new String[0]);
    }
}

