/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.positron.actions;

import com.oxygenxml.positron.actions.ParamExpanderUIProvider;
import com.oxygenxml.positron.core.actions.ParamsExpander;
import com.oxygenxml.positron.core.actions.types.PositronAIActionBase;
import com.oxygenxml.positron.core.plugin.Translator;
import com.oxygenxml.positron.plugin.util.IconsLoader;
import com.oxygenxml.positron.plugin.util.UIUtil;
import com.oxygenxml.positron.utilities.json.AIActionDetails;
import com.oxygenxml.positron.utilities.json.ActionParam;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.util.ArrayList;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import ro.sync.exml.workspace.api.standalone.ui.OxygenUIComponentsFactory;

public class ConfigDialogFloatingWindowUpdater {
    private static final Timer FLOAT_TIMER = new Timer("Floating Configuration Window Float Timer");
    private TimerTask task;
    private JPanel configurationButtonPanel;

    public ConfigDialogFloatingWindowUpdater(AbstractButton button, Component rootPaneComp) {
        this.installActionListener(button);
        this.installMouseListener(button);
        this.installMouseMoveListener(button, rootPaneComp);
    }

    private void installMouseMoveListener(final AbstractButton button, final Component rootPaneComp) {
        button.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseMoved(MouseEvent e) {
                if (ConfigDialogFloatingWindowUpdater.this.configurationButtonPanel == null || !ConfigDialogFloatingWindowUpdater.this.configurationButtonPanel.isShowing()) {
                    ConfigDialogFloatingWindowUpdater.this.hideButton();
                    ConfigDialogFloatingWindowUpdater.this.task = new TimerTask(){

                        @Override
                        public void run() {
                            ConfigDialogFloatingWindowUpdater.this.showConfigButton(button, rootPaneComp);
                        }
                    };
                    FLOAT_TIMER.schedule(ConfigDialogFloatingWindowUpdater.this.task, 100L);
                }
            }
        });
    }

    private void installActionListener(AbstractButton button) {
        button.addActionListener(e -> this.hideButton());
    }

    private void installMouseListener(AbstractButton button) {
        button.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseExited(MouseEvent e) {
                if (ConfigDialogFloatingWindowUpdater.this.configurationButtonPanel != null && ConfigDialogFloatingWindowUpdater.this.configurationButtonPanel.isShowing() && new Rectangle(ConfigDialogFloatingWindowUpdater.this.configurationButtonPanel.getLocationOnScreen().x, ConfigDialogFloatingWindowUpdater.this.configurationButtonPanel.getLocationOnScreen().y, ConfigDialogFloatingWindowUpdater.this.configurationButtonPanel.getWidth(), ConfigDialogFloatingWindowUpdater.this.configurationButtonPanel.getHeight()).contains(e.getLocationOnScreen())) {
                    return;
                }
                ConfigDialogFloatingWindowUpdater.this.hideButton();
            }

            @Override
            public void mousePressed(MouseEvent e) {
                ConfigDialogFloatingWindowUpdater.this.hideButton();
            }
        });
    }

    private void hideButton() {
        if (this.task != null) {
            this.task.cancel();
            this.task = null;
        }
        if (this.configurationButtonPanel != null && this.configurationButtonPanel.getParent() != null) {
            this.configurationButtonPanel.setVisible(false);
            this.configurationButtonPanel.getParent().remove(this.configurationButtonPanel);
            this.configurationButtonPanel = null;
        }
    }

    private void showConfigButton(AbstractButton actionButton, Component rootPaneComp) {
        if (actionButton.isShowing()) {
            JRootPane rootPane;
            if (this.configurationButtonPanel == null) {
                this.createConfigPanel(actionButton);
            }
            if (this.configurationButtonPanel != null && (rootPane = UIUtil.getRootPane(rootPaneComp)) != null) {
                JLayeredPane layeredPane = rootPane.getLayeredPane();
                layeredPane.remove(this.configurationButtonPanel);
                Point buttonLocation = actionButton.getLocationOnScreen();
                Point rpLocation = rootPane.getLocationOnScreen();
                if (buttonLocation != null && rpLocation != null) {
                    this.configurationButtonPanel.setBounds(buttonLocation.x - rpLocation.x + actionButton.getSize().width, buttonLocation.y - rpLocation.y, this.configurationButtonPanel.getPreferredSize().width, this.configurationButtonPanel.getPreferredSize().height);
                    layeredPane.add(this.configurationButtonPanel, JLayeredPane.POPUP_LAYER, 0);
                    this.configurationButtonPanel.setVisible(true);
                }
            }
        }
    }

    private void createConfigPanel(AbstractButton actionButton) {
        final PositronAIActionBase action = (PositronAIActionBase)actionButton.getAction();
        AIActionDetails actionDetails = action.getActionDetails();
        List expandParams = actionDetails.getExpandParams();
        final ArrayList<ActionParam> configParams = new ArrayList<ActionParam>();
        if (expandParams != null) {
            for (ActionParam actionParam : expandParams) {
                if (!ParamsExpander.isChoiceParam((ActionParam)actionParam)) continue;
                configParams.add(actionParam);
            }
        }
        if (!configParams.isEmpty() && !"action.translate.to.lang".equals(actionDetails.getId())) {
            JButton configButton = OxygenUIComponentsFactory.createToolbarButton((Action)new AbstractAction(Translator.getInstance().getTranslation("Customize") + "...", IconsLoader.loadIcon("/images/Settings16.png")){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ConfigDialogFloatingWindowUpdater.this.hideButton();
                    ParamExpanderUIProvider.getParamExpanderUI().configureAction(action, configParams, false);
                    action.reconfigureTooltip();
                    ConfigDialogFloatingWindowUpdater.this.hideButton();
                }
            }, (boolean)false);
            this.configurationButtonPanel = new JPanel();
            this.configurationButtonPanel.setLayout(new BorderLayout());
            this.configurationButtonPanel.add((Component)configButton, "Center");
            this.configurationButtonPanel.setPreferredSize(configButton.getPreferredSize());
            this.configurationButtonPanel.setBorder(BorderFactory.createLineBorder(Color.LIGHT_GRAY));
            configButton.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseExited(MouseEvent e) {
                    ConfigDialogFloatingWindowUpdater.this.hideButton();
                }
            });
        }
    }
}

