/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.positron.actions;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.google.common.annotations.VisibleForTesting;
import com.oxygenxml.positron.actions.AIActionsUtil;
import com.oxygenxml.positron.actions.ConfigDialogFloatingWindowUpdater;
import com.oxygenxml.positron.actions.RecentlyUsedActionsOptionsStorageUtil;
import com.oxygenxml.positron.actions.dialog.internal.DialogType;
import com.oxygenxml.positron.actions.dialog.internal.MessageDialogBuilder;
import com.oxygenxml.positron.core.actions.ReloadActionsListener;
import com.oxygenxml.positron.core.actions.types.PositronAIActionBase;
import com.oxygenxml.positron.core.interactions.ContentInserter;
import com.oxygenxml.positron.core.interactions.DocumentContentInteractor;
import com.oxygenxml.positron.core.plugin.Translator;
import com.oxygenxml.positron.plugin.MenusActionsManager;
import com.oxygenxml.positron.plugin.chat.ChatImporterExporter;
import com.oxygenxml.positron.plugin.chat.ChatModel;
import com.oxygenxml.positron.plugin.chat.ChatUserInputInteractor;
import com.oxygenxml.positron.plugin.chat.actions.importexport.ImportExportChatUtil;
import com.oxygenxml.positron.plugin.chat.history.UnknownActionToImportException;
import com.oxygenxml.positron.plugin.completion.AICompletionProvidersManager;
import com.oxygenxml.positron.plugin.completion.CompletionActionsManager;
import com.oxygenxml.positron.plugin.recordexamples.EditorRecorder;
import com.oxygenxml.positron.plugin.recordexamples.InstructionsSaver;
import com.oxygenxml.positron.plugin.recordexamples.InstructionsWithExamples;
import com.oxygenxml.positron.plugin.util.IconsLoader;
import com.oxygenxml.positron.plugin.util.UIUtil;
import com.oxygenxml.positron.utilities.json.AIActionDetails;
import com.oxygenxml.positron.utilities.json.ActionParam;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.sync.basic.io.IOUtil;
import ro.sync.basic.util.URLUtil;
import ro.sync.basic.xml.encoding.EncodingDetectorInterface;
import ro.sync.ecss.extensions.api.CancelledByUserException;
import ro.sync.exml.workspace.api.PluginWorkspaceProvider;
import ro.sync.exml.workspace.api.options.WSOptionsStorage;
import ro.sync.exml.workspace.api.standalone.StandalonePluginWorkspace;
import ro.sync.exml.workspace.api.standalone.ui.Menu;
import ro.sync.exml.workspace.api.standalone.ui.OxygenUIComponentsFactory;
import ro.sync.exml.workspace.api.standalone.ui.SplitMenuButton;
import ro.sync.xml.encoding.EncodingDetector;

public class AIActionsPanel
extends JPanel
implements ReloadActionsListener {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)AIActionsPanel.class.getName());
    private static final Translator TRANSLATOR = Translator.getInstance();
    private CompletionActionsManager completionActionsManager;
    private AbstractAction recordChangesAction;
    private SplitMenuButton actionsButton;
    private AbstractAction exportChatAction;
    private AbstractAction importChatAction;
    private ChatImporterExporter chatImportExportHelper;
    private ChatUserInputInteractor userInteractor;
    private AICompletionProvidersManager aiCompletionProvidersManager;
    private AbstractAction quickFindAction;
    private Menu aiActionsMenu;

    public AIActionsPanel(CompletionActionsManager completionActionsManager, StandalonePluginWorkspace pluginWS, InstructionsSaver instructionsSaver, ChatImporterExporter chatImportExportHelper, AICompletionProvidersManager aiCompletionProviderManager, ChatUserInputInteractor userInteractor) {
        this.setLayout(new FlowLayout(0, 0, 0));
        this.completionActionsManager = completionActionsManager;
        this.completionActionsManager.addReloadActionListener(this);
        this.chatImportExportHelper = chatImportExportHelper;
        this.aiCompletionProvidersManager = aiCompletionProviderManager;
        this.userInteractor = userInteractor;
        this.recordChangesAction = this.createRecordChangesAction(pluginWS, instructionsSaver);
        this.exportChatAction = this.createExportConversationAction();
        this.exportChatAction.setEnabled(false);
        chatImportExportHelper.setChatPanelMessagesVisibilityListener(areMesagesShown -> this.exportChatAction.setEnabled(areMesagesShown));
        this.importChatAction = this.createImportConversationAction();
        UIUtil.runNowOrLaterOnAWT(this::initializeActionsButtonsInternal);
    }

    @VisibleForTesting
    void initializeActionsButtonsInternal() {
        this.removeAll();
        this.actionsButton = new SplitMenuButton(Translator.getInstance().getTranslation("Actions"), null, false, false, true, false);
        this.actionsButton.addMenuListener(new MenuListener(){

            @Override
            public void menuSelected(MenuEvent e) {
                JPopupMenu popupMenu = AIActionsPanel.this.actionsButton.getPopupMenu();
                popupMenu.removeAll();
                AIActionsPanel.this.populateActionsPopup(popupMenu);
            }

            @Override
            public void menuDeselected(MenuEvent e) {
            }

            @Override
            public void menuCanceled(MenuEvent e) {
            }
        });
        this.actionsButton.setHorizontalTextPosition(2);
        this.actionsButton.setVerticalTextPosition(0);
        this.add((Component)this.actionsButton);
    }

    @VisibleForTesting
    void populateActionsPopup(JPopupMenu actionsPopup) {
        WSOptionsStorage optionsStorage;
        boolean hideRecordExamples;
        if (this.quickFindAction == null) {
            this.quickFindAction = this.createQuickFindAction();
        }
        actionsPopup.add(this.quickFindAction);
        actionsPopup.addSeparator();
        List<PositronAIActionBase> completionActions = this.completionActionsManager.getCompletionActions();
        Map<String, List<PositronAIActionBase>> groupedActions = AIActionsUtil.groupActionByCategory(completionActions);
        if (!groupedActions.isEmpty()) {
            for (String category : groupedActions.keySet()) {
                Menu categoryMenu = OxygenUIComponentsFactory.createMenu((String)category);
                actionsPopup.add((JMenuItem)categoryMenu);
                List<PositronAIActionBase> actionsList = groupedActions.get(category);
                for (PositronAIActionBase action : actionsList) {
                    JMenuItem actionMenuItem = this.createActionMenuItem(action);
                    categoryMenu.add(actionMenuItem);
                }
            }
            actionsPopup.addSeparator();
        }
        if (!(hideRecordExamples = Boolean.parseBoolean((optionsStorage = PluginWorkspaceProvider.getPluginWorkspace().getOptionsStorage()).getOption("oxygen.positron.plugin.hide.record.examples.action", String.valueOf(Boolean.FALSE))))) {
            actionsPopup.add(this.recordChangesAction);
        }
        this.addRecentUsedActions(actionsPopup, completionActions);
        this.addSeparatorIfNeeded(actionsPopup);
        actionsPopup.add(this.exportChatAction);
        actionsPopup.add(this.importChatAction);
    }

    private AbstractAction createQuickFindAction() {
        return AIActionsUtil.createQuickFindAction(() -> this.actionsButton, () -> this.completionActionsManager.getCompletionActions(), false);
    }

    private AbstractAction createImportConversationAction() {
        return new AbstractAction(TRANSLATOR.getTranslation("Import_Conversation") + "..."){

            @Override
            public void actionPerformed(ActionEvent e) {
                String[] extensions = new String[]{"json"};
                File chooseFile = PluginWorkspaceProvider.getPluginWorkspace().chooseFile(TRANSLATOR.getTranslation("Import_Conversation"), extensions, TRANSLATOR.getTranslation("Import_Conversation_Filter_Description"));
                if (chooseFile == null) {
                    return;
                }
                try {
                    EncodingDetectorInterface encodingDetector = EncodingDetector.getInstance();
                    String contentType = PluginWorkspaceProvider.getPluginWorkspace().getUtilAccess().getContentType(URLUtil.correct((File)chooseFile).toString());
                    String javaEncoding = encodingDetector.getJavaEncodingFromContentType(contentType);
                    Charset charset = Charset.forName(javaEncoding);
                    String importConversationFileContent = Files.readString(Paths.get(chooseFile.toURI()), charset);
                    ChatModel newChatModelFromJSON = ImportExportChatUtil.newChatModelFromJSON(importConversationFileContent, AIActionsPanel.this.completionActionsManager);
                    AIActionsPanel.this.chatImportExportHelper.importChat(newChatModelFromJSON);
                }
                catch (JsonProcessingException e1) {
                    AIActionsPanel.this.showErrorDialogToUser((IOException)((Object)e1), TRANSLATOR.getTranslation("Import_Conversation"), TRANSLATOR.getTranslation("Import_Conversation_JSON_Error"));
                }
                catch (UnknownActionToImportException e1) {
                    String formattedMessage = MessageFormat.format(TRANSLATOR.getTranslation("Import_Conversation_Action_Not_Found_Error"), e1.getInvalidActionID());
                    AIActionsPanel.this.showErrorDialogToUser(e1, TRANSLATOR.getTranslation("Import_Conversation"), formattedMessage);
                }
                catch (IOException e1) {
                    AIActionsPanel.this.showErrorDialogToUser(e1, TRANSLATOR.getTranslation("Import_Conversation"), TRANSLATOR.getTranslation("Import_Conversation_Error"));
                }
            }
        };
    }

    private AbstractAction createExportConversationAction() {
        return new AbstractAction(TRANSLATOR.getTranslation("Export_Conversation") + "..."){

            @Override
            public void actionPerformed(ActionEvent e) {
                String[] extensions = new String[]{"json"};
                try {
                    File exportFile = PluginWorkspaceProvider.getPluginWorkspace().chooseFile(TRANSLATOR.getTranslation("Export_Conversation"), extensions, TRANSLATOR.getTranslation("Export_Conversation_Filter_Description"), true);
                    if (exportFile != null) {
                        String exportedChatModel = ImportExportChatUtil.serializeChatModelAsJSON(AIActionsPanel.this.chatImportExportHelper.getChatModel());
                        IOUtil.saveInURLWithUTF8((URL)exportFile.toURI().toURL(), (String)exportedChatModel);
                        PluginWorkspaceProvider.getPluginWorkspace().open(exportFile.toURI().toURL(), "Text");
                    }
                }
                catch (IOException e1) {
                    AIActionsPanel.this.showErrorDialogToUser(e1, TRANSLATOR.getTranslation("Export_Conversation"), TRANSLATOR.getTranslation("Export_Conversation_Error"));
                }
            }
        };
    }

    private JMenuItem createActionMenuItem(final PositronAIActionBase action) {
        JMenuItem actionMenuItem = OxygenUIComponentsFactory.createMenuItem((Action)action);
        actionMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                List expandParams;
                Optional<ActionParam> param;
                AIActionDetails actionDetails = action.getActionDetails();
                if (actionDetails != null && actionDetails.getId().equals("action.translate.to.lang") && (param = (expandParams = actionDetails.getExpandParams()).stream().filter(p -> p.getName().equals("translationLanguage") && p.getValue() != null && !p.getValue().isBlank()).findFirst()).isPresent()) {
                    RecentlyUsedActionsOptionsStorageUtil.promoteRecentTranslateToUserProvidedLanguageAction(param.get().getValue());
                }
            }
        });
        new ConfigDialogFloatingWindowUpdater(actionMenuItem, this);
        return actionMenuItem;
    }

    private void addRecentUsedActions(JPopupMenu actionsPopup, List<PositronAIActionBase> completionActions) {
        List<JMenuItem> recentlyUsedMenuItems;
        String[] recentlyUsedIDs = RecentlyUsedActionsOptionsStorageUtil.getRecentlyUsedActionsData();
        if (completionActions != null && recentlyUsedIDs != null && recentlyUsedIDs.length > 0 && !(recentlyUsedMenuItems = this.createRecentlyUsedMenuItems(completionActions, recentlyUsedIDs)).isEmpty()) {
            this.addSeparatorIfNeeded(actionsPopup);
            JMenuItem recentlyUsed = new JMenuItem(Translator.getInstance().getTranslation("Recently_used"));
            recentlyUsed.setEnabled(false);
            actionsPopup.add(recentlyUsed);
            for (JMenuItem actionMI : recentlyUsedMenuItems) {
                actionsPopup.add(actionMI);
            }
            actionsPopup.add(new AbstractAction(Translator.getInstance().getTranslation("Clear_history") + "...", IconsLoader.loadIcon("/images/RemoveAll16.png")){

                @Override
                public void actionPerformed(ActionEvent e) {
                    RecentlyUsedActionsOptionsStorageUtil.clearRecentlyUsedActionsData();
                }
            });
        }
    }

    @VisibleForTesting
    List<JMenuItem> createRecentlyUsedMenuItems(List<PositronAIActionBase> completionActions, String[] recentlyUsedInfo) {
        ArrayList<JMenuItem> actionMenuItems = new ArrayList<JMenuItem>();
        block0: for (int i = 0; i < recentlyUsedInfo.length; ++i) {
            if (recentlyUsedInfo[i].contains("%#%#%")) {
                String[] split = recentlyUsedInfo[i].split("%#%#%");
                String actionId = split[0];
                String actionParams = split[1];
                if (!"action.translate.to.lang".equals(actionId)) continue;
                this.createRecentlyUsedMenuItemForTranslationToSelectedLang(completionActions, actionMenuItems, actionId, actionParams);
                continue;
            }
            String recentlyUsedActionID = recentlyUsedInfo[i];
            if (recentlyUsedActionID == null) continue;
            for (PositronAIActionBase action : completionActions) {
                boolean foundActionCorrespondingToRecentlyUsedID = action.getActionDetails() != null && recentlyUsedActionID.equals(action.getActionDetails().getId());
                if (!foundActionCorrespondingToRecentlyUsedID) continue;
                JMenuItem menuItem = this.createActionMenuItem(action);
                actionMenuItems.add(menuItem);
                continue block0;
            }
        }
        return actionMenuItems;
    }

    private void createRecentlyUsedMenuItemForTranslationToSelectedLang(List<PositronAIActionBase> completionActions, List<JMenuItem> actionMenuItems, String actionId, String actionParams) {
        String[] paranNameAndLang = actionParams.split("=");
        if (paranNameAndLang.length < 2) {
            return;
        }
        String langParamValue = paranNameAndLang[1];
        for (PositronAIActionBase action : completionActions) {
            AIActionDetails actionDetails = action.getActionDetails();
            if (actionDetails == null || !actionId.equals(actionDetails.getId())) continue;
            try {
                PositronAIActionBase clone = action.clone();
                clone.setActionCustomizer(null);
                AIActionDetails cloneActionDetails = clone.getActionDetails();
                cloneActionDetails.getExpandParams().forEach(p -> {
                    if ("translationLanguage".equals(p.getName())) {
                        p.setValue(langParamValue);
                    }
                });
                clone.reconfigureTooltip();
                JMenuItem menuItem = this.createActionMenuItem(clone);
                menuItem.setText(langParamValue);
                actionMenuItems.add(menuItem);
            }
            catch (CloneNotSupportedException e) {
                LOGGER.warn("Could not clone action: " + actionDetails.getId() + " " + actionDetails.getExpandParams(), (Throwable)e);
            }
            break;
        }
    }

    public void setCompletionImplementation(ContentInserter completionInserter, DocumentContentInteractor prefixExtractor) {
        this.completionActionsManager.setCompletionImplementation(completionInserter, prefixExtractor);
    }

    @Override
    public void setEnabled(boolean enabled) {
        Component[] components;
        super.setEnabled(enabled);
        for (Component component : components = this.getComponents()) {
            if (component instanceof JPanel) {
                Component[] componentsOfChild;
                for (Component childComponent : componentsOfChild = ((JPanel)component).getComponents()) {
                    childComponent.setEnabled(enabled);
                }
            }
            component.setEnabled(enabled);
        }
    }

    public Map<String, List<PositronAIActionBase>> getCompletionActions() {
        return AIActionsUtil.groupActionByCategory(this.completionActionsManager.getCompletionActions());
    }

    public void actionsReloaded() {
        UIUtil.runNowOrLaterOnAWT(this::initializeActionsButtonsInternal);
        UIUtil.runNowOrLaterOnAWT(() -> MenusActionsManager.populateAiMenu(this.aiActionsMenu, this.getCompletionActions(), this.aiCompletionProvidersManager, this.completionActionsManager, this.userInteractor));
    }

    public void setAiActionsMenuBar(Menu aiActionsMenu) {
        this.aiActionsMenu = aiActionsMenu;
    }

    private AbstractAction createRecordChangesAction(final StandalonePluginWorkspace pluginWorkspaceAccess, final InstructionsSaver instructionsSaver) {
        AbstractAction action = new AbstractAction(TRANSLATOR.getTranslation("Record_changes_action_name"), IconsLoader.loadIcon("/images/StartRecording16.png")){

            @Override
            public void actionPerformed(ActionEvent actionevent) {
                EditorRecorder editorRecorder = EditorRecorder.getInstance();
                if (editorRecorder.isRunning()) {
                    InstructionsWithExamples prompt = editorRecorder.stopRecording();
                    try {
                        instructionsSaver.saveAsChosenByUser(prompt);
                    }
                    catch (CancelledByUserException e) {
                        LOGGER.debug("The user decided not to save the prompt.");
                    }
                    catch (IOException e) {
                        pluginWorkspaceAccess.showErrorMessage("An error has occured when trying to save the prompt: " + e.getMessage(), (Throwable)e);
                    }
                } else {
                    editorRecorder.startRecording();
                }
                this.putValue("Name", AIActionsPanel.this.getPromptBuilderActionName());
                this.putValue("ShortDescription", AIActionsPanel.this.getPromptBuilderActionTooltipText());
                this.putValue("SwingLargeIconKey", AIActionsPanel.this.getPromptBuilderActionIcon());
            }
        };
        action.putValue("ShortDescription", this.getPromptBuilderActionTooltipText());
        return action;
    }

    private String getPromptBuilderActionName() {
        return TRANSLATOR.getTranslation(EditorRecorder.getInstance().isRunning() ? "Stop_recording_action_name" : "Record_changes_action_name");
    }

    private String getPromptBuilderActionTooltipText() {
        return TRANSLATOR.getTranslation(EditorRecorder.getInstance().isRunning() ? "Stop_recording_tooltip_message" : "Record_changes_tooltip_message");
    }

    private Object getPromptBuilderActionIcon() {
        return IconsLoader.loadIcon(EditorRecorder.getInstance().isRunning() ? "/images/StopRecording16.png" : "/images/StartRecording16.png");
    }

    @VisibleForTesting
    SplitMenuButton getActionsButton() {
        return this.actionsButton;
    }

    private void addSeparatorIfNeeded(JPopupMenu popupMenu) {
        boolean needSeparator;
        int compCount = popupMenu.getComponentCount();
        boolean bl = needSeparator = compCount == 0 || !(popupMenu.getComponent(compCount - 1) instanceof JSeparator);
        if (needSeparator) {
            popupMenu.addSeparator();
        }
    }

    protected void showErrorDialogToUser(IOException originalException, String dialogTitle, String customErrorMessage) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Throwable)originalException);
        }
        MessageDialogBuilder errorDialog = new MessageDialogBuilder(dialogTitle, DialogType.ERROR);
        errorDialog.setMessage(customErrorMessage);
        errorDialog.setCancelButtonVisible(false);
        errorDialog.buildAndShow();
    }
}

