/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.positron.utilities.models;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.oxygenxml.positron.utilities.AIModelUtils;
import com.oxygenxml.positron.utilities.models.ModelDTO;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ModelLoader {
    private static final Logger log = LoggerFactory.getLogger(ModelLoader.class);
    private static ModelLoader instance = null;
    private Map<String, ModelDTO> modelsById = null;
    private final Map<String, String> MODEL_NAME_TO_UI_LABEL = new HashMap<String, String>();

    private ModelLoader() {
    }

    public static ModelLoader getInstance() {
        if (instance == null) {
            instance = new ModelLoader();
        }
        return instance;
    }

    private void reloadIfNecessary() {
        if (this.modelsById == null) {
            this.reloadModels();
        }
    }

    public void reloadModels() {
        ObjectMapper mapper = new ObjectMapper();
        try (InputStream input = this.getClass().getClassLoader().getResourceAsStream("models.json");){
            if (input == null) {
                throw new FileNotFoundException("models.json not found in resources!");
            }
            List models = (List)mapper.readValue(input, (TypeReference)new TypeReference<List<ModelDTO>>(){});
            this.modelsById = new LinkedHashMap<String, ModelDTO>();
            for (ModelDTO modelDTO : models) {
                this.modelsById.put(modelDTO.getModelID(), modelDTO);
            }
        }
        catch (IOException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
    }

    public ModelDTO getBestMatchingModelDTO(String modelID) {
        this.reloadIfNecessary();
        ModelDTO result = this.getModelDTOById(modelID);
        if (result == null) {
            List<ModelDTO> loadedModels = this.getLoadedModels();
            for (ModelDTO modelDTO : loadedModels) {
                if (!AIModelUtils.isTheSameEngineType(modelID, modelDTO.getModelID())) continue;
                result = modelDTO;
                break;
            }
        }
        return result;
    }

    public String determineAIServiceId(String modelId) {
        ModelDTO modelDTO;
        String toRet = "openai";
        if (modelId != null && !modelId.trim().isEmpty() && (modelDTO = this.getBestMatchingModelDTO(modelId)) != null && modelDTO.getAiServiceID() != null) {
            toRet = modelDTO.getAiServiceID();
        }
        return toRet;
    }

    public String getRequestModel(String modelID) {
        String requestModel = modelID;
        this.reloadIfNecessary();
        if (this.modelsById.containsKey(modelID) && this.modelsById.get(modelID).getRequestModelId() != null) {
            requestModel = this.modelsById.get(modelID).getRequestModelId();
        }
        return requestModel;
    }

    public ModelDTO getModelDTOById(String modelID) {
        ModelDTO toRet = null;
        this.reloadIfNecessary();
        if (this.modelsById.containsKey(modelID)) {
            toRet = this.modelsById.get(modelID);
        } else {
            Collection<ModelDTO> models = this.modelsById.values();
            for (ModelDTO modelDTO : models) {
                if (modelDTO.getRequestModelId() == null || !modelDTO.getRequestModelId().equals(modelID)) continue;
                toRet = modelDTO;
                break;
            }
        }
        return toRet;
    }

    public List<ModelDTO> getLoadedModels() {
        this.reloadIfNecessary();
        if (this.modelsById == null) {
            return Collections.emptyList();
        }
        ArrayList<ModelDTO> models = new ArrayList<ModelDTO>(this.modelsById.values());
        return models;
    }

    public String getModelNameToUI(String modelID) {
        if (this.MODEL_NAME_TO_UI_LABEL.isEmpty()) {
            List<ModelDTO> loadedModels = ModelLoader.getInstance().getLoadedModels();
            for (ModelDTO modelDTO : loadedModels) {
                this.MODEL_NAME_TO_UI_LABEL.put(modelDTO.getModelID(), modelDTO.getModelDisplayName());
            }
        }
        return this.MODEL_NAME_TO_UI_LABEL.getOrDefault(modelID, modelID);
    }

    public static String getLabelForServiceId(String serviceId) {
        String toReturn = serviceId;
        if ("openai".equals(serviceId)) {
            toReturn = "OpenAI";
        } else if ("vertex".equals(serviceId)) {
            toReturn = "VertexAI";
        } else if ("claude".equals(serviceId)) {
            toReturn = "Claude";
        } else if ("xAI".equals(serviceId)) {
            toReturn = "xAI Grok";
        }
        return toReturn;
    }
}

