/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.positron.utilities.models;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

@JsonIgnoreProperties(ignoreUnknown=true)
public class ModelDTO
implements Cloneable {
    @JsonProperty(value="model_id")
    private String modelID;
    @JsonProperty(value="request_model_id")
    private String requestModelId;
    @JsonProperty(value="model_user_name")
    private String modelUsername;
    @JsonProperty(value="description")
    private String modelDescription;
    @JsonProperty(value="max_total_tokens")
    private Integer maxTotalTokens;
    @JsonProperty(value="max_output_tokens")
    private Integer maxOutputTokens;
    @JsonProperty(value="input_cost")
    private Float inputCost;
    @JsonProperty(value="output_cost")
    private Float outputCost;
    @JsonProperty(value="is_reasoning_model")
    private boolean isReasoningModel;
    @JsonProperty(value="reasoning_effort")
    private String reasoningEffort;
    @JsonProperty(value="show_in_ui")
    private Boolean shouldBeShownInUI = false;
    @JsonProperty(value="ai_service_id")
    private String aiServiceID = "openai";
    @JsonProperty(value="input_pricing_tiers")
    private List<PricingTier> inputPricingTiers;
    @JsonProperty(value="output_pricing_tiers")
    private List<PricingTier> outputPricingTiers;
    @JsonProperty(value="isEnterpriseOnly")
    private Boolean isEnterpriseOnly;

    public float getInputWeight() {
        return this.inputCost.floatValue() / 2.0f;
    }

    public float getOutputWeight() {
        return this.outputCost.floatValue() / 2.0f;
    }

    public String getModelDisplayName() {
        return this.modelUsername != null ? this.modelUsername : this.modelID;
    }

    public String getModelID() {
        return this.modelID;
    }

    public String getRequestModelId() {
        return this.requestModelId;
    }

    public String getModelUsername() {
        return this.modelUsername;
    }

    public String getModelDescription() {
        return this.modelDescription;
    }

    public Integer getMaxTotalTokens() {
        return this.maxTotalTokens;
    }

    public Integer getMaxOutputTokens() {
        return this.maxOutputTokens;
    }

    public Float getInputCost() {
        return this.inputCost;
    }

    public Float getOutputCost() {
        return this.outputCost;
    }

    public boolean isReasoningModel() {
        return this.isReasoningModel;
    }

    public String getReasoningEffort() {
        return this.reasoningEffort;
    }

    public Boolean getShouldBeShownInUI() {
        return this.shouldBeShownInUI;
    }

    public String getAiServiceID() {
        return this.aiServiceID;
    }

    public List<PricingTier> getInputPricingTiers() {
        return this.inputPricingTiers;
    }

    public List<PricingTier> getOutputPricingTiers() {
        return this.outputPricingTiers;
    }

    public Boolean getIsEnterpriseOnly() {
        return this.isEnterpriseOnly;
    }

    @JsonProperty(value="model_id")
    public void setModelID(String modelID) {
        this.modelID = modelID;
    }

    @JsonProperty(value="request_model_id")
    public void setRequestModelId(String requestModelId) {
        this.requestModelId = requestModelId;
    }

    @JsonProperty(value="model_user_name")
    public void setModelUsername(String modelUsername) {
        this.modelUsername = modelUsername;
    }

    @JsonProperty(value="description")
    public void setModelDescription(String modelDescription) {
        this.modelDescription = modelDescription;
    }

    @JsonProperty(value="max_total_tokens")
    public void setMaxTotalTokens(Integer maxTotalTokens) {
        this.maxTotalTokens = maxTotalTokens;
    }

    @JsonProperty(value="max_output_tokens")
    public void setMaxOutputTokens(Integer maxOutputTokens) {
        this.maxOutputTokens = maxOutputTokens;
    }

    @JsonProperty(value="input_cost")
    public void setInputCost(Float inputCost) {
        this.inputCost = inputCost;
    }

    @JsonProperty(value="output_cost")
    public void setOutputCost(Float outputCost) {
        this.outputCost = outputCost;
    }

    @JsonProperty(value="is_reasoning_model")
    public void setReasoningModel(boolean isReasoningModel) {
        this.isReasoningModel = isReasoningModel;
    }

    @JsonProperty(value="reasoning_effort")
    public void setReasoningEffort(String reasoningEffort) {
        this.reasoningEffort = reasoningEffort;
    }

    @JsonProperty(value="show_in_ui")
    public void setShouldBeShownInUI(Boolean shouldBeShownInUI) {
        this.shouldBeShownInUI = shouldBeShownInUI;
    }

    @JsonProperty(value="ai_service_id")
    public void setAiServiceID(String aiServiceID) {
        this.aiServiceID = aiServiceID;
    }

    @JsonProperty(value="input_pricing_tiers")
    public void setInputPricingTiers(List<PricingTier> inputPricingTiers) {
        this.inputPricingTiers = inputPricingTiers;
    }

    @JsonProperty(value="output_pricing_tiers")
    public void setOutputPricingTiers(List<PricingTier> outputPricingTiers) {
        this.outputPricingTiers = outputPricingTiers;
    }

    @JsonProperty(value="isEnterpriseOnly")
    public void setIsEnterpriseOnly(Boolean isEnterpriseOnly) {
        this.isEnterpriseOnly = isEnterpriseOnly;
    }

    public String toString() {
        return "ModelDTO(modelID=" + this.getModelID() + ", requestModelId=" + this.getRequestModelId() + ", modelUsername=" + this.getModelUsername() + ", modelDescription=" + this.getModelDescription() + ", maxTotalTokens=" + this.getMaxTotalTokens() + ", maxOutputTokens=" + this.getMaxOutputTokens() + ", inputCost=" + this.getInputCost() + ", outputCost=" + this.getOutputCost() + ", isReasoningModel=" + this.isReasoningModel() + ", reasoningEffort=" + this.getReasoningEffort() + ", shouldBeShownInUI=" + this.getShouldBeShownInUI() + ", aiServiceID=" + this.getAiServiceID() + ", inputPricingTiers=" + this.getInputPricingTiers() + ", outputPricingTiers=" + this.getOutputPricingTiers() + ", isEnterpriseOnly=" + this.getIsEnterpriseOnly() + ")";
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class PricingTier {
        @JsonProperty(value="up_to_tokens")
        private Integer upToTokens;
        @JsonProperty(value="input_cost")
        private Float inputCost;
        @JsonProperty(value="output_cost")
        private Float outputCost;

        public Float getInputWeight() {
            return this.inputCost == null ? null : Float.valueOf(this.inputCost.floatValue() / 2.0f);
        }

        public Float getOutputWeight() {
            return this.outputCost == null ? null : Float.valueOf(this.outputCost.floatValue() / 2.0f);
        }

        public Integer getUpToTokens() {
            return this.upToTokens;
        }

        public Float getInputCost() {
            return this.inputCost;
        }

        public Float getOutputCost() {
            return this.outputCost;
        }

        @JsonProperty(value="up_to_tokens")
        public void setUpToTokens(Integer upToTokens) {
            this.upToTokens = upToTokens;
        }

        @JsonProperty(value="input_cost")
        public void setInputCost(Float inputCost) {
            this.inputCost = inputCost;
        }

        @JsonProperty(value="output_cost")
        public void setOutputCost(Float outputCost) {
            this.outputCost = outputCost;
        }
    }
}

