/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.positron.utilities.json;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import java.util.Optional;
import java.util.stream.Stream;

@JsonIgnoreProperties(ignoreUnknown=true)
public enum InputContext {
    NONE("none"),
    SELECTION("selection"),
    NODE("node"),
    DOCUMENT("document"),
    SELECTION_NODE_DOCUMENT("selection, node, document"),
    AUTO_SELECTION_DOCUMENT("selection, document");

    private final String id;

    private InputContext(String id) {
        this.id = id;
    }

    @JsonCreator
    public static InputContext fromString(String id) {
        Optional<InputContext> type = Stream.of(InputContext.values()).filter(t -> t.id.equalsIgnoreCase(id)).findFirst();
        if (type.isPresent()) {
            return type.get();
        }
        return AUTO_SELECTION_DOCUMENT;
    }

    public String toString() {
        return this.id;
    }
}

