/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.positron.utilities.json;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.oxygenxml.positron.utilities.json.ActionParam;
import com.oxygenxml.positron.utilities.json.ActionType;
import com.oxygenxml.positron.utilities.json.AdditionalInfo;
import com.oxygenxml.positron.utilities.json.Examples;
import com.oxygenxml.positron.utilities.json.InputContext;
import com.oxygenxml.positron.utilities.json.InputType;
import com.oxygenxml.positron.utilities.json.InsertMode;
import com.oxygenxml.positron.utilities.json.OutputAction;
import com.oxygenxml.positron.utilities.json.Parameters;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@JsonIgnoreProperties(ignoreUnknown=true)
public class AIActionDetails
implements Cloneable {
    @Deprecated
    public static final String CONTEXT_PROP_NAME = "context";
    public static final String PROMPT_PROP_NAME = "prompt";
    public static final String PROMPTREF_PROP_NAME = "prompt_ref";
    public static final String ID_PROP_NAME = "id";
    public static final String TITLE_PROP_NAME = "title";
    public static final String TYPE_PROP_NAME = "type";
    public static final String OUTPUT_ACTION_PROP_NAME = "output-action";
    public static final String DESCRIPTION_PROP_NAME = "description";
    public static final String EXAMPLES_PROP_NAME = "examples";
    @JsonProperty(value="id")
    private String id;
    @JsonProperty(value="categoryId")
    private String categoryId;
    @JsonProperty(value="type")
    private ActionType type;
    @JsonProperty(value="title")
    private String title;
    @JsonProperty(value="short-description")
    private String shortDescription;
    @JsonProperty(value="description")
    private String description;
    @JsonProperty(value="input-type")
    private InputType inputType;
    @JsonProperty(value="input")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private InputContext inputContext;
    @JsonProperty(value="output-action")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private OutputAction outputAction;
    @JsonProperty(value="additional_info")
    private AdditionalInfo additionalInfo;
    @JsonProperty(value="insert-modes")
    private List<InsertMode> insertModes;
    @JsonProperty(value="expand-params")
    private List<ActionParam> expandParams;
    @JsonProperty(value="framework")
    private String framework;
    @JsonProperty(value="parameters")
    private Parameters parameters;
    @JsonProperty(value="quick-assist")
    private boolean quickAssist;
    @JsonProperty(value="embed-assist")
    private boolean embedAssist;
    @JsonProperty(value="context")
    @Deprecated
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private String context;
    @JsonProperty(value="prompt")
    private String prompt;
    @JsonProperty(value="prompt_ref")
    private String promptRef;
    @JsonProperty(value="examples")
    private List<Examples> examples;
    @JsonProperty(value="isBuiltinAction")
    private boolean isBuiltinAction;
    @JsonProperty(value="profile")
    private String profile;

    public Parameters getParameters() {
        if (this.parameters == null) {
            this.parameters = new Parameters();
        }
        return this.parameters;
    }

    public String getShortDescription() {
        return this.shortDescription != null ? this.shortDescription : this.getTitle();
    }

    public boolean hasShortDescription() {
        return this.shortDescription != null;
    }

    @JsonIgnore
    public int getContextLength() {
        int[] lenght = new int[1];
        int n = lenght[0] = this.context != null ? this.context.length() : 0;
        if (lenght[0] == 0 && this.examples != null) {
            this.examples.forEach(e -> {
                lenght[0] = lenght[0] + e.getCompletion().length();
            });
        }
        return lenght[0];
    }

    public int hashCode() {
        return Objects.hash(this.id);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        return Objects.equals(this.id, ((AIActionDetails)obj).id);
    }

    public AIActionDetails clone() throws CloneNotSupportedException {
        AIActionDetails cloned = (AIActionDetails)super.clone();
        if (this.additionalInfo != null) {
            cloned.setAdditionalInfo(this.additionalInfo.clone());
        }
        if (this.insertModes != null) {
            ArrayList<InsertMode> insertModesClone = new ArrayList<InsertMode>(this.insertModes.size());
            for (InsertMode insertMode : this.insertModes) {
                insertModesClone.add(insertMode.clone());
            }
            cloned.setInsertModes(insertModesClone);
        }
        if (this.expandParams != null) {
            ArrayList<ActionParam> expandParamsClone = new ArrayList<ActionParam>(this.expandParams.size());
            for (ActionParam param : this.expandParams) {
                expandParamsClone.add(param.clone());
            }
            cloned.setExpandParams(expandParamsClone);
        }
        if (this.parameters != null) {
            cloned.setParameters(this.parameters.clone());
        }
        if (this.examples != null) {
            ArrayList<Examples> examplesClone = new ArrayList<Examples>(this.examples.size());
            for (Examples example : this.examples) {
                examplesClone.add(example.clone());
            }
            cloned.setExamples(examplesClone);
        }
        return cloned;
    }

    public InputContext getInputContext() {
        InputContext ret = this.inputContext;
        ActionType actionType = this.getComputedType();
        if (ret == null) {
            if (this.additionalInfo != null && this.additionalInfo.getProperties() != null && "document".equals(this.additionalInfo.getProperties().get("input_content"))) {
                ret = InputContext.DOCUMENT;
            } else if (actionType == ActionType.REPLACE_SELECTION || actionType == ActionType.REPLACE_SELECTION_BASED_ON_IMAGE_ANALYSIS || actionType == ActionType.SHOW_RESPONSE) {
                ret = InputContext.AUTO_SELECTION_DOCUMENT;
            } else if (actionType == ActionType.UPDATE_ENTIRE_DOCUMENT_BASED_ON_IMAGES) {
                ret = InputContext.DOCUMENT;
            }
        }
        return ret;
    }

    private ActionType getType() {
        return this.type;
    }

    @JsonIgnore
    public ActionType getComputedType() {
        ActionType computedType = this.type;
        if (computedType == null && this.outputAction != null) {
            if (this.outputAction == OutputAction.INSERT) {
                computedType = ActionType.INSERT_SCHEMA_AWARE;
            } else if (this.outputAction == OutputAction.NEW_DOCUMENT) {
                computedType = ActionType.CREATE_NEW_DOCUMENT_FROM_TEXT;
            } else if (this.outputAction == OutputAction.REPLACE) {
                computedType = ActionType.REPLACE_SELECTION;
            } else if (this.outputAction == OutputAction.NONE) {
                computedType = ActionType.SHOW_RESPONSE;
            }
        }
        if (computedType == null) {
            computedType = ActionType.REPLACE_SELECTION;
        }
        return computedType;
    }

    private String getContext() {
        return this.context;
    }

    private void setContext(String context) {
        this.context = context;
    }

    public String getPrompt() {
        Object promptToReturn;
        Object object = promptToReturn = this.prompt == null ? this.context : this.prompt;
        if (promptToReturn != null && !((String)promptToReturn).contains("${contextPrompt}")) {
            promptToReturn = "${contextPrompt} " + (String)promptToReturn;
        }
        String oldContextInfoVariable = "${contextInfo}";
        if (promptToReturn != null && ((String)promptToReturn).contains(oldContextInfoVariable)) {
            promptToReturn = ((String)promptToReturn).replace(oldContextInfoVariable, "${contextPrompt}");
        }
        return promptToReturn;
    }

    public List<ActionParam> getExpandParams() {
        boolean hasContextInfo = false;
        List<ActionParam> params = this.expandParams;
        if (params != null) {
            for (ActionParam actionParam : params) {
                if (actionParam.getValue() == null || !actionParam.getName().contains("contextPrompt")) continue;
                hasContextInfo = true;
                break;
            }
        }
        if (!hasContextInfo) {
            params = params == null ? new ArrayList<ActionParam>(1) : new ArrayList<ActionParam>(params);
            ActionParam ciParam = new ActionParam();
            ciParam.setName("contextPrompt");
            ciParam.setValue("${contextPrompt}");
            params.add(ciParam);
        }
        return params;
    }

    public String getId() {
        return this.id;
    }

    public String getCategoryId() {
        return this.categoryId;
    }

    public String getTitle() {
        return this.title;
    }

    public String getDescription() {
        return this.description;
    }

    public InputType getInputType() {
        return this.inputType;
    }

    public OutputAction getOutputAction() {
        return this.outputAction;
    }

    public AdditionalInfo getAdditionalInfo() {
        return this.additionalInfo;
    }

    public List<InsertMode> getInsertModes() {
        return this.insertModes;
    }

    public String getFramework() {
        return this.framework;
    }

    public boolean isQuickAssist() {
        return this.quickAssist;
    }

    public boolean isEmbedAssist() {
        return this.embedAssist;
    }

    public String getPromptRef() {
        return this.promptRef;
    }

    public List<Examples> getExamples() {
        return this.examples;
    }

    public boolean isBuiltinAction() {
        return this.isBuiltinAction;
    }

    public String getProfile() {
        return this.profile;
    }

    @JsonProperty(value="id")
    public void setId(String id) {
        this.id = id;
    }

    @JsonProperty(value="categoryId")
    public void setCategoryId(String categoryId) {
        this.categoryId = categoryId;
    }

    @JsonProperty(value="type")
    public void setType(ActionType type) {
        this.type = type;
    }

    @JsonProperty(value="title")
    public void setTitle(String title) {
        this.title = title;
    }

    @JsonProperty(value="short-description")
    public void setShortDescription(String shortDescription) {
        this.shortDescription = shortDescription;
    }

    @JsonProperty(value="description")
    public void setDescription(String description) {
        this.description = description;
    }

    @JsonProperty(value="input-type")
    public void setInputType(InputType inputType) {
        this.inputType = inputType;
    }

    @JsonProperty(value="input")
    public void setInputContext(InputContext inputContext) {
        this.inputContext = inputContext;
    }

    @JsonProperty(value="output-action")
    public void setOutputAction(OutputAction outputAction) {
        this.outputAction = outputAction;
    }

    @JsonProperty(value="additional_info")
    public void setAdditionalInfo(AdditionalInfo additionalInfo) {
        this.additionalInfo = additionalInfo;
    }

    @JsonProperty(value="insert-modes")
    public void setInsertModes(List<InsertMode> insertModes) {
        this.insertModes = insertModes;
    }

    @JsonProperty(value="expand-params")
    public void setExpandParams(List<ActionParam> expandParams) {
        this.expandParams = expandParams;
    }

    @JsonProperty(value="framework")
    public void setFramework(String framework) {
        this.framework = framework;
    }

    @JsonProperty(value="parameters")
    public void setParameters(Parameters parameters) {
        this.parameters = parameters;
    }

    @JsonProperty(value="quick-assist")
    public void setQuickAssist(boolean quickAssist) {
        this.quickAssist = quickAssist;
    }

    @JsonProperty(value="embed-assist")
    public void setEmbedAssist(boolean embedAssist) {
        this.embedAssist = embedAssist;
    }

    @JsonProperty(value="prompt")
    public void setPrompt(String prompt) {
        this.prompt = prompt;
    }

    @JsonProperty(value="prompt_ref")
    public void setPromptRef(String promptRef) {
        this.promptRef = promptRef;
    }

    @JsonProperty(value="examples")
    public void setExamples(List<Examples> examples) {
        this.examples = examples;
    }

    @JsonProperty(value="isBuiltinAction")
    public void setBuiltinAction(boolean isBuiltinAction) {
        this.isBuiltinAction = isBuiltinAction;
    }

    @JsonProperty(value="profile")
    public void setProfile(String profile) {
        this.profile = profile;
    }

    public String toString() {
        return "AIActionDetails(id=" + this.getId() + ", categoryId=" + this.getCategoryId() + ", type=" + this.getType() + ", title=" + this.getTitle() + ", shortDescription=" + this.getShortDescription() + ", description=" + this.getDescription() + ", inputType=" + this.getInputType() + ", inputContext=" + this.getInputContext() + ", outputAction=" + this.getOutputAction() + ", additionalInfo=" + this.getAdditionalInfo() + ", insertModes=" + this.getInsertModes() + ", expandParams=" + this.getExpandParams() + ", framework=" + this.getFramework() + ", parameters=" + this.getParameters() + ", quickAssist=" + this.isQuickAssist() + ", embedAssist=" + this.isEmbedAssist() + ", context=" + this.getContext() + ", prompt=" + this.getPrompt() + ", promptRef=" + this.getPromptRef() + ", examples=" + this.getExamples() + ", isBuiltinAction=" + this.isBuiltinAction() + ", profile=" + this.getProfile() + ")";
    }
}

