/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.positron.utilities.functions.testingutils;

import com.oxygenxml.positron.utilities.functions.AddToDitaMapStructureFunctionSignature;
import com.oxygenxml.positron.utilities.functions.ChatFunctionSignature;
import com.oxygenxml.positron.utilities.functions.ClearMemoryFunctionSignature;
import com.oxygenxml.positron.utilities.functions.EditDocumentFunctionSignature;
import com.oxygenxml.positron.utilities.functions.ExpandContextFunctionSignature;
import com.oxygenxml.positron.utilities.functions.FindSimilarReusableComponentsFunctionSignature;
import com.oxygenxml.positron.utilities.functions.GetContentForDocumentURLFunctionSignature;
import com.oxygenxml.positron.utilities.functions.GetCorrespondingKeyReferencesFunctionSignature;
import com.oxygenxml.positron.utilities.functions.GetCurrentDocumentMarkedUpFunctionSignature;
import com.oxygenxml.positron.utilities.functions.GetCurrentDocumentPlainTextFunctionSignature;
import com.oxygenxml.positron.utilities.functions.GetCurrentEditorFileLocationFunctionSignature;
import com.oxygenxml.positron.utilities.functions.GetDitaMapStructureContextFunctionSignature;
import com.oxygenxml.positron.utilities.functions.GetRelatedContentFromSpecificFeedbackSiteSignature;
import com.oxygenxml.positron.utilities.functions.GetRelatedProjectResourcesOverviewFunctionSignature;
import com.oxygenxml.positron.utilities.functions.GetRelatedWebHelpContentFunctionSignature;
import com.oxygenxml.positron.utilities.functions.GetSCHComponentDetailsSignature;
import com.oxygenxml.positron.utilities.functions.GetTextAroundCaretFunctionSignature;
import com.oxygenxml.positron.utilities.functions.GetXSDComponentDetailsSignature;
import com.oxygenxml.positron.utilities.functions.GetXSLComponentDetailsSignature;
import com.oxygenxml.positron.utilities.functions.InvokeActionFunctionSignature;
import com.oxygenxml.positron.utilities.functions.InvokeXMLRefactorOperationFunctionSignature;
import com.oxygenxml.positron.utilities.functions.InvokeXMLRefactorXSLTScriptFunctionSignature;
import com.oxygenxml.positron.utilities.functions.ResolveReferenceFunctionSignature;
import com.oxygenxml.positron.utilities.functions.RetrieveActionIDsFunctionSignature;
import com.oxygenxml.positron.utilities.functions.RetrieveXMLRefactorOperationParamsFunctionSignature;
import com.oxygenxml.positron.utilities.functions.RetrieveXMLRefactorOperationsFunctionSignature;
import com.oxygenxml.positron.utilities.functions.SaveDocumentFunctionSignature;
import com.oxygenxml.positron.utilities.functions.SearchInProjectFunctionSignature;
import com.oxygenxml.positron.utilities.functions.StoreInMemoryFunctionSignature;
import com.oxygenxml.positron.utilities.functions.ValidateCurrentDocumentFunctionSignature;
import com.oxygenxml.positron.utilities.functions.ValidateDocumentFunctionSignature;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseToolIdValidationTestUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)BaseToolIdValidationTestUtil.class.getName());
    private static final String FOUND_IN_DELIMITER = " ~FOUND IN~ ";
    private static final Map<String, String> TOOL_ID_MAPPINGS = BaseToolIdValidationTestUtil.loadToolIdMappingsFromFunctionSignatures();

    private static Map<String, String> loadToolIdMappingsFromFunctionSignatures() {
        ChatFunctionSignature[] signatures;
        HashMap<String, String> mappings = new HashMap<String, String>();
        for (ChatFunctionSignature signature : signatures = new ChatFunctionSignature[]{new GetDitaMapStructureContextFunctionSignature(), new AddToDitaMapStructureFunctionSignature(), new RetrieveXMLRefactorOperationsFunctionSignature(), new SearchInProjectFunctionSignature(), new GetCorrespondingKeyReferencesFunctionSignature(), new GetRelatedProjectResourcesOverviewFunctionSignature(), new GetTextAroundCaretFunctionSignature(), new RetrieveXMLRefactorOperationParamsFunctionSignature(), new ValidateDocumentFunctionSignature(), new StoreInMemoryFunctionSignature(), new RetrieveActionIDsFunctionSignature(), new ResolveReferenceFunctionSignature(), new GetXSLComponentDetailsSignature(), new GetXSDComponentDetailsSignature(), new GetSCHComponentDetailsSignature(), new GetRelatedWebHelpContentFunctionSignature(), new GetRelatedContentFromSpecificFeedbackSiteSignature(), new GetCurrentEditorFileLocationFunctionSignature(), new GetCurrentDocumentPlainTextFunctionSignature(), new GetCurrentDocumentMarkedUpFunctionSignature(), new GetContentForDocumentURLFunctionSignature(), new FindSimilarReusableComponentsFunctionSignature(), new InvokeXMLRefactorOperationFunctionSignature(), new EditDocumentFunctionSignature(), new SaveDocumentFunctionSignature(), new ValidateCurrentDocumentFunctionSignature(), new InvokeXMLRefactorXSLTScriptFunctionSignature(), new InvokeActionFunctionSignature(), new ClearMemoryFunctionSignature(), new ExpandContextFunctionSignature()}) {
            String currentName = signature.getName();
            List<String> alternateNames = signature.getAlternateNames();
            for (String oldName : alternateNames) {
                mappings.put(oldName, currentName);
            }
        }
        return mappings;
    }

    public abstract File getSourceDirectory();

    public abstract String getProjectName();

    public Set<String> getPackagesToSkip() {
        return new HashSet<String>();
    }

    public String getDeprecatedToolIds() throws Exception {
        HashSet<String> deprecatedToolIdUsages = new HashSet<String>();
        File sourceDir = this.getSourceDirectory();
        if (!sourceDir.exists()) {
            LOGGER.warn("Source directory does not exist: {} - skipping tool ID validation for {}", (Object)sourceDir.getPath(), (Object)this.getProjectName());
            return "Soruce directory does not exist";
        }
        LOGGER.info("Scanning {} project source directory: {}", (Object)this.getProjectName(), (Object)sourceDir.getPath());
        this.scanDirectoryForDeprecatedToolIds(sourceDir, deprecatedToolIdUsages);
        StringBuilder sb = new StringBuilder();
        for (String usage : deprecatedToolIdUsages) {
            sb.append(usage + "\n");
        }
        return sb.toString();
    }

    private void scanDirectoryForDeprecatedToolIds(File directory, Set<String> deprecatedToolIdUsages) {
        this.scanDirectoryForDeprecatedToolIds(directory, deprecatedToolIdUsages, this.getSourceDirectory());
    }

    private void scanDirectoryForDeprecatedToolIds(File directory, Set<String> deprecatedToolIdUsages, File sourceDir) {
        if (!directory.exists() || !directory.isDirectory()) {
            return;
        }
        File[] files = directory.listFiles();
        if (files == null) {
            return;
        }
        for (File file : files) {
            String relativePath = this.getRelativePath(sourceDir, file);
            if (file.isDirectory()) {
                String dirName = file.getName();
                if ("target".equals(dirName) || "build".equals(dirName) || ".git".equals(dirName) || "node_modules".equals(dirName) || dirName.startsWith(".")) continue;
                if (!this.shouldSkipFileOrDirectory(relativePath)) {
                    this.scanDirectoryForDeprecatedToolIds(file, deprecatedToolIdUsages, sourceDir);
                    continue;
                }
                LOGGER.info("Skipping package: {}", (Object)relativePath);
                continue;
            }
            if (this.shouldSkipFileOrDirectory(relativePath)) continue;
            this.scanFileForDeprecatedToolIds(file, deprecatedToolIdUsages);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void scanFileForDeprecatedToolIds(File file, Set<String> deprecatedToolIdUsages) {
        BufferedReader br = null;
        try {
            br = new BufferedReader(new FileReader(file));
            String line = "";
            int lineNumber = 0;
            while ((line = br.readLine()) != null) {
                ++lineNumber;
                for (String oldToolId : TOOL_ID_MAPPINGS.keySet()) {
                    if (!line.contains(oldToolId) || !this.isActualToolIdUsage(line, oldToolId)) continue;
                    String newToolId = TOOL_ID_MAPPINGS.get(oldToolId);
                    deprecatedToolIdUsages.add("Old tool ID: '" + oldToolId + "' should be replaced with: '" + newToolId + "' ~FOUND IN~ " + file.getName() + ":" + lineNumber + " -> " + line.trim());
                }
            }
        }
        catch (FileNotFoundException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
        }
        catch (IOException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
        }
        finally {
            if (br != null) {
                try {
                    br.close();
                }
                catch (IOException e) {
                    LOGGER.error(e.getMessage(), (Throwable)e);
                }
            }
        }
    }

    private boolean isActualToolIdUsage(String line, String toolId) {
        return line.contains("\"" + toolId + "\"") || line.contains("'" + toolId + "'") || line.contains(toolId) && (line.contains("=") || line.contains(":"));
    }

    private boolean shouldSkipFileOrDirectory(String relativePath) {
        Set<String> packagesToSkip = this.getPackagesToSkip();
        for (String packageToSkip : packagesToSkip) {
            if (!relativePath.equals(packageToSkip) && !relativePath.startsWith(packageToSkip + File.separator)) continue;
            return true;
        }
        return false;
    }

    private String getRelativePath(File sourceDir, File targetDir) {
        try {
            String sourcePath = sourceDir.getCanonicalPath();
            String targetPath = targetDir.getCanonicalPath();
            if (targetPath.startsWith(sourcePath)) {
                String relativePath = targetPath.substring(sourcePath.length());
                if (relativePath.startsWith(File.separator)) {
                    relativePath = relativePath.substring(1);
                }
                return relativePath.replace(File.separator, "/");
            }
            return targetPath;
        }
        catch (Exception e) {
            return targetDir.getName();
        }
    }
}

