/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.positron.utilities.functions;

import com.oxygenxml.positron.utilities.functions.ChatFunctionSignature;
import com.oxygenxml.positron.utilities.functions.FunctionsAndRAGHelper;
import com.oxygenxml.positron.utilities.functions.FunctionsAndRAGHelperProvider;
import com.oxygenxml.positron.utilities.functions.parameters.Memory;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class StoreInMemoryFunctionSignature
implements ChatFunctionSignature {
    @Override
    public String getName() {
        return "store_to_memory";
    }

    @Override
    public List<String> getAlternateNames() {
        return Collections.unmodifiableList(Arrays.asList("store_in_memory"));
    }

    @Override
    public String getDescription() {
        return "Record a user preference in a persistent long-term memory.\nInvoke this tool whenever the end user provides a rule, preference, or directive \u2014 explicitly or implicitly \u2014 about formatting, content style, behavior, or any other instruction meant to guide future interactions. This includes instructions stated as requirements, rules, or best practices, even if not phrased as a direct command to \"remember\" or \"store.\" Use this tool to ensure that further actions will take into account user preferences in future interactions.";
    }

    @Override
    public String getUIDecriptionForChatMessage() {
        return "Store to memory";
    }

    @Override
    public Class<?> getParameters() {
        return Memory.class;
    }

    @Override
    public boolean isEnabled() {
        FunctionsAndRAGHelper projectRAGHelper = FunctionsAndRAGHelperProvider.getProjectRAGHelper();
        return ChatFunctionSignature.super.isEnabled() && projectRAGHelper != null && projectRAGHelper.isPersistentMemoryStoreEnabled();
    }
}

