/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.positron.utilities.functions;

import com.oxygenxml.positron.utilities.functions.FunctionsAndRAGHelperProvider;
import com.oxygenxml.positron.utilities.functions.RAGFunctionSignature;
import com.oxygenxml.positron.utilities.functions.parameters.SearchParams;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class SearchInProjectFunctionSignature
implements RAGFunctionSignature {
    @Override
    public String getName() {
        return "grep_project";
    }

    @Override
    public List<String> getAlternateNames() {
        return Collections.unmodifiableList(Arrays.asList("search_in_project"));
    }

    @Override
    public String getDescription() {
        return "Search project files for exact text matches and returns results in JSON format. Similar to grep command-line tool.\nReturns:\n- Total match count across all files\n- Per-file match counts\n- Up to 'maxNumberOfMatches' individual match details including:\n  - Line number (1-indexed)\n  - Column number (1-indexed)  \n  - Match length in characters\n  - Matched text\n  - Contextual text content containing the match\n\nWhen total match count exceeds 'maxNumberOfMatches', only the first 'maxNumberOfMatches' matches are returned.\nFor large result sets, refine results by using a more specific 'includedFileNamesPattern' parameter.\nCost: Low to moderate";
    }

    @Override
    public Class<?> getParameters() {
        return SearchParams.class;
    }

    @Override
    public boolean isEnabled() {
        return RAGFunctionSignature.super.isEnabled() && FunctionsAndRAGHelperProvider.getProjectRAGHelper() != null && FunctionsAndRAGHelperProvider.getProjectRAGHelper().isSearchInProjectAvailable();
    }

    @Override
    public String getUIDecriptionForChatMessage() {
        return "Search exact matches in project";
    }
}

