/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.positron.utilities.functions;

import com.oxygenxml.positron.utilities.functions.FunctionsAndRAGHelperProvider;
import com.oxygenxml.positron.utilities.functions.RAGFunctionSignature;
import com.oxygenxml.positron.utilities.functions.parameters.AdvancedSearchKeywords;
import com.oxygenxml.positron.utilities.functions.parameters.SearchKeywords;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class GetRelatedProjectResourcesOverviewFunctionSignature
implements RAGFunctionSignature {
    @Override
    public String getName() {
        return "search_project_resources";
    }

    @Override
    public List<String> getAlternateNames() {
        return Collections.unmodifiableList(Arrays.asList("get_related_resources_overview_from_project"));
    }

    @Override
    public String getDescription() {
        boolean lowCost = FunctionsAndRAGHelperProvider.getProjectRAGHelper() != null && FunctionsAndRAGHelperProvider.getProjectRAGHelper().isAdvancedSearchAvailable();
        return "Searches the local project for resources matching keywords and returns an overview (JSON format) with title, description, and relevance ranking, ordered from highest to lowest relevance. Use 'get_document_content' to retrieve full content. Cost: " + (lowCost ? "low" : "medium") + ".";
    }

    @Override
    public Class<?> getParameters() {
        if (FunctionsAndRAGHelperProvider.getProjectRAGHelper() != null && FunctionsAndRAGHelperProvider.getProjectRAGHelper().isAdvancedSearchAvailable()) {
            return AdvancedSearchKeywords.class;
        }
        return SearchKeywords.class;
    }

    @Override
    public boolean isEnabled() {
        return RAGFunctionSignature.super.isEnabled() && FunctionsAndRAGHelperProvider.getProjectRAGHelper() != null && FunctionsAndRAGHelperProvider.getProjectRAGHelper().isRagAvailable();
    }

    @Override
    public String getUIDecriptionForChatMessage() {
        return "Search in project";
    }
}

