/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.positron.utilities.functions;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.github.victools.jsonschema.generator.Module;
import com.github.victools.jsonschema.generator.OptionPreset;
import com.github.victools.jsonschema.generator.SchemaGenerator;
import com.github.victools.jsonschema.generator.SchemaGeneratorConfigBuilder;
import com.github.victools.jsonschema.generator.SchemaVersion;
import com.github.victools.jsonschema.module.jackson.JacksonModule;
import com.github.victools.jsonschema.module.jackson.JacksonOption;
import com.oxygenxml.positron.api.connector.dto.ChatFunctionDTO;
import com.oxygenxml.positron.utilities.AIRequestUtil;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.slf4j.LoggerFactory;

public interface ChatFunctionSignature {
    public String getName();

    public String getDescription();

    public String getUIDecriptionForChatMessage();

    public Class<?> getParameters();

    default public boolean isEnabled() {
        return true;
    }

    default public List<String> getAlternateNames() {
        return Collections.unmodifiableList(new ArrayList());
    }

    default public Object deserializeArguments(String serializedArguments) throws JsonProcessingException {
        Object argumentsObj = null;
        if (serializedArguments != null && this.getParameters() != null) {
            argumentsObj = AIRequestUtil.defaultObjectMapper().readValue(serializedArguments, this.getParameters());
        }
        return argumentsObj;
    }

    default public ChatFunctionDTO toDto() {
        ChatFunctionDTO chatFunctionDTO = new ChatFunctionDTO();
        chatFunctionDTO.setName(this.getName());
        chatFunctionDTO.setDescription(this.getDescription());
        String paramsSchema = this.getParamsSchema();
        try {
            chatFunctionDTO.setParametersObj(AIRequestUtil.defaultObjectMapper().readValue(paramsSchema, Object.class));
        }
        catch (JsonProcessingException e) {
            LoggerFactory.getLogger((String)ChatFunctionSignature.class.getName()).error(e.getMessage(), (Throwable)e);
        }
        return chatFunctionDTO;
    }

    default public String getParamsSchema() {
        if (this.getParameters() != null) {
            JacksonModule module = new JacksonModule(new JacksonOption[]{JacksonOption.RESPECT_JSONPROPERTY_REQUIRED});
            SchemaGenerator schemaGenerator = new SchemaGenerator(new SchemaGeneratorConfigBuilder(SchemaVersion.DRAFT_2020_12, OptionPreset.PLAIN_JSON).with((Module)module).build());
            ObjectNode jsonSchema = schemaGenerator.generateSchema(this.getParameters(), new Type[0]);
            return jsonSchema.toPrettyString();
        }
        return "{\"$schema\" : \"https://json-schema.org/draft/2020-12/schema\",\"type\" : \"object\",\"properties\" : {}}";
    }

    default public boolean isSafe() {
        return true;
    }
}

