/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.positron.utilities.exceptions;

import com.oxygenxml.positron.api.connector.dto.Message;
import com.oxygenxml.positron.api.connector.dto.MessageImageUrlContent;
import java.util.List;

public class ModelTokensLimitExcededException
extends Exception {
    private final int maxTotalTokens;
    private final int prefixTokens;
    private final List<Message> requestMessages;

    public ModelTokensLimitExcededException(int maxTotalTokens, int prefixTokens, List<Message> requestMessages) {
        super("The number of tokens in the prefix (i.e. prompt + user input) is too large.\nPrefix tokens: " + prefixTokens + ".\nMaximum total tokens: " + maxTotalTokens + ".\nThe maximum has been exceeded by " + (prefixTokens - maxTotalTokens) + " tokens.");
        this.maxTotalTokens = maxTotalTokens;
        this.prefixTokens = prefixTokens;
        this.requestMessages = requestMessages;
    }

    public String getExcessInfoMessage() {
        Object infoMessage = "";
        int exceedingNoOfTokens = this.prefixTokens - this.maxTotalTokens;
        boolean hasImage = this.requestMessages.stream().anyMatch(m -> m.getContent().stream().anyMatch(MessageImageUrlContent.class::isInstance));
        if (hasImage) {
            infoMessage = "The input contains too many tokens. It exceeds the maximum allowed number of tokens by " + exceedingNoOfTokens + ".";
        } else {
            int exceedingNoOfChars = Math.round((float)exceedingNoOfTokens * 4.0f);
            infoMessage = "The input text contains too many characters. It exceeds the maximum allowed length by " + exceedingNoOfChars + " characters.";
        }
        return infoMessage;
    }

    public int getMaxTotalTokens() {
        return this.maxTotalTokens;
    }

    public int getPrefixTokens() {
        return this.prefixTokens;
    }

    public List<Message> getRequestMessages() {
        return this.requestMessages;
    }
}

