/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.positron.utilities.credits;

import com.oxygenxml.positron.utilities.exceptions.InvalidParamException;
import com.oxygenxml.positron.utilities.models.ModelDTO;
import com.oxygenxml.positron.utilities.models.ModelLoader;
import java.util.Comparator;
import java.util.List;

public class CreditsConverterUtil {
    public static final float APPROX_TOKENS_PER_WORD_ENGLISH = 1.3f;

    private CreditsConverterUtil() {
    }

    public static final int getNoOfCredits(int noOfTokens, String engine, boolean areInputTokens) throws InvalidParamException {
        float noOfCredits = noOfTokens;
        float modelWeight = CreditsConverterUtil.getModelWeightWithTiers(noOfTokens, engine, areInputTokens);
        return Math.round(noOfCredits *= modelWeight);
    }

    public static final int getNoOfOutputCreditsConsideringInput(int noOfOutputTokens, int noOfInputTokens, String engine) throws InvalidParamException {
        float noOfCredits = noOfOutputTokens;
        float modelWeight = CreditsConverterUtil.getModelWeightWithTiers(noOfInputTokens, engine, false);
        return Math.round(noOfCredits *= modelWeight);
    }

    private static float getModelWeightWithTiers(int noOfTokens, String engine, boolean areInputTokens) throws InvalidParamException {
        List<ModelDTO.PricingTier> tiers;
        ModelLoader modelLoader = ModelLoader.getInstance();
        ModelDTO modelDTO = modelLoader.getBestMatchingModelDTO(engine);
        if (modelDTO == null) {
            throw new InvalidParamException("The model \"" + engine + "\" is not supported. Please use another model.");
        }
        List<ModelDTO.PricingTier> list = tiers = areInputTokens ? modelDTO.getInputPricingTiers() : modelDTO.getOutputPricingTiers();
        if (tiers != null && !tiers.isEmpty()) {
            Float cost;
            tiers.sort(new Comparator<ModelDTO.PricingTier>(){

                @Override
                public int compare(ModelDTO.PricingTier a, ModelDTO.PricingTier b) {
                    return Integer.compare(this.getMaxTokens(a), this.getMaxTokens(b));
                }

                private int getMaxTokens(ModelDTO.PricingTier a) {
                    return a.getUpToTokens() == null || a.getUpToTokens() < 0 ? Integer.MAX_VALUE : a.getUpToTokens();
                }
            });
            ModelDTO.PricingTier matchingTier = null;
            for (ModelDTO.PricingTier tier : tiers) {
                Integer upto = tier.getUpToTokens();
                int cap = upto == null || upto < 0 ? Integer.MAX_VALUE : upto;
                if (noOfTokens > cap) continue;
                matchingTier = tier;
                break;
            }
            if (matchingTier == null) {
                matchingTier = tiers.get(tiers.size() - 1);
            }
            Float f = cost = areInputTokens ? matchingTier.getInputCost() : matchingTier.getOutputCost();
            if (cost != null && cost.floatValue() > 0.0f) {
                return cost.floatValue() / 2.0f;
            }
        }
        return areInputTokens ? modelDTO.getInputWeight() : modelDTO.getOutputWeight();
    }

    public static final float getApproximateCreditsPerWord(float creditsPerTokenWeight) {
        float rawCredits = 1.3f * creditsPerTokenWeight;
        if (rawCredits > 0.0f && rawCredits < 1.0f) {
            return Math.max(0.01f, (float)Math.round((double)rawCredits * 100.0) / 100.0f);
        }
        if (rawCredits >= 1.0f) {
            return (float)Math.floor(rawCredits);
        }
        return 0.0f;
    }
}

