/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.positron.utilities.claude.dto;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.oxygenxml.positron.api.connector.dto.ChatFunctionDTO;
import com.oxygenxml.positron.utilities.AIRequestUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonIgnoreProperties(ignoreUnknown=true)
public class ClaudeFunctionDTO
extends ChatFunctionDTO {
    private static final Logger log = LoggerFactory.getLogger(ClaudeFunctionDTO.class);
    @JsonProperty(value="input_schema")
    private Object parametersObject;

    public void setContent(ChatFunctionDTO chatFunctionDTO) {
        this.setName(chatFunctionDTO.getName());
        this.setDescription(chatFunctionDTO.getDescription());
        if (chatFunctionDTO.getParametersObj() != null) {
            this.parametersObject = chatFunctionDTO.getParametersObj();
        } else {
            String emptySchema = "{\"$schema\":\"https://json-schema.org/draft/2020-12/schema\",\"type\":\"object\"}";
            try {
                this.parametersObject = AIRequestUtil.defaultObjectMapper().readValue(emptySchema, Object.class);
            }
            catch (JsonProcessingException e) {
                log.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    public Object getParametersObject() {
        return this.parametersObject;
    }

    @JsonProperty(value="input_schema")
    public void setParametersObject(Object parametersObject) {
        this.parametersObject = parametersObject;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ClaudeFunctionDTO)) {
            return false;
        }
        ClaudeFunctionDTO other = (ClaudeFunctionDTO)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Object this$parametersObject = this.getParametersObject();
        Object other$parametersObject = other.getParametersObject();
        return !(this$parametersObject == null ? other$parametersObject != null : !this$parametersObject.equals(other$parametersObject));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ClaudeFunctionDTO;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Object $parametersObject = this.getParametersObject();
        result = result * 59 + ($parametersObject == null ? 43 : $parametersObject.hashCode());
        return result;
    }

    public String toString() {
        return "ClaudeFunctionDTO(parametersObject=" + this.getParametersObject() + ")";
    }
}

