/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.positron.utilities;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.github.victools.jsonschema.generator.Module;
import com.github.victools.jsonschema.generator.Option;
import com.github.victools.jsonschema.generator.OptionPreset;
import com.github.victools.jsonschema.generator.SchemaGenerator;
import com.github.victools.jsonschema.generator.SchemaGeneratorConfigBuilder;
import com.github.victools.jsonschema.generator.SchemaVersion;
import com.github.victools.jsonschema.module.jackson.JacksonModule;
import com.github.victools.jsonschema.module.jackson.JacksonOption;
import com.oxygenxml.positron.api.connector.dto.ChatFunctionDTO;
import com.oxygenxml.positron.api.connector.dto.CompletionRequest;
import com.oxygenxml.positron.api.connector.dto.Message;
import com.oxygenxml.positron.api.connector.dto.MessageContent;
import com.oxygenxml.positron.api.connector.dto.MessageContentType;
import com.oxygenxml.positron.api.connector.dto.MessageTextContent;
import com.oxygenxml.positron.api.connector.dto.ModerationRequest;
import com.oxygenxml.positron.api.connector.dto.ResponseFormatDTO;
import com.oxygenxml.positron.api.connector.dto.ResponseJsonSchemaDTO;
import com.oxygenxml.positron.api.connector.dto.RoleType;
import com.oxygenxml.positron.api.connector.dto.StreamOptions;
import com.oxygenxml.positron.api.connector.dto.Tool;
import com.oxygenxml.positron.utilities.AIProviderConstants;
import com.oxygenxml.positron.utilities.TokensUtil;
import com.oxygenxml.positron.utilities.exceptions.InvalidMessageException;
import com.oxygenxml.positron.utilities.exceptions.ModelTokensLimitExcededException;
import com.oxygenxml.positron.utilities.functions.ChatFunctionSignature;
import com.oxygenxml.positron.utilities.functions.IFunctionSignaturesRepository;
import com.oxygenxml.positron.utilities.json.AIActionDetails;
import com.oxygenxml.positron.utilities.json.ChatFunctionRef;
import com.oxygenxml.positron.utilities.json.Engine;
import com.oxygenxml.positron.utilities.json.Examples;
import com.oxygenxml.positron.utilities.json.Parameters;
import com.oxygenxml.positron.utilities.models.ModelDTO;
import com.oxygenxml.positron.utilities.models.ModelLoader;
import com.oxygenxml.positron.utilities.response.IResponseFormatsRepository;
import com.oxygenxml.positron.utilities.response.ResponseFormat;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AIRequestUtil {
    private static final Logger log = LoggerFactory.getLogger(AIRequestUtil.class);
    private static final Logger logger = LoggerFactory.getLogger((String)AIRequestUtil.class.getName());
    private static final Pattern REASONING_MODEL_PATTERN = Pattern.compile("^o[\\d]+");
    private static SchemaGenerator RESPONSE_FORMAT_SCHEMA_GENERATOR = new SchemaGenerator(new SchemaGeneratorConfigBuilder(SchemaVersion.DRAFT_2020_12, OptionPreset.PLAIN_JSON).with((Module)new JacksonModule(new JacksonOption[]{JacksonOption.RESPECT_JSONPROPERTY_REQUIRED})).with(Option.FORBIDDEN_ADDITIONAL_PROPERTIES_BY_DEFAULT, new Option[0]).build());

    private AIRequestUtil() {
        throw new UnsupportedOperationException("Instantiation of this utility class is not allowed!");
    }

    static String expandContextParams(Map<String, String> parameters, String context) {
        if (parameters != null && !parameters.isEmpty() && context != null) {
            for (String paramName : parameters.keySet()) {
                String paramValue = parameters.get(paramName);
                if (paramValue == null) {
                    paramValue = "";
                    logger.error("Parameter {} has null value.", (Object)paramName);
                }
                context = context.replace("${" + paramName + "}", paramValue);
            }
        }
        return context;
    }

    private static void addExamplesMessages(List<Message> inputMessages, AIActionDetails details) {
        List<Examples> examples = details.getExamples();
        if (examples != null) {
            for (Examples ex : examples) {
                inputMessages.add(1, new Message(RoleType.ASSISTANT, (MessageContent)new MessageTextContent(ex.getCompletion().trim())));
                inputMessages.add(1, new Message(RoleType.USER, (MessageContent)new MessageTextContent(ex.getPrompt().trim())));
            }
        }
    }

    static void aggregateContext(List<Message> inputMessages, AIActionDetails details, Map<String, String> parameters) {
        String context = "";
        String rawContext = details.getPrompt();
        if (rawContext != null) {
            context = AIRequestUtil.expandContextParams(parameters, rawContext);
        }
        if (!context.isBlank()) {
            inputMessages.add(0, new Message(RoleType.SYSTEM, (MessageContent)new MessageTextContent(context)));
        }
        AIRequestUtil.addExamplesMessages(inputMessages, details);
    }

    public static CompletionRequest processRequestTakingAccountOfReasoningDeployments(CompletionRequest completionRequest, String deployment) {
        boolean isReasoningModel = deployment.contains("gpt-5") || REASONING_MODEL_PATTERN.matcher(deployment).find();
        return AIRequestUtil.processRequestTakingAccountOfReasoning(completionRequest, isReasoningModel);
    }

    public static CompletionRequest processRequestTakingAccountOfReasoningModels(CompletionRequest completionRequest, String model) {
        ModelDTO modelDTO;
        if (model == null) {
            return completionRequest;
        }
        boolean isReasoningModel = REASONING_MODEL_PATTERN.matcher(model).find();
        if (!isReasoningModel && (modelDTO = ModelLoader.getInstance().getBestMatchingModelDTO(model)) != null) {
            isReasoningModel = modelDTO.isReasoningModel();
        }
        return AIRequestUtil.processRequestTakingAccountOfReasoning(completionRequest, isReasoningModel);
    }

    private static CompletionRequest processRequestTakingAccountOfReasoning(CompletionRequest completionRequest, boolean isReasoningModel) {
        if (isReasoningModel) {
            Message message = (Message)completionRequest.getMessages().get(0);
            if (message.getRole() == RoleType.SYSTEM) {
                completionRequest.getMessages().set(0, new Message(RoleType.DEVELOPER, message.getContent()));
            }
            completionRequest.setTemperature(null);
            completionRequest.setMaxTokens(null);
        } else {
            completionRequest.setMaxCompletionTokens(null);
            completionRequest.setReasoningEffort(null);
        }
        return completionRequest;
    }

    public static CompletionRequest getCompletionRequestPayload(List<Message> inputMessages, AIActionDetails actionDetails, IFunctionSignaturesRepository functionsRepo, IResponseFormatsRepository responseFormatRepo, String userId, boolean shouldSetStream, Integer defaultMaxTokens) {
        List<Tool> expandFunctionReferences = AIRequestUtil.expandFunctionReferences(actionDetails.getParameters().getFunctionRefs(), functionsRepo, actionDetails.getId());
        ResponseFormatDTO responseFormat = AIRequestUtil.expandResponseFormat(actionDetails.getParameters(), responseFormatRepo);
        return AIRequestUtil.getCompletionRequestPayload(inputMessages, actionDetails, expandFunctionReferences, responseFormat, userId, shouldSetStream, false, defaultMaxTokens);
    }

    public static ResponseFormatDTO expandResponseFormat(Parameters parameters, IResponseFormatsRepository responseFormatRepo) {
        ResponseFormatDTO toRet = null;
        if (parameters != null) {
            if (parameters.getResponseFormatSchema() != null) {
                ResponseFormatDTO responseFormatDTO = new ResponseFormatDTO();
                responseFormatDTO.setJsonSchema(parameters.getResponseFormatSchema());
                toRet = responseFormatDTO;
            } else {
                ResponseFormat foundResponseFormat;
                String responseFormatRef = parameters.getResponseFormatRef();
                if (responseFormatRepo != null && responseFormatRef != null && !responseFormatRef.isEmpty() && (foundResponseFormat = responseFormatRepo.searchForResponseFormat(responseFormatRef)) != null) {
                    ResponseFormatDTO responseFormatDTO = new ResponseFormatDTO();
                    ResponseJsonSchemaDTO responseJsonSchemaDTO = new ResponseJsonSchemaDTO();
                    responseJsonSchemaDTO.setName(foundResponseFormat.getName());
                    responseJsonSchemaDTO.setDescription(foundResponseFormat.getDescription());
                    if (foundResponseFormat.getResponseFormatStructure() != null) {
                        ObjectNode jsonSchema = RESPONSE_FORMAT_SCHEMA_GENERATOR.generateSchema(foundResponseFormat.getResponseFormatStructure(), new Type[0]);
                        try {
                            responseJsonSchemaDTO.setSchema(AIRequestUtil.defaultObjectMapper().readValue(jsonSchema.toPrettyString(), Object.class));
                        }
                        catch (JsonProcessingException e) {
                            log.error(e.getMessage(), (Throwable)e);
                        }
                    }
                    responseFormatDTO.setJsonSchema(responseJsonSchemaDTO);
                    toRet = responseFormatDTO;
                }
            }
        }
        return toRet;
    }

    public static CompletionRequest getCompletionRequestPayload(List<Message> inputMessages, AIActionDetails actionDetails, List<Tool> imposedTools, ResponseFormatDTO responseFormat, String userId, boolean shouldSetStream, boolean includeTokenUsage, Integer defaultMaxTokens) {
        Parameters actionParameters = actionDetails.getParameters();
        CompletionRequest.CompletionRequestBuilder requestBuilder = CompletionRequest.builder().messages(inputMessages);
        if (userId != null && !userId.isEmpty()) {
            requestBuilder = requestBuilder.user(userId);
        }
        if (shouldSetStream) {
            requestBuilder = requestBuilder.stream(Boolean.TRUE);
            if (includeTokenUsage) {
                requestBuilder = requestBuilder.streamOptions(StreamOptions.builder().includeTokenUsage(Boolean.valueOf(true)).build());
            }
        }
        if (actionParameters != null) {
            if (actionParameters.getMaxTokens() > 0) {
                requestBuilder = requestBuilder.maxTokens(Integer.valueOf(actionParameters.getMaxTokens()));
            } else if (defaultMaxTokens > 0) {
                requestBuilder = requestBuilder.maxTokens(defaultMaxTokens);
            }
            if (actionParameters.getMaxCompletionTokens() != null && actionParameters.getMaxCompletionTokens() > 0) {
                requestBuilder = requestBuilder.maxCompletionTokens(actionParameters.getMaxCompletionTokens());
            }
            if (actionParameters.getReasoningEffort() != null) {
                requestBuilder = requestBuilder.reasoningEffort(actionParameters.getReasoningEffort());
            }
            if (actionParameters.getStop() != null) {
                requestBuilder = requestBuilder.stop(actionParameters.getStop());
            }
            requestBuilder = requestBuilder.temperature(Float.valueOf(actionParameters.getTemperature()));
            if (responseFormat != null) {
                requestBuilder = requestBuilder.responseFormat(responseFormat);
            }
            if (imposedTools != null) {
                requestBuilder.tools(imposedTools);
            }
            if (actionParameters.getEngine() != null) {
                requestBuilder = requestBuilder.model(actionParameters.getEngine().getId());
            }
        }
        CompletionRequest completionRequest = requestBuilder.build();
        return completionRequest;
    }

    public static CompletionRequest updateCompletionRequestTakingModelConfigurationIntoAccount(CompletionRequest completionRequest) {
        String model = completionRequest.getModel();
        ModelDTO modelDto = ModelLoader.getInstance().getModelDTOById(model);
        if (modelDto != null) {
            if (modelDto.getReasoningEffort() != null) {
                completionRequest.setReasoningEffort(modelDto.getReasoningEffort());
            }
            model = ModelLoader.getInstance().getRequestModel(model);
            completionRequest.setModel(model);
        }
        return completionRequest;
    }

    @JsonIgnore
    public static List<Tool> expandFunctionReferences(List<ChatFunctionRef> functionRefs, IFunctionSignaturesRepository functionsDefinitionsRepo, String actionID) {
        ArrayList<Tool> tools = new ArrayList<Tool>();
        if (functionRefs != null && functionsDefinitionsRepo != null) {
            for (ChatFunctionRef functionRef : functionRefs) {
                ChatFunctionSignature functionDefinition = functionsDefinitionsRepo.searchForFunctionSignature(functionRef.getRef());
                if (functionDefinition != null) {
                    boolean shouldExpandFunction = functionDefinition.isEnabled();
                    if (!shouldExpandFunction) continue;
                    ChatFunctionDTO functionDTO = functionDefinition.toDto();
                    if (functionRef.getDescription() != null) {
                        functionDTO.setDescription(functionRef.getDescription());
                    }
                    tools.add(new Tool(functionDTO));
                    continue;
                }
                if (!log.isDebugEnabled()) continue;
                log.debug("Referenced function is not available: {}. List of available functions: {}", (Object)functionRef.getRef(), functionsDefinitionsRepo.getAvailableFunctionNames());
            }
        }
        return tools.isEmpty() ? null : tools;
    }

    public static void aggregateContextIfNeeded(List<Message> inputMessages, AIActionDetails actionDetails, Map<String, String> promptExpandParams) {
        if (!AIRequestUtil.hasSystemPrompt(inputMessages)) {
            AIRequestUtil.aggregateContext(inputMessages, actionDetails, promptExpandParams);
        }
    }

    private static boolean hasSystemPrompt(List<Message> messages) {
        return messages != null && !messages.isEmpty() && messages.get(0).getRole() == RoleType.SYSTEM && !messages.get(0).getContent().isEmpty();
    }

    public static Engine getEngineToUse(List<Message> inputMessages, Parameters parameters) throws ModelTokensLimitExcededException, InvalidMessageException {
        Engine engine = Optional.ofNullable(parameters).map(Parameters::getEngine).orElse(AIProviderConstants.DEFAULT_ENGINE);
        TokensUtil.checkLimit(inputMessages, engine);
        String model = ModelLoader.getInstance().getRequestModel(engine.getId());
        engine = new Engine(model);
        return engine;
    }

    public static String getModerationRequestPayload(String inputText) throws JsonProcessingException {
        ObjectMapper objectMapper = new ObjectMapper();
        return objectMapper.writeValueAsString((Object)new ModerationRequest(inputText));
    }

    public static String getModerationRequestPayload(List<Message> messages) throws JsonProcessingException {
        String contentToModerate = AIRequestUtil.extractTextContentForModeration(messages);
        return AIRequestUtil.getModerationRequestPayload(contentToModerate);
    }

    public static String extractTextContentForModeration(List<Message> messages) {
        StringBuilder inputText = new StringBuilder();
        messages.stream().forEach(m -> {
            if (RoleType.USER == m.getRole()) {
                List content = m.getContent();
                content.stream().forEach(contentItem -> {
                    if (contentItem.getType() == MessageContentType.TEXT) {
                        String text = ((MessageTextContent)contentItem).getText();
                        inputText.append(text).append("\n");
                    }
                });
            }
        });
        return inputText.toString();
    }

    public static ObjectMapper defaultObjectMapper() {
        ObjectMapper mapper = new ObjectMapper();
        mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        mapper.configure(SerializationFeature.FAIL_ON_EMPTY_BEANS, false);
        mapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        return mapper;
    }

    public static String mapResponseModelToConfiguredModel(String responseModel, String configuredModel) {
        boolean hasResponseModel;
        String mappedModel = responseModel;
        boolean bl = hasResponseModel = responseModel != null && !responseModel.isBlank();
        if (hasResponseModel && configuredModel != null) {
            boolean hasRequestModelForConfigured;
            String requestModelForConfigured = ModelLoader.getInstance().getRequestModel(configuredModel);
            boolean bl2 = hasRequestModelForConfigured = requestModelForConfigured != null && !requestModelForConfigured.isBlank();
            if (hasRequestModelForConfigured) {
                boolean isSameAsRequestModel;
                boolean bl3 = isSameAsRequestModel = responseModel.equals(requestModelForConfigured) || responseModel.startsWith(requestModelForConfigured);
                if (isSameAsRequestModel) {
                    mappedModel = configuredModel;
                }
            }
        }
        return mappedModel;
    }
}

