/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.positron.eclipse.view;

import com.oxygenxml.ai.positron.license.exception.InvalidLicenseException;
import com.oxygenxml.positron.core.plugin.Translator;
import com.oxygenxml.positron.eclipse.utils.IconsLoader;
import com.oxygenxml.positron.eclipse.utils.SWTUtils;
import com.oxygenxml.positron.eclipse.view.PositronAssistantPanelController;
import com.oxygenxml.positron.plugin.license.DirectConnectionLicenseChangedListener;
import com.oxygenxml.positron.plugin.license.DirectConnectionLicenseManager;
import java.util.Objects;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.ToolBar;
import ro.sync.exml.workspace.api.PluginWorkspaceProvider;

public class DirectConnectionInfoPanel
extends Composite {
    private Image licenseKeyImage = IconsLoader.loadIcon("/images/Key24.png").createImage();
    private ToolBarManager tbm = null;
    private Label infoAboutConfigLabel = null;

    public DirectConnectionInfoPanel(Composite parent) {
        super(parent, 0);
        this.setLayout((Layout)new GridLayout(2, false));
        SWTUtils.createImageLabel(this, this.licenseKeyImage);
        this.infoAboutConfigLabel = SWTUtils.createGridMultiLineLabel(this, -1, -1, 1);
        DirectConnectionLicenseManager.getInstance().addDirectConnectionLicenseListener(new DirectConnectionLicenseChangedListener(){

            public void licenseChanged() {
                if (DirectConnectionInfoPanel.this.isNoLicenseKeySetInOptions()) {
                    DirectConnectionInfoPanel.this.infoAboutConfigLabel.setText(Translator.getInstance().getTranslation("Direct_Connection_Using_Info"));
                    DirectConnectionInfoPanel.this.layout(true);
                }
            }
        });
        SWTUtils.createLabel(this, "");
        ToolBar tb = new ToolBar((Composite)this, 0x800840);
        tb.setLayoutData((Object)new GridData(16384, 0x1000000, true, false));
        this.tbm = new ToolBarManager(tb);
        this.addDisposeListener(e -> this.licenseKeyImage.dispose());
    }

    public void setController(PositronAssistantPanelController controller) {
        this.tbm.add((IAction)controller.getRegisterDirectConnectionLicenseAction());
        this.tbm.update(true);
        if (!this.isDisposed()) {
            this.infoAboutConfigLabel.setText(this.getLicenseConfigurationInfo(controller));
            this.layout(true);
        }
    }

    String getLicenseConfigurationInfo(PositronAssistantPanelController controller) {
        String messsage4User = Translator.getInstance().getTranslation("Direct_Connection_Using_Info");
        if (!this.isNoLicenseKeySetInOptions()) {
            try {
                controller.checkDirectConnectionLicense();
            }
            catch (InvalidLicenseException e) {
                messsage4User = e.getMessage();
            }
        }
        return messsage4User;
    }

    boolean isNoLicenseKeySetInOptions() {
        return Objects.isNull(PluginWorkspaceProvider.getPluginWorkspace().getOptionsStorage().getOption("oxygen.positron.plugin.direct.connection.key", null));
    }
}

