/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.positron.eclipse.utils;

import com.oxygenxml.positron.eclipse.PositronPlugin;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.dialogs.PreferencesUtil;

@Singleton
public final class PositronUtilities {
    @Inject
    static IWorkbench workbench;

    public static IEditorPart getCurrentEditor() {
        if (!workbench.isClosing()) {
            return workbench.getActiveWorkbenchWindow().getActivePage().getActiveEditor();
        }
        return null;
    }

    public static void showPreferences(Shell shell, String mainPageID, String[] pages) {
        PreferencesUtil.createPreferenceDialogOn((Shell)shell, (String)PositronUtilities.computePreferencesPageID(mainPageID)[0], (String[])PositronUtilities.computePreferencesPageID(pages), null).open();
    }

    public static String[] computePreferencesPageID(String ... suffixes) {
        String[] computedIDs = new String[suffixes.length];
        String pluginID = PositronPlugin.getPluginID();
        for (int i = 0; i < suffixes.length; ++i) {
            StringBuilder computedID = new StringBuilder(pluginID);
            computedID.append(".preferences.").append(suffixes[i]);
            computedIDs[i] = computedID.toString();
        }
        return computedIDs;
    }

    private PositronUtilities() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

