/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.positron.eclipse.utils;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuCreator;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.CoolBar;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;

public class PopupMenuAction
extends Action
implements IMenuCreator {
    private List<Object> actionsList = new ArrayList<Object>();
    private Menu menu;
    private ActionContributionItem item;
    private ToolItem toolItem = null;
    private Action mainAction = null;

    public PopupMenuAction(String tooltipText, ImageDescriptor imageDescriptor) {
        super(tooltipText, 4);
        this.setImageDescriptor(imageDescriptor);
        this.setToolTipText(tooltipText);
        this.setMenuCreator(this);
        this.item = new ActionContributionItem((IAction)this){

            public void fill(ToolBar parent, int index) {
                super.fill(parent, index);
                PopupMenuAction.this.toolItem = parent.getItem(index >= 0 ? index : parent.getItemCount());
            }

            public void fill(Composite parent) {
                super.fill(parent);
                PopupMenuAction.this.toolItem = null;
            }

            public void fill(CoolBar parent, int index) {
                super.fill(parent, index);
                PopupMenuAction.this.toolItem = null;
            }

            public void fill(Menu parent, int index) {
                super.fill(parent, index);
                PopupMenuAction.this.toolItem = null;
            }

            public void dispose() {
                super.dispose();
                PopupMenuAction.this.toolItem = null;
            }
        };
    }

    public ActionContributionItem getToolbarContributorItem() {
        return this.item;
    }

    public void addAction(Action action) {
        this.actionsList.add(action);
    }

    public void setAction(Action mainAction) {
        this.mainAction = mainAction;
    }

    public void addContributionItem(IContributionItem ci) {
        this.actionsList.add(ci);
    }

    public List<Object> repopulateActionsList(List<Object> existingActions) {
        return existingActions;
    }

    public void run() {
        if (this.mainAction != null) {
            this.mainAction.run();
        } else if (this.item != null && this.toolItem != null && !this.toolItem.isDisposed()) {
            Event event = new Event();
            event.detail = 4;
            Rectangle bounds = this.toolItem.getBounds();
            event.x = bounds.x;
            event.y = bounds.y + bounds.height;
            this.toolItem.notifyListeners(13, event);
        }
    }

    public void dispose() {
        if (this.menu != null) {
            this.menu.dispose();
        }
    }

    public Menu getMenu(Control parent) {
        if (this.menu != null) {
            this.menu.dispose();
        }
        final MenuManager newMenuMgr = new MenuManager("NewPopupMenu");
        parent.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                newMenuMgr.dispose();
            }
        });
        this.menu = newMenuMgr.createContextMenu(parent);
        this.actionsList = this.repopulateActionsList(this.actionsList);
        for (int i = 0; i < this.actionsList.size(); ++i) {
            Object obj = this.actionsList.get(i);
            if (obj == null) {
                newMenuMgr.add((IContributionItem)new Separator());
                continue;
            }
            if (obj instanceof Action) {
                newMenuMgr.add((IAction)((Action)obj));
                continue;
            }
            if (!(obj instanceof IContributionItem)) continue;
            newMenuMgr.add((IContributionItem)obj);
        }
        return this.menu;
    }

    public Menu getMenu(Menu parent) {
        if (this.menu != null) {
            this.menu.dispose();
        }
        this.menu = new Menu(parent);
        this.actionsList = this.repopulateActionsList(this.actionsList);
        for (int i = 0; i < this.actionsList.size(); ++i) {
            Object action = this.actionsList.get(i);
            if (action == null) {
                Separator sep = new Separator();
                sep.fill(this.menu, -1);
                continue;
            }
            if (action instanceof Action) {
                ActionContributionItem cItem = new ActionContributionItem((IAction)((Action)action));
                cItem.fill(this.menu, -1);
                continue;
            }
            if (!(action instanceof IContributionItem)) continue;
            ((IContributionItem)action).fill(this.menu, -1);
        }
        return this.menu;
    }

    public void clearActions() {
        this.actionsList.clear();
    }
}

